/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.layout.layout;

import com.jgoodies.common.base.Preconditions;
import com.jgoodies.common.swing.ScreenScaling;
import com.jgoodies.layout.layout.FormLayout;
import com.jgoodies.layout.layout.Size;
import com.jgoodies.layout.layout.Sizes;
import com.jgoodies.layout.layout.Unit;
import java.awt.Component;
import java.awt.Container;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public final class ConstantSize
implements Size,
Serializable {
    private static final Map<String, ConstantSize> CACHE = new HashMap<String, ConstantSize>();
    private final double value;
    private final Unit unit;

    public ConstantSize(int value, Unit unit) {
        this.value = value;
        this.unit = unit;
    }

    public ConstantSize(double value, Unit unit) {
        this.value = value;
        this.unit = unit;
    }

    static ConstantSize decode(String encodedValueAndUnit) {
        ConstantSize size = CACHE.get(encodedValueAndUnit);
        if (size == null) {
            size = ConstantSize.decode0(encodedValueAndUnit);
            CACHE.put(encodedValueAndUnit, size);
        }
        return size;
    }

    private static ConstantSize decode0(String encodedValueAndUnit) {
        String[] split = ConstantSize.splitValueAndUnit(encodedValueAndUnit);
        String encodedValue = split[0];
        String encodedUnit = split[1];
        Unit unit = Unit.decode(encodedUnit);
        double value = Double.parseDouble(encodedValue);
        if (unit.requiresIntegers) {
            Preconditions.checkArgument(value == (double)((int)value), "%s value %s must be an integer.", new Object[]{unit, encodedValue});
        }
        return new ConstantSize(value, unit);
    }

    public double getValue() {
        return this.value;
    }

    public Unit getUnit() {
        return this.unit;
    }

    public int getPixelSize(Component component, boolean horizontal) {
        switch (this.unit) {
            case PIXEL: {
                return this.intValue();
            }
            case EFFECTIVE_PIXEL: {
                return ScreenScaling.toPhysical(this.intValue());
            }
            case DIALOG_UNITS: {
                return horizontal ? Sizes.dialogUnitXAsPixel(this.intValue(), component) : Sizes.dialogUnitYAsPixel(this.intValue(), component);
            }
            case POINT: {
                return Sizes.pointAsPixel(this.intValue(), component);
            }
            case INCH: {
                return Sizes.inchAsPixel(this.value, component);
            }
            case MILLIMETER: {
                return Sizes.millimeterAsPixel(this.value, component);
            }
            case CENTIMETER: {
                return Sizes.centimeterAsPixel(this.value, component);
            }
        }
        throw new IllegalStateException("Invalid unit " + (Object)((Object)this.unit));
    }

    @Override
    public int maximumSize(Container container, List<Component> components, FormLayout.ComponentSizeCache sizeCache, FormLayout.Measure minMeasure, FormLayout.Measure prefMeasure, FormLayout.Measure defaultMeasure, boolean horizontal) {
        return this.getPixelSize(container, horizontal);
    }

    @Override
    public boolean compressible() {
        return false;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ConstantSize)) {
            return false;
        }
        ConstantSize size = (ConstantSize)o;
        return this.value == size.value && this.unit == size.unit;
    }

    public int hashCode() {
        return Double.hashCode(this.value) + 37 * this.unit.hashCode();
    }

    public String toString() {
        return this.value == (double)this.intValue() ? Integer.toString(this.intValue()) + this.unit.abbreviation() : Double.toString(this.value) + this.unit.abbreviation();
    }

    @Override
    public String encode() {
        return this.value == (double)this.intValue() ? Integer.toString(this.intValue()) + this.unit.encode() : Double.toString(this.value) + this.unit.encode();
    }

    private int intValue() {
        return (int)Math.round(this.value);
    }

    private static String[] splitValueAndUnit(String encodedValueAndUnit) {
        int len;
        int firstLetterIndex;
        String[] result = new String[2];
        for (firstLetterIndex = len = encodedValueAndUnit.length(); firstLetterIndex > 0 && Character.isLetter(encodedValueAndUnit.charAt(firstLetterIndex - 1)); --firstLetterIndex) {
        }
        result[0] = encodedValueAndUnit.substring(0, firstLetterIndex);
        result[1] = encodedValueAndUnit.substring(firstLetterIndex);
        return result;
    }
}

