/*
 * Decompiled with CFR 0.152.
 */
package plugin.lsttokens.auto;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.StringTokenizer;
import pcgen.cdom.base.CDOMObject;
import pcgen.cdom.base.ChooseDriver;
import pcgen.cdom.base.ChooseSelectionActor;
import pcgen.cdom.content.ConditionalSelectionActor;
import pcgen.cdom.enumeration.ListKey;
import pcgen.cdom.enumeration.ObjectKey;
import pcgen.cdom.helper.WeaponProfProvider;
import pcgen.cdom.reference.CDOMGroupRef;
import pcgen.cdom.reference.CDOMSingleRef;
import pcgen.core.PlayerCharacter;
import pcgen.core.QualifiedObject;
import pcgen.core.WeaponProf;
import pcgen.core.prereq.Prerequisite;
import pcgen.persistence.PersistenceLayerException;
import pcgen.persistence.lst.prereq.PreParserFactory;
import pcgen.rules.context.Changes;
import pcgen.rules.context.LoadContext;
import pcgen.rules.persistence.TokenUtilities;
import pcgen.rules.persistence.token.AbstractNonEmptyToken;
import pcgen.rules.persistence.token.CDOMSecondaryToken;
import pcgen.rules.persistence.token.ParseResult;
import pcgen.util.Logging;

public class WeaponProfToken
extends AbstractNonEmptyToken<CDOMObject>
implements CDOMSecondaryToken<CDOMObject>,
ChooseSelectionActor<WeaponProf> {
    private static final Class<WeaponProf> WEAPONPROF_CLASS = WeaponProf.class;

    public String getParentToken() {
        return "AUTO";
    }

    public String getTokenName() {
        return "WEAPONPROF";
    }

    private String getFullName() {
        return this.getParentToken() + ":" + this.getTokenName();
    }

    protected ParseResult parseNonEmptyToken(LoadContext context, CDOMObject obj, String value) {
        String weaponProfs;
        Prerequisite prereq = null;
        boolean isPre = false;
        if (value.indexOf("[") == -1) {
            weaponProfs = value;
            StringTokenizer tok = new StringTokenizer(weaponProfs, "|");
            while (tok.hasMoreTokens()) {
                String token = tok.nextToken();
                if (!PreParserFactory.isPreReqString((String)token)) continue;
                if (isPre) {
                    String errorText = "Invalid " + this.getTokenName() + ": " + value + "  PRExxx must be at the END of the Token";
                    Logging.errorPrint((String)errorText);
                    return new ParseResult.Fail(errorText, context);
                }
                prereq = this.getPrerequisite(token);
                if (prereq == null) {
                    return new ParseResult.Fail("Error generating Prerequisite " + prereq + " in " + this.getFullName(), context);
                }
                int preStart = value.indexOf(token) - 1;
                weaponProfs = value.substring(0, preStart);
                isPre = true;
                ParseResult fail = this.checkForLoopPrereqs(prereq, context);
                if (fail == null) continue;
                return fail;
            }
        } else {
            return new ParseResult.Fail("Use of [] for Prerequisites has been removed. Please use | based standard", context);
        }
        ParseResult pr = this.checkForIllegalSeparator('|', weaponProfs);
        if (!pr.passed()) {
            return pr;
        }
        boolean foundAny = false;
        boolean foundOther = false;
        StringTokenizer tok = new StringTokenizer(weaponProfs, "|");
        WeaponProfProvider wpp = new WeaponProfProvider();
        while (tok.hasMoreTokens()) {
            String token = tok.nextToken();
            if ("%LIST".equals(token)) {
                WeaponProfToken cra;
                foundOther = true;
                if (prereq == null) {
                    cra = this;
                } else {
                    ConditionalSelectionActor cca = new ConditionalSelectionActor((ChooseSelectionActor)this);
                    cca.addPrerequisite(prereq);
                    cra = cca;
                }
                context.getObjectContext().addToList(obj, ListKey.NEW_CHOOSE_ACTOR, (Object)cra);
                continue;
            }
            if ("DEITYWEAPONS".equals(token)) {
                foundOther = true;
                context.getObjectContext().put(obj, ObjectKey.HAS_DEITY_WEAPONPROF, (Object)new QualifiedObject((Object)Boolean.TRUE, prereq));
                continue;
            }
            if ("ALL".equalsIgnoreCase(token)) {
                foundAny = true;
                CDOMGroupRef allRef = context.getReferenceContext().getCDOMAllReference(WEAPONPROF_CLASS);
                wpp.addWeaponProfAll(allRef);
                continue;
            }
            foundOther = true;
            if (token.startsWith("TYPE.") || token.startsWith("TYPE=")) {
                CDOMGroupRef rr = TokenUtilities.getTypeReference((LoadContext)context, WEAPONPROF_CLASS, (String)token.substring(5));
                if (rr == null) {
                    return ParseResult.INTERNAL_ERROR;
                }
                wpp.addWeaponProfType(rr);
                continue;
            }
            CDOMSingleRef ref = context.getReferenceContext().getCDOMReference(WEAPONPROF_CLASS, token);
            wpp.addWeaponProf(ref);
        }
        if (foundAny && foundOther) {
            return new ParseResult.Fail("Non-sensical " + this.getFullName() + ": Contains ANY and a specific reference: " + value, context);
        }
        if (!wpp.isEmpty()) {
            if (prereq != null) {
                wpp.addPrerequisite(prereq);
            }
            context.getObjectContext().addToList(obj, ListKey.WEAPONPROF, (Object)wpp);
        }
        return ParseResult.SUCCESS;
    }

    private ParseResult checkForLoopPrereqs(Prerequisite prereq, LoadContext context) {
        if ("WEAPONPROF".equalsIgnoreCase(prereq.getKind()) && prereq.getKey().startsWith("TYPE")) {
            return new ParseResult.Fail("AUTO:WEAPONPROF may not use PREWEAPONPROF requirements  other than specific named proficiencies.", context);
        }
        for (Prerequisite childPrereq : prereq.getPrerequisites()) {
            ParseResult res = this.checkForLoopPrereqs(childPrereq, context);
            if (res == null) continue;
            return res;
        }
        return null;
    }

    public String[] unparse(LoadContext context, CDOMObject obj) {
        ArrayList<String> list = new ArrayList<String>();
        Changes listChanges = context.getObjectContext().getListChanges(obj, ListKey.NEW_CHOOSE_ACTOR);
        Changes changes = context.getObjectContext().getListChanges(obj, ListKey.WEAPONPROF);
        QualifiedObject deityweap = (QualifiedObject)context.getObjectContext().getObject(obj, ObjectKey.HAS_DEITY_WEAPONPROF);
        Collection added = changes.getAdded();
        Collection listAdded = listChanges.getAdded();
        boolean foundAny = false;
        boolean foundOther = false;
        if (listAdded != null && !listAdded.isEmpty()) {
            foundOther = true;
            for (ChooseSelectionActor cra : listAdded) {
                if (!cra.getSource().equals(this.getTokenName())) continue;
                try {
                    list.add(cra.getLstFormat());
                }
                catch (PersistenceLayerException e) {
                    context.addWriteMessage("Error writing Prerequisite: " + (Object)((Object)e));
                    return null;
                }
            }
        }
        if (deityweap != null && ((Boolean)deityweap.getRawObject()).booleanValue()) {
            foundOther = true;
            StringBuilder sb = new StringBuilder();
            sb.append("DEITYWEAPONS");
            if (deityweap.hasPrerequisites()) {
                sb.append('|');
                sb.append(context.getPrerequisiteString((Collection)deityweap.getPrerequisiteList()));
            }
            list.add(sb.toString());
        }
        if (added != null) {
            for (WeaponProfProvider wpp : added) {
                if (!wpp.isValid()) {
                    context.addWriteMessage("Non-sensical WeaponProfProvider in " + this.getFullName() + ": Had invalid contents");
                    return null;
                }
                StringBuilder sb = new StringBuilder(wpp.getLstFormat());
                List prereqs = wpp.getPrerequisiteList();
                if (prereqs != null && !prereqs.isEmpty()) {
                    if (prereqs.size() > 1) {
                        context.addWriteMessage("Error: " + obj.getClass().getSimpleName() + " had more than one Prerequisite for " + this.getFullName());
                        return null;
                    }
                    sb.append('|');
                    sb.append(context.getPrerequisiteString((Collection)prereqs));
                }
                String lstFormat = sb.toString();
                boolean isUnconditionalAll = "ALL".equals(lstFormat);
                foundAny |= isUnconditionalAll;
                foundOther |= !isUnconditionalAll;
                list.add(lstFormat);
            }
        }
        if (foundAny && foundOther) {
            context.addWriteMessage("Non-sensical " + this.getFullName() + ": Contains ANY and a specific reference: " + list);
            return null;
        }
        if (list.isEmpty()) {
            return null;
        }
        return list.toArray(new String[list.size()]);
    }

    public Class<CDOMObject> getTokenClass() {
        return CDOMObject.class;
    }

    public void applyChoice(ChooseDriver obj, WeaponProf wp, PlayerCharacter pc) {
        pc.addWeaponProf((Object)obj, wp);
    }

    public void removeChoice(ChooseDriver obj, WeaponProf wp, PlayerCharacter pc) {
        pc.removeWeaponProf((Object)obj, wp);
    }

    public Class<WeaponProf> getChoiceClass() {
        return WEAPONPROF_CLASS;
    }

    public String getSource() {
        return this.getTokenName();
    }

    public String getLstFormat() {
        return "%LIST";
    }
}

