/*
 * Decompiled with CFR 0.152.
 */
package plugin.initiative;

import gmgen.plugin.PcgCombatant;
import java.util.List;
import pcgen.cdom.enumeration.ObjectKey;
import pcgen.core.Globals;
import pcgen.core.PlayerCharacter;
import pcgen.core.RollingMethods;
import pcgen.core.Skill;
import pcgen.core.analysis.SkillModifier;
import pcgen.core.analysis.SkillRankControl;
import plugin.initiative.OpposedSkillBasicModel;

public class OpposedSkillModel
extends OpposedSkillBasicModel {
    protected String skillName;

    public OpposedSkillModel() {
        this.columns.addColumn("BONUS", Integer.class, 0, false, "Bonus");
        this.columns.addColumn("FUDGE", Integer.class, null, true, "Fudge");
        this.columns.addColumn("RESULT", Integer.class, null, false, "Result");
    }

    public OpposedSkillModel(List combatantList) {
        super(combatantList);
        this.columns.addColumn("BONUS", Integer.class, 0, false, "Bonus");
        this.columns.addColumn("FUDGE", Integer.class, null, true, "Fudge");
        this.columns.addColumn("RESULT", Integer.class, null, false, "Result");
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        Object returnValue = null;
        if (rowIndex < this.combatants.size()) {
            SkillInitWrapper entry = (SkillInitWrapper)this.getRowEntry(rowIndex);
            switch (columnIndex) {
                case 0: {
                    returnValue = super.getValueAt(rowIndex, columnIndex);
                    break;
                }
                case 1: {
                    returnValue = entry.getSkillBonus(this.skillName);
                    break;
                }
                case 2: {
                    returnValue = entry.getFudge();
                    break;
                }
                case 3: {
                    returnValue = entry.getResult();
                }
            }
        }
        return returnValue;
    }

    public void roll(int rowIndex) {
        if (rowIndex < this.combatants.size()) {
            ((SkillInitWrapper)this.getRowEntry(rowIndex)).roll();
            this.fireTableCellUpdated(rowIndex, 3);
        }
    }

    public void rollAll() {
        for (int i = 0; i < this.combatants.size(); ++i) {
            this.roll(i);
        }
    }

    public void setSkill(String name) {
        this.skillName = name;
        this.rollAll();
    }

    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        if (rowIndex < this.combatants.size() && columnIndex == 2 && aValue instanceof Integer) {
            SkillInitWrapper entry = (SkillInitWrapper)this.getRowEntry(rowIndex);
            entry.setFudge((Integer)aValue);
        } else {
            super.setValueAt(aValue, rowIndex, columnIndex);
        }
    }

    @Override
    public void addCombatant(PcgCombatant combatant) {
        this.combatants.put(combatant.getName(), new SkillInitWrapper(combatant));
        int rowIndex = this.getIndexOf(combatant.getName());
        this.fireTableRowsInserted(rowIndex, rowIndex);
    }

    protected class SkillInitWrapper
    extends OpposedSkillBasicModel.InitWrapper {
        private Integer fudge;
        private Integer result;
        private Integer roll;

        public SkillInitWrapper(PcgCombatant init) {
            super(init);
            this.fudge = null;
            this.result = null;
            this.roll = null;
            if (OpposedSkillModel.this.skillName != null) {
                this.roll();
            }
        }

        public Integer getSkillBonus(String aSkillKey) {
            Integer returnValue = null;
            if (this.initiative != null && aSkillKey != null) {
                PlayerCharacter pc = this.initiative.getPC();
                Skill skill = (Skill)Globals.getContext().getReferenceContext().silentlyGetConstructedCDOMObject(Skill.class, aSkillKey);
                if (skill != null && pc.getDisplay().hasSkill(skill)) {
                    returnValue = SkillModifier.modifier((Skill)skill, (PlayerCharacter)pc) + SkillRankControl.getTotalRank((PlayerCharacter)pc, (Skill)skill).intValue();
                } else if (skill != null && ((Boolean)skill.getSafe(ObjectKey.USE_UNTRAINED)).booleanValue() && skill.get(ObjectKey.KEY_STAT) != null) {
                    returnValue = (int)SkillModifier.modifier((Skill)skill, (PlayerCharacter)pc);
                }
            }
            return returnValue;
        }

        public void roll() {
            this.roll = RollingMethods.roll((String)"1d20");
            this.calc();
        }

        public void calc() {
            Integer i = this.getSkillBonus(OpposedSkillModel.this.skillName);
            if (i != null && this.roll != null) {
                int r = this.roll;
                r += i.intValue();
                i = this.fudge;
                if (i != null) {
                    r += i.intValue();
                }
                this.result = r;
            } else {
                this.result = null;
            }
        }

        public Integer getFudge() {
            return this.fudge;
        }

        public void setFudge(Integer fudge) {
            this.fudge = fudge;
            this.calc();
        }

        public Integer getResult() {
            return this.result;
        }

        public void setResult(Integer result) {
            this.result = result;
        }
    }
}

