/*
 * Decompiled with CFR 0.152.
 */
package plugin.exporttokens;

import java.math.BigDecimal;
import java.util.StringTokenizer;
import pcgen.cdom.base.CDOMObject;
import pcgen.cdom.enumeration.FormulaKey;
import pcgen.core.Equipment;
import pcgen.core.Globals;
import pcgen.core.PlayerCharacter;
import pcgen.core.analysis.OutputNameFormatting;
import pcgen.io.ExportHandler;
import pcgen.io.exporttoken.Token;
import pcgen.util.BigDecimalHelper;

public class EqContainersToken
extends Token {
    public static final String TOKENNAME = "EQCONTAINERS";
    public static final String INDENT = "\t";

    public String getTokenName() {
        return TOKENNAME;
    }

    public String getToken(String tokenSource, PlayerCharacter pc, ExportHandler eh) {
        String retString = "";
        StringTokenizer aTok = new StringTokenizer(tokenSource, ".", false);
        aTok.nextToken();
        Equipment eq = null;
        if (aTok.hasMoreElements()) {
            try {
                int containerNo = Integer.parseInt(aTok.nextToken());
                eq = this.getContainer(pc, containerNo);
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
        if (eq != null) {
            String property = "NAME";
            if (aTok.hasMoreElements()) {
                property = aTok.nextToken();
            }
            if (property.equals("ACCHECK")) {
                retString = Integer.toString(EqContainersToken.getAcCheckToken(pc, eq));
            } else if (property.equals("ACMOD")) {
                retString = Integer.toString(EqContainersToken.getAcModToken(pc, eq));
            } else if (property.equals("ALTCRIT")) {
                retString = EqContainersToken.getAltCritToken(eq);
            } else if (property.equals("ALTDAMAGE")) {
                retString = EqContainersToken.getAltDamageToken(pc, eq);
            } else if (property.equals("ATTACKS")) {
                retString = Double.toString(EqContainersToken.getAttacksToken(pc, eq));
            } else if (property.equals("CARRIED")) {
                retString = Float.toString(EqContainersToken.getCarriedToken(eq));
            } else if (property.equals("CONTENTS")) {
                retString = EqContainersToken.getContentsToken(eq, aTok);
            } else if (property.equals("CONTENTWEIGHT")) {
                retString = BigDecimalHelper.trimZeros((String)Float.toString(EqContainersToken.getContentWeightToken(pc, eq)));
            } else if (property.equals("COST")) {
                retString = BigDecimalHelper.trimZeros((BigDecimal)EqContainersToken.getCostToken(pc, eq));
            } else if (property.equals("CRITMULT")) {
                retString = EqContainersToken.getCritMultToken(eq);
            } else if (property.equals("CRITRANGE")) {
                retString = EqContainersToken.getCritRangeToken(pc, eq);
            } else if (property.equals("DAMAGE")) {
                retString = EqContainersToken.getDamageToken(pc, eq);
            } else if (property.equals("EDR")) {
                retString = Integer.toString(EqContainersToken.getEdrToken(pc, eq));
            } else if (property.equals("EQUIPPED")) {
                retString = EqContainersToken.getEquippedToken(eq);
            } else if (property.equals("ITEMWEIGHT")) {
                retString = BigDecimalHelper.trimZeros((String)Float.toString(EqContainersToken.getItemWeightToken(pc, eq)));
            } else if (property.equals("LOCATION")) {
                retString = EqContainersToken.getLocationToken(eq);
            } else if (property.equals("LONGNAME")) {
                retString = EqContainersToken.getLongNameToken(eq);
            } else if (property.equals("MAXDEX")) {
                retString = Integer.toString(EqContainersToken.getMaxDexToken(pc, eq));
            } else if (property.equals("MOVE")) {
                retString = EqContainersToken.getMoveToken(eq);
            } else if (property.equals("NAME") || property.equals("OUTPUTNAME")) {
                retString = EqContainersToken.getNameToken(eq, pc);
            } else if (property.equals("PROF")) {
                retString = eq.consolidatedProfName();
            } else if (property.equals("QTY")) {
                retString = BigDecimalHelper.trimZeros((String)Double.toString(EqContainersToken.getQuantityToken(eq)));
            } else if (property.equals("RANGE")) {
                retString = Integer.toString(EqContainersToken.getRangeToken(eq, pc));
            } else if (property.equals("SIZE")) {
                retString = EqContainersToken.getSizeToken(eq);
            } else if (property.equals("SPELLFAILURE")) {
                retString = Integer.toString(EqContainersToken.getSpellFailureToken(pc, eq));
            } else if (property.equals("SPROP")) {
                retString = EqContainersToken.getSPropToken(pc, eq);
            } else if (property.equals("TOTALWEIGHT") || property.equals("WT")) {
                retString = BigDecimalHelper.trimZeros((String)Float.toString(EqContainersToken.getTotalWeightToken(pc, eq)));
            } else if (property.equals("TYPE")) {
                retString = EqContainersToken.getTypeToken(eq, aTok);
            }
        }
        return retString;
    }

    public static int getAcCheckToken(PlayerCharacter pc, Equipment eq) {
        return eq.acCheck(pc);
    }

    public static int getAcModToken(PlayerCharacter pc, Equipment eq) {
        return eq.getACMod(pc);
    }

    public static String getAltCritToken(Equipment eq) {
        return eq.getAltCritMult();
    }

    public static String getAltDamageToken(PlayerCharacter pc, Equipment eq) {
        return eq.getAltDamage(pc);
    }

    public static double getAttacksToken(PlayerCharacter pc, Equipment eq) {
        return eq.bonusTo(pc, "COMBAT", "ATTACKS", true);
    }

    public static float getCarriedToken(Equipment eq) {
        return eq.numberCarried().floatValue();
    }

    public static String getContentsToken(Equipment eq, StringTokenizer aTok) {
        String retString = "";
        if (aTok.hasMoreTokens()) {
            String aType = aTok.nextToken();
            String aSubTag = "NAME";
            if (aTok.hasMoreTokens()) {
                aSubTag = aTok.nextToken();
            }
            retString = eq.getContainerByType(aType, aSubTag);
        } else {
            retString = eq.getContainerContentsString();
        }
        return retString;
    }

    public static float getContentWeightToken(PlayerCharacter pc, Equipment eq) {
        if (eq.getChildCount() == 0) {
            return 0.0f;
        }
        return eq.getContainedWeight(pc).floatValue();
    }

    public static BigDecimal getCostToken(PlayerCharacter pc, Equipment eq) {
        return eq.getCost(pc);
    }

    public static String getCritMultToken(Equipment eq) {
        return eq.getCritMult();
    }

    public static String getCritRangeToken(PlayerCharacter pc, Equipment eq) {
        int critRange = pc.getCritRange(eq, true);
        return critRange == 0 ? "" : Integer.toString(critRange);
    }

    public static String getDamageToken(PlayerCharacter pc, Equipment eq) {
        String retString = eq.getDamage(pc);
        if (pc != null && eq.isNatural()) {
            retString = Globals.adjustDamage((String)retString, (int)pc.getDisplay().getRace().getSafe(FormulaKey.SIZE).resolve(pc, "").intValue(), (int)pc.getDisplay().sizeInt());
        }
        return retString;
    }

    public static int getEdrToken(PlayerCharacter pc, Equipment eq) {
        return eq.eDR(pc);
    }

    public static String getEquippedToken(Equipment eq) {
        if (eq.isEquipped()) {
            return "Y";
        }
        return "N";
    }

    public static float getItemWeightToken(PlayerCharacter pc, Equipment eq) {
        return eq.getWeight(pc).floatValue();
    }

    public static String getLocationToken(Equipment eq) {
        return eq.getParentName();
    }

    public static String getLongNameToken(Equipment eq) {
        StringBuilder retString = new StringBuilder();
        for (int depth = eq.itemDepth(); depth > 0; --depth) {
            retString.append(INDENT);
        }
        retString.append(eq.longName());
        return retString.toString();
    }

    public static int getMaxDexToken(PlayerCharacter pc, Equipment eq) {
        return eq.getMaxDex(pc);
    }

    public static String getMoveToken(Equipment eq) {
        return eq.moveString();
    }

    public static String getNameToken(Equipment eq, PlayerCharacter pc) {
        return OutputNameFormatting.parseOutputName((CDOMObject)eq, (PlayerCharacter)pc);
    }

    public static double getQuantityToken(Equipment eq) {
        return eq.qty();
    }

    public static int getRangeToken(Equipment eq, PlayerCharacter pc) {
        return eq.getRange(pc);
    }

    public static String getSizeToken(Equipment eq) {
        return eq.getSize();
    }

    public static int getSpellFailureToken(PlayerCharacter pc, Equipment eq) {
        return eq.spellFailure(pc);
    }

    public static String getSPropToken(PlayerCharacter pc, Equipment eq) {
        return eq.getSpecialProperties(pc);
    }

    public static float getTotalWeightToken(PlayerCharacter pc, Equipment eq) {
        return EqContainersToken.getContentWeightToken(pc, eq) + EqContainersToken.getItemWeightToken(pc, eq);
    }

    public static String getTypeToken(Equipment eq, StringTokenizer aTok) {
        String retString = "";
        if (aTok.hasMoreTokens()) {
            try {
                int x = Integer.parseInt(aTok.nextToken());
                retString = eq.typeIndex(x);
            }
            catch (NumberFormatException numberFormatException) {}
        } else {
            retString = eq.getType();
        }
        return retString;
    }

    private Equipment getContainer(PlayerCharacter pc, int no) {
        for (Equipment eq : pc.getEquipmentListInOutputOrder()) {
            if (eq.isContainer()) {
                --no;
            }
            if (no >= 0) continue;
            return eq;
        }
        return null;
    }
}

