/*
 * Decompiled with CFR 0.152.
 */
package plugin.lsttokens.pcclass;

import java.util.ArrayList;
import java.util.StringTokenizer;
import pcgen.base.formula.Formula;
import pcgen.cdom.base.CDOMObject;
import pcgen.cdom.base.ChoiceSet;
import pcgen.cdom.base.ConcreteTransitionChoice;
import pcgen.cdom.base.FormulaFactory;
import pcgen.cdom.base.PrimitiveChoiceSet;
import pcgen.cdom.base.SelectableSet;
import pcgen.cdom.base.TransitionChoice;
import pcgen.cdom.choiceset.ReferenceChoiceSet;
import pcgen.cdom.enumeration.ObjectKey;
import pcgen.cdom.list.ClassSkillList;
import pcgen.cdom.reference.CDOMGroupRef;
import pcgen.core.PCClass;
import pcgen.rules.context.LoadContext;
import pcgen.rules.persistence.token.AbstractTokenWithSeparator;
import pcgen.rules.persistence.token.CDOMPrimaryToken;
import pcgen.rules.persistence.token.ParseResult;

public class SkilllistToken
extends AbstractTokenWithSeparator<PCClass>
implements CDOMPrimaryToken<PCClass> {
    private static final Class<ClassSkillList> SKILLLIST_CLASS = ClassSkillList.class;

    public String getTokenName() {
        return "SKILLLIST";
    }

    protected char separator() {
        return '|';
    }

    protected ParseResult parseTokenWithSeparator(LoadContext context, PCClass pcc, String value) {
        StringTokenizer tok = new StringTokenizer(value, "|");
        Formula count = FormulaFactory.getFormulaFor((String)tok.nextToken());
        if (!count.isValid()) {
            return new ParseResult.Fail("Count in " + this.getTokenName() + " was not valid: " + count.toString(), context);
        }
        if (!count.isStatic() || count.resolveStatic().intValue() <= 0) {
            return new ParseResult.Fail("Count in " + this.getTokenName() + " must be > 0", context);
        }
        if (!tok.hasMoreTokens()) {
            return new ParseResult.Fail(this.getTokenName() + " must have a | separating " + "count from the list of possible values: " + value, context);
        }
        ArrayList<CDOMGroupRef> refs = new ArrayList<CDOMGroupRef>();
        while (tok.hasMoreTokens()) {
            String token = tok.nextToken();
            Object ref = "ALL".equals(token) ? context.getReferenceContext().getCDOMAllReference(SKILLLIST_CLASS) : context.getReferenceContext().getCDOMReference(SKILLLIST_CLASS, token);
            refs.add((CDOMGroupRef)ref);
        }
        ReferenceChoiceSet rcs = new ReferenceChoiceSet(refs);
        if (!rcs.getGroupingState().isValid()) {
            return new ParseResult.Fail("Non-sensical " + this.getTokenName() + ": Contains ANY and a specific reference: " + value);
        }
        ChoiceSet cs = new ChoiceSet(this.getTokenName(), (PrimitiveChoiceSet)rcs);
        cs.setTitle("Select class whose class-skills this class will inherit");
        ConcreteTransitionChoice tc = new ConcreteTransitionChoice((SelectableSet)cs, count);
        context.getObjectContext().put((CDOMObject)pcc, ObjectKey.SKILLLIST_CHOICE, (Object)tc);
        tc.setRequired(false);
        return ParseResult.SUCCESS;
    }

    public String[] unparse(LoadContext context, PCClass pcc) {
        TransitionChoice grantChanges = (TransitionChoice)context.getObjectContext().getObject((CDOMObject)pcc, ObjectKey.SKILLLIST_CHOICE);
        if (grantChanges == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        Formula count = grantChanges.getCount();
        if (count == null) {
            context.addWriteMessage("Unable to find " + this.getTokenName() + " Count");
            return null;
        }
        sb.append(count);
        sb.append("|");
        sb.append(grantChanges.getChoices().getLSTformat().replaceAll(",", "|"));
        return new String[]{sb.toString()};
    }

    public Class<PCClass> getTokenClass() {
        return PCClass.class;
    }
}

