/*
 * Decompiled with CFR 0.152.
 */
package pcgen.cdom.facet.analysis;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import pcgen.base.util.NamedValue;
import pcgen.cdom.base.CDOMObject;
import pcgen.cdom.base.FormulaFactory;
import pcgen.cdom.enumeration.CharID;
import pcgen.cdom.facet.BonusCheckingFacet;
import pcgen.cdom.facet.EquipmentFacet;
import pcgen.cdom.facet.FormulaResolvingFacet;
import pcgen.cdom.facet.analysis.BaseMovementFacet;
import pcgen.cdom.facet.analysis.LoadFacet;
import pcgen.cdom.facet.analysis.MovementFacet;
import pcgen.cdom.facet.analysis.UnencumberedArmorFacet;
import pcgen.cdom.facet.analysis.UnencumberedLoadFacet;
import pcgen.cdom.facet.base.AbstractItemFacet;
import pcgen.cdom.facet.base.AbstractStorageFacet;
import pcgen.cdom.facet.event.DataFacetChangeEvent;
import pcgen.cdom.facet.event.DataFacetChangeListener;
import pcgen.cdom.facet.model.DeityFacet;
import pcgen.cdom.facet.model.RaceFacet;
import pcgen.cdom.facet.model.TemplateFacet;
import pcgen.core.Equipment;
import pcgen.core.Globals;
import pcgen.core.Movement;
import pcgen.core.Race;
import pcgen.core.SettingsHandler;
import pcgen.core.utils.CoreUtility;
import pcgen.util.enumeration.Load;

public class MovementResultFacet
extends AbstractStorageFacet<CharID>
implements DataFacetChangeListener<CharID, CDOMObject> {
    private MovementFacet movementFacet;
    private BaseMovementFacet baseMovementFacet;
    private RaceFacet raceFacet;
    private TemplateFacet templateFacet;
    private DeityFacet deityFacet;
    private EquipmentFacet equipmentFacet;
    private BonusCheckingFacet bonusCheckingFacet;
    private UnencumberedArmorFacet unencumberedArmorFacet;
    private UnencumberedLoadFacet unencumberedLoadFacet;
    private FormulaResolvingFacet formulaResolvingFacet;
    private LoadFacet loadFacet;
    public static final double[] EMPTY_DOUBLE_ARRAY = new double[0];

    public double movementOfType(CharID id, String moveType) {
        MovementCacheInfo mci = this.getInfo(id);
        if (mci == null) {
            return 0.0;
        }
        return mci.movementOfType(id, moveType);
    }

    private MovementCacheInfo getConstructingInfo(CharID id) {
        MovementCacheInfo rci = this.getInfo(id);
        if (rci == null) {
            rci = new MovementCacheInfo();
            this.setCache(id, rci);
        }
        return rci;
    }

    private MovementCacheInfo getInfo(CharID id) {
        return (MovementCacheInfo)this.getCache(id);
    }

    public int countMovementTypes(CharID id) {
        MovementCacheInfo mci = this.getInfo(id);
        if (mci == null) {
            return 0;
        }
        return mci.countMovementTypes();
    }

    public void reset(CharID id) {
        this.getConstructingInfo(id).adjustMoveRates(id);
    }

    public List<NamedValue> getMovementValues(CharID id) {
        MovementCacheInfo mci = this.getInfo(id);
        if (mci == null) {
            return Collections.emptyList();
        }
        return mci.getMovementValues(id);
    }

    public double getMovementOfType(CharID id, String moveType) {
        MovementCacheInfo mci = this.getInfo(id);
        if (mci == null) {
            return 0.0;
        }
        return mci.getMovementOfType(moveType);
    }

    public int getBaseMovement(CharID id, String moveType, Load load) {
        MovementCacheInfo mci = this.getInfo(id);
        if (mci == null) {
            return 0;
        }
        return mci.getBaseMovement(moveType, load);
    }

    public boolean hasMovement(CharID id, String moveType) {
        MovementCacheInfo mci = this.getInfo(id);
        if (mci == null) {
            return false;
        }
        return mci.hasMovement(moveType);
    }

    @Override
    public void dataAdded(DataFacetChangeEvent<CharID, CDOMObject> dfce) {
        this.reset(dfce.getCharID());
    }

    @Override
    public void dataRemoved(DataFacetChangeEvent<CharID, CDOMObject> dfce) {
        this.reset(dfce.getCharID());
    }

    public void setMovementFacet(MovementFacet movementFacet) {
        this.movementFacet = movementFacet;
    }

    public void setBaseMovementFacet(BaseMovementFacet baseMovementFacet) {
        this.baseMovementFacet = baseMovementFacet;
    }

    public void setRaceFacet(RaceFacet raceFacet) {
        this.raceFacet = raceFacet;
    }

    public void setTemplateFacet(TemplateFacet templateFacet) {
        this.templateFacet = templateFacet;
    }

    public void setDeityFacet(DeityFacet deityFacet) {
        this.deityFacet = deityFacet;
    }

    public void setEquipmentFacet(EquipmentFacet equipmentFacet) {
        this.equipmentFacet = equipmentFacet;
    }

    public void setBonusCheckingFacet(BonusCheckingFacet bonusCheckingFacet) {
        this.bonusCheckingFacet = bonusCheckingFacet;
    }

    public void setUnencumberedArmorFacet(UnencumberedArmorFacet unencumberedArmorFacet) {
        this.unencumberedArmorFacet = unencumberedArmorFacet;
    }

    public void setUnencumberedLoadFacet(UnencumberedLoadFacet unencumberedLoadFacet) {
        this.unencumberedLoadFacet = unencumberedLoadFacet;
    }

    public void setFormulaResolvingFacet(FormulaResolvingFacet formulaResolvingFacet) {
        this.formulaResolvingFacet = formulaResolvingFacet;
    }

    public void setLoadFacet(LoadFacet loadFacet) {
        this.loadFacet = loadFacet;
    }

    public void init() {
        this.raceFacet.addDataFacetChangeListener(2000, this);
        this.deityFacet.addDataFacetChangeListener(2000, this);
        this.templateFacet.addDataFacetChangeListener(2000, this);
    }

    @Override
    public void copyContents(CharID source, CharID copy) {
        MovementCacheInfo mci = this.getInfo(source);
        if (mci != null) {
            MovementCacheInfo copymci = this.getConstructingInfo(copy);
            if (mci.movementMult != null) {
                MovementCacheInfo.access$902(copymci, (double[])mci.movementMult.clone());
            }
            if (mci.movementMultOp != null) {
                MovementCacheInfo.access$1002(copymci, (String[])mci.movementMultOp.clone());
            }
            if (mci.movements != null) {
                MovementCacheInfo.access$1102(copymci, (double[])mci.movements.clone());
            }
            if (mci.movementTypes != null) {
                MovementCacheInfo.access$1202(copymci, (String[])mci.movementTypes.clone());
            }
        }
    }

    public class MovementCacheInfo {
        private double[] movementMult = EMPTY_DOUBLE_ARRAY;
        private String[] movementMultOp = Globals.EMPTY_STRING_ARRAY;
        private String[] movementTypes = Globals.EMPTY_STRING_ARRAY;
        private double[] movements = EMPTY_DOUBLE_ARRAY;

        public double movementOfType(CharID id, String moveType) {
            if (this.movementTypes == null) {
                return 0.0;
            }
            for (int moveIdx = 0; moveIdx < this.movementTypes.length; ++moveIdx) {
                if (!this.movementTypes[moveIdx].equalsIgnoreCase(moveType)) continue;
                return this.movement(id, moveIdx);
            }
            return 0.0;
        }

        public int countMovementTypes() {
            return this.movements != null ? this.movements.length : 0;
        }

        public void adjustMoveRates(CharID id) {
            this.movementMult = EMPTY_DOUBLE_ARRAY;
            this.movementMultOp = Globals.EMPTY_STRING_ARRAY;
            this.movementTypes = Globals.EMPTY_STRING_ARRAY;
            this.movements = EMPTY_DOUBLE_ARRAY;
            Race race = (Race)((AbstractItemFacet)MovementResultFacet.this.raceFacet).get(id);
            if (race == null) {
                return;
            }
            Set mms = MovementResultFacet.this.baseMovementFacet.getSet(id);
            if (mms == null || mms.isEmpty()) {
                return;
            }
            Movement movement = (Movement)mms.iterator().next();
            this.movements = movement.getMovements();
            this.movementTypes = movement.getMovementTypes();
            this.movementMult = movement.getMovementMult();
            this.movementMultOp = movement.getMovementMultOp();
            for (Movement mv : MovementResultFacet.this.movementFacet.getSet(id)) {
                for (int i1 = 0; i1 < mv.getNumberOfMovements(); ++i1) {
                    if (mv.getMovementType(i1) == null) continue;
                    this.setMyMoveRates(mv.getMovementType(i1), mv.getMovement(i1), mv.getMovementMult(i1), mv.getMovementMultOp(i1), mv.getMoveRatesFlag());
                }
            }
            for (String moveType : MovementResultFacet.this.bonusCheckingFacet.getExpandedBonusInfo(id, "MOVEADD")) {
                if (moveType.startsWith("TYPE")) {
                    moveType = moveType.substring(5);
                }
                if (moveType.equalsIgnoreCase("ALL")) continue;
                moveType = CoreUtility.capitalizeFirstLetter(moveType);
                boolean found = false;
                for (int i = 0; i < this.movements.length; ++i) {
                    if (!moveType.equals(this.movementTypes[i])) continue;
                    found = true;
                }
                if (found) continue;
                this.setMyMoveRates(moveType, 0.0, 0.0, "", 0);
            }
        }

        private void setMyMoveRates(String moveType, double anDouble, double moveMult, String multOp, int moveFlag) {
            if ("ALL".equals(moveType)) {
                if (moveFlag == 0) {
                    for (int i = 0; i < this.movements.length; ++i) {
                        double moveRate;
                        this.movements[i] = moveRate = anDouble;
                    }
                } else {
                    for (int i = 0; i < this.movements.length; ++i) {
                        double moveRate;
                        this.movements[i] = moveRate = anDouble + this.movements[i];
                    }
                }
            } else if (moveFlag == 0) {
                double moveRate = anDouble;
                for (int i = 0; i < this.movements.length; ++i) {
                    if (!moveType.equals(this.movementTypes[i])) continue;
                    if (moveRate > this.movements[i]) {
                        this.movements[i] = moveRate;
                    }
                    if (multOp != null && (this.movementMultOp[i] == null || multOp.length() > 0)) {
                        this.movementMult[i] = moveMult;
                        this.movementMultOp[i] = multOp;
                    }
                    return;
                }
                this.increaseMoveArray(moveRate, moveType, moveMult, multOp);
            } else {
                double moveRate = anDouble + this.movements[0];
                for (int i = 0; i < this.movements.length; ++i) {
                    if (!moveType.equals(this.movementTypes[i])) continue;
                    this.movements[i] = moveRate;
                    this.movementMult[i] = moveMult;
                    this.movementMultOp[i] = multOp;
                    return;
                }
                this.increaseMoveArray(moveRate, moveType, moveMult, multOp);
            }
        }

        private void increaseMoveArray(double moveRate, String moveType, Double moveMult, String multOp) {
            double[] tempMove = this.movements;
            String[] tempType = this.movementTypes;
            double[] tempMult = this.movementMult;
            String[] tempMultOp = this.movementMultOp;
            this.movements = new double[tempMove.length + 1];
            this.movementTypes = new String[tempMove.length + 1];
            this.movementMult = new double[tempMove.length + 1];
            this.movementMultOp = new String[tempMove.length + 1];
            System.arraycopy(tempMove, 0, this.movements, 0, tempMove.length);
            System.arraycopy(tempType, 0, this.movementTypes, 0, tempMove.length);
            System.arraycopy(tempMult, 0, this.movementMult, 0, tempMove.length);
            System.arraycopy(tempMultOp, 0, this.movementMultOp, 0, tempMove.length);
            this.movements[tempMove.length] = moveRate;
            this.movementTypes[tempMove.length] = moveType;
            this.movementMult[tempMove.length] = moveMult;
            this.movementMultOp[tempMove.length] = multOp;
        }

        public double movement(CharID id, int moveIdx) {
            double moveInFeet = this.getMovement(moveIdx);
            moveInFeet += MovementResultFacet.this.bonusCheckingFacet.getBonus(id, "MOVEADD", "TYPE." + this.getMovementType(moveIdx).toUpperCase());
            double calcMove = moveInFeet += MovementResultFacet.this.bonusCheckingFacet.getBonus(id, "MOVEADD", "TYPE.ALL");
            if (this.getMovementMult(moveIdx) > 0.0) {
                calcMove = this.calcMoveMult(moveInFeet, moveIdx);
            }
            double moveMult = MovementResultFacet.this.bonusCheckingFacet.getBonus(id, "MOVEMULT", "TYPE." + this.getMovementType(moveIdx).toUpperCase());
            if ((moveMult += MovementResultFacet.this.bonusCheckingFacet.getBonus(id, "MOVEMULT", "TYPE.ALL")) > 0.0) {
                calcMove = (int)(calcMove * moveMult);
            }
            double postMove = calcMove;
            postMove += MovementResultFacet.this.bonusCheckingFacet.getBonus(id, "POSTMOVEADD", "TYPE." + this.getMovementType(moveIdx).toUpperCase());
            moveInFeet = Math.max(calcMove, postMove += MovementResultFacet.this.bonusCheckingFacet.getBonus(id, "POSTMOVEADD", "TYPE.ALL"));
            Load armorLoad = Load.LIGHT;
            for (Equipment eq : MovementResultFacet.this.equipmentFacet.getSet(id)) {
                if (!eq.typeStringContains("Armor") || !eq.isEquipped() || eq.isShield()) continue;
                if (eq.isHeavy() && !MovementResultFacet.this.unencumberedArmorFacet.ignoreLoad(id, Load.HEAVY)) {
                    armorLoad = armorLoad.max(Load.HEAVY);
                    continue;
                }
                if (!eq.isMedium() || MovementResultFacet.this.unencumberedArmorFacet.ignoreLoad(id, Load.MEDIUM)) continue;
                armorLoad = armorLoad.max(Load.MEDIUM);
            }
            double armorMove = Globals.calcEncumberedMove(armorLoad, moveInFeet);
            Load pcLoad = MovementResultFacet.this.loadFacet.getLoadType(id);
            double loadMove = this.calcEncumberedMove(id, pcLoad, moveInFeet);
            moveInFeet = Math.min(armorMove, loadMove);
            return moveInFeet;
        }

        private double getMovement(int moveIdx) {
            if (this.movements != null && moveIdx < this.movements.length) {
                return this.movements[moveIdx];
            }
            return 0.0;
        }

        public String getMovementType(int moveIdx) {
            if (this.movementTypes != null && moveIdx < this.movementTypes.length) {
                return this.movementTypes[moveIdx];
            }
            return "";
        }

        private double getMovementMult(int moveIdx) {
            if (this.movements != null && moveIdx < this.movementMult.length) {
                return this.movementMult[moveIdx];
            }
            return 0.0;
        }

        private double calcMoveMult(double move, int index) {
            double iMove = 0.0;
            if (this.movementMultOp[index].charAt(0) == '*') {
                iMove = move * this.movementMult[index];
            } else if (this.movementMultOp[index].charAt(0) == '/') {
                iMove = move / this.movementMult[index];
            }
            if (iMove > 0.0) {
                return iMove;
            }
            return move;
        }

        public List<NamedValue> getMovementValues(CharID id) {
            ArrayList<NamedValue> list = new ArrayList<NamedValue>();
            for (int i = 0; i < this.countMovementTypes(); ++i) {
                list.add(new NamedValue(this.getMovementType(i), this.movement(id, i)));
            }
            return list;
        }

        public double getMovementOfType(String moveType) {
            for (int x = 0; x < this.countMovementTypes(); ++x) {
                String type = this.getMovementType(x);
                if (!moveType.equalsIgnoreCase(type)) continue;
                return this.getMovement(x);
            }
            return 0.0;
        }

        public int getBaseMovement(String moveType, Load load) {
            for (int i = 0; i < this.countMovementTypes(); ++i) {
                if (!this.getMovementType(i).equalsIgnoreCase(moveType)) continue;
                return (int)this.getMovement(i);
            }
            return 0;
        }

        public boolean hasMovement(String moveType) {
            for (int i = 0; i < this.countMovementTypes(); ++i) {
                if (!this.getMovementType(i).equalsIgnoreCase(moveType)) continue;
                return true;
            }
            return false;
        }

        public double calcEncumberedMove(CharID id, Load load, double unencumberedMove) {
            if (!MovementResultFacet.this.unencumberedLoadFacet.ignoreLoad(id, load)) {
                String formula = SettingsHandler.getGame().getLoadInfo().getLoadMoveFormula(load.toString());
                if (formula.length() != 0) {
                    formula = formula.replaceAll(Pattern.quote("$$MOVE$$"), Double.toString(Math.floor(unencumberedMove)));
                    return MovementResultFacet.this.formulaResolvingFacet.resolve(id, FormulaFactory.getFormulaFor(formula), "").doubleValue();
                }
                return Globals.calcEncumberedMove(load, unencumberedMove);
            }
            double encumberedMove = unencumberedMove;
            return encumberedMove;
        }

        public int hashCode() {
            return this.movementTypes.length == 0 ? -1 : this.movementTypes[0].hashCode();
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (o instanceof MovementCacheInfo) {
                MovementCacheInfo ci = (MovementCacheInfo)o;
                return Arrays.equals(this.movementMult, ci.movementMult) && Arrays.deepEquals(this.movementMultOp, ci.movementMultOp) && Arrays.deepEquals(this.movementTypes, ci.movementTypes) && Arrays.equals(this.movements, ci.movements);
            }
            return false;
        }

        static /* synthetic */ double[] access$902(MovementCacheInfo x0, double[] x1) {
            x0.movementMult = x1;
            return x1;
        }

        static /* synthetic */ String[] access$1002(MovementCacheInfo x0, String[] x1) {
            x0.movementMultOp = x1;
            return x1;
        }

        static /* synthetic */ double[] access$1102(MovementCacheInfo x0, double[] x1) {
            x0.movements = x1;
            return x1;
        }

        static /* synthetic */ String[] access$1202(MovementCacheInfo x0, String[] x1) {
            x0.movementTypes = x1;
            return x1;
        }
    }
}

