/*
 * Decompiled with CFR 0.152.
 */
package pcgen.cdom.facet.analysis;

import java.util.List;
import pcgen.base.util.HashMapToList;
import pcgen.base.util.MapToList;
import pcgen.cdom.base.CDOMObject;
import pcgen.cdom.base.Loadable;
import pcgen.cdom.enumeration.CharID;
import pcgen.cdom.enumeration.ListKey;
import pcgen.cdom.facet.CDOMObjectConsolidationFacet;
import pcgen.cdom.facet.base.AbstractStorageFacet;
import pcgen.cdom.facet.event.DataFacetChangeEvent;
import pcgen.cdom.facet.event.DataFacetChangeListener;
import pcgen.cdom.reference.CDOMSingleRef;
import pcgen.cdom.reference.Qualifier;

public class QualifyFacet
extends AbstractStorageFacet<CharID>
implements DataFacetChangeListener<CharID, CDOMObject> {
    private CDOMObjectConsolidationFacet consolidationFacet;

    @Override
    public void dataAdded(DataFacetChangeEvent<CharID, CDOMObject> dfce) {
        CDOMObject cdo = dfce.getCDOMObject();
        List<Qualifier> qualList = cdo.getListFor(ListKey.QUALIFY);
        CacheInfo ci = this.getConstructingCacheInfo(dfce.getCharID());
        if (qualList != null) {
            for (Qualifier q : qualList) {
                ci.add(q, cdo);
            }
        }
    }

    @Override
    public void dataRemoved(DataFacetChangeEvent<CharID, CDOMObject> dfce) {
        CharID id = dfce.getCharID();
        CacheInfo ci = (CacheInfo)this.getCache(id);
        if (ci != null) {
            ci.removeAll(dfce.getCDOMObject());
        }
    }

    private CacheInfo getConstructingCacheInfo(CharID id) {
        CacheInfo ci = (CacheInfo)this.getCache(id);
        if (ci == null) {
            ci = new CacheInfo();
            this.setCache(id, ci);
        }
        return ci;
    }

    private CacheInfo getCacheInfo(CharID id) {
        return (CacheInfo)this.getCache(id);
    }

    public boolean grantsQualify(CharID id, CDOMObject qualTestObject) {
        CacheInfo ci = this.getCacheInfo(id);
        return ci != null && ci.isQualified(qualTestObject);
    }

    public void setConsolidationFacet(CDOMObjectConsolidationFacet consolidationFacet) {
        this.consolidationFacet = consolidationFacet;
    }

    public void init() {
        this.consolidationFacet.addDataFacetChangeListener(this);
    }

    public int getCount(CharID id) {
        CacheInfo ci = (CacheInfo)this.getCache(id);
        return ci == null ? 0 : ci.hml.size();
    }

    @Override
    public void copyContents(CharID source, CharID copy) {
        CacheInfo ci = this.getCacheInfo(source);
        if (ci != null) {
            CacheInfo copyci = this.getConstructingCacheInfo(copy);
            copyci.hml.addAllLists((MapToList)ci.hml);
            copyci.sourceMap.addAllLists((MapToList)ci.sourceMap);
        }
    }

    private static class CacheInfo {
        private HashMapToList<Class<? extends Loadable>, Qualifier> hml = new HashMapToList();
        private HashMapToList<CDOMObject, Qualifier> sourceMap = new HashMapToList();

        private CacheInfo() {
        }

        public void add(Qualifier q, CDOMObject source) {
            this.hml.addToListFor(q.getQualifiedClass(), (Object)q);
            this.sourceMap.addToListFor((Object)source, (Object)q);
        }

        public void removeAll(CDOMObject object) {
            List list = this.sourceMap.removeListFor((Object)object);
            if (list != null) {
                for (Qualifier q : list) {
                    this.hml.removeFromListFor(q.getQualifiedClass(), (Object)q);
                }
            }
        }

        public boolean isQualified(Loadable qualTestObject) {
            Class<?> cl = qualTestObject.getClass();
            List list = this.hml.getListFor(cl);
            if (list != null) {
                for (Qualifier q : list) {
                    CDOMSingleRef<? extends Loadable> qRef = q.getQualifiedReference();
                    if (!qRef.contains(qualTestObject)) continue;
                    return true;
                }
            }
            return false;
        }

        public int hashCode() {
            return this.hml.hashCode();
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (o instanceof CacheInfo) {
                CacheInfo ci = (CacheInfo)o;
                return ci.hml.equals(this.hml) && ci.sourceMap.equals(this.sourceMap);
            }
            return false;
        }
    }
}

