/*
 * Decompiled with CFR 0.152.
 */
package pcgen.cdom.facet.base;

import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Set;
import pcgen.base.util.ListSet;
import pcgen.cdom.enumeration.CharID;
import pcgen.cdom.facet.base.AbstractScopeFacet;

public abstract class AbstractAssociationFacet<S, A>
extends AbstractScopeFacet<CharID, S, A> {
    public A get(CharID id, S obj) {
        if (obj == null) {
            throw new IllegalArgumentException("Object for getting association may not be null");
        }
        Map<S, A> map = this.getCachedMap(id);
        if (map != null) {
            return map.get(obj);
        }
        return null;
    }

    public void set(CharID id, S obj, A association) {
        if (obj == null) {
            throw new IllegalArgumentException("Object to add may not be null");
        }
        if (association == null) {
            throw new IllegalArgumentException("Association may not be null");
        }
        A old = this.getConstructingCachedMap(id).put(obj, association);
        if (old != null) {
            this.fireScopeFacetChangeEvent(id, obj, old, 1);
        }
        this.fireScopeFacetChangeEvent(id, obj, association, 0);
    }

    public void remove(CharID id, S obj) {
        A old;
        Map<S, A> map = this.getCachedMap(id);
        if (map != null && (old = map.remove(obj)) != null) {
            this.fireScopeFacetChangeEvent(id, obj, old, 1);
        }
    }

    public Map<S, A> removeAll(CharID id) {
        Map componentMap = (Map)this.removeCache(id);
        if (componentMap == null) {
            return Collections.emptyMap();
        }
        for (Map.Entry entry : componentMap.entrySet()) {
            this.fireScopeFacetChangeEvent(id, entry.getKey(), entry.getValue(), 1);
        }
        return componentMap;
    }

    public Set<S> getSet(CharID id) {
        Map<S, A> componentMap = this.getCachedMap(id);
        if (componentMap == null) {
            return Collections.emptySet();
        }
        return Collections.unmodifiableSet(new ListSet(componentMap.keySet()));
    }

    public int getCount(CharID id) {
        Map<S, A> componentMap = this.getCachedMap(id);
        if (componentMap == null) {
            return 0;
        }
        return componentMap.size();
    }

    public boolean isEmpty(CharID id) {
        Map<S, A> componentMap = this.getCachedMap(id);
        return componentMap == null || componentMap.isEmpty();
    }

    public boolean contains(CharID id, S obj) {
        Map<S, A> componentMap = this.getCachedMap(id);
        return componentMap != null && componentMap.containsKey(obj);
    }

    protected Map<S, A> getCachedMap(CharID id) {
        return (Map)this.getCache(id);
    }

    private Map<S, A> getConstructingCachedMap(CharID id) {
        Map<S, A> componentMap = this.getCachedMap(id);
        if (componentMap == null) {
            componentMap = this.getComponentMap();
            this.setCache(id, componentMap);
        }
        return componentMap;
    }

    protected Map<S, A> getComponentMap() {
        return new IdentityHashMap();
    }

    @Override
    public void copyContents(CharID source, CharID destination) {
        Map<S, A> sourceMap = this.getCachedMap(source);
        if (sourceMap != null) {
            this.getConstructingCachedMap(destination).putAll(sourceMap);
        }
    }
}

