/*
 * Decompiled with CFR 0.152.
 */
package pcgen.cdom.facet.base;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import pcgen.base.util.WrappedMapSet;
import pcgen.cdom.base.QualifiedActor;
import pcgen.cdom.base.QualifyingObject;
import pcgen.cdom.enumeration.CharID;
import pcgen.cdom.facet.FacetLibrary;
import pcgen.cdom.facet.PrerequisiteFacet;
import pcgen.cdom.facet.base.AbstractDataFacet;

public abstract class AbstractQualifiedListFacet<T extends QualifyingObject>
extends AbstractDataFacet<CharID, T> {
    private PrerequisiteFacet prereqFacet = FacetLibrary.getFacet(PrerequisiteFacet.class);

    public void add(CharID id, T obj, Object source) {
        boolean fireNew;
        if (obj == null) {
            throw new IllegalArgumentException("Object to add may not be null");
        }
        Map<T, Set<Object>> map = this.getConstructingCachedMap(id);
        WrappedMapSet set = map.get(obj);
        boolean bl = fireNew = set == null;
        if (fireNew) {
            set = new WrappedMapSet(IdentityHashMap.class);
            map.put(obj, (Set<Object>)set);
        }
        set.add((Object)source);
        if (fireNew) {
            this.fireDataFacetChangeEvent(id, obj, 0);
        }
    }

    public void addAll(CharID id, Collection<? extends T> c, Object source) {
        for (QualifyingObject obj : c) {
            this.add(id, obj, source);
        }
    }

    public void remove(CharID id, T obj, Object source) {
        Map<T, Set<Object>> componentMap = this.getCachedMap(id);
        if (componentMap != null) {
            this.processRemoval(id, componentMap, obj, source);
        }
    }

    public void removeAll(CharID id, Collection<T> c, Object source) {
        Map<T, Set<Object>> componentMap = this.getCachedMap(id);
        if (componentMap != null) {
            for (QualifyingObject obj : c) {
                this.processRemoval(id, componentMap, obj, source);
            }
        }
    }

    public Map<T, Set<Object>> removeAll(CharID id) {
        Map<T, Set<Object>> componentMap = this.getCachedMap(id);
        if (componentMap == null) {
            return Collections.emptyMap();
        }
        this.removeCache(id);
        for (QualifyingObject obj : componentMap.keySet()) {
            this.fireDataFacetChangeEvent(id, obj, 1);
        }
        return componentMap;
    }

    public Set<T> getSet(CharID id) {
        Map<T, Set<Object>> componentMap = this.getCachedMap(id);
        if (componentMap == null) {
            return Collections.emptySet();
        }
        return Collections.unmodifiableSet(componentMap.keySet());
    }

    public int getCount(CharID id) {
        Map<T, Set<Object>> componentMap = this.getCachedMap(id);
        if (componentMap == null) {
            return 0;
        }
        return componentMap.size();
    }

    public boolean isEmpty(CharID id) {
        Map<T, Set<Object>> componentMap = this.getCachedMap(id);
        return componentMap == null || componentMap.isEmpty();
    }

    public boolean contains(CharID id, T obj) {
        Map<T, Set<Object>> componentMap = this.getCachedMap(id);
        return componentMap != null && componentMap.containsKey(obj);
    }

    private Set<Object> getConstructingCachedSetFor(CharID id, T obj) {
        Map<T, Set<Object>> map = this.getConstructingCachedMap(id);
        WrappedMapSet set = map.get(obj);
        if (set == null) {
            set = new WrappedMapSet(IdentityHashMap.class);
            map.put(obj, (Set<Object>)set);
        }
        return set;
    }

    private Map<T, Set<Object>> getCachedMap(CharID id) {
        return (Map)this.getCache(id);
    }

    private Map<T, Set<Object>> getConstructingCachedMap(CharID id) {
        Map<T, Set<Object>> componentMap = this.getCachedMap(id);
        if (componentMap == null) {
            componentMap = this.getComponentMap();
            this.setCache(id, componentMap);
        }
        return componentMap;
    }

    protected Map<T, Set<Object>> getComponentMap() {
        return new IdentityHashMap();
    }

    @Override
    public void copyContents(CharID source, CharID destination) {
        Map<T, Set<Object>> sourceMap = this.getCachedMap(source);
        if (sourceMap != null) {
            for (Map.Entry<T, Set<Object>> me : sourceMap.entrySet()) {
                QualifyingObject obj = (QualifyingObject)me.getKey();
                Set<Object> sourceSet = me.getValue();
                Set<Object> targetSet = this.getConstructingCachedSetFor(destination, obj);
                targetSet.addAll(sourceSet);
            }
        }
    }

    private void processRemoval(CharID id, Map<T, Set<Object>> componentMap, T obj, Object source) {
        if (obj == null) {
            throw new IllegalArgumentException("Object to remove may not be null");
        }
        Set<Object> set = componentMap.get(obj);
        if (set != null) {
            set.remove(source);
            if (set.isEmpty()) {
                componentMap.remove(obj);
                this.fireDataFacetChangeEvent(id, obj, 1);
            }
        }
    }

    public void removeAll(CharID id, Object source) {
        Map<T, Set<Object>> componentMap = this.getCachedMap(id);
        if (componentMap != null) {
            ArrayList<QualifyingObject> removedKeys = new ArrayList<QualifyingObject>();
            Iterator<Map.Entry<T, Set<Object>>> it = componentMap.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry<T, Set<Object>> me = it.next();
                Set<Object> set = me.getValue();
                if (!set.remove(source) || !set.isEmpty()) continue;
                QualifyingObject obj = (QualifyingObject)me.getKey();
                it.remove();
                removedKeys.add(obj);
            }
            if (componentMap.isEmpty()) {
                this.removeCache(id);
            }
            for (QualifyingObject obj : removedKeys) {
                this.fireDataFacetChangeEvent(id, obj, 1);
            }
        }
    }

    public List<? extends T> getSet(CharID id, Object owner) {
        ArrayList<T> list = new ArrayList<T>();
        Map<T, Set<Object>> componentMap = this.getCachedMap(id);
        if (componentMap != null) {
            for (Map.Entry<T, Set<Object>> me : componentMap.entrySet()) {
                Set<Object> set = me.getValue();
                if (!set.contains(owner)) continue;
                list.add(me.getKey());
            }
        }
        return list;
    }

    public Collection<T> getQualifiedSet(CharID id) {
        HashSet<QualifyingObject> set = new HashSet<QualifyingObject>();
        Map<T, Set<Object>> componentMap = this.getCachedMap(id);
        if (componentMap != null) {
            block0: for (Map.Entry<T, Set<Object>> me : componentMap.entrySet()) {
                QualifyingObject obj = (QualifyingObject)me.getKey();
                Set<Object> sources = me.getValue();
                for (Object source : sources) {
                    if (!this.prereqFacet.qualifies(id, obj, source)) continue;
                    set.add(obj);
                    continue block0;
                }
            }
        }
        return set;
    }

    public Collection<T> getQualifiedSet(CharID id, Object source) {
        WrappedMapSet set = new WrappedMapSet(IdentityHashMap.class);
        Map<T, Set<Object>> componentMap = this.getCachedMap(id);
        if (componentMap != null) {
            for (Map.Entry<T, Set<Object>> me : componentMap.entrySet()) {
                QualifyingObject obj = (QualifyingObject)me.getKey();
                Set<Object> sources = me.getValue();
                if (!sources.contains(source) || !this.prereqFacet.qualifies(id, obj, source)) continue;
                set.add(obj);
            }
        }
        return set;
    }

    public <R> List<R> actOnQualifiedSet(CharID id, QualifiedActor<T, R> qa) {
        ArrayList<R> list = new ArrayList<R>();
        Map<T, Set<Object>> componentMap = this.getCachedMap(id);
        if (componentMap != null) {
            for (Map.Entry<T, Set<Object>> me : componentMap.entrySet()) {
                QualifyingObject obj = (QualifyingObject)me.getKey();
                Set<Object> sources = me.getValue();
                for (Object source : sources) {
                    if (!this.prereqFacet.qualifies(id, obj, source)) continue;
                    list.add(qa.act(obj, source));
                }
            }
        }
        return list;
    }

    public Collection<Object> getSources(CharID id, T obj) {
        Set<Object> sources;
        Map<T, Set<Object>> componentMap = this.getCachedMap(id);
        if (componentMap != null && (sources = componentMap.get(obj)) != null) {
            return Collections.unmodifiableSet(sources);
        }
        return Collections.emptySet();
    }
}

