/*
 * Decompiled with CFR 0.152.
 */
package pcgen.cdom.helper;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import pcgen.base.lang.StringUtil;
import pcgen.cdom.base.ConcretePrereqObject;
import pcgen.cdom.content.CNAbility;
import pcgen.cdom.enumeration.AspectName;
import pcgen.cdom.enumeration.MapKey;
import pcgen.core.Ability;
import pcgen.core.PlayerCharacter;
import pcgen.io.EntityEncoder;
import pcgen.persistence.lst.output.prereq.PrerequisiteWriter;
import pcgen.util.Logging;

public class Aspect
extends ConcretePrereqObject {
    private final AspectName key;
    private final List<String> theComponents = new ArrayList<String>();
    private List<String> theVariables = null;
    private static final String VAR_NAME = "%NAME";
    private static final String VAR_LIST = "%LIST";
    private static final String VAR_MARKER = "$$VAR:";

    public Aspect(String name, String aString) {
        if (name == null) {
            throw new IllegalArgumentException("Name for Aspect cannot be null");
        }
        if (aString == null) {
            throw new IllegalArgumentException("Value for Aspect cannot be null");
        }
        this.key = AspectName.getConstant(name);
        this.parseAspectString(aString);
    }

    public Aspect(AspectName key, String aString) {
        if (key == null) {
            throw new IllegalArgumentException("Key for Aspect cannot be null");
        }
        if (aString == null) {
            throw new IllegalArgumentException("Value for Aspect cannot be null");
        }
        this.key = key;
        this.parseAspectString(aString);
    }

    private void parseAspectString(String aString) {
        int currentInd = 0;
        int percentInd = -1;
        while ((percentInd = aString.indexOf(37, currentInd)) != -1) {
            String preText = aString.substring(currentInd, percentInd);
            if (preText.length() > 0) {
                this.theComponents.add(preText);
            }
            if (percentInd == aString.length() - 1) {
                this.theComponents.add("%");
                return;
            }
            if (aString.charAt(percentInd + 1) == '{') {
                currentInd = aString.indexOf(125, percentInd + 1) + 1;
                String replacement = aString.substring(percentInd + 1, currentInd);
                try {
                    Integer.parseInt(replacement);
                }
                catch (NumberFormatException nfe) {
                    Logging.errorPrintLocalised("Errors.Description.InvalidVariableReplacement", replacement);
                }
                this.theComponents.add(VAR_MARKER + replacement);
                continue;
            }
            if (aString.charAt(percentInd + 1) == '%') {
                currentInd = percentInd + 2;
                this.theComponents.add("%");
                continue;
            }
            for (currentInd = percentInd + 1; currentInd < aString.length(); ++currentInd) {
                char val = aString.charAt(currentInd);
                try {
                    Integer.parseInt(String.valueOf(val));
                    continue;
                }
                catch (NumberFormatException nfe) {
                    break;
                }
            }
            if (currentInd > percentInd + 1) {
                this.theComponents.add(VAR_MARKER + aString.substring(percentInd + 1, currentInd));
                continue;
            }
            this.theComponents.add(aString.substring(percentInd, percentInd + 1));
        }
        this.theComponents.add(aString.substring(currentInd));
    }

    public void addVariable(String aVariable) {
        if (this.theVariables == null) {
            this.theVariables = new ArrayList<String>();
        }
        this.theVariables.add(aVariable);
    }

    public String getName() {
        return this.key.toString();
    }

    public AspectName getKey() {
        return this.key;
    }

    public String getAspectText(PlayerCharacter aPC, List<CNAbility> abilities) {
        StringBuilder buf = new StringBuilder(50);
        if (abilities == null || abilities.size() == 0) {
            return "";
        }
        Ability sampleAbilityObject = abilities.get(0).getAbility();
        if (!this.qualifies(aPC, sampleAbilityObject)) {
            return "";
        }
        for (String comp : this.theComponents) {
            if (comp.startsWith(VAR_MARKER)) {
                int ind = Integer.parseInt(comp.substring(VAR_MARKER.length()));
                if (this.theVariables == null || ind > this.theVariables.size()) {
                    buf.append("");
                    continue;
                }
                String var = this.theVariables.get(ind - 1);
                if (var.equals(VAR_NAME)) {
                    buf.append(sampleAbilityObject.getOutputName());
                    continue;
                }
                if (var.equals(VAR_LIST)) {
                    ArrayList<String> assocList = new ArrayList<String>();
                    for (CNAbility cna : abilities) {
                        assocList.addAll(aPC.getAssociationList(cna));
                    }
                    String joinString = assocList.size() == 2 ? " and " : ", ";
                    Collections.sort(assocList);
                    buf.append((CharSequence)StringUtil.joinToStringBuilder(assocList, (String)joinString));
                    continue;
                }
                if (var.startsWith("\"")) {
                    buf.append(var.substring(1, var.length() - 1));
                    continue;
                }
                buf.append(aPC.getVariableValue(var, "Aspect").intValue());
                continue;
            }
            buf.append(comp);
        }
        return buf.toString();
    }

    public String getPCCText() {
        StringBuilder buf = new StringBuilder();
        for (String str : this.theComponents) {
            if (str.startsWith(VAR_MARKER)) {
                int ind = Integer.parseInt(str.substring(VAR_MARKER.length()));
                buf.append('%').append(ind);
                continue;
            }
            if (str.equals("%")) {
                buf.append("%%");
                continue;
            }
            buf.append(EntityEncoder.encode(str));
        }
        if (this.theVariables != null) {
            for (String var : this.theVariables) {
                buf.append("|");
                buf.append(var);
            }
        }
        if (this.hasPrerequisites()) {
            buf.append("|");
            buf.append(new PrerequisiteWriter().getPrerequisiteString(this.getPrerequisiteList(), "|"));
        }
        return buf.toString();
    }

    public String toString() {
        return this.getPCCText();
    }

    public int hashCode() {
        return this.theComponents.size() + 7 * (this.theVariables == null ? 0 : this.theVariables.size());
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof Aspect)) {
            return false;
        }
        Aspect other = (Aspect)obj;
        if (this.theVariables == null && other.theVariables != null) {
            return false;
        }
        return this.theComponents.equals(other.theComponents) && (this.theVariables == null || this.theVariables.equals(other.theVariables));
    }

    public static String printAspect(PlayerCharacter pc, AspectName key, List<CNAbility> abilities, boolean printName) {
        if (abilities.size() == 0) {
            return "";
        }
        Ability sampleAbilityObject = abilities.get(0).getAbility();
        StringBuilder buff = new StringBuilder(50);
        List<Aspect> aspects = sampleAbilityObject.get(MapKey.ASPECT, key);
        Aspect aspect = Aspect.lastPassingAspect(aspects, pc, sampleAbilityObject);
        if (aspect != null) {
            if (printName) {
                buff.append(aspect.getName()).append(": ");
            }
            buff.append(aspect.getAspectText(pc, abilities));
        }
        return buff.toString();
    }

    public static String printAspect(PlayerCharacter pc, AspectName key, List<CNAbility> abilities) {
        return Aspect.printAspect(pc, key, abilities, true);
    }

    public static String printAspectValue(PlayerCharacter pc, AspectName key, List<CNAbility> abilities) {
        return Aspect.printAspect(pc, key, abilities, false);
    }

    public static Aspect lastPassingAspect(List<Aspect> aspects, PlayerCharacter pc, Ability a) {
        Aspect retAspect = null;
        if (aspects != null) {
            for (int i = 0; i < aspects.size(); ++i) {
                Aspect testAspect = aspects.get(i);
                if (!testAspect.qualifies(pc, a)) continue;
                retAspect = testAspect;
            }
        }
        return retAspect;
    }
}

