/*
 * Decompiled with CFR 0.152.
 */
package pcgen.core.doomsdaybook;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import pcgen.core.doomsdaybook.DataElement;
import pcgen.core.doomsdaybook.Operation;
import pcgen.core.doomsdaybook.variableException;

public class VariableHashMap
extends HashMap<String, String> {
    private List<Operation> initialize = new ArrayList<Operation>();
    private Map<String, DataElement> dataElements;

    public VariableHashMap() {
        this.dataElements = new HashMap<String, DataElement>();
    }

    public VariableHashMap(HashMap<String, DataElement> dataElements) {
        this.dataElements = dataElements;
    }

    public DataElement getDataElement(String key) throws Exception {
        DataElement de = this.dataElements.get(key);
        if (de == null) {
            throw new Exception("Data Set " + key + " Does Not Exist");
        }
        return de;
    }

    public String getVal(String key) throws variableException {
        String value = (String)this.get(key);
        if (value == null) {
            throw new variableException("Variable " + key + " does not exist, cannot get value");
        }
        return value;
    }

    public void setVar(String key, String value) throws variableException {
        if (this.get(key) == null) {
            throw new variableException("Variable " + key + " does not exist, cannot set value");
        }
        this.put(key, value);
    }

    public void addDataElement(DataElement dataElement) {
        String key = dataElement.getId();
        dataElement.trimToSize();
        this.dataElements.put(key, dataElement);
    }

    public void addInitialOperations(Operation op) {
        this.initialize.add(op);
    }

    public String addVar(String key, int add) throws variableException {
        String value = (String)this.get(key);
        if (value == null) {
            throw new variableException("Variable " + key + " does not exist, cannot add to value");
        }
        int val = "".equals(value) ? 0 : Integer.parseInt((String)this.get(key));
        return this.put(key, Integer.toString(val + add));
    }

    public String divideVar(String key, int divide) throws variableException {
        String value = (String)this.get(key);
        if (value == null) {
            throw new variableException("Variable " + key + " does not exist, cannot divide by value");
        }
        int val = "".equals(value) ? 0 : Integer.parseInt((String)this.get(key));
        return this.put(key, Integer.toString(val / divide));
    }

    public void doOperation(List<Operation> ops) throws variableException {
        for (Operation op : ops) {
            this.doOperation(op);
        }
    }

    public void doOperation(Operation op) throws variableException {
        String type = op.getType();
        String key = op.getKey();
        String value = op.getValue();
        if (type.equals("Set")) {
            value = this.parse(value);
            this.setVar(key, value);
        } else if (type.equals("Add")) {
            int val = Integer.parseInt(this.parse(value));
            this.addVar(key, val);
        } else if (type.equals("Subtract")) {
            int val = Integer.parseInt(this.parse(value));
            this.subtractVar(key, val);
        } else if (type.equals("Multiply")) {
            int val = Integer.parseInt(this.parse(value));
            this.multiplyVar(key, val);
        } else if (type.equals("Divide")) {
            int val = Integer.parseInt(this.parse(value));
            this.divideVar(key, val);
        }
    }

    public void initialize() throws variableException {
        this.doOperation(this.initialize);
    }

    public String multiplyVar(String key, int multiply) throws variableException {
        String value = (String)this.get(key);
        if (value == null) {
            throw new variableException("Variable " + key + " does not exist, cannot multiply by value");
        }
        int val = "".equals(value) ? 0 : Integer.parseInt((String)this.get(key));
        return this.put(key, Integer.toString(val * multiply));
    }

    public String parse(String val) {
        String retString = val;
        if (val.matches("\\$\\{.*?\\}.*")) {
            String var = val.substring(val.indexOf("${") + 2, val.indexOf("}"));
            String value = (String)this.get(var);
            if (value == null) {
                value = "";
            }
            retString = val.replaceFirst("\\$\\{.*?\\}", value);
        }
        return retString;
    }

    public String subtractVar(String key, int subtract) throws variableException {
        String value = (String)this.get(key);
        if (value == null) {
            throw new variableException("Variable " + key + " does not exist, cannot subtract from value");
        }
        int val = "".equals(value) ? 0 : Integer.parseInt((String)this.get(key));
        return this.put(key, Integer.toString(val - subtract));
    }
}

