/*
 * Decompiled with CFR 0.152.
 */
package pcgen.core.kit;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import pcgen.base.util.HashMapToList;
import pcgen.cdom.reference.CDOMSingleRef;
import pcgen.core.Kit;
import pcgen.core.PCTemplate;
import pcgen.core.PlayerCharacter;
import pcgen.core.SettingsHandler;
import pcgen.core.kit.BaseKit;
import pcgen.util.chooser.ChooserFactory;

public class KitTemplate
extends BaseKit {
    private HashMapToList<CDOMSingleRef<PCTemplate>, CDOMSingleRef<PCTemplate>> templateList = new HashMapToList();

    @Override
    public void apply(PlayerCharacter aPC) {
        HashMapToList<PCTemplate, PCTemplate> selectedMap = this.buildSelectedTemplateMap(aPC, true);
        boolean tempShowHP = SettingsHandler.getShowHPDialogAtLevelUp();
        SettingsHandler.setShowHPDialogAtLevelUp(false);
        for (PCTemplate template : selectedMap.getKeySet()) {
            List added = selectedMap.getListFor((Object)template);
            if (added != null) {
                for (PCTemplate subtemplate : added) {
                    aPC.setTemplatesAdded(template, subtemplate);
                }
            }
            aPC.addTemplate(template);
        }
        SettingsHandler.setShowHPDialogAtLevelUp(tempShowHP);
    }

    @Override
    public boolean testApply(Kit aKit, PlayerCharacter aPC, List<String> warnings) {
        HashMapToList<PCTemplate, PCTemplate> selectedMap = this.buildSelectedTemplateMap(aPC, false);
        return selectedMap.size() > 0;
    }

    private HashMapToList<PCTemplate, PCTemplate> buildSelectedTemplateMap(PlayerCharacter aPC, boolean apply) {
        boolean tempShowHP = SettingsHandler.getShowHPDialogAtLevelUp();
        SettingsHandler.setShowHPDialogAtLevelUp(false);
        if (!apply) {
            ChooserFactory.pushChooserClassname("pcgen.util.chooser.RandomChooser");
        }
        HashMapToList selectedMap = new HashMapToList();
        for (CDOMSingleRef ref : this.templateList.getKeySet()) {
            PCTemplate templateToAdd = (PCTemplate)ref.resolvesTo();
            List subList = this.templateList.getListFor((Object)ref);
            ArrayList<PCTemplate> subAdded = new ArrayList<PCTemplate>();
            if (subList != null) {
                for (CDOMSingleRef subRef : subList) {
                    PCTemplate ownedTemplate = (PCTemplate)subRef.resolvesTo();
                    subAdded.add(ownedTemplate);
                    aPC.setTemplatesAdded(templateToAdd, ownedTemplate);
                }
            }
            aPC.addTemplate(templateToAdd);
            selectedMap.initializeListFor((Object)templateToAdd);
            selectedMap.addAllToListFor((Object)templateToAdd, subAdded);
        }
        if (!apply) {
            ChooserFactory.popChooserClassname();
        }
        SettingsHandler.setShowHPDialogAtLevelUp(tempShowHP);
        return selectedMap;
    }

    @Override
    public String getObjectName() {
        return "Templates";
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        boolean needsPipe = false;
        for (CDOMSingleRef ref : this.templateList.getKeySet()) {
            if (needsPipe) {
                sb.append("|");
            }
            needsPipe = true;
            sb.append(ref.getLSTformat(false));
            List subList = this.templateList.getListFor((Object)ref);
            if (subList == null) continue;
            for (CDOMSingleRef subref : subList) {
                sb.append("[TEMPLATE:");
                sb.append(subref.getLSTformat(false));
                sb.append(']');
            }
        }
        return sb.toString();
    }

    public void addTemplate(CDOMSingleRef<PCTemplate> ref, List<CDOMSingleRef<PCTemplate>> subList) {
        this.templateList.initializeListFor(ref);
        this.templateList.addAllToListFor(ref, subList);
    }

    public Collection<CDOMSingleRef<PCTemplate>> getTemplates() {
        return this.templateList.getKeySet();
    }

    public boolean isEmpty() {
        return this.templateList.isEmpty();
    }
}

