/*
 * Decompiled with CFR 0.152.
 */
package pcgen.core.term;

import pcgen.cdom.base.CDOMObject;
import pcgen.core.Globals;
import pcgen.core.PObject;
import pcgen.core.PlayerCharacter;
import pcgen.core.SettingsHandler;
import pcgen.core.term.BasePCTermEvaluator;
import pcgen.core.term.TermEvaluator;

public class PCCountSpellsKnownTermEvaluator
extends BasePCTermEvaluator
implements TermEvaluator {
    private final int[] nums;

    public PCCountSpellsKnownTermEvaluator(String originalText, int[] nums) {
        this.originalText = originalText;
        this.nums = nums;
    }

    @Override
    public Float resolve(PlayerCharacter pc) {
        Float count = Float.valueOf(0.0f);
        if (SettingsHandler.getPrintSpellsWithPC()) {
            if (this.nums[0] == -1) {
                for (CDOMObject cDOMObject : pc.getDisplay().getClassSet()) {
                    count = Float.valueOf(count.floatValue() + (float)pc.getCharacterSpellCount(cDOMObject));
                }
            } else {
                PObject pObj = pc.getSpellClassAtIndex(this.nums[0]);
                if (pObj != null) {
                    count = Float.valueOf(pc.getCharacterSpells(pObj, null, Globals.getDefaultSpellBook(), this.nums[1]).size());
                }
            }
        }
        return count;
    }

    @Override
    public boolean isSourceDependant() {
        return false;
    }

    public boolean isStatic() {
        return false;
    }
}

