/*
 * Decompiled with CFR 0.152.
 */
package pcgen.gui2.converter;

import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import pcgen.base.util.DoubleKeyMap;
import pcgen.base.util.DoubleKeyMapToList;
import pcgen.cdom.base.Category;
import pcgen.cdom.enumeration.AspectName;
import pcgen.cdom.enumeration.RaceSubType;
import pcgen.cdom.enumeration.RaceType;
import pcgen.cdom.enumeration.Region;
import pcgen.cdom.enumeration.SubClassCategory;
import pcgen.cdom.enumeration.SubRace;
import pcgen.cdom.enumeration.SubRegion;
import pcgen.cdom.enumeration.Type;
import pcgen.cdom.enumeration.VariableKey;
import pcgen.core.AbilityCategory;
import pcgen.gui2.converter.DefaultTokenProcessor;
import pcgen.gui2.converter.event.TokenProcessEvent;
import pcgen.gui2.converter.event.TokenProcessorPlugin;
import pcgen.system.PluginLoader;
import pcgen.util.Logging;

public class TokenConverter {
    private static final DoubleKeyMap<Class<?>, String, TokenProcessorPlugin> map = new DoubleKeyMap();
    private static final DoubleKeyMap<Class<?>, String, Boolean> cached = new DoubleKeyMap();
    private static final DoubleKeyMapToList<Class<?>, String, TokenProcessorPlugin> tokenCache = new DoubleKeyMapToList();
    private static final DefaultTokenProcessor defaultProc = new DefaultTokenProcessor();

    public static void addToTokenMap(TokenProcessorPlugin tpp) {
        TokenProcessorPlugin old = (TokenProcessorPlugin)map.put(tpp.getProcessedClass(), (Object)tpp.getProcessedToken(), (Object)tpp);
        if (old != null) {
            Logging.errorPrint("More than one Conversion token for " + tpp.getProcessedClass().getSimpleName() + " " + tpp.getProcessedToken() + " found");
        }
    }

    public static PluginLoader getPluginLoader() {
        return new PluginLoader(){

            @Override
            public void loadPlugin(Class<?> clazz) throws Exception {
                TokenConverter.addToTokenMap((TokenProcessorPlugin)clazz.newInstance());
            }

            public Class[] getPluginClasses() {
                return new Class[]{TokenProcessorPlugin.class};
            }
        };
    }

    public static String process(TokenProcessEvent tpe) {
        Class<?> cl = tpe.getPrimary().getClass();
        String key = tpe.getKey();
        TokenConverter.ensureCategoryExists(tpe);
        List<TokenProcessorPlugin> tokens = TokenConverter.getTokens(cl, key);
        String error = "";
        try {
            if (tokens != null) {
                for (TokenProcessorPlugin converter : tokens) {
                    error = error + converter.process(tpe);
                    if (!tpe.isConsumed()) continue;
                    break;
                }
            }
            if (!tpe.isConsumed()) {
                error = error + defaultProc.process(tpe);
            }
        }
        catch (Exception ex) {
            Logging.errorPrint("Parse of " + tpe.getKey() + ":" + tpe.getValue() + " failed");
            ex.printStackTrace();
        }
        return tpe.isConsumed() ? null : error;
    }

    private static void ensureCategoryExists(TokenProcessEvent tpe) {
        if (!tpe.getKey().equals("ABILITY")) {
            return;
        }
        String value = tpe.getValue();
        StringTokenizer tok = new StringTokenizer(value, "|");
        String cat = tok.nextToken();
        Category category = tpe.getContext().getReferenceContext().silentlyGetConstructedCDOMObject(AbilityCategory.class, cat);
        if (category == null) {
            tpe.getContext().getReferenceContext().constructCDOMObject(AbilityCategory.class, cat);
        }
    }

    public static List<TokenProcessorPlugin> getTokens(Class<?> cl, String name) {
        List list = tokenCache.getListFor(cl, (Object)name);
        if (!cached.containsKey(cl, (Object)name)) {
            ConverterIterator it = new ConverterIterator(cl, name);
            while (it.hasNext()) {
                TokenProcessorPlugin token = (TokenProcessorPlugin)it.next();
                tokenCache.addToListFor(cl, (Object)name, (Object)token);
            }
            list = tokenCache.getListFor(cl, (Object)name);
            cached.put(cl, (Object)name, (Object)Boolean.TRUE);
        }
        return list;
    }

    public static void clearConstants() {
        AspectName.clearConstants();
        RaceSubType.clearConstants();
        RaceType.clearConstants();
        Region.clearConstants();
        SubClassCategory.clearConstants();
        SubRace.clearConstants();
        SubRegion.clearConstants();
        Type.clearConstants();
        VariableKey.clearConstants();
    }

    static class ConverterIterator
    implements Iterator<TokenProcessorPlugin> {
        private Class<?> rootClass;
        private final String tokenKey;
        private TokenProcessorPlugin nextToken = null;
        private boolean needNewToken = true;

        public ConverterIterator(Class<?> cl, String key) {
            this.rootClass = cl;
            this.tokenKey = key;
        }

        @Override
        public boolean hasNext() {
            this.setNextToken();
            return !this.needNewToken;
        }

        protected void setNextToken() {
            if (this.needNewToken) {
                this.nextToken = null;
                while (this.nextToken == null && this.rootClass != null) {
                    this.nextToken = this.grabToken(this.rootClass, this.tokenKey);
                    this.rootClass = this.rootClass.getSuperclass();
                }
                this.needNewToken = this.nextToken == null;
            }
        }

        protected TokenProcessorPlugin grabToken(Class<?> cl, String key) {
            return (TokenProcessorPlugin)map.get(cl, (Object)key);
        }

        @Override
        public TokenProcessorPlugin next() {
            this.setNextToken();
            if (this.needNewToken) {
                throw new NoSuchElementException();
            }
            this.needNewToken = true;
            return this.nextToken;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Iterator does not support remove");
        }
    }
}

