/*
 * Decompiled with CFR 0.152.
 */
package pcgen.gui2.facade;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.SwingUtilities;
import pcgen.cdom.base.Category;
import pcgen.cdom.content.CNAbility;
import pcgen.cdom.content.CNAbilityFactory;
import pcgen.cdom.enumeration.CharID;
import pcgen.cdom.enumeration.Nature;
import pcgen.cdom.enumeration.ObjectKey;
import pcgen.cdom.facet.FacetLibrary;
import pcgen.cdom.facet.GrantedAbilityFacet;
import pcgen.cdom.facet.event.DataFacetChangeEvent;
import pcgen.cdom.facet.event.DataFacetChangeListener;
import pcgen.cdom.helper.CNAbilitySelection;
import pcgen.core.Ability;
import pcgen.core.AbilityCategory;
import pcgen.core.AbilityUtilities;
import pcgen.core.Globals;
import pcgen.core.PlayerCharacter;
import pcgen.core.display.CharacterDisplay;
import pcgen.core.utils.MessageType;
import pcgen.core.utils.ShowMessageDelegate;
import pcgen.facade.core.AbilityCategoryFacade;
import pcgen.facade.core.AbilityFacade;
import pcgen.facade.core.DataSetFacade;
import pcgen.facade.core.UIDelegate;
import pcgen.facade.util.DefaultListFacade;
import pcgen.facade.util.ListFacade;
import pcgen.facade.util.event.ChangeEvent;
import pcgen.facade.util.event.ChangeListener;
import pcgen.gui2.facade.TodoFacadeImpl;
import pcgen.gui2.facade.TodoManager;
import pcgen.system.LanguageBundle;
import pcgen.util.Logging;
import pcgen.util.enumeration.Tab;
import pcgen.util.enumeration.View;

public class CharacterAbilities {
    private final PlayerCharacter theCharacter;
    private final CharacterDisplay charDisplay;
    private UIDelegate delegate;
    private Map<AbilityCategoryFacade, DefaultListFacade<AbilityFacade>> abilityListMap;
    private DefaultListFacade<AbilityCategoryFacade> activeCategories;
    private CharID charID;
    private DataSetFacade dataSetFacade;
    private final List<ChangeListener> abilityCatSelectionListeners;
    private final TodoManager todoManager;
    private GrantedAbilityChangeHandler grantedAbilityChangeHandler;

    public CharacterAbilities(PlayerCharacter pc, UIDelegate delegate, DataSetFacade dataSetFacade, TodoManager todoManager) {
        this.theCharacter = pc;
        this.charDisplay = pc.getDisplay();
        this.delegate = delegate;
        this.dataSetFacade = dataSetFacade;
        this.todoManager = todoManager;
        this.abilityCatSelectionListeners = new ArrayList<ChangeListener>();
        this.initForCharacter();
    }

    protected void closeCharacter() {
        GrantedAbilityFacet grantedAbilityFacet = FacetLibrary.getFacet(GrantedAbilityFacet.class);
        grantedAbilityFacet.removeDataFacetChangeListener(this.grantedAbilityChangeHandler);
    }

    private void initForCharacter() {
        this.abilityListMap = new LinkedHashMap<AbilityCategoryFacade, DefaultListFacade<AbilityFacade>>();
        this.activeCategories = new DefaultListFacade();
        this.charID = this.theCharacter.getCharID();
        GrantedAbilityFacet grantedAbilityFacet = FacetLibrary.getFacet(GrantedAbilityFacet.class);
        this.rebuildAbilityLists();
        this.grantedAbilityChangeHandler = new GrantedAbilityChangeHandler();
        grantedAbilityFacet.addDataFacetChangeListener(this.grantedAbilityChangeHandler);
    }

    void removeAbilityFromLists(AbilityCategory cat, Ability ability, Nature nature) {
        this.removeCategorisedAbility(cat, ability, nature);
        boolean stillActive = cat.isVisibleTo(View.VISIBLE_DISPLAY);
        if (!stillActive && this.activeCategories.containsElement(cat)) {
            this.activeCategories.removeElement(cat);
        } else {
            this.adviseSelectionChangeLater(cat);
        }
        this.updateAbilityCategoryLater(cat);
    }

    synchronized void rebuildAbilityLists() {
        LinkedHashMap<AbilityCategoryFacade, DefaultListFacade<AbilityFacade>> workingAbilityListMap = new LinkedHashMap<AbilityCategoryFacade, DefaultListFacade<AbilityFacade>>();
        DefaultListFacade<AbilityCategoryFacade> workingActiveCategories = new DefaultListFacade<AbilityCategoryFacade>();
        for (AbilityCategoryFacade category : this.dataSetFacade.getAbilities().getKeys()) {
            AbilityCategory cat = (AbilityCategory)category;
            for (CNAbility cna : this.theCharacter.getPoolAbilities(cat)) {
                this.addCategorisedAbility(cna, workingAbilityListMap);
            }
            boolean visible = cat.isVisibleTo(this.theCharacter, View.VISIBLE_DISPLAY);
            if (visible && !workingActiveCategories.containsElement(cat)) {
                int index = this.getCatIndex(cat, workingActiveCategories);
                workingActiveCategories.addElement(index, cat);
            }
            if (!visible && workingActiveCategories.containsElement(cat)) {
                workingActiveCategories.removeElement(cat);
            }
            if (!visible) continue;
            this.adviseSelectionChangeLater(cat);
        }
        for (AbilityCategoryFacade category : workingAbilityListMap.keySet()) {
            DefaultListFacade workingListFacade = (DefaultListFacade)workingAbilityListMap.get(category);
            DefaultListFacade<AbilityFacade> masterListFacade = this.abilityListMap.get(category);
            if (masterListFacade == null) {
                this.abilityListMap.put(category, workingListFacade);
            } else {
                masterListFacade.updateContentsNoOrder(workingListFacade.getContents());
            }
            this.updateAbilityCategoryTodo((AbilityCategory)category);
        }
        HashSet<AbilityCategoryFacade> origCats = new HashSet<AbilityCategoryFacade>(this.abilityListMap.keySet());
        for (AbilityCategoryFacade category : origCats) {
            if (workingAbilityListMap.containsKey(category)) continue;
            if (workingActiveCategories.containsElement(category)) {
                this.abilityListMap.get(category).clearContents();
            } else {
                this.abilityListMap.remove(category);
            }
            this.updateAbilityCategoryTodo((AbilityCategory)category);
        }
        this.activeCategories.updateContents(workingActiveCategories.getContents());
    }

    private void updateAbilityCategoryTodo(Category<Ability> cat) {
        if (!(cat instanceof AbilityCategory)) {
            return;
        }
        AbilityCategory category = (AbilityCategory)cat;
        int numSelections = this.theCharacter.getAvailableAbilityPool(category).intValue();
        if (category.getVisibility().isVisibleTo(View.HIDDEN_DISPLAY)) {
            numSelections = 0;
        }
        if (numSelections < 0) {
            this.todoManager.addTodo(new TodoFacadeImpl(Tab.ABILITIES, category.getDisplayName(), "in_featTodoTooMany", category.getType(), 1));
            this.todoManager.removeTodo("in_featTodoRemain", category.getDisplayName());
        } else if (numSelections > 0) {
            this.todoManager.addTodo(new TodoFacadeImpl(Tab.ABILITIES, category.getDisplayName(), "in_featTodoRemain", category.getType(), 1));
            this.todoManager.removeTodo("in_featTodoTooMany", category.getDisplayName());
        } else {
            this.todoManager.removeTodo("in_featTodoRemain", category.getDisplayName());
            this.todoManager.removeTodo("in_featTodoTooMany", category.getDisplayName());
        }
    }

    private int getCatIndex(AbilityCategory abilityCategory, ListFacade<AbilityCategoryFacade> catList) {
        Set<AbilityCategoryFacade> allCategories = this.dataSetFacade.getAbilities().getKeys();
        int index = 0;
        for (AbilityCategoryFacade compCat : allCategories) {
            if (compCat == abilityCategory || index >= catList.getSize()) break;
            if (catList.getElementAt(index) != compCat) continue;
            ++index;
        }
        return index;
    }

    private void addCategorisedAbility(CNAbility cna, Map<AbilityCategoryFacade, DefaultListFacade<AbilityFacade>> workingAbilityListMap) {
        Ability ability = cna.getAbility();
        ArrayList<CNAbilitySelection> cas = new ArrayList<CNAbilitySelection>();
        Category<Ability> cat = cna.getAbilityCategory();
        Nature nature = cna.getNature();
        if (ability.getSafe(ObjectKey.MULTIPLE_ALLOWED).booleanValue()) {
            List<String> choices = this.theCharacter.getAssociationList(cna);
            if (choices == null || choices.isEmpty()) {
                Logging.errorPrint("Ignoring Ability: " + ability + " (" + cat + " / " + (Object)((Object)nature) + ") that UI has as added to the PC, but it has no associations");
            } else {
                for (String choice : choices) {
                    cas.add(new CNAbilitySelection(CNAbilityFactory.getCNAbility(cat, nature, ability), choice));
                }
            }
        } else {
            cas.add(new CNAbilitySelection(CNAbilityFactory.getCNAbility(cat, nature, ability)));
        }
        for (CNAbilitySelection sel : cas) {
            this.addElement(workingAbilityListMap, sel);
        }
    }

    private void removeCategorisedAbility(AbilityCategory cat, Ability ability, Nature nature) {
        CNAbilitySelection cas = ability.getSafe(ObjectKey.MULTIPLE_ALLOWED) != false ? new CNAbilitySelection(CNAbilityFactory.getCNAbility(cat, nature, ability), "") : new CNAbilitySelection(CNAbilityFactory.getCNAbility(cat, nature, ability));
        this.removeElement(cas);
    }

    public void addAbility(AbilityCategoryFacade categoryFacade, AbilityFacade abilityFacade) {
        if (abilityFacade == null || !(abilityFacade instanceof Ability) || categoryFacade == null || !(categoryFacade instanceof AbilityCategory)) {
            return;
        }
        Ability ability = (Ability)abilityFacade;
        AbilityCategory category = (AbilityCategory)categoryFacade;
        if (!this.checkAbilityQualify(ability, category)) {
            return;
        }
        try {
            this.theCharacter.setDirty(true);
            this.theCharacter.getSpellList();
            CNAbility cna = CNAbilityFactory.getCNAbility(category, Nature.NORMAL, ability);
            AbilityUtilities.driveChooseAndAdd(cna, this.theCharacter, true);
        }
        catch (Exception exc) {
            Logging.errorPrint("Failed to add ability due to ", exc);
            ShowMessageDelegate.showMessageDialog(LanguageBundle.getFormattedString("in_iayAddAbility", exc.getMessage()), "PCGen", MessageType.ERROR);
        }
        this.theCharacter.getSpellList();
        this.theCharacter.calcActiveBonuses();
        this.rebuildAbilityLists();
    }

    public void removeAbility(AbilityCategoryFacade categoryFacade, AbilityFacade abilityFacade) {
        if (abilityFacade == null || !(abilityFacade instanceof Ability) || categoryFacade == null || !(categoryFacade instanceof AbilityCategory)) {
            return;
        }
        Ability anAbility = (Ability)abilityFacade;
        AbilityCategory theCategory = (AbilityCategory)categoryFacade;
        try {
            Ability pcAbility = this.theCharacter.getMatchingAbility(theCategory, anAbility, Nature.NORMAL);
            if (pcAbility != null) {
                CNAbility cna = CNAbilityFactory.getCNAbility(theCategory, Nature.NORMAL, anAbility);
                AbilityUtilities.driveChooseAndAdd(cna, this.theCharacter, false);
                this.theCharacter.adjustMoveRates();
            }
        }
        catch (Exception exc) {
            Logging.errorPrintLocalised("in_iayFailedToRemoveAbility", exc);
            this.delegate.showErrorMessage("PCGen", LanguageBundle.getString("in_iayRemoveAbility") + ": " + exc.getMessage());
            return;
        }
        this.theCharacter.calcActiveBonuses();
        this.rebuildAbilityLists();
    }

    public ListFacade<AbilityFacade> getAbilities(AbilityCategoryFacade category) {
        DefaultListFacade<AbilityFacade> abList = this.abilityListMap.get(category);
        if (abList == null) {
            abList = new DefaultListFacade();
            this.abilityListMap.put(category, abList);
        }
        return abList;
    }

    public ListFacade<AbilityCategoryFacade> getActiveAbilityCategories() {
        return this.activeCategories;
    }

    public int getTotalSelections(AbilityCategoryFacade categoryFacade) {
        if (categoryFacade == null || !(categoryFacade instanceof AbilityCategory)) {
            return 0;
        }
        AbilityCategory category = (AbilityCategory)categoryFacade;
        BigDecimal pool = this.theCharacter.getTotalAbilityPool(category);
        return pool.intValue();
    }

    public int getRemainingSelections(AbilityCategoryFacade categoryFacade) {
        if (categoryFacade == null || !(categoryFacade instanceof AbilityCategory)) {
            return 0;
        }
        AbilityCategory category = (AbilityCategory)categoryFacade;
        BigDecimal pool = this.theCharacter.getAvailableAbilityPool(category);
        return pool.intValue();
    }

    public void setRemainingSelection(AbilityCategoryFacade categoryFacade, int remaining) {
        BigDecimal newRemain;
        if (categoryFacade == null || !(categoryFacade instanceof AbilityCategory)) {
            return;
        }
        AbilityCategory category = (AbilityCategory)categoryFacade;
        BigDecimal pool = this.theCharacter.getAvailableAbilityPool(category);
        if (pool.equals(newRemain = new BigDecimal(remaining))) {
            return;
        }
        this.theCharacter.adjustAbilities(category, newRemain.subtract(pool));
    }

    public boolean hasAbility(AbilityCategoryFacade category, AbilityFacade ability) {
        DefaultListFacade<AbilityFacade> abList = this.abilityListMap.get(category);
        if (abList == null) {
            return false;
        }
        return abList.containsElement(ability);
    }

    public void addAbilityCatSelectionListener(ChangeListener listener) {
        this.abilityCatSelectionListeners.add(listener);
    }

    public void removeAbilityCatSelectionListener(ChangeListener listener) {
        this.abilityCatSelectionListeners.remove(listener);
    }

    private void fireAbilityCatSelectionUpdated(AbilityCategory cat) {
        ChangeEvent event = null;
        for (ChangeListener listener : this.abilityCatSelectionListeners) {
            if (event == null) {
                event = new ChangeEvent(cat);
            }
            listener.ItemChanged(event);
        }
    }

    private void adviseSelectionChangeLater(final AbilityCategory cat) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                CharacterAbilities.this.updateAbilityCategoryTodo(cat);
                CharacterAbilities.this.fireAbilityCatSelectionUpdated(cat);
                CharacterAbilities.this.refreshChoices(cat);
            }
        });
    }

    private void updateAbilityCategoryLater(final Category<Ability> category) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                CharacterAbilities.this.updateAbilityCategoryTodo(category);
            }
        });
    }

    protected void refreshChoices(Category<Ability> category) {
        DefaultListFacade<AbilityFacade> listFacade = this.abilityListMap.get(category);
        if (listFacade == null) {
            return;
        }
        for (AbilityFacade abilityFacade : listFacade) {
            Ability ability = (Ability)abilityFacade;
            if (!ability.getSafe(ObjectKey.MULTIPLE_ALLOWED).booleanValue()) continue;
            listFacade.modifyElement(ability);
        }
    }

    private boolean checkAbilityQualify(Ability anAbility, AbilityCategory theCategory) {
        BigDecimal cost;
        String aKey = anAbility.getKeyName();
        boolean pcHasIt = this.theCharacter.hasAbilityKeyed(theCategory, aKey);
        if (pcHasIt && !anAbility.getSafe(ObjectKey.MULTIPLE_ALLOWED).booleanValue()) {
            this.delegate.showErrorMessage("PCGen", LanguageBundle.getString("InfoAbility.Messages.Duplicate"));
            return false;
        }
        Ability ability = Globals.getContext().getReferenceContext().silentlyGetConstructedCDOMObject(Ability.class, theCategory, aKey);
        if (!(ability == null || ability.qualifies(this.theCharacter, ability) || Globals.checkRule("FEATPRE") && AbilityUtilities.isFeat(ability))) {
            this.delegate.showErrorMessage("PCGen", LanguageBundle.getString("InfoAbility.Messages.NotQualified"));
            return false;
        }
        if (ability != null && (cost = ability.getSafe(ObjectKey.SELECTION_COST)).compareTo(this.theCharacter.getAvailableAbilityPool(theCategory)) > 0) {
            this.delegate.showErrorMessage("PCGen", LanguageBundle.getString("InfoAbility.Messages.NoPoints"));
            return false;
        }
        return true;
    }

    private void addElement(Map<AbilityCategoryFacade, DefaultListFacade<AbilityFacade>> workingAbilityListMap, CNAbilitySelection cnas) {
        CNAbility cas = cnas.getCNAbility();
        Ability ability = cas.getAbility();
        if (!ability.getSafe(ObjectKey.VISIBILITY).isVisibleTo(View.VISIBLE_DISPLAY)) {
            return;
        }
        AbilityCategoryFacade cat = (AbilityCategoryFacade)((Object)cas.getAbilityCategory());
        DefaultListFacade<AbilityFacade> listFacade = workingAbilityListMap.get(cat);
        if (listFacade == null) {
            listFacade = new DefaultListFacade();
            workingAbilityListMap.put(cat, listFacade);
        }
        if (!listFacade.containsElement(ability)) {
            listFacade.addElement(ability);
        }
    }

    private void removeElement(CNAbilitySelection cnas) {
        CNAbility cas = cnas.getCNAbility();
        Ability ability = cas.getAbility();
        AbilityCategoryFacade cat = (AbilityCategoryFacade)((Object)cas.getAbilityCategory());
        DefaultListFacade<AbilityFacade> listFacade = this.abilityListMap.get(cat);
        if (listFacade != null) {
            listFacade.removeElement(ability);
        }
    }

    private final class GrantedAbilityChangeHandler
    implements DataFacetChangeListener<CharID, CNAbilitySelection> {
        private GrantedAbilityChangeHandler() {
        }

        @Override
        public void dataAdded(DataFacetChangeEvent<CharID, CNAbilitySelection> dfce) {
            if (dfce.getCharID() != CharacterAbilities.this.charID) {
                return;
            }
            if (Logging.isDebugMode()) {
                Logging.debugPrint("Got granted ability added of " + dfce.getCDOMObject());
            }
            CharacterAbilities.this.rebuildAbilityLists();
        }

        @Override
        public void dataRemoved(DataFacetChangeEvent<CharID, CNAbilitySelection> dfce) {
            if (dfce.getCharID() != CharacterAbilities.this.charID) {
                Logging.debugPrint("CA for " + CharacterAbilities.this.charDisplay.getName() + ". Ignoring granted ability removed for character " + dfce.getCharID());
                return;
            }
            if (Logging.isDebugMode()) {
                Logging.debugPrint("Got granted ability removed of " + dfce.getCDOMObject());
            }
            CharacterAbilities.this.rebuildAbilityLists();
        }
    }
}

