/*
 * Decompiled with CFR 0.152.
 */
package pcgen.gui2.filter;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.SizeRequirements;
import javax.swing.UIManager;
import javax.swing.border.Border;
import org.apache.commons.lang.ArrayUtils;
import pcgen.gui2.filter.DisplayableFilter;
import pcgen.gui2.filter.FilterHandler;

public class FilterBar<C, E>
extends JPanel
implements DisplayableFilter<C, E> {
    private JPanel filterPanel = new JPanel(new FilterLayout());
    private List<DisplayableFilter<? super C, ? super E>> filters = new ArrayList<DisplayableFilter<? super C, ? super E>>();
    private FilterHandler filterHandler;

    public FilterBar() {
        this(true);
    }

    public FilterBar(boolean collapsable) {
        this.setLayout(new BorderLayout());
        this.add((Component)this.filterPanel, "Center");
        final ArrowButton arrowbutton = new ArrowButton();
        arrowbutton.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                boolean closed = !arrowbutton.isOpen();
                arrowbutton.setOpen(closed);
                FilterBar.this.filterPanel.setVisible(closed);
            }
        });
        if (collapsable) {
            this.add((Component)arrowbutton, "South");
        }
    }

    public void addDisplayableFilter(DisplayableFilter<? super C, ? super E> filter) {
        this.filterPanel.add(filter.getFilterComponent());
        this.filters.add(filter);
        filter.setFilterHandler(this.filterHandler);
    }

    public void removeDisplayableFilter(DisplayableFilter<C, E> filter) {
        this.filterPanel.remove(filter.getFilterComponent());
        this.filters.remove(filter);
        filter.setFilterHandler(null);
    }

    @Override
    public Component getFilterComponent() {
        return this;
    }

    @Override
    public void setFilterHandler(FilterHandler handler) {
        this.filterHandler = handler;
        for (DisplayableFilter<C, E> displayableFilter : this.filters) {
            displayableFilter.setFilterHandler(handler);
        }
    }

    @Override
    public boolean accept(C context, E element) {
        for (DisplayableFilter<C, E> displayableFilter : this.filters) {
            if (displayableFilter.accept(context, element)) continue;
            return false;
        }
        return true;
    }

    private static class FilterLayout
    extends FlowLayout {
        public FilterLayout() {
            super(0, 5, 2);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void layoutContainer(Container target) {
            Object object = target.getTreeLock();
            synchronized (object) {
                Insets insets = target.getInsets();
                int maxwidth = target.getWidth() - (insets.left + insets.right + this.getHgap() * 2);
                int nmembers = target.getComponentCount();
                int x = 0;
                int y = insets.top + this.getVgap();
                int rowh = 0;
                int start = 0;
                boolean ltr = target.getComponentOrientation().isLeftToRight();
                SizeRequirements[] xChildren = new SizeRequirements[nmembers];
                SizeRequirements[] yChildren = new SizeRequirements[nmembers];
                for (int i = 0; i < nmembers; ++i) {
                    Component c = target.getComponent(i);
                    if (!c.isVisible()) {
                        xChildren[i] = new SizeRequirements(0, 0, 0, c.getAlignmentX());
                        yChildren[i] = new SizeRequirements(0, 0, 0, c.getAlignmentY());
                        continue;
                    }
                    Dimension min = c.getMinimumSize();
                    Dimension typ = c.getPreferredSize();
                    Dimension max = c.getMaximumSize();
                    xChildren[i] = new SizeRequirements(min.width, typ.width, max.width, c.getAlignmentX());
                    yChildren[i] = new SizeRequirements(min.height, typ.height, max.height, c.getAlignmentY());
                    if (x == 0 || x + typ.width <= maxwidth) {
                        if (x > 0) {
                            x += this.getHgap();
                        }
                        x += typ.width;
                        rowh = Math.max(rowh, typ.height);
                        continue;
                    }
                    this.layoutComponents(target, insets.left + this.getHgap(), y, maxwidth, rowh, xChildren, yChildren, start, i, ltr);
                    x = typ.width;
                    y += this.getVgap() + rowh;
                    rowh = typ.height;
                    start = i;
                }
                this.layoutComponents(target, insets.left + this.getHgap(), y, maxwidth, rowh, xChildren, yChildren, start, nmembers, ltr);
            }
        }

        private void layoutComponents(Container target, int xOffset, int yOffset, int maxwidth, int rowheight, SizeRequirements[] xChildren, SizeRequirements[] yChildren, int start, int end, boolean ltr) {
            SizeRequirements[] children = (SizeRequirements[])ArrayUtils.subarray(xChildren, start, end);
            int[] xOffsets = new int[children.length];
            int[] xSpans = new int[children.length];
            SizeRequirements.calculateTiledPositions(maxwidth, null, children, xOffsets, xSpans, ltr);
            children = (SizeRequirements[])ArrayUtils.subarray(yChildren, start, end);
            int[] yOffsets = new int[children.length];
            int[] ySpans = new int[children.length];
            SizeRequirements total = new SizeRequirements(rowheight, rowheight, rowheight, 0.5f);
            SizeRequirements.calculateAlignedPositions(rowheight, total, children, yOffsets, ySpans, ltr);
            Insets in = target.getInsets();
            for (int i = 0; i < children.length; ++i) {
                Component c = target.getComponent(i + start);
                c.setBounds((int)Math.min((long)xOffset + (long)xOffsets[i], Integer.MAX_VALUE), (int)Math.min((long)yOffset + (long)yOffsets[i], Integer.MAX_VALUE), xSpans[i], ySpans[i]);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Dimension preferredLayoutSize(Container target) {
            Object object = target.getTreeLock();
            synchronized (object) {
                Dimension dim = new Dimension(0, 0);
                int nmembers = target.getComponentCount();
                Insets insets = target.getInsets();
                int targetWidth = target.getWidth() == 0 ? 400 : target.getWidth();
                int maxwidth = targetWidth - (insets.left + insets.right + this.getHgap() * 2);
                int width = 0;
                int height = 0;
                int component = 0;
                int i = 0;
                while (i < nmembers) {
                    Component m = target.getComponent(i);
                    if (m.isVisible()) {
                        Dimension d = m.getPreferredSize();
                        if (component > 0) {
                            if (width + d.width > maxwidth) {
                                dim.width = Math.max(dim.width, width);
                                dim.height += height + this.getVgap();
                                width = 0;
                                height = 0;
                                component = 0;
                            }
                            width += this.getHgap();
                        }
                        height = Math.max(height, d.height);
                        width += d.width;
                    }
                    ++i;
                    ++component;
                }
                dim.width = Math.max(dim.width, width);
                dim.height += height;
                dim.width += insets.left + insets.right + this.getHgap() * 2;
                dim.height += insets.top + insets.bottom + this.getVgap() * 2;
                return dim;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Dimension minimumLayoutSize(Container target) {
            Object object = target.getTreeLock();
            synchronized (object) {
                Dimension dim = new Dimension(0, 0);
                int nmembers = target.getComponentCount();
                Insets insets = target.getInsets();
                int maxwidth = target.getWidth() - (insets.left + insets.right + this.getHgap() * 2);
                int width = 0;
                int height = 0;
                int component = 0;
                int i = 0;
                while (i < nmembers) {
                    Component m = target.getComponent(i);
                    if (m.isVisible()) {
                        Dimension d = m.getMinimumSize();
                        if (component > 0) {
                            if (width + d.width > maxwidth) {
                                dim.width = Math.max(dim.width, width);
                                dim.height += height + this.getVgap();
                                width = 0;
                                height = 0;
                                component = 0;
                            }
                            width += this.getHgap();
                        }
                        height = Math.max(height, d.height);
                        width += d.width;
                    }
                    ++i;
                    ++component;
                }
                dim.width = Math.max(dim.width, width);
                dim.height += height;
                dim.width += insets.left + insets.right + this.getHgap() * 2;
                dim.height += insets.top + insets.bottom + this.getVgap() * 2;
                return dim;
            }
        }
    }

    private static class ArrowButton
    extends JButton {
        private boolean entered = false;
        private boolean open = true;
        private static final int[] yup = new int[]{1, 4, 4};
        private static final int[] ydown = new int[]{4, 1, 1};

        public ArrowButton() {
            this.setMinimumSize(new Dimension(6, 6));
            this.setPreferredSize(new Dimension(6, 6));
            this.setFocusPainted(false);
            this.setBorderPainted(false);
            this.setRequestFocusEnabled(false);
            this.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseEntered(MouseEvent e) {
                    ArrowButton.this.entered = true;
                    ArrowButton.this.repaint();
                }

                @Override
                public void mouseExited(MouseEvent e) {
                    ArrowButton.this.entered = false;
                    ArrowButton.this.repaint();
                }
            });
        }

        @Override
        public void setBorder(Border border) {
        }

        @Override
        public void paint(Graphics g) {
            Color f;
            Color b;
            if (this.entered) {
                b = UIManager.getColor("controlDkShadow");
                f = Color.BLACK;
            } else {
                b = UIManager.getColor("control");
                f = UIManager.getColor("controlDkShadow");
            }
            g.setColor(b);
            g.fillRect(0, 0, this.getWidth(), this.getHeight());
            int center = this.getWidth() / 2;
            int[] xs = new int[]{center, center - 3, center + 3};
            int[] ys = this.open ? yup : ydown;
            g.setColor(f);
            g.drawPolygon(xs, ys, 3);
            g.fillPolygon(xs, ys, 3);
        }

        public void setOpen(boolean open) {
            this.open = open;
        }

        public boolean isOpen() {
            return this.open;
        }
    }
}

