/*
 * Decompiled with CFR 0.152.
 */
package pcgen.gui2.plaf;

import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeListener;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.LookAndFeel;
import javax.swing.UIManager;
import org.apache.commons.lang.SystemUtils;
import pcgen.gui2.plaf.SkinManager;
import pcgen.system.ConfigurationSettings;
import pcgen.util.Logging;
import pcgen.util.SkinLFResourceChecker;

public final class LookAndFeelManager {
    public static final boolean HAS_SKIN_LAF = SkinLFResourceChecker.getMissingResourceCount() == 0;
    private static final String SYSTEM_LAF_CLASS = UIManager.getSystemLookAndFeelClassName();
    private static final String CROSS_LAF_CLASS = UIManager.getCrossPlatformLookAndFeelClassName();
    private static final LookAndFeelHandler[] lafHandlers;
    private static final Map<String, LookAndFeelHandler> lafMap;
    private static final LookAndFeelManager instance;
    private static String selectedLookAndFeel;
    private static String selectedTheme;
    private static String currentTheme;
    private static String currentLAF;
    private String oldThemePack = null;

    private LookAndFeelManager() {
    }

    public static void initLookAndFeel() {
        currentLAF = "Java";
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        UIManager.LookAndFeelInfo nimbus = LookAndFeelManager.getNimbusLaf();
        if (screenSize.height > 800 && nimbus != null) {
            currentLAF = nimbus.getName();
        }
        String laf = ConfigurationSettings.initSystemProperty("lookAndFeel", currentLAF);
        selectedTheme = ConfigurationSettings.getSystemProperty("selectedThemePack");
        LookAndFeelManager.setLookAndFeel(laf);
    }

    private static UIManager.LookAndFeelInfo getNimbusLaf() {
        UIManager.LookAndFeelInfo[] lafInfo;
        for (UIManager.LookAndFeelInfo lookAndFeelInfo : lafInfo = UIManager.getInstalledLookAndFeels()) {
            if (!"nimbus".equalsIgnoreCase(lookAndFeelInfo.getName())) continue;
            return lookAndFeelInfo;
        }
        return null;
    }

    public static Action[] getActions() {
        return lafHandlers;
    }

    public static void addThemePackListener(PropertyChangeListener listener) {
        ConfigurationSettings.getInstance().addPropertyChangeListener("selectedThemePack", listener);
    }

    public static String getCurrentThemePack() {
        return ConfigurationSettings.getSystemProperty("selectedThemePack");
    }

    public static String getCurrentLAF() {
        return ConfigurationSettings.getSystemProperty("lookAndFeel");
    }

    public static void setSelectedThemePack(String themePack) {
        selectedTheme = themePack;
        ConfigurationSettings.setSystemProperty("selectedThemePack", selectedTheme);
    }

    private static void setSkinLAF() {
        try {
            LookAndFeel laf = SkinManager.createSkinLAF(selectedTheme);
            UIManager.setLookAndFeel(laf);
            ConfigurationSettings.setSystemProperty("lookAndFeel", "Skinned");
            ConfigurationSettings.setSystemProperty("selectedThemePack", selectedTheme);
            currentTheme = selectedTheme;
            currentLAF = "Skinned";
        }
        catch (Exception ex) {
            if ("Skinned".equals(currentLAF)) {
                try {
                    LookAndFeel laf = SkinManager.createSkinLAF(currentTheme);
                    UIManager.setLookAndFeel(laf);
                }
                catch (Exception ex1) {
                    LookAndFeelManager.setLookAndFeel("Java");
                }
            }
            LookAndFeelManager.setLookAndFeel(currentLAF);
        }
    }

    public static void setLookAndFeel(String name) {
        LookAndFeelHandler handler = lafMap.get(name);
        if (handler == null) {
            Logging.errorPrint("Look and Feel " + name + " cannot be found");
            return;
        }
        String className = handler.getClassName();
        if (className != null) {
            try {
                UIManager.setLookAndFeel(className);
                ConfigurationSettings.setSystemProperty("lookAndFeel", name);
                currentLAF = name;
            }
            catch (Exception ex) {
                LookAndFeelManager.setLookAndFeel(currentLAF);
            }
        } else if (HAS_SKIN_LAF) {
            LookAndFeelManager.setSkinLAF();
        } else {
            Logging.errorPrint("Skin LAF library is missing! Setting to default LAF");
            LookAndFeelManager.setLookAndFeel("Java");
        }
    }

    static {
        lafMap = new HashMap<String, LookAndFeelHandler>();
        instance = new LookAndFeelManager();
        try {
            Class.forName("com.incors.plaf.kunststoff.KunststoffLookAndFeel");
            UIManager.installLookAndFeel("Kunststoff", "com.incors.plaf.kunststoff.KunststoffLookAndFeel");
        }
        catch (ClassNotFoundException ex) {
            // empty catch block
        }
        Comparator<UIManager.LookAndFeelInfo> lafcomp = new Comparator<UIManager.LookAndFeelInfo>(){

            @Override
            public int compare(UIManager.LookAndFeelInfo o1, UIManager.LookAndFeelInfo o2) {
                if (o1.getClassName().equals(SYSTEM_LAF_CLASS)) {
                    return -1;
                }
                if (o2.getClassName().equals(SYSTEM_LAF_CLASS)) {
                    return 1;
                }
                if (o1.getClassName().equals(CROSS_LAF_CLASS)) {
                    return -1;
                }
                if (o2.getClassName().equals(CROSS_LAF_CLASS)) {
                    return 1;
                }
                return 0;
            }
        };
        UIManager.LookAndFeelInfo[] lafInfo = UIManager.getInstalledLookAndFeels();
        Arrays.sort(lafInfo, lafcomp);
        if (!SystemUtils.IS_OS_WINDOWS) {
            for (int i = 0; i < lafInfo.length; ++i) {
                if (!lafInfo[i].getClassName().endsWith("WindowsLookAndFeel")) continue;
                lafInfo[i] = new UIManager.LookAndFeelInfo(lafInfo[i].getName(), "pcgen.gui2.plaf.FakeWindowsLookAndFeel");
                break;
            }
        }
        int length = lafInfo.length;
        if (HAS_SKIN_LAF) {
            ++length;
        }
        lafHandlers = new LookAndFeelHandler[length];
        for (int i = 0; i < lafInfo.length; ++i) {
            LookAndFeelHandler handler;
            String tooltip;
            String name;
            UIManager.LookAndFeelInfo info = lafInfo[i];
            if (info.getClassName().equals(SYSTEM_LAF_CLASS)) {
                name = "System";
                tooltip = "Sets the look to that of the System you are using";
            } else if (info.getClassName().equals(CROSS_LAF_CLASS)) {
                name = "Java";
                tooltip = "Sets the look to that of Java's cross platform look";
            } else {
                name = info.getName();
                tooltip = "Sets the look to " + name + " look";
            }
            LookAndFeelManager.lafHandlers[i] = handler = new LookAndFeelHandler(name, info.getClassName(), tooltip);
            lafMap.put(name, handler);
        }
        if (HAS_SKIN_LAF) {
            LookAndFeelHandler skinhandler;
            String name = "Skinned";
            String tooltip = "Sets the look to skinned";
            LookAndFeelManager.lafHandlers[lafInfo.length] = skinhandler = new LookAndFeelHandler(name, null, tooltip);
            lafMap.put(name, skinhandler);
        }
        UIManager.setInstalledLookAndFeels(lafInfo);
        selectedLookAndFeel = null;
        selectedTheme = null;
        currentTheme = null;
        currentLAF = null;
    }

    public static class LookAndFeelHandler
    extends AbstractAction {
        private String className;

        public LookAndFeelHandler(String name, String className, String tooltip) {
            super(name);
            this.className = className;
            this.putValue("ShortDescription", tooltip);
        }

        public String getClassName() {
            return this.className;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            String name = (String)this.getValue("Name");
            ConfigurationSettings.setSystemProperty("lookAndFeel", name);
        }
    }
}

