/*
 * Decompiled with CFR 0.152.
 */
package pcgen.gui2.tabs.bio;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import javax.imageio.ImageIO;
import javax.swing.AbstractAction;
import javax.swing.DefaultBoundedRangeModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import pcgen.core.utils.MessageType;
import pcgen.core.utils.ShowMessageDelegate;
import pcgen.facade.core.CharacterFacade;
import pcgen.facade.util.event.ReferenceEvent;
import pcgen.facade.util.event.ReferenceListener;
import pcgen.gui2.tabs.CharacterInfoTab;
import pcgen.gui2.tabs.TabTitle;
import pcgen.gui2.tabs.bio.ImagePreviewer;
import pcgen.gui2.tabs.bio.PortraitPane;
import pcgen.gui2.tabs.bio.ThumbnailPane;
import pcgen.gui2.tools.Icons;
import pcgen.gui2.tools.Utility;
import pcgen.system.LanguageBundle;
import pcgen.system.PCGenSettings;
import pcgen.util.Logging;

public class PortraitInfoPane
extends JScrollPane
implements CharacterInfoTab {
    private static final TabTitle tabTitle = new TabTitle("in_portrait", null);
    private static final int MAX_PORTRAIT_HEIGHT = 400;
    private final PortraitPane portraitPane;
    private final ThumbnailPane tnPane = new ThumbnailPane();
    private final JButton loadButton;
    private final JButton clearButton;
    private final JButton purchaseButton;
    private final JSlider zoomSlider;
    private JFileChooser chooser = null;

    public PortraitInfoPane() {
        this.portraitPane = new PortraitPane();
        this.loadButton = new JButton();
        this.clearButton = new JButton();
        this.purchaseButton = new JButton();
        this.zoomSlider = new JSlider(1);
        this.initComponents();
    }

    private void initComponents() {
        JPanel panel = new JPanel(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        Utility.buildConstraints(gbc, 0, 0, 2, 1, 0.0, 0.0);
        panel.add((Component)new JLabel(LanguageBundle.getString("in_largePortrait")), gbc);
        Utility.buildConstraints(gbc, 0, 1, 2, 1, 0.0, 0.0);
        panel.add((Component)this.portraitPane, gbc);
        Utility.buildConstraints(gbc, 0, 2, 1, 1, 0.0, 0.0, 0, 13);
        panel.add((Component)this.loadButton, gbc);
        Utility.buildConstraints(gbc, 1, 2, 1, 1, 0.0, 0.0, 0, 17);
        panel.add((Component)this.clearButton, gbc);
        Utility.buildConstraints(gbc, 2, 1, 1, 1, 0.0, 0.0, 3, 10);
        this.zoomSlider.setInverted(true);
        this.zoomSlider.setPreferredSize(new Dimension(20, 10));
        panel.add((Component)this.zoomSlider, gbc);
        Utility.buildConstraints(gbc, 3, 0, 1, 1, 0.0, 0.0, 2, 10);
        panel.add((Component)new JLabel(LanguageBundle.getString("in_thumbnailPortrait")), gbc);
        Utility.buildConstraints(gbc, 3, 1, 1, 1, 0.0, 0.0, 0, 11);
        panel.add((Component)this.tnPane, gbc);
        this.setViewportView(panel);
    }

    private BufferedImage createDefaultPortrait() {
        ImageIcon defaultPortrait = Icons.DefaultPortrait.getImageIcon();
        BufferedImage bufImage = new BufferedImage(defaultPortrait.getIconWidth(), defaultPortrait.getIconHeight(), 2);
        defaultPortrait.paintIcon(this, bufImage.createGraphics(), 0, 0);
        return bufImage;
    }

    @Override
    public CharacterInfoTab.ModelMap createModels(CharacterFacade character) {
        CharacterInfoTab.ModelMap models = new CharacterInfoTab.ModelMap();
        models.put(PortraitHandler.class, new PortraitHandler(character));
        models.put(LoadAction.class, new LoadAction(character));
        models.put(ClearAction.class, new ClearAction(character));
        return models;
    }

    @Override
    public void restoreModels(CharacterInfoTab.ModelMap models) {
        this.loadButton.setAction(models.get(LoadAction.class));
        this.clearButton.setAction(models.get(ClearAction.class));
        models.get(PortraitHandler.class).install();
    }

    @Override
    public void storeModels(CharacterInfoTab.ModelMap models) {
        models.get(PortraitHandler.class).uninstall();
    }

    @Override
    public TabTitle getTabTitle() {
        return tabTitle;
    }

    private class PortraitHandler
    extends MouseAdapter
    implements ReferenceListener<Object>,
    ChangeListener {
        private final CharacterFacade character;
        private Rectangle cropRect;
        private BufferedImage portrait;
        private float scale;
        private boolean movingRect = false;
        private Point cropOffset = null;

        public PortraitHandler(CharacterFacade character) {
            this.character = character;
            this.cropRect = character.getThumbnailCropRef().getReference();
            if (this.cropRect == null) {
                this.cropRect = new Rectangle(0, 0, 100, 100);
            }
        }

        public void install() {
            this.setPortrait(this.character.getPortraitRef().getReference());
            PortraitInfoPane.this.portraitPane.setCropRectangle(this.cropRect);
            PortraitInfoPane.this.tnPane.setCropRectangle(this.cropRect);
            this.character.getPortraitRef().addReferenceListener(this);
            this.character.getThumbnailCropRef().addReferenceListener(this);
            PortraitInfoPane.this.portraitPane.addMouseListener(this);
            PortraitInfoPane.this.portraitPane.addMouseMotionListener(this);
            PortraitInfoPane.this.portraitPane.addMouseWheelListener(this);
            PortraitInfoPane.this.zoomSlider.addChangeListener(this);
        }

        public void uninstall() {
            this.character.getPortraitRef().removeReferenceListener(this);
            this.character.getThumbnailCropRef().removeReferenceListener(this);
            PortraitInfoPane.this.portraitPane.removeMouseListener(this);
            PortraitInfoPane.this.portraitPane.removeMouseMotionListener(this);
            PortraitInfoPane.this.portraitPane.removeMouseWheelListener(this);
            PortraitInfoPane.this.zoomSlider.removeChangeListener(this);
        }

        private void setPortrait(File file) {
            this.portrait = null;
            try {
                if (file != null) {
                    if (file.exists() && file.canRead()) {
                        this.portrait = ImageIO.read(file);
                    } else {
                        Logging.errorPrint("Unable to read portrait file " + file.getAbsolutePath());
                    }
                }
            }
            catch (IOException ex) {
                Logging.errorPrint("Could not load image", ex);
            }
            if (this.portrait == null) {
                this.portrait = PortraitInfoPane.this.createDefaultPortrait();
            }
            PortraitInfoPane.this.portraitPane.setPortraitImage(this.portrait);
            this.scale = Math.min(400.0f / (float)this.portrait.getHeight(), 1.0f);
            int min = 100;
            int max = Math.min(this.portrait.getHeight(), this.portrait.getWidth());
            int value = Math.min(this.cropRect.width, max);
            value = Math.max(value, min);
            PortraitInfoPane.this.zoomSlider.setModel(new DefaultBoundedRangeModel(value, 0, min, max));
            PortraitInfoPane.this.portraitPane.revalidate();
            PortraitInfoPane.this.tnPane.setPortraitImage(this.portrait);
            PortraitInfoPane.this.tnPane.revalidate();
        }

        @Override
        public void referenceChanged(ReferenceEvent<Object> e) {
            Object obj = e.getNewReference();
            if (obj == null || obj instanceof File) {
                this.setPortrait((File)obj);
                Rectangle cropRect = new Rectangle(1, 1, 100, 100);
                Utility.adjustRectToFitImage(this.portrait, cropRect);
                this.character.setThumbnailCrop(cropRect);
            } else if (obj instanceof Rectangle) {
                Rectangle rect = (Rectangle)obj;
                Rectangle cropRect = new Rectangle(rect);
                Utility.adjustRectToFitImage(this.portrait, cropRect);
                if (!rect.equals(cropRect)) {
                    this.character.setThumbnailCrop(new Rectangle(cropRect));
                }
                PortraitInfoPane.this.portraitPane.setCropRectangle(rect);
                PortraitInfoPane.this.tnPane.setCropRectangle(rect);
                PortraitInfoPane.this.zoomSlider.setValue(rect.width);
            }
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            if (this.movingRect) {
                int y;
                int x;
                if (this.scale < 1.0f) {
                    x = (int)((float)e.getX() / this.scale - (float)this.cropOffset.x);
                    y = (int)((float)e.getY() / this.scale - (float)this.cropOffset.y);
                } else {
                    x = e.getX() - this.cropOffset.x;
                    y = e.getY() - this.cropOffset.y;
                }
                x = Math.max(x, 0);
                y = Math.max(y, 0);
                this.cropRect.setLocation(x, y);
                Utility.adjustRectToFitImage(this.portrait, this.cropRect);
                this.character.setThumbnailCrop(new Rectangle(this.cropRect));
            }
        }

        @Override
        public void mousePressed(MouseEvent e) {
            if (e.getButton() != 1) {
                return;
            }
            Point mousepoint = e.getPoint();
            if (this.scale < 1.0f) {
                mousepoint.x = (int)((float)mousepoint.x / this.scale);
                mousepoint.y = (int)((float)mousepoint.y / this.scale);
            }
            this.movingRect = this.cropRect.contains(mousepoint);
            this.cropOffset = new Point(mousepoint.x - this.cropRect.x, mousepoint.y - this.cropRect.y);
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            this.movingRect = false;
        }

        @Override
        public void mouseWheelMoved(MouseWheelEvent e) {
            if (e.getScrollType() != 0) {
                return;
            }
            Point mousepoint = e.getPoint();
            if (this.scale < 1.0f) {
                mousepoint.x = (int)((float)mousepoint.x / this.scale);
                mousepoint.y = (int)((float)mousepoint.y / this.scale);
            }
            if (!this.cropRect.contains(mousepoint)) {
                return;
            }
            int units = e.getUnitsToScroll();
            int size = this.cropRect.width + units;
            size = Math.max(size, 100);
            size = Math.min(size, this.portrait.getWidth());
            this.cropRect.width = size = Math.min(size, this.portrait.getHeight());
            this.cropRect.height = size;
            int x = this.cropRect.x;
            int y = this.cropRect.y;
            x = Math.max(x, 0);
            y = Math.max(y, 0);
            this.cropRect.setLocation(x, y);
            Utility.adjustRectToFitImage(this.portrait, this.cropRect);
            this.character.setThumbnailCrop(new Rectangle(this.cropRect));
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            int size;
            this.cropRect.width = size = PortraitInfoPane.this.zoomSlider.getValue();
            this.cropRect.height = size;
            int x = this.cropRect.x;
            int y = this.cropRect.y;
            x = Math.max(x, 0);
            y = Math.max(y, 0);
            this.cropRect.setLocation(x, y);
            Utility.adjustRectToFitImage(this.portrait, this.cropRect);
            this.character.setThumbnailCrop(new Rectangle(this.cropRect));
        }
    }

    private class PurchaseAction
    extends AbstractAction {
        private final CharacterFacade character;

        public PurchaseAction(CharacterFacade character) {
            super(LanguageBundle.getString("in_buyPortrait"));
            this.character = character;
            this.putValue("ShortDescription", LanguageBundle.getString("in_buyPortraitTipString"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            try {
                Utility.viewInBrowser("https://www.e-junkie.com/ecom/gb.php?cl=154598&c=ib&aff=154875");
            }
            catch (IOException ex) {
                Logging.errorPrint("Could not open affiliate site in external browser.", ex);
                ShowMessageDelegate.showMessageDialog("Could not open affiliate site in external browser.", "PCGen", MessageType.ERROR);
            }
        }
    }

    private class ClearAction
    extends AbstractAction {
        private final CharacterFacade character;

        public ClearAction(CharacterFacade character) {
            super(LanguageBundle.getString("in_clearPortrait"));
            this.character = character;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.character.setPortrait(null);
        }
    }

    private class LoadAction
    extends AbstractAction
    implements PropertyChangeListener {
        private final CharacterFacade character;
        private final ImagePreviewer previewer;

        public LoadAction(CharacterFacade character) {
            super(LanguageBundle.getString("in_loadPortrait"));
            this.previewer = new ImagePreviewer();
            this.character = character;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (PortraitInfoPane.this.chooser == null) {
                PortraitInfoPane.this.chooser = new JFileChooser(PCGenSettings.getPortraitsDir());
            }
            PortraitInfoPane.this.chooser.setAccessory(this.previewer);
            PortraitInfoPane.this.chooser.addPropertyChangeListener(this);
            int ret = PortraitInfoPane.this.chooser.showOpenDialog(PortraitInfoPane.this);
            PortraitInfoPane.this.chooser.removePropertyChangeListener(this);
            BufferedImage image = this.previewer.getImage();
            if (ret == 0 && image != null) {
                this.character.setPortrait(PortraitInfoPane.this.chooser.getSelectedFile());
            }
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            this.previewer.setImage(PortraitInfoPane.this.chooser.getSelectedFile());
        }
    }
}

