/*
 * Decompiled with CFR 0.152.
 */
package pcgen.gui2.tabs.spells;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFileChooser;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import pcgen.facade.core.CharacterFacade;
import pcgen.facade.core.ClassFacade;
import pcgen.facade.core.SpellFacade;
import pcgen.facade.core.SpellSupportFacade;
import pcgen.gui2.filter.Filter;
import pcgen.gui2.filter.FilterBar;
import pcgen.gui2.filter.FilterButton;
import pcgen.gui2.filter.FilterUtilities;
import pcgen.gui2.filter.FilteredTreeViewTable;
import pcgen.gui2.filter.SearchFilterPanel;
import pcgen.gui2.tabs.CharacterInfoTab;
import pcgen.gui2.tabs.TabTitle;
import pcgen.gui2.tabs.spells.ClassInfoHandler;
import pcgen.gui2.tabs.spells.QualifiedSpellTreeCellRenderer;
import pcgen.gui2.tabs.spells.SpellInfoHandler;
import pcgen.gui2.tabs.spells.SpellTreeViewModel;
import pcgen.gui2.tools.FlippingSplitPane;
import pcgen.gui2.tools.Icons;
import pcgen.gui2.tools.InfoPane;
import pcgen.gui2.util.JTreeViewTable;
import pcgen.system.ConfigurationSettings;
import pcgen.system.LanguageBundle;
import pcgen.system.PCGenSettings;
import pcgen.util.enumeration.Tab;

public class SpellsKnownTab
extends FlippingSplitPane
implements CharacterInfoTab {
    private final TabTitle tabTitle = new TabTitle(Tab.KNOWN_SPELLS);
    private final FilteredTreeViewTable<CharacterFacade, SpellSupportFacade.SuperNode> availableTable = new FilteredTreeViewTable();
    private final JTreeViewTable<SpellSupportFacade.SuperNode> selectedTable = new JTreeViewTable();
    private final QualifiedSpellTreeCellRenderer spellRenderer = new QualifiedSpellTreeCellRenderer();
    private final JButton addButton = new JButton();
    private final JButton removeButton = new JButton();
    private final FilterButton<CharacterFacade, SpellSupportFacade.SuperNode> qFilterButton = new FilterButton("SpellsKnownQualified");
    private final JCheckBox autoKnownBox = new JCheckBox();
    private final JCheckBox slotsBox = new JCheckBox();
    private final JTextField spellSheetField = new JTextField();
    private final InfoPane spellsPane = new InfoPane(LanguageBundle.getString("InfoSpells.spell.info"));
    private final InfoPane classPane = new InfoPane(LanguageBundle.getString("InfoSpells.class.info"));
    private JFileChooser fileChooser = null;
    private JButton previewSpellsButton;
    private JButton exportSpellsButton;

    public SpellsKnownTab() {
        super("SpellsKnown");
        this.initComponents();
    }

    private void initComponents() {
        this.availableTable.setTreeCellRenderer(this.spellRenderer);
        this.selectedTable.setTreeCellRenderer(this.spellRenderer);
        FilterBar<Object, Object> filterBar = new FilterBar<Object, Object>();
        filterBar.addDisplayableFilter(new SearchFilterPanel());
        this.qFilterButton.setText(LanguageBundle.getString("in_igQualFilter"));
        filterBar.addDisplayableFilter(this.qFilterButton);
        FlippingSplitPane upperPane = new FlippingSplitPane("SpellsKnownTop");
        JPanel availPanel = FilterUtilities.configureFilteredTreeViewPane(this.availableTable, filterBar);
        Box box = Box.createVerticalBox();
        box.add(Box.createVerticalStrut(2));
        Box hbox = Box.createHorizontalBox();
        hbox.add(Box.createHorizontalStrut(5));
        hbox.add(this.autoKnownBox);
        hbox.add(Box.createHorizontalGlue());
        box.add(hbox);
        hbox = Box.createHorizontalBox();
        hbox.add(Box.createHorizontalStrut(5));
        hbox.add(this.slotsBox);
        hbox.add(Box.createHorizontalGlue());
        hbox.add(Box.createHorizontalStrut(10));
        hbox.add(this.addButton);
        hbox.add(Box.createHorizontalStrut(5));
        box.add(hbox);
        box.add(Box.createVerticalStrut(5));
        availPanel.add((Component)box, "South");
        upperPane.setLeftComponent(availPanel);
        box = Box.createVerticalBox();
        box.add(new JScrollPane(this.selectedTable));
        box.add(Box.createVerticalStrut(4));
        hbox = Box.createHorizontalBox();
        hbox.add(Box.createHorizontalStrut(5));
        hbox.add(this.removeButton);
        hbox.add(Box.createHorizontalStrut(10));
        JButton spellSheetButton = new JButton(LanguageBundle.getString("InfoSpells.select.spellsheet"));
        spellSheetButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SpellsKnownTab.this.selectSpellSheetButton();
            }
        });
        hbox.add(spellSheetButton);
        hbox.add(Box.createHorizontalStrut(3));
        String text = PCGenSettings.getSelectedSpellSheet();
        if (text != null) {
            text = new File(text).getName();
        }
        this.spellSheetField.setEditable(false);
        this.spellSheetField.setText(text);
        this.spellSheetField.setToolTipText(text);
        hbox.add(this.spellSheetField);
        hbox.add(Box.createHorizontalStrut(3));
        this.previewSpellsButton = new JButton(Icons.PrintPreview16.getImageIcon());
        hbox.add(this.previewSpellsButton);
        hbox.add(Box.createHorizontalStrut(3));
        this.exportSpellsButton = new JButton(Icons.Print16.getImageIcon());
        hbox.add(this.exportSpellsButton);
        hbox.add(Box.createHorizontalStrut(5));
        box.add(hbox);
        box.add(Box.createVerticalStrut(5));
        upperPane.setRightComponent(box);
        upperPane.setResizeWeight(0.0);
        this.setTopComponent(upperPane);
        FlippingSplitPane bottomPane = new FlippingSplitPane("SpellsKnownBottom");
        bottomPane.setLeftComponent(this.spellsPane);
        bottomPane.setRightComponent(this.classPane);
        this.setBottomComponent(bottomPane);
        this.setOrientation(0);
    }

    @Override
    public CharacterInfoTab.ModelMap createModels(CharacterFacade character) {
        CharacterInfoTab.ModelMap models = new CharacterInfoTab.ModelMap();
        models.put(TreeViewModelHandler.class, new TreeViewModelHandler(character));
        models.put(AddSpellAction.class, new AddSpellAction(character));
        models.put(RemoveSpellAction.class, new RemoveSpellAction(character));
        models.put(AutoAddSpellsAction.class, new AutoAddSpellsAction(character));
        models.put(UseHigherSlotsAction.class, new UseHigherSlotsAction(character));
        models.put(PreviewSpellsAction.class, new PreviewSpellsAction(character));
        models.put(ExportSpellsAction.class, new ExportSpellsAction(character));
        models.put(SpellInfoHandler.class, new SpellInfoHandler(character, this.availableTable, this.selectedTable, this.spellsPane));
        models.put(ClassInfoHandler.class, new ClassInfoHandler(character, this.availableTable, this.selectedTable, this.classPane));
        models.put(SpellFilterHandler.class, new SpellFilterHandler(character));
        return models;
    }

    @Override
    public void restoreModels(CharacterInfoTab.ModelMap models) {
        models.get(SpellFilterHandler.class).install();
        models.get(TreeViewModelHandler.class).install();
        models.get(SpellInfoHandler.class).install();
        models.get(ClassInfoHandler.class).install();
        models.get(AddSpellAction.class).install();
        models.get(RemoveSpellAction.class).install();
        models.get(AutoAddSpellsAction.class).install();
        models.get(UseHigherSlotsAction.class).install();
        this.previewSpellsButton.setAction(models.get(PreviewSpellsAction.class));
        this.exportSpellsButton.setAction(models.get(ExportSpellsAction.class));
    }

    @Override
    public void storeModels(CharacterInfoTab.ModelMap models) {
        models.get(SpellInfoHandler.class).uninstall();
        models.get(ClassInfoHandler.class).uninstall();
        models.get(AddSpellAction.class).uninstall();
        models.get(RemoveSpellAction.class).uninstall();
        models.get(TreeViewModelHandler.class).uninstall();
    }

    @Override
    public TabTitle getTabTitle() {
        return this.tabTitle;
    }

    private void selectSpellSheetButton() {
        if (this.fileChooser == null) {
            this.fileChooser = new JFileChooser();
        }
        this.fileChooser.setDialogTitle(LanguageBundle.getString("InfoSpells.select.output.sheet"));
        this.fileChooser.setCurrentDirectory(new File(ConfigurationSettings.getOutputSheetsDir()));
        if (PCGenSettings.getSelectedSpellSheet() != null) {
            this.fileChooser.setSelectedFile(new File(PCGenSettings.getSelectedSpellSheet()));
        }
        if (this.fileChooser.showOpenDialog(this) == 0) {
            PCGenSettings.getInstance().setProperty("pcgen.files.selectedSpellOutputSheet", this.fileChooser.getSelectedFile().getAbsolutePath());
            this.spellSheetField.setText(this.fileChooser.getSelectedFile().getName());
            this.spellSheetField.setToolTipText(this.fileChooser.getSelectedFile().getName());
        }
    }

    private class SpellFilterHandler
    implements Filter<CharacterFacade, SpellSupportFacade.SuperNode> {
        private final CharacterFacade character;

        public SpellFilterHandler(CharacterFacade character) {
            this.character = character;
        }

        public void install() {
            SpellsKnownTab.this.qFilterButton.setFilter(this);
        }

        @Override
        public boolean accept(CharacterFacade context, SpellSupportFacade.SuperNode element) {
            if (element instanceof SpellSupportFacade.SpellNode) {
                SpellSupportFacade.SpellNode spellNode = (SpellSupportFacade.SpellNode)element;
                SpellFacade spell = spellNode.getSpell();
                ClassFacade pcClass = spellNode.getSpellcastingClass();
                return this.character.isQualifiedFor(spell, pcClass);
            }
            return true;
        }
    }

    private class TreeViewModelHandler {
        private final SpellTreeViewModel availableModel;
        private final SpellTreeViewModel selectedModel;
        private final CharacterFacade character;

        public TreeViewModelHandler(CharacterFacade character) {
            this.character = character;
            this.availableModel = new SpellTreeViewModel(character.getSpellSupport().getAvailableSpellNodes(), false, "SpellsKnownAva", character.getInfoFactory());
            this.selectedModel = new SpellTreeViewModel(character.getSpellSupport().getAllKnownSpellNodes(), true, "SpellsKnownSel", character.getInfoFactory());
        }

        public void install() {
            SpellsKnownTab.this.spellRenderer.setCharacter(this.character);
            SpellsKnownTab.this.availableTable.setTreeViewModel(this.availableModel);
            SpellsKnownTab.this.selectedTable.setTreeViewModel(this.selectedModel);
        }

        public void uninstall() {
            SpellsKnownTab.this.spellRenderer.setCharacter(null);
        }
    }

    private class ExportSpellsAction
    extends AbstractAction {
        private final CharacterFacade character;

        public ExportSpellsAction(CharacterFacade character) {
            this.character = character;
            this.putValue("SmallIcon", Icons.Print16.getImageIcon());
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.character.getSpellSupport().exportSpells();
        }
    }

    private class PreviewSpellsAction
    extends AbstractAction {
        private final CharacterFacade character;

        public PreviewSpellsAction(CharacterFacade character) {
            this.character = character;
            this.putValue("SmallIcon", Icons.PrintPreview16.getImageIcon());
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.character.getSpellSupport().previewSpells();
        }
    }

    private class UseHigherSlotsAction
    extends AbstractAction {
        private final CharacterFacade character;

        public UseHigherSlotsAction(CharacterFacade character) {
            super(LanguageBundle.getString("InfoKnownSpells.canUseHigherSlots"));
            this.character = character;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.character.getSpellSupport().setUseHigherKnownSlots(SpellsKnownTab.this.slotsBox.isSelected());
        }

        public void install() {
            SpellsKnownTab.this.slotsBox.setAction(this);
            SpellsKnownTab.this.slotsBox.setSelected(this.character.getSpellSupport().isUseHigherKnownSlots());
        }
    }

    private class AutoAddSpellsAction
    extends AbstractAction {
        private final CharacterFacade character;

        public AutoAddSpellsAction(CharacterFacade character) {
            super(LanguageBundle.getString("InfoSpells.autoload"));
            this.character = character;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.character.getSpellSupport().setAutoSpells(SpellsKnownTab.this.autoKnownBox.isSelected());
        }

        public void install() {
            SpellsKnownTab.this.autoKnownBox.setAction(this);
            SpellsKnownTab.this.autoKnownBox.setSelected(this.character.getSpellSupport().isAutoSpells());
        }
    }

    private class RemoveSpellAction
    extends AbstractAction {
        private final CharacterFacade character;

        public RemoveSpellAction(CharacterFacade character) {
            this.character = character;
            this.putValue("SmallIcon", Icons.Back16.getImageIcon());
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            List<Object> data = SpellsKnownTab.this.selectedTable.getSelectedData();
            for (Object object : data) {
                if (!(object instanceof SpellSupportFacade.SpellNode)) continue;
                this.character.getSpellSupport().removeKnownSpell((SpellSupportFacade.SpellNode)object);
            }
        }

        public void install() {
            SpellsKnownTab.this.selectedTable.addActionListener(this);
            SpellsKnownTab.this.removeButton.setAction(this);
        }

        public void uninstall() {
            SpellsKnownTab.this.selectedTable.removeActionListener(this);
        }
    }

    private class AddSpellAction
    extends AbstractAction {
        private final CharacterFacade character;

        public AddSpellAction(CharacterFacade character) {
            this.character = character;
            this.putValue("SmallIcon", Icons.Forward16.getImageIcon());
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            List<Object> data = SpellsKnownTab.this.availableTable.getSelectedData();
            for (Object object : data) {
                if (!(object instanceof SpellSupportFacade.SpellNode)) continue;
                this.character.getSpellSupport().addKnownSpell((SpellSupportFacade.SpellNode)object);
            }
        }

        public void install() {
            SpellsKnownTab.this.availableTable.addActionListener(this);
            SpellsKnownTab.this.addButton.setAction(this);
        }

        public void uninstall() {
            SpellsKnownTab.this.availableTable.removeActionListener(this);
        }
    }
}

