/*
 * Decompiled with CFR 0.152.
 */
package pcgen.io;

import java.awt.Rectangle;
import java.io.File;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import org.apache.commons.lang.StringUtils;
import pcgen.base.util.HashMapToList;
import pcgen.cdom.base.AssociatedPrereqObject;
import pcgen.cdom.base.CDOMObject;
import pcgen.cdom.base.CDOMReference;
import pcgen.cdom.base.Constants;
import pcgen.cdom.base.PersistentTransitionChoice;
import pcgen.cdom.base.SelectableSet;
import pcgen.cdom.base.UserSelection;
import pcgen.cdom.content.CNAbility;
import pcgen.cdom.content.CNAbilityFactory;
import pcgen.cdom.enumeration.AssociationKey;
import pcgen.cdom.enumeration.AssociationListKey;
import pcgen.cdom.enumeration.BiographyField;
import pcgen.cdom.enumeration.Gender;
import pcgen.cdom.enumeration.Handed;
import pcgen.cdom.enumeration.IntegerKey;
import pcgen.cdom.enumeration.ListKey;
import pcgen.cdom.enumeration.Nature;
import pcgen.cdom.enumeration.ObjectKey;
import pcgen.cdom.enumeration.PCStringKey;
import pcgen.cdom.enumeration.Region;
import pcgen.cdom.enumeration.SkillFilter;
import pcgen.cdom.enumeration.SkillsOutputOrder;
import pcgen.cdom.enumeration.SourceFormat;
import pcgen.cdom.enumeration.StringKey;
import pcgen.cdom.enumeration.Type;
import pcgen.cdom.facet.FacetLibrary;
import pcgen.cdom.facet.input.DomainInputFacet;
import pcgen.cdom.facet.input.RaceInputFacet;
import pcgen.cdom.facet.input.TemplateInputFacet;
import pcgen.cdom.helper.CNAbilitySelection;
import pcgen.cdom.helper.ClassSource;
import pcgen.cdom.inst.EquipmentHead;
import pcgen.cdom.inst.PCClassLevel;
import pcgen.cdom.list.ClassSpellList;
import pcgen.cdom.list.CompanionList;
import pcgen.cdom.list.DomainSpellList;
import pcgen.core.Ability;
import pcgen.core.AbilityCategory;
import pcgen.core.BonusManager;
import pcgen.core.Campaign;
import pcgen.core.ChronicleEntry;
import pcgen.core.Deity;
import pcgen.core.Domain;
import pcgen.core.Equipment;
import pcgen.core.GameMode;
import pcgen.core.Globals;
import pcgen.core.Kit;
import pcgen.core.Language;
import pcgen.core.NoteItem;
import pcgen.core.PCAlignment;
import pcgen.core.PCClass;
import pcgen.core.PCStat;
import pcgen.core.PCTemplate;
import pcgen.core.PObject;
import pcgen.core.PlayerCharacter;
import pcgen.core.Race;
import pcgen.core.SettingsHandler;
import pcgen.core.Skill;
import pcgen.core.SpecialAbility;
import pcgen.core.SpellProhibitor;
import pcgen.core.SubClass;
import pcgen.core.SubstitutionClass;
import pcgen.core.SystemCollections;
import pcgen.core.WeaponProf;
import pcgen.core.analysis.BonusAddition;
import pcgen.core.analysis.ChooseActivation;
import pcgen.core.analysis.DomainApplication;
import pcgen.core.analysis.RaceAlignment;
import pcgen.core.analysis.SkillRankControl;
import pcgen.core.analysis.SpellLevel;
import pcgen.core.analysis.SubClassApplication;
import pcgen.core.analysis.SubstitutionLevelSupport;
import pcgen.core.bonus.Bonus;
import pcgen.core.bonus.BonusObj;
import pcgen.core.character.CharacterSpell;
import pcgen.core.character.EquipSet;
import pcgen.core.character.Follower;
import pcgen.core.character.SpellBook;
import pcgen.core.character.SpellInfo;
import pcgen.core.chooser.ChoiceManagerList;
import pcgen.core.chooser.ChooserUtilities;
import pcgen.core.display.BonusDisplay;
import pcgen.core.pclevelinfo.PCLevelInfo;
import pcgen.core.spell.Spell;
import pcgen.core.utils.CoreUtility;
import pcgen.core.utils.MessageType;
import pcgen.core.utils.ShowMessageDelegate;
import pcgen.facade.core.SourceSelectionFacade;
import pcgen.io.Cache;
import pcgen.io.Compatibility;
import pcgen.io.EntityEncoder;
import pcgen.io.IOConstants;
import pcgen.io.PCGParseException;
import pcgen.io.PCGParser;
import pcgen.io.migration.AbilityMigration;
import pcgen.io.migration.EquipSetMigration;
import pcgen.io.migration.EquipmentMigration;
import pcgen.io.migration.RaceMigration;
import pcgen.io.migration.SourceMigration;
import pcgen.io.migration.SpellMigration;
import pcgen.persistence.PersistenceLayerException;
import pcgen.rules.context.AbstractReferenceContext;
import pcgen.rules.context.LoadContext;
import pcgen.system.FacadeFactory;
import pcgen.system.LanguageBundle;
import pcgen.system.PCGenSettings;
import pcgen.util.Logging;
import pcgen.util.enumeration.ProhibitedSpellType;

final class PCGVer2Parser
implements PCGParser,
IOConstants {
    private static final Class<Domain> DOMAIN_CLASS = Domain.class;
    private static final String TAG_PCTEMPLATE = "PCTEMPLATE";
    private RaceInputFacet raceInputFacet = FacetLibrary.getFacet(RaceInputFacet.class);
    private DomainInputFacet domainInputFacet = FacetLibrary.getFacet(DomainInputFacet.class);
    private TemplateInputFacet templateInputFacet = FacetLibrary.getFacet(TemplateInputFacet.class);
    private final List<String> warnings = new ArrayList<String>();
    private Cache cache;
    private PlayerCharacter thePC;
    private final Set<String> seenStats = new HashSet<String>();
    private final Set<Language> cachedLanguages = new HashSet<Language>();
    private int[] pcgenVersion = new int[]{0, 0, 0};
    private String pcgenVersionSuffix;
    private boolean calcFeatPoolAfterLoad = false;
    private double baseFeatPool = 0.0;
    private boolean featsPresent = false;
    private static final Class<Language> LANGUAGE_CLASS = Language.class;

    PCGVer2Parser(PlayerCharacter aPC) {
        this.thePC = aPC;
    }

    @Override
    public List<String> getWarnings() {
        return this.warnings;
    }

    @Override
    public void parsePCG(String[] lines) throws PCGParseException {
        this.buildPcgLineCache(lines);
        this.parseCachedLines();
        this.resolveLanguages();
    }

    @Override
    public SourceSelectionFacade parcePCGSourceOnly(String[] lines) throws PCGParseException {
        this.buildPcgLineCache(lines);
        if (this.cache.containsKey("VERSION")) {
            this.parseVersionLine(this.cache.get("VERSION").get(0));
        }
        if (!this.cache.containsKey("GAMEMODE")) {
            Logging.errorPrint("Character does not have game mode information.");
            return null;
        }
        String line = this.cache.get("GAMEMODE").get(0);
        String requestedMode = line.substring("GAMEMODE".length() + 1);
        GameMode mode = SystemCollections.getGameModeNamed(requestedMode);
        if (mode == null) {
            for (GameMode gameMode : SystemCollections.getUnmodifiableGameModeList()) {
                if (!gameMode.getAllowedModes().contains(requestedMode)) continue;
                mode = gameMode;
                break;
            }
        }
        if (mode == null) {
            Logging.errorPrint("Character's game mode entry was not valid: " + line);
            return null;
        }
        if (!this.cache.containsKey("CAMPAIGN")) {
            Logging.errorPrint("Character does not have campaign information.");
            return FacadeFactory.createSourceSelection(mode, new ArrayList());
        }
        List<Campaign> campaigns = this.getCampaignList(this.cache.get("CAMPAIGN"), mode.getName());
        if (campaigns.isEmpty()) {
            Logging.errorPrint("Character's campaign entry was empty.");
        }
        return FacadeFactory.createSourceSelection(mode, campaigns);
    }

    private void buildPcgLineCache(String[] lines) {
        this.initCache(lines.length);
        for (int i = 0; i < lines.length; ++i) {
            if (lines[i].trim().length() <= 0 || PCGVer2Parser.isComment(lines[i])) continue;
            this.cacheLine(lines[i].trim());
        }
    }

    private static boolean isComment(String line) {
        return line.trim().startsWith("#");
    }

    private Map<BonusObj, BonusManager.TempBonusInfo> getBonusFromName(String sName, String tName) {
        String sourceStr = sName.substring("TEMPBONUS".length() + 1);
        String targetStr = tName.substring("TBTARGET".length() + 1);
        PObject oSource = null;
        Equipment oTarget = null;
        if (sourceStr.startsWith("FEAT=")) {
            sourceStr = sourceStr.substring(5);
            oSource = Globals.getContext().getReferenceContext().silentlyGetConstructedCDOMObject(Ability.class, AbilityCategory.FEAT, sourceStr);
            oSource = this.thePC.getAbilityKeyed(AbilityCategory.FEAT, sourceStr);
            if (oSource == null) {
                for (AbilityCategory cat : SettingsHandler.getGame().getAllAbilityCategories()) {
                    Ability abilSourceObj = Globals.getContext().getReferenceContext().silentlyGetConstructedCDOMObject(Ability.class, cat, sourceStr);
                    if (abilSourceObj == null) continue;
                    oSource = abilSourceObj;
                }
            }
        } else if (sourceStr.startsWith("SPELL=")) {
            sourceStr = sourceStr.substring(6);
            oSource = Globals.getSpellKeyed(sourceStr);
        } else if (sourceStr.startsWith("EQUIPMENT=")) {
            sourceStr = sourceStr.substring(10);
            oSource = this.thePC.getEquipmentNamed(sourceStr);
        } else if (sourceStr.startsWith("CLASS=")) {
            sourceStr = sourceStr.substring(6);
            oSource = this.thePC.getClassKeyed(sourceStr);
        } else if (sourceStr.startsWith("TEMPLATE=")) {
            sourceStr = sourceStr.substring(9);
            oSource = Globals.getContext().getReferenceContext().silentlyGetConstructedCDOMObject(PCTemplate.class, sourceStr);
        } else if (sourceStr.startsWith("SKILL=")) {
            sourceStr = sourceStr.substring(6);
            Skill aSkill = Globals.getContext().getReferenceContext().silentlyGetConstructedCDOMObject(Skill.class, sourceStr);
            if (this.thePC.hasSkill(aSkill)) {
                oSource = aSkill;
            }
        }
        if (oSource != null) {
            sourceStr = ((CDOMObject)oSource).getKeyName();
        }
        if (targetStr.equals("PC")) {
            targetStr = this.thePC.getName();
        } else {
            oTarget = this.thePC.getEquipmentNamed(targetStr);
            targetStr = ((CDOMObject)oTarget).getDisplayName();
        }
        return this.thePC.getTempBonusMap(sourceStr, targetStr);
    }

    private void addKeyedTemplate(PCTemplate template, String choice) {
        if (ChooseActivation.hasNewChooseToken(template) && choice == null) {
            String message = "Template ignored: " + template + " as a choice was expected but none was present in character.";
            this.warnings.add(message);
            return;
        }
        int preXP = this.thePC.getXP();
        this.templateInputFacet.importSelection(this.thePC.getCharID(), template, choice);
        this.thePC.addTemplate(template);
        if (this.thePC.getXP() != preXP) {
            this.thePC.setXP(preXP);
        }
    }

    private void cacheLine(String s) {
        this.cache.put(s.substring(0, s.indexOf(58)), s);
    }

    private void checkSkillPools() {
        int skillPoints = 0;
        for (PCClass pcClass : this.thePC.getClassSet()) {
            skillPoints += pcClass.getSkillPool(this.thePC);
        }
        this.thePC.setDirty(true);
    }

    private void checkStats() throws PCGParseException {
        if (this.seenStats.size() != Globals.getContext().getReferenceContext().getConstructedObjectCount(PCStat.class)) {
            String message = LanguageBundle.getFormattedString("Exceptions.PCGenParser.WrongNumAttributes", this.seenStats.size(), Globals.getContext().getReferenceContext().getConstructedObjectCount(PCStat.class));
            throw new PCGParseException("parseStatLines", "N/A", message);
        }
    }

    private void initCache(int capacity) {
        this.cache = new Cache(capacity * 4 / 3);
    }

    private void parseAgeLine(String line) {
        try {
            this.thePC.setAge(Integer.parseInt(line.substring("AGE".length() + 1)));
        }
        catch (NumberFormatException nfe) {
            String message = LanguageBundle.getFormattedString("Warnings.PCGenParser.IllegalAgeLine", line);
            this.warnings.add(message);
        }
    }

    private void parseAgeSet(String line) {
        StringTokenizer aTok = new StringTokenizer(line, ":", false);
        int i = 0;
        aTok.nextToken();
        while (aTok.hasMoreTokens() && i < 10) {
            this.thePC.setHasMadeKitSelectionForAgeSet(i++, aTok.nextToken().equals("1"));
        }
    }

    private void parseAlignmentLine(String line) {
        String alignment = line.substring("ALIGN".length() + 1);
        PCAlignment align = Globals.getContext().getReferenceContext().silentlyGetConstructedCDOMObject(PCAlignment.class, alignment);
        if (align != null) {
            if (!RaceAlignment.canBeAlignment(this.thePC.getRace(), align)) {
                ShowMessageDelegate.showMessageDialog("Invalid alignment. Setting to <none selected>", "PCGen", MessageType.INFORMATION);
                align = this.getNoAlignment();
            }
            this.thePC.setAlignment(align);
            return;
        }
        String message = LanguageBundle.getFormattedString("Warnings.PCGenParser.IllegalAlignment", line);
        this.warnings.add(message);
    }

    private void parseAutoSortGearLine(String line) {
        this.thePC.setAutoSortGear(line.endsWith("Y"));
    }

    private void parseIgnoreCostLine(String line) {
        this.thePC.setIgnoreCost(line.endsWith("Y"));
    }

    private void parseAllowDebtLine(String line) {
        this.thePC.setAllowDebt(line.endsWith("Y"));
    }

    private void parseAutoResizeGearLine(String line) {
        this.thePC.setAutoResize(line.endsWith("Y"));
    }

    private void parseAutoSortSkillsLine(String line) {
        if (line.endsWith("Y")) {
            this.thePC.setSkillsOutputOrder(SkillsOutputOrder.NAME_ASC);
        } else {
            this.thePC.setSkillsOutputOrder(SkillsOutputOrder.MANUAL);
        }
    }

    private void parseAutoSpellsLine(String line) {
        this.thePC.setAutoSpells(line.endsWith("Y"));
    }

    private void parseUseHigherKnownSpellSlotsLine(String line) {
        this.thePC.setUseHigherKnownSlots(line.endsWith("Y"));
    }

    private void parseUseHigherPreppedSpellSlotsLine(String line) {
        this.thePC.setUseHigherPreppedSlots(line.endsWith("Y"));
    }

    private void parseBirthdayLine(String line) {
        this.thePC.setBirthday(EntityEncoder.decode(line.substring("BIRTHDAY".length() + 1)));
    }

    private void parseBirthplaceLine(String line) {
        this.thePC.setBirthplace(EntityEncoder.decode(line.substring("BIRTHPLACE".length() + 1)));
    }

    private void parseCachedLines() throws PCGParseException {
        if (this.cache.containsKey("VERSION")) {
            this.parseVersionLine(this.cache.get("VERSION").get(0));
        }
        if (this.cache.containsKey("GAMEMODE")) {
            this.parseGameMode(this.cache.get("GAMEMODE").get(0));
        }
        if (this.cache.containsKey("CAMPAIGN")) {
            this.checkDisplayListsHappy();
        }
        if (this.cache.containsKey("STAT")) {
            for (String stat : this.cache.get("STAT")) {
                this.parseStatLine(stat);
            }
            this.checkStats();
        }
        if (this.cache.containsKey("ALIGN")) {
            this.parseAlignmentLine(this.cache.get("ALIGN").get(0));
        }
        if (this.cache.containsKey("KIT")) {
            for (String line : this.cache.get("KIT")) {
                this.parseKitLine(line);
            }
        }
        if (this.cache.containsKey("RACE")) {
            this.parseRaceLine(this.cache.get("RACE").get(0));
        }
        if (this.cache.containsKey("FAVOREDCLASS")) {
            this.parseFavoredClassLine(this.cache.get("FAVOREDCLASS").get(0));
        }
        if (this.cache.containsKey("POOLPOINTS")) {
            this.parsePoolPointsLine(this.cache.get("POOLPOINTS").get(0));
        }
        if (this.cache.containsKey("POOLPOINTSAVAIL")) {
            this.parsePoolPointsLine2(this.cache.get("POOLPOINTSAVAIL").get(0));
        }
        if (this.cache.containsKey("CHARACTERTYPE")) {
            this.parseCharacterTypeLine(this.cache.get("CHARACTERTYPE").get(0));
        }
        if (this.cache.containsKey("PREVIEWSHEET")) {
            this.parsePreviewSheetLine(this.cache.get("PREVIEWSHEET").get(0));
        }
        if (this.cache.containsKey("AUTOSPELLS")) {
            this.parseAutoSpellsLine(this.cache.get("AUTOSPELLS").get(0));
        }
        if (this.cache.containsKey("USEHIGHERKNOWN")) {
            this.parseUseHigherKnownSpellSlotsLine(this.cache.get("USEHIGHERKNOWN").get(0));
        }
        if (this.cache.containsKey("USEHIGHERPREPPED")) {
            this.parseUseHigherPreppedSpellSlotsLine(this.cache.get("USEHIGHERPREPPED").get(0));
        }
        if (this.cache.containsKey("LOADCOMPANIONS")) {
            this.parseLoadCompanionLine(this.cache.get("LOADCOMPANIONS").get(0));
        }
        if (this.cache.containsKey("USETEMPMODS")) {
            this.parseUseTempModsLine(this.cache.get("USETEMPMODS").get(0));
        }
        if (this.cache.containsKey("OUTPUTSHEETHTML")) {
            this.parseHTMLOutputSheetLine(this.cache.get("OUTPUTSHEETHTML").get(0));
        }
        if (this.cache.containsKey("OUTPUTSHEETPDF")) {
            this.parsePDFOutputSheetLine(this.cache.get("OUTPUTSHEETPDF").get(0));
        }
        if (this.cache.containsKey("AUTOSORTGEAR")) {
            this.parseAutoSortGearLine(this.cache.get("AUTOSORTGEAR").get(0));
        }
        if (this.cache.containsKey("IGNORECOST")) {
            this.parseIgnoreCostLine(this.cache.get("IGNORECOST").get(0));
        }
        if (this.cache.containsKey("ALLOWDEBT")) {
            this.parseAllowDebtLine(this.cache.get("ALLOWDEBT").get(0));
        }
        if (this.cache.containsKey("AUTORESIZEGEAR")) {
            this.parseAutoResizeGearLine(this.cache.get("AUTORESIZEGEAR").get(0));
        }
        if (this.cache.containsKey("AUTOSORTSKILLS")) {
            this.parseAutoSortSkillsLine(this.cache.get("AUTOSORTSKILLS").get(0));
        }
        if (this.cache.containsKey("SKILLSOUTPUTORDER")) {
            this.parseSkillsOutputOrderLine(this.cache.get("SKILLSOUTPUTORDER").get(0));
        }
        if (this.cache.containsKey("SKILLFILTER")) {
            this.parseSkillFilterLine(this.cache.get("SKILLFILTER").get(0));
        }
        if (this.cache.containsKey("CLASS")) {
            for (String line : this.cache.get("CLASS")) {
                this.parseClassLine(line);
            }
            this.checkSkillPools();
        }
        ArrayList<PCLevelInfo> pcLevelInfoList = new ArrayList<PCLevelInfo>(this.thePC.getLevelInfo());
        if (this.cache.containsKey("CLASSABILITIESLEVEL")) {
            this.thePC.clearLevelInfo();
            for (String line : this.cache.get("CLASSABILITIESLEVEL")) {
                this.parseClassAbilitiesLevelLine(line, pcLevelInfoList);
            }
        }
        if (this.cache.containsKey("EXPERIENCE")) {
            this.parseExperienceLine(this.cache.get("EXPERIENCE").get(0));
        }
        if (this.cache.containsKey("EXPERIENCETABLE")) {
            this.parseExperienceTableLine(this.cache.get("EXPERIENCETABLE").get(0));
        }
        if (this.cache.containsKey("TEMPLATESAPPLIED")) {
            for (String line : this.cache.get("TEMPLATESAPPLIED")) {
                this.parseTemplateLine(line);
            }
        }
        if (this.cache.containsKey("REGION")) {
            for (String line : this.cache.get("REGION")) {
                this.parseRegionLine(line);
            }
        }
        if (this.cache.containsKey("SKILL")) {
            for (String line : this.cache.get("SKILL")) {
                this.parseSkillLine(line);
            }
        }
        if (this.cache.containsKey("LANGUAGE")) {
            for (String line : this.cache.get("LANGUAGE")) {
                this.parseLanguageLine(line);
            }
        }
        if (this.cache.containsKey("FEAT")) {
            for (String line : this.cache.get("FEAT")) {
                this.parseFeatLine(line);
            }
        }
        if (this.cache.containsKey("VFEAT")) {
            for (String line : this.cache.get("VFEAT")) {
                this.parseVFeatLine(line);
            }
        }
        if (this.cache.containsKey("FEATPOOL")) {
            for (String line : this.cache.get("FEATPOOL")) {
                this.parseFeatPoolLine(line);
            }
        }
        if (this.cache.containsKey("ABILITY")) {
            for (String line : this.cache.get("ABILITY")) {
                this.parseAbilityLine(line);
            }
        }
        if (this.cache.containsKey("USERPOOL")) {
            for (String line : this.cache.get("USERPOOL")) {
                this.parseUserPoolLine(line);
            }
        }
        if (this.cache.containsKey("DEITY")) {
            for (String line : this.cache.get("DEITY")) {
                this.parseDeityLine(line);
            }
        }
        if (this.cache.containsKey("DOMAIN")) {
            for (String line : this.cache.get("DOMAIN")) {
                this.parseDomainLine(line);
            }
        }
        if (this.cache.containsKey("SPELLBOOK")) {
            for (String line : this.cache.get("SPELLBOOK")) {
                this.parseSpellBookLines(line);
            }
        }
        if (this.cache.containsKey("SPELLLIST")) {
            for (String line : this.cache.get("SPELLLIST")) {
                this.parseSpellListLines(line);
            }
        }
        this.insertDefaultClassSpellLists();
        if (this.cache.containsKey("SPELLNAME")) {
            this.thePC.setImporting(false);
            this.thePC.calcActiveBonuses();
            this.thePC.setImporting(true);
            for (String line : this.cache.get("SPELLNAME")) {
                this.parseSpellLine(line);
            }
        }
        if (this.cache.containsKey("CHARACTERBIO")) {
            this.parseCharacterBioLine(this.cache.get("CHARACTERBIO").get(0));
        }
        if (this.cache.containsKey("CHARACTERDESC")) {
            this.parseCharacterDescLine(this.cache.get("CHARACTERDESC").get(0));
        }
        if (this.cache.containsKey("CHARACTERCOMP")) {
            for (String line : this.cache.get("CHARACTERCOMP")) {
                this.parseCharacterCompLine(line);
            }
        }
        if (this.cache.containsKey("CHARACTERASSET")) {
            for (String line : this.cache.get("CHARACTERASSET")) {
                this.parseCharacterAssetLine(line);
            }
        }
        if (this.cache.containsKey("CHARACTERMAGIC")) {
            for (String line : this.cache.get("CHARACTERMAGIC")) {
                this.parseCharacterMagicLine(line);
            }
        }
        if (this.cache.containsKey("CHARACTERDMNOTES")) {
            for (String line : this.cache.get("CHARACTERDMNOTES")) {
                this.parseCharacterDmNotesLine(line);
            }
        }
        if (this.cache.containsKey("MASTER")) {
            for (String line : this.cache.get("MASTER")) {
                this.parseMasterLine(line);
            }
        }
        if (this.cache.containsKey("FOLLOWER")) {
            for (String line : this.cache.get("FOLLOWER")) {
                this.parseFollowerLine(line);
            }
        }
        if (this.cache.containsKey("MONEY")) {
            for (String line : this.cache.get("MONEY")) {
                this.parseMoneyLine(line);
            }
        }
        if (this.cache.containsKey("EQUIPNAME")) {
            this.thePC.setImporting(false);
            this.thePC.setCalcFollowerBonus();
            this.thePC.calcActiveBonuses();
            this.thePC.setImporting(true);
            for (String line : this.cache.get("EQUIPNAME")) {
                this.parseEquipmentLine(line);
            }
        }
        if (this.cache.containsKey("EQUIPSET")) {
            for (String line : this.cache.get("EQUIPSET")) {
                this.parseEquipmentSetLine(line);
            }
            EquipSetMigration.migrateEquipSets(this.thePC, this.pcgenVersion);
        }
        if (this.cache.containsKey("CALCEQUIPSET")) {
            for (String line : this.cache.get("CALCEQUIPSET")) {
                this.parseCalcEquipSet(line);
            }
        }
        if (this.cache.containsKey("NOTE")) {
            for (String line : this.cache.get("NOTE")) {
                this.parseNoteLine(line);
            }
        }
        if (this.cache.containsKey("CHARACTERNAME")) {
            this.parseCharacterNameLine(this.cache.get("CHARACTERNAME").get(0));
        }
        if (this.cache.containsKey("TABNAME")) {
            this.parseTabNameLine(this.cache.get("TABNAME").get(0));
        }
        if (this.cache.containsKey("PLAYERNAME")) {
            this.parsePlayerNameLine(this.cache.get("PLAYERNAME").get(0));
        }
        if (this.cache.containsKey("HEIGHT")) {
            this.parseHeightLine(this.cache.get("HEIGHT").get(0));
        }
        if (this.cache.containsKey("WEIGHT")) {
            this.parseWeightLine(this.cache.get("WEIGHT").get(0));
        }
        if (this.cache.containsKey("AGE")) {
            this.parseAgeLine(this.cache.get("AGE").get(0));
        }
        if (this.cache.containsKey("GENDER")) {
            this.parseGenderLine(this.cache.get("GENDER").get(0));
        }
        if (this.cache.containsKey("HANDED")) {
            this.parseHandedLine(this.cache.get("HANDED").get(0));
        }
        if (this.cache.containsKey("SKINCOLOR")) {
            this.parseSkinColorLine(this.cache.get("SKINCOLOR").get(0));
        }
        if (this.cache.containsKey("EYECOLOR")) {
            this.parseEyeColorLine(this.cache.get("EYECOLOR").get(0));
        }
        if (this.cache.containsKey("HAIRCOLOR")) {
            this.parseHairColorLine(this.cache.get("HAIRCOLOR").get(0));
        }
        if (this.cache.containsKey("HAIRSTYLE")) {
            this.parseHairStyleLine(this.cache.get("HAIRSTYLE").get(0));
        }
        if (this.cache.containsKey("LOCATION")) {
            this.parseLocationLine(this.cache.get("LOCATION").get(0));
        }
        if (this.cache.containsKey("RESIDENCE")) {
            this.parseResidenceLine(this.cache.get("RESIDENCE").get(0));
        }
        if (this.cache.containsKey("CITY")) {
            this.parseCityLine(this.cache.get("CITY").get(0));
        }
        if (this.cache.containsKey("BIRTHDAY")) {
            this.parseBirthdayLine(this.cache.get("BIRTHDAY").get(0));
        }
        if (this.cache.containsKey("BIRTHPLACE")) {
            this.parseBirthplaceLine(this.cache.get("BIRTHPLACE").get(0));
        }
        if (this.cache.containsKey("PERSONALITYTRAIT1")) {
            for (String line : this.cache.get("PERSONALITYTRAIT1")) {
                this.parsePersonalityTrait1Line(line);
            }
        }
        if (this.cache.containsKey("PERSONALITYTRAIT2")) {
            for (String line : this.cache.get("PERSONALITYTRAIT2")) {
                this.parsePersonalityTrait2Line(line);
            }
        }
        if (this.cache.containsKey("SPEECHPATTERN")) {
            this.parseSpeechPatternLine(this.cache.get("SPEECHPATTERN").get(0));
        }
        if (this.cache.containsKey("PHOBIAS")) {
            this.parsePhobiasLine(this.cache.get("PHOBIAS").get(0));
        }
        if (this.cache.containsKey("INTERESTS")) {
            this.parseInterestsLine(this.cache.get("INTERESTS").get(0));
        }
        if (this.cache.containsKey("CATCHPHRASE")) {
            this.parseCatchPhraseLine(this.cache.get("CATCHPHRASE").get(0));
        }
        if (this.cache.containsKey("PORTRAIT")) {
            this.parsePortraitLine(this.cache.get("PORTRAIT").get(0));
        }
        if (this.cache.containsKey("PORTRAITTHUMBNAILRECT")) {
            this.parsePortraitThumbnailRectLine(this.cache.get("PORTRAITTHUMBNAILRECT").get(0));
        }
        if (this.cache.containsKey("WEAPONPROF")) {
            for (String line : this.cache.get("WEAPONPROF")) {
                this.parseWeaponProficienciesLine(line);
            }
        }
        if (this.cache.containsKey("TEMPBONUS")) {
            for (String line : this.cache.get("TEMPBONUS")) {
                this.parseTempBonusLine(line);
            }
        }
        if (this.cache.containsKey("EQSETBONUS")) {
            for (String line : this.cache.get("EQSETBONUS")) {
                this.parseEquipSetTempBonusLine(line);
            }
        }
        if (this.cache.containsKey("AGESET")) {
            for (String line : this.cache.get("AGESET")) {
                this.parseAgeSet(line);
            }
        }
        if (this.cache.containsKey("CHRONICLEENTRY")) {
            for (String line : this.cache.get("CHRONICLEENTRY")) {
                this.parseChronicleEntryLine(line);
            }
        }
        if (this.cache.containsKey("SUPPRESSBIOFIELDS")) {
            for (String line : this.cache.get("SUPPRESSBIOFIELDS")) {
                this.parseSupressBioFieldsLine(line);
            }
        }
    }

    private void checkDisplayListsHappy() throws PCGParseException {
        if (!Globals.displayListsHappy()) {
            throw new PCGParseException("parseCampaignLines", "N/A", LanguageBundle.getString("Exceptions.PCGenParser.NoCampaignInfo"));
        }
    }

    private List<Campaign> getCampaignList(List<String> lines, String gameModeName) throws PCGParseException {
        ArrayList<Campaign> campaigns = new ArrayList<Campaign>();
        for (String line : lines) {
            PCGTokenizer tokens;
            try {
                tokens = new PCGTokenizer(line);
            }
            catch (PCGParseException pcgpex) {
                throw new PCGParseException("parseCampaignLines", line, pcgpex.getMessage());
            }
            for (PCGElement element : tokens.getElements()) {
                String sourceKey = SourceMigration.getNewSourceKey(element.getText(), this.pcgenVersion, gameModeName);
                Campaign aCampaign = Globals.getCampaignKeyed(sourceKey);
                if (aCampaign == null) continue;
                campaigns.add(aCampaign);
            }
        }
        return campaigns;
    }

    private void parseCatchPhraseLine(String line) {
        this.thePC.setCatchPhrase(EntityEncoder.decode(line.substring("CATCHPHRASE".length() + 1)));
    }

    private void parseCharacterAssetLine(String line) {
        this.thePC.setStringFor(PCStringKey.ASSETS, EntityEncoder.decode(line.substring("CHARACTERASSET".length() + 1)));
    }

    private void parseCharacterCompLine(String line) {
        this.thePC.setStringFor(PCStringKey.COMPANIONS, EntityEncoder.decode(line.substring("CHARACTERCOMP".length() + 1)));
    }

    private void parseCharacterDescLine(String line) {
        this.thePC.setDescription(EntityEncoder.decode(line.substring("CHARACTERDESC".length() + 1)));
    }

    private void parseCharacterMagicLine(String line) {
        this.thePC.setStringFor(PCStringKey.MAGIC, EntityEncoder.decode(line.substring("CHARACTERMAGIC".length() + 1)));
    }

    private void parseCharacterDmNotesLine(String line) {
        this.thePC.setStringFor(PCStringKey.GMNOTES, EntityEncoder.decode(line.substring("CHARACTERDMNOTES".length() + 1)));
    }

    private void parseCharacterNameLine(String line) {
        this.thePC.setName(EntityEncoder.decode(line.substring("CHARACTERNAME".length() + 1)));
    }

    private void parseCityLine(String line) {
        this.thePC.setResidence(EntityEncoder.decode(line.substring("CITY".length() + 1)));
    }

    private void parseClassAbilitiesLevelLine(String line, List<PCLevelInfo> pcLevelInfoList) {
        PCGElement element;
        PCGTokenizer tokens;
        try {
            tokens = new PCGTokenizer(line);
        }
        catch (PCGParseException pcgpex) {
            String message = LanguageBundle.getFormattedString("Warnings.PCGenParser.IllegalClassAbility", line, pcgpex.getMessage());
            this.warnings.add(message);
            return;
        }
        int level = -1;
        PCClass aPCClass = null;
        PCLevelInfo pcl = null;
        Iterator it = tokens.getElements().iterator();
        if (it.hasNext()) {
            element = (PCGElement)it.next();
            int index = element.getText().indexOf(61);
            if (index < 0) {
                String message = LanguageBundle.getFormattedString("Warnings.PCGenParser.InvalidClassLevel", element.getText());
                this.warnings.add(message);
                return;
            }
            String classKeyName = EntityEncoder.decode(element.getText().substring(0, index));
            aPCClass = this.thePC.getClassKeyed(classKeyName);
            if (aPCClass == null) {
                String message = LanguageBundle.getFormattedString("Warnings.PCGenParser.ClassNotFound", classKeyName);
                this.warnings.add(message);
                return;
            }
            try {
                level = Integer.parseInt(element.getText().substring(index + 1));
            }
            catch (NumberFormatException nfe) {
                String message = LanguageBundle.getFormattedString("Warnings.PCGenParser.InvalidClassLevel", element.getText());
                this.warnings.add(message);
                return;
            }
            if (level < 1) {
                String message = LanguageBundle.getFormattedString("Warnings.PCGenParser.InvalidClassLevel", element.getText());
                this.warnings.add(message);
                return;
            }
            for (PCLevelInfo info : pcLevelInfoList) {
                if (!classKeyName.equalsIgnoreCase(info.getClassKeyName()) || level != info.getClassLevel()) continue;
                pcl = info;
                break;
            }
            if (pcl == null) {
                pcl = this.thePC.addLevelInfo(classKeyName);
                pcl.setClassLevel(level);
            } else {
                this.thePC.addLevelInfo(pcl);
            }
            pcl.setSkillPointsRemaining(0);
        }
        while (it.hasNext()) {
            element = (PCGElement)it.next();
            String tag = element.getName();
            if ("SUBSTITUTIONLEVEL".equals(tag)) {
                String substitutionClassKeyName = EntityEncoder.decode(element.getText());
                SubstitutionClass aSubstitutionClass = aPCClass.getSubstitutionClassKeyed(substitutionClassKeyName);
                if (aSubstitutionClass == null) {
                    String message = LanguageBundle.getFormattedString("Warnings.PCGenParser.ClassNotFound", substitutionClassKeyName);
                    this.warnings.add(message);
                    return;
                }
                SubstitutionLevelSupport.applyLevelArrayModsToLevel(aSubstitutionClass, aPCClass, level, this.thePC);
                this.thePC.setSubstitutionClassName(this.thePC.getActiveClassLevel(aPCClass, level), substitutionClassKeyName);
                continue;
            }
            if ("HITPOINTS".equals(tag)) {
                try {
                    PCClassLevel classLevel = this.thePC.getActiveClassLevel(aPCClass, level - 1);
                    this.thePC.setHP(classLevel, Integer.valueOf(element.getText()));
                }
                catch (NumberFormatException nfe) {
                    String message = LanguageBundle.getFormattedString("Warnings.PCGenParser.InvalidHP", tag, element.getText());
                    this.warnings.add(message);
                }
                continue;
            }
            if ("SAVES".equals(tag)) {
                for (PCGElement child : element.getChildren()) {
                    CDOMObject target;
                    String bonusString;
                    block40: {
                        int pipeLoc;
                        String dString = EntityEncoder.decode(child.getText());
                        if (!dString.startsWith("BONUS|") || (pipeLoc = (bonusString = dString.substring(6)).indexOf(124)) == -1) continue;
                        target = aPCClass;
                        String potentialInt = bonusString.substring(0, pipeLoc);
                        try {
                            int bonusLevel = Integer.parseInt(potentialInt);
                            if (bonusLevel > 0) {
                                target = this.thePC.getActiveClassLevel(aPCClass, bonusLevel);
                            }
                            bonusString = bonusString.substring(pipeLoc + 1);
                        }
                        catch (NumberFormatException e) {
                            if (level <= 0) break block40;
                            target = this.thePC.getActiveClassLevel(aPCClass, level);
                        }
                    }
                    BonusAddition.applyBonus(bonusString, "", this.thePC, target);
                }
                continue;
            }
            if ("SPECIALTIES".equals(tag)) {
                for (PCGElement child : element.getChildren()) {
                    this.thePC.setAssoc(aPCClass, AssociationKey.SPECIALTY, EntityEncoder.decode(child.getText()));
                }
                continue;
            }
            if ("SPECIALABILITIES".equals(tag)) {
                for (PCGElement child : element.getChildren()) {
                    String specialAbilityName = EntityEncoder.decode(child.getText());
                    if (this.pcgenVersion[0] <= 5 && this.pcgenVersion[1] <= 5 && this.pcgenVersion[2] < 6) {
                        if (specialAbilityName.equals("Turn Undead")) {
                            this.parseFeatLine("FEAT:Turn Undead|TYPE:SPECIAL.TURNUNDEAD|DESC:");
                            continue;
                        }
                        if (specialAbilityName.equals("Rebuke Undead")) {
                            this.parseFeatLine("FEAT:Rebuke Undead|TYPE:SPECIAL.TURNUNDEAD|DESC:");
                            continue;
                        }
                    }
                    SpecialAbility specialAbility = new SpecialAbility(specialAbilityName);
                    CDOMObject target = aPCClass;
                    if (level > 0) {
                        target = this.thePC.getActiveClassLevel(aPCClass, level);
                    }
                    if (this.thePC.hasSpecialAbility(specialAbilityName)) continue;
                    this.thePC.addUserSpecialAbility(specialAbility, target);
                }
                continue;
            }
            if (tag.equals("ABILITY")) {
                this.parseLevelAbilityInfo(element, aPCClass, level);
                continue;
            }
            if (tag.equals("ADD")) {
                this.parseAddTokenInfo(element, this.thePC.getActiveClassLevel(aPCClass, level));
                continue;
            }
            if (tag.equals("PRESTAT") || tag.equals("POSTSTAT")) {
                int idx;
                boolean isPre = false;
                if (tag.equals("PRESTAT")) {
                    isPre = true;
                }
                if ((idx = element.getText().indexOf(61)) > 0) {
                    String statAbb = element.getText().substring(0, idx);
                    PCStat pcstat = Globals.getContext().getReferenceContext().silentlyGetConstructedCDOMObject(PCStat.class, statAbb);
                    if (pcstat != null) {
                        try {
                            this.thePC.saveStatIncrease(pcstat, Integer.parseInt(element.getText().substring(idx + 1)), isPre);
                        }
                        catch (NumberFormatException nfe) {
                            String msg = LanguageBundle.getFormattedString("Warnings.PCGenParser.InvalidStatMod", tag, element.getText());
                            this.warnings.add(msg);
                        }
                        continue;
                    }
                    String msg = LanguageBundle.getFormattedString("Warnings.PCGenParser.UnknownStat", tag, element.getText());
                    this.warnings.add(msg);
                    continue;
                }
                String msg = LanguageBundle.getFormattedString("Warnings.PCGenParser.MissingEquals", tag, element.getText());
                this.warnings.add(msg);
                continue;
            }
            if (pcl != null && "SKILLSGAINED".equals(tag)) {
                pcl.setFixedSkillPointsGained(Integer.parseInt(element.getText()));
                continue;
            }
            if (pcl != null && "SKILLSREMAINING".equals(tag)) {
                pcl.setSkillPointsRemaining(Integer.parseInt(element.getText()));
                continue;
            }
            if ("DATA".equals(tag)) continue;
            String msg = LanguageBundle.getFormattedString("Warnings.PCGenParser.UnknownTag", tag, element.getText());
            this.warnings.add(msg);
        }
    }

    private void parseAddTokenInfo(PCGElement element, CDOMObject cdo) {
        Iterator<PCGElement> it2 = element.getChildren().iterator();
        if (!it2.hasNext()) {
            this.warnings.add(cdo.getDisplayName() + "(" + cdo.getClass().getName() + ")\nInvalid save structure in ADD:");
            return;
        }
        PCGElement addType = it2.next();
        String name = addType.getName();
        String dString = EntityEncoder.decode(addType.getText());
        List<PersistentTransitionChoice<?>> addList = cdo.getListFor(ListKey.ADD);
        if (addList == null) {
            this.warnings.add(cdo.getDisplayName() + "(" + cdo.getClass().getName() + ")\nCould not find any ADD: " + name + "|" + dString);
            return;
        }
        boolean found = false;
        for (PersistentTransitionChoice<?> tc : addList) {
            found |= this.processTransitionChoice(cdo, it2, name, dString, tc);
        }
        if (!found) {
            this.warnings.add(cdo.getDisplayName() + "(" + cdo.getClass().getName() + ")\nCould not find matching ADD: " + name + "|" + dString);
        }
    }

    private <T> boolean processTransitionChoice(CDOMObject cdo, Iterator<PCGElement> it2, String name, String dString, PersistentTransitionChoice<T> tc) {
        SelectableSet choices = tc.getChoices();
        if (dString.equals(choices.getLSTformat())) {
            while (it2.hasNext()) {
                String choice = EntityEncoder.decode(it2.next().getText());
                Object obj = tc.decodeChoice(Globals.getContext(), choice);
                if (obj == null) {
                    this.warnings.add(cdo.getDisplayName() + "(" + cdo.getClass().getName() + ")\nCould not decode " + choice + " for ADD: " + name + "|" + dString);
                    continue;
                }
                tc.restoreChoice(this.thePC, cdo, tc.castChoice(obj));
            }
            return true;
        }
        return false;
    }

    private void parseClassLine(String line) throws PCGParseException {
        String tag;
        PCGElement element;
        String classKey;
        PCGTokenizer tokens;
        try {
            tokens = new PCGTokenizer(line);
        }
        catch (PCGParseException pcgpex) {
            throw new PCGParseException("parseClassLine", line, pcgpex.getMessage());
        }
        PCClass aPCClass = null;
        Iterator it = tokens.getElements().iterator();
        if (it.hasNext() && (aPCClass = this.thePC.getClassKeyed(classKey = EntityEncoder.decode((element = (PCGElement)it.next()).getText()))) == null) {
            aPCClass = Globals.getContext().getReferenceContext().silentlyGetConstructedCDOMObject(PCClass.class, classKey);
            if (aPCClass != null) {
                aPCClass = aPCClass.clone();
            } else {
                String msg = LanguageBundle.getFormattedString("Warnings.PCGenParser.CouldntAddClass", element.getText());
                this.warnings.add(msg);
                return;
            }
        }
        int level = -1;
        int skillPool = -1;
        String subClassKey = "None";
        while (it.hasNext()) {
            String msg;
            SubClass sc;
            element = (PCGElement)it.next();
            tag = element.getName();
            if ("SUBCLASS".equals(tag) && (subClassKey = EntityEncoder.decode(element.getText())).length() > 0 && !subClassKey.equals("None") && (sc = aPCClass.getSubClassKeyed(subClassKey)) == null) {
                if (subClassKey.equals(aPCClass.getKeyName())) {
                    subClassKey = "None";
                } else {
                    msg = LanguageBundle.getFormattedString("Warnings.PCGenParser.InvalidSubclass", element.getText());
                    this.warnings.add(msg);
                }
            }
            if ("LEVEL".equals(tag)) {
                try {
                    level = Integer.parseInt(element.getText());
                }
                catch (NumberFormatException nfe) {
                    msg = LanguageBundle.getFormattedString("Warnings.PCGenParser.InvalidLevel", element.getText());
                    this.warnings.add(msg);
                }
                continue;
            }
            if ("SKILLPOOL".equals(tag)) {
                try {
                    skillPool = Integer.parseInt(element.getText());
                }
                catch (NumberFormatException nfe) {
                    msg = LanguageBundle.getFormattedString("Warnings.PCGenParser.InvalidSkillPool", element.getText());
                    this.warnings.add(msg);
                }
                continue;
            }
            if ("CANCASTPERDAY".equals(tag)) continue;
            if ("SPELLBASE".equals(tag)) {
                String spellBase = EntityEncoder.decode(element.getText());
                if ("None".equals(spellBase)) continue;
                Globals.getContext().unconditionallyProcess(aPCClass, "SPELLSTAT", spellBase);
                continue;
            }
            if (!"PROHIBITED".equals(tag)) continue;
            String prohib = EntityEncoder.decode(element.getText());
            StringTokenizer st = new StringTokenizer(prohib, ",");
            while (st.hasMoreTokens()) {
                String choice = st.nextToken();
                if ("None".equalsIgnoreCase(choice)) continue;
                SpellProhibitor prohibSchool = new SpellProhibitor();
                prohibSchool.setType(ProhibitedSpellType.SCHOOL);
                prohibSchool.addValue(choice);
                SpellProhibitor prohibSubSchool = new SpellProhibitor();
                prohibSubSchool.setType(ProhibitedSpellType.SUBSCHOOL);
                prohibSubSchool.addValue(choice);
                this.thePC.addProhibitedSchool(prohibSchool, aPCClass);
                this.thePC.addProhibitedSchool(prohibSubSchool, aPCClass);
            }
        }
        if (level > -1) {
            this.thePC.addClass(aPCClass);
            if (StringUtils.isNotBlank(subClassKey) && !subClassKey.equals("None")) {
                SubClassApplication.setSubClassKey(this.thePC, aPCClass, subClassKey);
            }
            for (int i = 0; i < level; ++i) {
                PCLevelInfo levelInfo = this.thePC.addLevelInfo(aPCClass.getKeyName());
                aPCClass.addLevel(false, false, this.thePC, true);
            }
        }
        for (PCGElement e : new PCGTokenizer(line).getElements()) {
            tag = e.getName();
            if (!tag.equals("ADD")) continue;
            this.parseAddTokenInfo(e, aPCClass);
        }
        if (skillPool > -1) {
            this.thePC.setSkillPool(aPCClass, skillPool);
        }
    }

    private void parseDeityLine(String line) {
        PCGTokenizer tokens;
        try {
            tokens = new PCGTokenizer(line);
        }
        catch (PCGParseException pcgpex) {
            String msg = LanguageBundle.getFormattedString("Warnings.PCGenParser.IllegalDeity", line, pcgpex.getMessage());
            this.warnings.add(msg);
            return;
        }
        String deityKey = EntityEncoder.decode(((PCGElement)tokens.getElements().get(0)).getText());
        Deity aDeity = Globals.getContext().getReferenceContext().silentlyGetConstructedCDOMObject(Deity.class, deityKey);
        if (aDeity != null) {
            this.thePC.setDeity(aDeity);
        } else if (!"None".equals(deityKey)) {
            String msg = LanguageBundle.getFormattedString("Warnings.PCGenParser.DeityNotFound", deityKey);
            this.warnings.add(msg);
        }
    }

    private void parseDomainLine(String line) {
        PCGTokenizer tokens;
        try {
            tokens = new PCGTokenizer(line);
        }
        catch (PCGParseException pcgpex) {
            String msg = LanguageBundle.getFormattedString("Warnings.PCGenParser.IllegalDomain", line, pcgpex.getMessage());
            this.warnings.add(msg);
            return;
        }
        Iterator it = tokens.getElements().iterator();
        if (it.hasNext()) {
            PCGElement element = (PCGElement)it.next();
            String domainKey = EntityEncoder.decode(element.getText());
            Domain aDomain = Globals.getContext().getReferenceContext().silentlyGetConstructedCDOMObject(Domain.class, domainKey);
            if (aDomain == null && !"None".equals(domainKey)) {
                String msg = LanguageBundle.getFormattedString("Warnings.PCGenParser.DomainNotFound", domainKey);
                this.warnings.add(msg);
            } else if (!this.thePC.hasDomain(aDomain) && !"None".equals(domainKey)) {
                String msg;
                ClassSource source = null;
                String fullassoc = null;
                while (it.hasNext()) {
                    element = (PCGElement)it.next();
                    String tag = element.getName();
                    if ("SOURCE".equals(tag)) {
                        source = this.getDomainSource(PCGVer2Parser.sourceElementToString(element));
                        continue;
                    }
                    if ("ASSOCIATEDDATA".equals(tag)) {
                        if (fullassoc != null) {
                            this.warnings.add("Found multiple selections for Domain: " + aDomain.getKeyName());
                        }
                        fullassoc = EntityEncoder.decode(element.getText());
                        continue;
                    }
                    if (tag.equals("DOMAINGRANTS") || tag.equals("ADD")) continue;
                    msg = LanguageBundle.getFormattedString("Warnings.PCGenParser.UnknownDomainInfo", tag + ":" + element.getText());
                    this.warnings.add(msg);
                }
                if (source == null) {
                    this.warnings.add("Domain not added due to no source: " + domainKey);
                } else {
                    this.domainInputFacet.importSelection(this.thePC.getCharID(), aDomain, fullassoc, source);
                    DomainApplication.applyDomain(this.thePC, aDomain);
                }
                try {
                    for (PCGElement e : new PCGTokenizer(line).getElements()) {
                        String tag = e.getName();
                        if (!tag.equals("ADD")) continue;
                        this.parseAddTokenInfo(e, aDomain);
                    }
                }
                catch (PCGParseException pcgpex) {
                    msg = LanguageBundle.getFormattedString("Warnings.PCGenParser.IllegalDomain", line, pcgpex.getMessage());
                    this.warnings.add(msg);
                    return;
                }
            } else {
                Logging.errorPrintLocalised("Errors.PCGenParser.DuplicateDomain", domainKey);
            }
        }
    }

    private void parseEquipSetTempBonusLine(String line) {
        String tag;
        PCGTokenizer tokens;
        try {
            tokens = new PCGTokenizer(line);
        }
        catch (PCGParseException pcgpex) {
            String msg = LanguageBundle.getFormattedString("Warnings.PCGenParser.IllegalEquipSetTempBonus", line, pcgpex.getMessage());
            this.warnings.add(msg);
            return;
        }
        String tagString = null;
        for (PCGElement element : tokens.getElements()) {
            tag = element.getName();
            if (!"EQSETBONUS".equals(tag)) continue;
            tagString = EntityEncoder.decode(element.getText());
        }
        if (tagString == null) {
            String msg = LanguageBundle.getFormattedString("Warnings.PCGenParser.InvalidEquipSetTempBonus", line);
            this.warnings.add(msg);
            return;
        }
        EquipSet eSet = this.thePC.getEquipSetByIdPath(tagString);
        if (eSet == null) {
            return;
        }
        IdentityHashMap<BonusObj, BonusManager.TempBonusInfo> aList = new IdentityHashMap<BonusObj, BonusManager.TempBonusInfo>();
        for (PCGElement element : tokens.getElements()) {
            String aString;
            StringTokenizer aTok;
            tag = element.getName();
            if (!"TBBONUS".equals(tag) || (aTok = new StringTokenizer(aString = EntityEncoder.decode(element.getText()), "|")).countTokens() < 2) continue;
            String sName = aTok.nextToken();
            String tName = aTok.nextToken();
            aList.putAll(this.getBonusFromName(sName, tName));
        }
        eSet.setTempBonusList(aList);
    }

    private void parseCharacterTypeLine(String line) throws PCGParseException {
        StringTokenizer stok = new StringTokenizer(line.substring("CHARACTERTYPE".length() + 1), ":", false);
        String characterType = stok.nextToken();
        if (!SettingsHandler.getGame().getCharacterTypeList().contains(characterType)) {
            String wantedType = characterType;
            characterType = SettingsHandler.getGame().getDefaultCharacterType();
            String message = "Character type " + wantedType + " not found. Using " + characterType;
            this.warnings.add(message);
        }
        this.thePC.setCharacterType(characterType);
    }

    private void parsePreviewSheetLine(String line) throws PCGParseException {
        StringTokenizer stok = new StringTokenizer(line.substring("PREVIEWSHEET".length() + 1), ":", false);
        this.thePC.setPreviewSheet(stok.nextToken());
    }

    private void parseExperienceLine(String line) throws PCGParseException {
        StringTokenizer stok = new StringTokenizer(line.substring("EXPERIENCE".length() + 1), ":", false);
        try {
            this.thePC.setXP(Integer.parseInt(stok.nextToken()));
        }
        catch (NumberFormatException nfe) {
            throw new PCGParseException("parseExperienceLine", line, nfe.getMessage());
        }
    }

    private void parseExperienceTableLine(String line) throws PCGParseException {
        StringTokenizer stok = new StringTokenizer(line.substring("EXPERIENCETABLE".length() + 1), ":", false);
        String xpTableName = stok.nextToken();
        if (!SettingsHandler.getGame().getXPTableNames().contains(xpTableName)) {
            String wantedName = xpTableName;
            xpTableName = SettingsHandler.getGame().getDefaultXPTableName();
            String message = "XP table " + wantedName + " not found. Using " + xpTableName;
            this.warnings.add(message);
        }
        this.thePC.setXPTable(xpTableName);
    }

    private void parseEyeColorLine(String line) {
        this.thePC.setEyeColor(EntityEncoder.decode(line.substring("EYECOLOR".length() + 1)));
    }

    private void parseAbilityLine(String line) {
        PCGElement element;
        PCGElement element2;
        PCGTokenizer tokens;
        try {
            tokens = new PCGTokenizer(line);
        }
        catch (PCGParseException pcgpex) {
            String msg = LanguageBundle.getFormattedString("Warnings.PCGenParser.IllegalAbility", line, pcgpex.getMessage());
            this.warnings.add(msg);
            return;
        }
        AbilityCategory category = null;
        Nature nature = Nature.NORMAL;
        String abilityCat = null;
        CDOMObject ability = null;
        String abilityKey = "";
        String missingCat = null;
        Iterator it = tokens.getElements().iterator();
        if (it.hasNext()) {
            element2 = (PCGElement)it.next();
            String categoryKey = EntityEncoder.decode(element2.getText());
            category = SettingsHandler.getGame().getAbilityCategory(categoryKey);
            if (category == null) {
                missingCat = categoryKey;
            }
        }
        if (it.hasNext()) {
            element2 = (PCGElement)it.next();
            String natureKey = EntityEncoder.decode(element2.getText());
            nature = Nature.valueOf(natureKey);
        }
        AbilityCategory innateCategory = null;
        if (it.hasNext()) {
            element = (PCGElement)it.next();
            abilityCat = EntityEncoder.decode(element.getText());
        }
        if (it.hasNext()) {
            element = (PCGElement)it.next();
            abilityKey = EntityEncoder.decode(element.getText());
            AbilityMigration.CategorisedKey categorisedKey = AbilityMigration.getNewAbilityKey(abilityCat, abilityKey, this.pcgenVersion, SettingsHandler.getGame().getName());
            abilityCat = categorisedKey.getCategory();
            abilityKey = categorisedKey.getKey();
            innateCategory = SettingsHandler.getGame().getAbilityCategory(abilityCat);
            if (innateCategory == null) {
                missingCat = abilityCat;
            }
            if (innateCategory == null || category == null) {
                String msg = LanguageBundle.getFormattedString("Warnings.PCGenParser.AbilityCategoryNotFound", abilityKey, missingCat);
                this.warnings.add(msg);
                return;
            }
            ability = Globals.getContext().getReferenceContext().silentlyGetConstructedCDOMObject(Ability.class, innateCategory, abilityKey);
            if (ability == null) {
                this.warnings.add("Unable to Find Ability: " + abilityKey);
                return;
            }
        }
        ArrayList<String> associations = new ArrayList<String>();
        ArrayList<BonusObj> bonuses = new ArrayList<BonusObj>();
        while (it.hasNext()) {
            PCGElement element3 = (PCGElement)it.next();
            String tag = element3.getName();
            if (tag.equals("APPLIEDTO")) {
                associations.add(EntityEncoder.decode(element3.getText()));
                continue;
            }
            if (!"SAVE".equals(tag)) continue;
            String saveKey = EntityEncoder.decode(element3.getText());
            if (saveKey.startsWith("BONUS") && saveKey.length() > 6) {
                BonusObj aBonus = Bonus.newBonus(Globals.getContext(), saveKey.substring(6));
                if (aBonus == null) continue;
                bonuses.add(aBonus);
                continue;
            }
            if (!Logging.isDebugMode()) continue;
            Logging.debugPrint("Ignoring SAVE:" + saveKey);
        }
        if (ability != null && category != null && nature != null) {
            CNAbility cna = null;
            boolean needError = true;
            if (nature == Nature.NORMAL) {
                if (!this.featsPresent || category != AbilityCategory.FEAT) {
                    try {
                        cna = CNAbilityFactory.getCNAbility(category, nature, ability);
                    }
                    catch (IllegalArgumentException e) {
                        Logging.log(Logging.INFO, "Unabe to parse ability line: " + e.getMessage());
                    }
                } else {
                    needError = false;
                }
            } else if (nature == Nature.VIRTUAL) {
                cna = CNAbilityFactory.getCNAbility(category, nature, ability);
            }
            if (cna == null) {
                if (needError) {
                    this.warnings.add("Unable to build Ability: " + ability);
                }
            } else {
                if (ability.getSafe(ObjectKey.MULTIPLE_ALLOWED).booleanValue()) {
                    for (String appliedToKey : associations) {
                        String[] assoc;
                        for (String string : assoc = appliedToKey.split(",", -1)) {
                            CNAbilitySelection cnas = new CNAbilitySelection(cna, string);
                            try {
                                if (nature == Nature.VIRTUAL) {
                                    this.thePC.addSavedAbility(cnas, UserSelection.getInstance(), UserSelection.getInstance());
                                    continue;
                                }
                                this.thePC.addAbility(cnas, UserSelection.getInstance(), UserSelection.getInstance());
                            }
                            catch (IllegalArgumentException e) {
                                Logging.errorPrint("PCGVer2Parser.parseAbilityLine failed", e);
                                this.warnings.add(cna + " with selection: " + string + " is no longer valid.");
                            }
                        }
                    }
                } else {
                    if (associations != null && !associations.isEmpty()) {
                        this.warnings.add(cna + " found with selections: " + associations + " but is MULT:NO in the data");
                    }
                    CNAbilitySelection cnas = new CNAbilitySelection(cna);
                    if (nature == Nature.VIRTUAL) {
                        this.thePC.addSavedAbility(cnas, UserSelection.getInstance(), UserSelection.getInstance());
                    } else {
                        this.thePC.addAbility(cnas, UserSelection.getInstance(), UserSelection.getInstance());
                    }
                }
                for (BonusObj b : bonuses) {
                    this.thePC.addSaveableBonus(b, cna.getAbility());
                }
            }
        }
    }

    private void parseFeatLine(String line) {
        PCGTokenizer tokens;
        try {
            tokens = new PCGTokenizer(line);
        }
        catch (PCGParseException pcgpex) {
            String msg = LanguageBundle.getFormattedString("Warnings.PCGenParser.IllegalFeat", line, pcgpex.getMessage());
            this.warnings.add(msg);
            return;
        }
        Iterator<PCGElement> it = tokens.getElements().iterator();
        if (it.hasNext()) {
            PCGElement element = (PCGElement)it.next();
            String abilityKey = EntityEncoder.decode(element.getText());
            Ability anAbility = Globals.getContext().getReferenceContext().silentlyGetConstructedCDOMObject(Ability.class, AbilityCategory.FEAT, abilityKey);
            if (anAbility == null) {
                String msg = LanguageBundle.getFormattedString("Warnings.PCGenParser.CouldntAddAbility", abilityKey);
                this.warnings.add(msg);
                return;
            }
            CNAbility pcAbility = CNAbilityFactory.getCNAbility(AbilityCategory.FEAT, Nature.NORMAL, anAbility);
            if (!anAbility.getSafe(ObjectKey.MULTIPLE_ALLOWED).booleanValue()) {
                this.thePC.addAbility(new CNAbilitySelection(pcAbility), UserSelection.getInstance(), UserSelection.getInstance());
            }
            this.parseFeatsHandleAppliedToAndSaveTags(it, pcAbility);
            this.featsPresent = true;
        }
    }

    private void parseFeatPoolLine(String line) {
        try {
            double featPool = Double.parseDouble(line.substring("FEATPOOL".length() + 1));
            if (this.compareVersionTo(new int[]{5, 11, 1}) < 0) {
                this.calcFeatPoolAfterLoad = true;
                this.baseFeatPool = featPool;
            } else {
                this.thePC.setUserPoolBonus(AbilityCategory.FEAT, new BigDecimal(featPool));
            }
        }
        catch (NumberFormatException nfe) {
            String msg = LanguageBundle.getFormattedString("Warnings.PCGenParser.IllegalFeatPool", line);
            this.warnings.add(msg);
        }
    }

    private void parseUserPoolLine(String line) {
        PCGTokenizer tokens;
        try {
            tokens = new PCGTokenizer(line);
        }
        catch (PCGParseException pcgpex) {
            String msg = LanguageBundle.getFormattedString("Warnings.PCGenParser.IllegalAbilityPool", line, pcgpex.getMessage());
            this.warnings.add(msg);
            return;
        }
        Iterator it = tokens.getElements().iterator();
        String cat = EntityEncoder.decode(((PCGElement)it.next()).getText());
        AbilityCategory category = SettingsHandler.getGame().getAbilityCategory(cat);
        try {
            this.thePC.setUserPoolBonus(category, new BigDecimal(((PCGElement)it.next()).getText()));
        }
        catch (NumberFormatException nfe) {
            String msg = LanguageBundle.getFormattedString("Warnings.PCGenParser.IllegalAbilityPool", line);
            this.warnings.add(msg);
        }
    }

    private void parseFeatsHandleAppliedToAndSaveTags(Iterator<PCGElement> it, CNAbility cna) {
        Ability aFeat = cna.getAbility();
        while (it.hasNext()) {
            PCGElement element = it.next();
            String tag = element.getName();
            if ("APPLIEDTO".equals(tag)) {
                String[] assoc;
                String appliedToKey = EntityEncoder.decode(element.getText());
                if (!aFeat.getSafe(ObjectKey.MULTIPLE_ALLOWED).booleanValue()) continue;
                for (String string : assoc = appliedToKey.split(",", -1)) {
                    CNAbilitySelection cnas = new CNAbilitySelection(cna, string);
                    if (cna.getNature() == Nature.VIRTUAL) {
                        this.thePC.addSavedAbility(cnas, UserSelection.getInstance(), UserSelection.getInstance());
                        continue;
                    }
                    this.thePC.addAbility(cnas, UserSelection.getInstance(), UserSelection.getInstance());
                }
                continue;
            }
            if ("SAVE".equals(tag)) {
                String saveKey = EntityEncoder.decode(element.getText());
                if (saveKey.startsWith("BONUS") && saveKey.length() > 6) {
                    BonusObj aBonus = Bonus.newBonus(Globals.getContext(), saveKey.substring(6));
                    if (aBonus == null) continue;
                    this.thePC.addSaveableBonus(aBonus, aFeat);
                    continue;
                }
                if (!Logging.isDebugMode()) continue;
                Logging.debugPrint("Ignoring SAVE:" + saveKey);
                continue;
            }
            if (tag.equals("ABILITY")) {
                this.parseLevelAbilityInfo(element, aFeat);
                continue;
            }
            if (!tag.equals("ADD")) continue;
            this.parseAddTokenInfo(element, aFeat);
        }
    }

    private void parseFollowerLine(String line) {
        PCGTokenizer tokens;
        try {
            tokens = new PCGTokenizer(line);
        }
        catch (PCGParseException pcgpex) {
            String msg = LanguageBundle.getFormattedString("Warnings.PCGenParser.IllegalFollower", line, pcgpex.getMessage());
            this.warnings.add(msg);
            return;
        }
        Follower aFollower = new Follower("", "", null);
        for (PCGElement element : tokens.getElements()) {
            String tag = element.getName();
            if ("FOLLOWER".equals(tag)) {
                aFollower.setName(EntityEncoder.decode(element.getText()));
                continue;
            }
            if ("TYPE".equals(tag)) {
                String cType = EntityEncoder.decode(element.getText());
                CompanionList cList = Globals.getContext().getReferenceContext().silentlyGetConstructedCDOMObject(CompanionList.class, cType);
                if (cList == null) {
                    Logging.errorPrint("Cannot find CompanionList: " + cType);
                    continue;
                }
                aFollower.setType(cList);
                continue;
            }
            if ("RACE".equals(tag)) {
                String raceText = EntityEncoder.decode(element.getText());
                Race r = Globals.getContext().getReferenceContext().silentlyGetConstructedCDOMObject(Race.class, raceText);
                if (r == null) {
                    Logging.errorPrint("Cannot find Race: " + raceText);
                    continue;
                }
                aFollower.setRace(r);
                continue;
            }
            if ("HITDICE".equals(tag)) {
                try {
                    aFollower.setUsedHD(Integer.parseInt(element.getText()));
                }
                catch (NumberFormatException nfe) {}
                continue;
            }
            if (!"FILE".equals(tag)) continue;
            String inputFileName = EntityEncoder.decode(element.getText());
            String masterFileName = this.makeFilenameAbsolute(inputFileName);
            if (masterFileName == null) {
                String msg = LanguageBundle.getFormattedString("Warnings.PCGenParser.CantFindFollower", inputFileName);
                this.warnings.add(msg);
                continue;
            }
            aFollower.setFileName(masterFileName);
        }
        if (!("".equals(aFollower.getFileName()) || "".equals(aFollower.getName()) || aFollower.getType() == null || "".equals(aFollower.getType().toString()))) {
            this.thePC.addFollower(aFollower);
        }
    }

    private void parseGameMode(String line) throws PCGParseException {
        GameMode currentGameMode;
        String currentMode;
        String requestedMode = line.substring("GAMEMODE".length() + 1);
        if (!requestedMode.equals(currentMode = (currentGameMode = SettingsHandler.getGame()).getName())) {
            String msg = LanguageBundle.getFormattedString("Exceptions.PCGenParser.WrongGameMode", requestedMode, currentMode);
            throw new PCGParseException("ParseGameMode", line, msg);
        }
    }

    private void parseGenderLine(String line) {
        Gender gender;
        String genderString = EntityEncoder.decode(line.substring("GENDER".length() + 1));
        if ("M".equals(genderString)) {
            gender = Gender.Male;
        } else if ("F".equals(genderString)) {
            gender = Gender.Female;
        } else {
            try {
                gender = Gender.getGenderByName(genderString);
            }
            catch (IllegalArgumentException e) {
                gender = Gender.getDefaultValue();
                String msg = LanguageBundle.getFormattedString("Warnings.PCGenParser.IllegalGender", line);
                this.warnings.add(msg);
            }
        }
        this.thePC.setGender(gender);
    }

    private void parseHTMLOutputSheetLine(String line) {
        String aFileName = EntityEncoder.decode(line.substring("OUTPUTSHEETHTML".length() + 1));
        if (aFileName.length() <= 0) {
            aFileName = SettingsHandler.getSelectedCharacterHTMLOutputSheet(this.thePC);
        }
        this.thePC.setSelectedCharacterHTMLOutputSheet(aFileName);
    }

    private void parseHairColorLine(String line) {
        this.thePC.setHairColor(EntityEncoder.decode(line.substring("HAIRCOLOR".length() + 1)));
    }

    private void parseHairStyleLine(String line) {
        this.thePC.setHairStyle(EntityEncoder.decode(line.substring("HAIRSTYLE".length() + 1)));
    }

    private void parseHandedLine(String line) {
        Handed h;
        String handed = EntityEncoder.decode(line.substring("HANDED".length() + 1));
        try {
            h = Handed.getHandedByName(handed);
        }
        catch (IllegalArgumentException e) {
            h = Handed.getDefaultValue();
            String msg = LanguageBundle.getFormattedString("Warnings.PCGenParser.IllegalHandedness", line, h);
            this.warnings.add(msg);
        }
        this.thePC.setHanded(h);
    }

    private void parseHeightLine(String line) {
        try {
            this.thePC.setHeight(Integer.parseInt(line.substring("HEIGHT".length() + 1)));
        }
        catch (NumberFormatException nfe) {
            String msg = LanguageBundle.getFormattedString("Warnings.PCGenParser.IllegalHeight", line);
            this.warnings.add(msg);
        }
    }

    private void parseInterestsLine(String line) {
        this.thePC.setInterests(EntityEncoder.decode(line.substring("INTERESTS".length() + 1)));
    }

    private void parseKitLine(String line) {
        StringTokenizer stok = new StringTokenizer(line.substring("KIT".length() + 1), "|", false);
        if (stok.countTokens() != 2) {
            // empty if block
        }
        stok.nextToken();
        Kit aKit = Globals.getContext().getReferenceContext().silentlyGetConstructedCDOMObject(Kit.class, line.substring("KIT".length() + 1));
        if (aKit == null) {
            String msg = LanguageBundle.getFormattedString("Warnings.PCGenParser.KitNotFound", line);
            this.warnings.add(msg);
            return;
        }
        this.thePC.addKit(aKit);
    }

    private void parseLanguageLine(String line) {
        PCGTokenizer tokens;
        try {
            tokens = new PCGTokenizer(line);
        }
        catch (PCGParseException pcgpex) {
            String msg = LanguageBundle.getFormattedString("Warnings.PCGenParser.IllegalLanguage", line, pcgpex.getMessage());
            this.warnings.add(msg);
            return;
        }
        for (PCGElement element : tokens.getElements()) {
            Language aLang = Globals.getContext().getReferenceContext().silentlyGetConstructedCDOMObject(Language.class, EntityEncoder.decode(element.getText()));
            if (aLang == null) {
                String message = "No longer speaks language: " + element.getText();
                this.warnings.add(message);
                continue;
            }
            this.cachedLanguages.add(aLang);
        }
    }

    private void parseLoadCompanionLine(String line) {
        this.thePC.setLoadCompanion(line.endsWith("Y"));
    }

    private void parseLocationLine(String line) {
        this.thePC.setLocation(EntityEncoder.decode(line.substring("LOCATION".length() + 1)));
    }

    private void parseMasterLine(String line) {
        PCGTokenizer tokens;
        try {
            tokens = new PCGTokenizer(line);
        }
        catch (PCGParseException pcgpex) {
            String msg = LanguageBundle.getFormattedString("Warnings.PCGenParser.IllegalMaster", line, pcgpex.getMessage());
            this.warnings.add(msg);
            return;
        }
        Follower aMaster = new Follower("", "", null);
        for (PCGElement element : tokens.getElements()) {
            String tag = element.getName();
            if ("MASTER".equals(tag)) {
                aMaster.setName(EntityEncoder.decode(element.getText()));
                continue;
            }
            if ("TYPE".equals(tag)) {
                String cType = EntityEncoder.decode(element.getText());
                CompanionList cList = Globals.getContext().getReferenceContext().silentlyGetConstructedCDOMObject(CompanionList.class, cType);
                if (cList == null) {
                    Logging.errorPrint("Cannot find CompanionList: " + cType);
                    continue;
                }
                aMaster.setType(cList);
                continue;
            }
            if ("HITDICE".equals(tag)) {
                try {
                    aMaster.setUsedHD(Integer.parseInt(element.getText()));
                }
                catch (NumberFormatException nfe) {}
                continue;
            }
            if ("FILE".equals(tag)) {
                String inputFileName = EntityEncoder.decode(element.getText());
                String masterFileName = this.makeFilenameAbsolute(inputFileName);
                if (masterFileName == null) {
                    String msg = LanguageBundle.getFormattedString("Warnings.PCGenParser.CantFindMaster", inputFileName);
                    this.warnings.add(msg);
                    continue;
                }
                aMaster.setFileName(masterFileName);
                continue;
            }
            if (!"ADJUSTMENT".equals(tag)) continue;
            aMaster.setAdjustment(Integer.parseInt(element.getText()));
        }
        if (!("".equals(aMaster.getFileName()) || "".equals(aMaster.getName()) || "".equals(aMaster.getType().toString()))) {
            this.thePC.setMaster(aMaster);
        }
    }

    private String makeFilenameAbsolute(String inFileName) {
        File pcFile = new File(this.thePC.getFileName());
        File inFile = new File(pcFile.getParentFile(), inFileName);
        if (inFile.exists()) {
            return inFile.getAbsolutePath();
        }
        File pcgDir = new File(PCGenSettings.getPcgDir());
        inFile = new File(pcgDir, inFileName);
        if (inFile.exists()) {
            return inFile.getAbsolutePath();
        }
        inFile = new File(inFileName);
        if (inFile.exists()) {
            return inFile.getAbsolutePath();
        }
        return null;
    }

    private void parseNoteLine(String line) {
        PCGTokenizer tokens;
        try {
            tokens = new PCGTokenizer(line);
        }
        catch (PCGParseException pcgpex) {
            String msg = LanguageBundle.getFormattedString("Warnings.PCGenParser.IllegalNotes", line, pcgpex.getMessage());
            this.warnings.add(msg);
            return;
        }
        NoteItem ni = new NoteItem(-1, -1, "", "");
        for (PCGElement element : tokens.getElements()) {
            String tag = element.getName();
            if ("NOTE".equals(tag)) {
                ni.setName(EntityEncoder.decode(element.getText()));
                continue;
            }
            if ("ID".equals(tag)) {
                try {
                    ni.setIdValue(Integer.parseInt(element.getText()));
                    continue;
                }
                catch (NumberFormatException nfe) {
                    ni.setIdValue(-1);
                    String msg = LanguageBundle.getFormattedString("Warnings.PCGenParser.InvalidNotes", line);
                    this.warnings.add(msg);
                    break;
                }
            }
            if ("PARENTID".equals(tag)) {
                try {
                    ni.setParentId(Integer.parseInt(element.getText()));
                    continue;
                }
                catch (NumberFormatException nfe) {
                    ni.setIdValue(-1);
                    String msg = LanguageBundle.getFormattedString("Warnings.PCGenParser.InvalidNotes", line);
                    this.warnings.add(msg);
                    break;
                }
            }
            if (!"VALUE".equals(tag)) continue;
            ni.setValue(EntityEncoder.decode(element.getText()));
        }
        if (ni.getId() > -1) {
            this.thePC.addNotesItem(ni);
        }
    }

    private void parseChronicleEntryLine(String line) {
        PCGTokenizer tokens;
        try {
            tokens = new PCGTokenizer(line);
        }
        catch (PCGParseException pcgpex) {
            String msg = LanguageBundle.getFormattedString("Warnings.PCGenParser.IllegalChronicleEntry", line, pcgpex.getMessage());
            this.warnings.add(msg);
            return;
        }
        ChronicleEntry ce = new ChronicleEntry();
        for (PCGElement element : tokens.getElements()) {
            String tag = element.getName();
            if ("CHRONICLEENTRY".equals(tag)) {
                ce.setOutputEntry("Y".equals(element.getText()));
                continue;
            }
            if ("EXPERIENCE".equals(tag)) {
                try {
                    ce.setXpField(Integer.parseInt(element.getText()));
                    continue;
                }
                catch (NumberFormatException nfe) {
                    ce.setXpField(0);
                    String msg = LanguageBundle.getFormattedString("Warnings.PCGenParser.InvalidChronicleEntry", line);
                    this.warnings.add(msg);
                    break;
                }
            }
            if ("CAMPAIGN".equals(tag)) {
                ce.setCampaign(EntityEncoder.decode(element.getText()));
                continue;
            }
            if ("ADVENTURE".equals(tag)) {
                ce.setAdventure(EntityEncoder.decode(element.getText()));
                continue;
            }
            if ("PARTY".equals(tag)) {
                ce.setParty(EntityEncoder.decode(element.getText()));
                continue;
            }
            if ("DATE".equals(tag)) {
                ce.setDate(EntityEncoder.decode(element.getText()));
                continue;
            }
            if ("GM".equals(tag)) {
                ce.setGmField(EntityEncoder.decode(element.getText()));
                continue;
            }
            if (!"CHRONICLE".equals(tag)) continue;
            ce.setChronicle(EntityEncoder.decode(element.getText()));
        }
        this.thePC.addChronicleEntry(ce);
    }

    private void parseSupressBioFieldsLine(String line) {
        String fieldNames = EntityEncoder.decode(line.substring("SUPPRESSBIOFIELDS".length() + 1));
        if (!fieldNames.isEmpty()) {
            String[] names;
            for (String field : names = fieldNames.split("\\|")) {
                this.thePC.setSuppressBioField(BiographyField.valueOf(field), true);
            }
        }
    }

    private void parsePDFOutputSheetLine(String line) {
        String aFileName = EntityEncoder.decode(line.substring("OUTPUTSHEETPDF".length() + 1));
        if (aFileName.length() <= 0) {
            aFileName = SettingsHandler.getSelectedCharacterPDFOutputSheet(this.thePC);
        }
        this.thePC.setSelectedCharacterPDFOutputSheet(aFileName);
    }

    private void parsePersonalityTrait1Line(String line) {
        this.thePC.setTrait1(EntityEncoder.decode(line.substring("PERSONALITYTRAIT1".length() + 1)));
    }

    private void parsePersonalityTrait2Line(String line) {
        this.thePC.setTrait2(EntityEncoder.decode(line.substring("PERSONALITYTRAIT2".length() + 1)));
    }

    private void parsePhobiasLine(String line) {
        this.thePC.setPhobias(EntityEncoder.decode(line.substring("PHOBIAS".length() + 1)));
    }

    private void parsePlayerNameLine(String line) {
        this.thePC.setPlayersName(EntityEncoder.decode(line.substring("PLAYERNAME".length() + 1)));
    }

    private void parsePoolPointsLine(String line) {
        try {
            int poolPoints = Integer.parseInt(line.substring("POOLPOINTS".length() + 1));
            this.thePC.setPoolAmount(poolPoints);
            this.thePC.setCostPool(poolPoints);
        }
        catch (NumberFormatException nfe) {
            String msg = LanguageBundle.getFormattedString("Warnings.PCGenParser.InvalidPoolPoints", line);
            this.warnings.add(msg);
        }
    }

    private void parsePoolPointsLine2(String line) {
        try {
            this.thePC.setPointBuyPoints(Integer.parseInt(line.substring("POOLPOINTSAVAIL".length() + 1)));
        }
        catch (NumberFormatException nfe) {
            String msg = LanguageBundle.getFormattedString("Warnings.PCGenParser.InvalidPoolPoints", line);
            this.warnings.add(msg);
        }
    }

    private void parsePortraitLine(String line) {
        this.thePC.setPortraitPath(EntityEncoder.decode(line.substring("PORTRAIT".length() + 1)));
    }

    private void parsePortraitThumbnailRectLine(String line) {
        String[] dim = line.substring("PORTRAITTHUMBNAILRECT".length() + 1).split(",");
        Rectangle rect = new Rectangle(Integer.parseInt(dim[0]), Integer.parseInt(dim[1]), Integer.parseInt(dim[2]), Integer.parseInt(dim[3]));
        this.thePC.setPortraitThumbnailRect(rect);
    }

    private void parseRaceLine(String line) throws PCGParseException {
        List elements = new PCGTokenizer(line).getElements();
        PCGElement raceElement = (PCGElement)elements.get(0);
        String raceName = EntityEncoder.decode(raceElement.getText());
        raceName = RaceMigration.getNewRaceKey(raceName, this.pcgenVersion, SettingsHandler.getGame().getName());
        Race aRace = Globals.getContext().getReferenceContext().silentlyGetConstructedCDOMObject(Race.class, raceName);
        if (aRace == null) {
            String msg = LanguageBundle.getFormattedString("Exceptions.PCGenParser.RaceNotFound", raceName);
            throw new PCGParseException("parseRaceLine", line, msg);
        }
        String selection = null;
        for (int i = 1; i < elements.size(); ++i) {
            PCGElement thisElement = (PCGElement)elements.get(i);
            String aString = thisElement.getName();
            if (aString.startsWith("APPLIEDTO")) {
                if (selection != null) {
                    this.warnings.add("Found multiple selections for Race: " + aRace.getKeyName());
                }
                selection = thisElement.getText();
                continue;
            }
            if (aString.startsWith("ADD")) continue;
            String msg = LanguageBundle.getFormattedString("Warnings.PCGenParser.UnknownRaceInfo", aString + ":" + thisElement.getText());
            this.warnings.add(msg);
        }
        this.raceInputFacet.importSelection(this.thePC.getCharID(), aRace, selection);
        this.thePC.setDirty(true);
        for (PCGElement e : new PCGTokenizer(line).getElements()) {
            String tag = e.getName();
            if (!tag.equals("ADD")) continue;
            this.parseAddTokenInfo(e, aRace);
        }
    }

    private void parseFavoredClassLine(String line) {
        String favClass = EntityEncoder.decode(line.substring("FAVOREDCLASS".length() + 1));
        PCClass cl = Globals.getContext().getReferenceContext().silentlyGetConstructedCDOMObject(PCClass.class, favClass);
        if (cl != null) {
            this.thePC.addFavoredClass(cl, this.thePC);
        }
    }

    private void parseRegionLine(String line) {
        String r = EntityEncoder.decode(line.substring("REGION".length() + 1));
        this.thePC.setRegion(Region.getConstant(r));
    }

    private void parseResidenceLine(String line) {
        this.thePC.setResidence(EntityEncoder.decode(line.substring("RESIDENCE".length() + 1)));
        this.thePC.setDirty(true);
    }

    private void parseSkillLine(String line) {
        PCGElement element;
        PCGTokenizer tokens;
        try {
            tokens = new PCGTokenizer(line);
        }
        catch (PCGParseException pcgpex) {
            String message = "Illegal Skill line ignored: " + line + Constants.LINE_SEPARATOR + "Error: " + pcgpex.getMessage();
            this.warnings.add(message);
            return;
        }
        Skill aSkill = null;
        Iterator it = tokens.getElements().iterator();
        String skillKey = "";
        if (it.hasNext()) {
            element = (PCGElement)it.next();
            skillKey = EntityEncoder.decode(element.getText());
            aSkill = Globals.getContext().getReferenceContext().silentlyGetConstructedCDOMObject(Skill.class, skillKey);
        }
        while (it.hasNext()) {
            element = (PCGElement)it.next();
            String tag = element.getName();
            if ("SYNERGY".equals(tag)) continue;
            if ("OUTPUTORDER".equals(tag)) {
                int outputindex = 0;
                try {
                    outputindex = Integer.parseInt(element.getText());
                }
                catch (NumberFormatException nfe) {
                    // empty catch block
                }
                if (aSkill == null) continue;
                this.thePC.setSkillOrder(aSkill, outputindex);
                continue;
            }
            if ("CLASSBOUGHT".equals(tag)) {
                String childClassKey;
                String message;
                PCGElement childClass = null;
                PCGElement childRanks = null;
                for (PCGElement child : element.getChildren()) {
                    if ("CLASS".equals(child.getName())) {
                        childClass = child;
                        continue;
                    }
                    if (!"RANKS".equals(child.getName())) continue;
                    childRanks = child;
                }
                if (childClass == null) {
                    message = "Invalid class/ranks specification: " + line;
                    this.warnings.add(message);
                    continue;
                }
                if (childRanks == null) {
                    message = "Invalid class/ranks specification: " + line;
                    this.warnings.add(message);
                    continue;
                }
                PCClass aPCClass = null;
                if (!childClass.getText().equals("None") && (aPCClass = this.thePC.getClassKeyed(childClassKey = EntityEncoder.decode(childClass.getText()))) == null) {
                    String message2 = "Could not find class: " + childClassKey;
                    this.warnings.add(message2);
                    continue;
                }
                if (aSkill == null) {
                    String message3 = "Could not add skill: " + skillKey;
                    this.warnings.add(message3);
                    return;
                }
                try {
                    double ranks = Double.parseDouble(childRanks.getText());
                    SkillRankControl.modRanks(ranks, aPCClass, true, this.thePC, aSkill);
                }
                catch (NumberFormatException nfe) {
                    String message4 = "Invalid ranks specification: " + childRanks.getText();
                    this.warnings.add(message4);
                }
                continue;
            }
            if (aSkill != null && "ASSOCIATEDDATA".equals(tag)) {
                String key = EntityEncoder.decode(element.getText());
                ChoiceManagerList controller = ChooserUtilities.getConfiguredController(aSkill, this.thePC, null, new ArrayList<String>());
                if (controller != null) {
                    String[] assoc;
                    for (String string : assoc = key.split(",", -1)) {
                        controller.restoreChoice(this.thePC, aSkill, string);
                    }
                    continue;
                }
                this.warnings.add("Failed to find choose controller for skill " + aSkill);
                continue;
            }
            if (aSkill != null && tag.equals("ABILITY")) {
                this.parseLevelAbilityInfo(element, aSkill);
                continue;
            }
            if (aSkill == null || !tag.equals("ADD")) continue;
            this.parseAddTokenInfo(element, aSkill);
        }
    }

    private void parseSkillsOutputOrderLine(String line) {
        try {
            int orderNum = Integer.parseInt(line.substring("SKILLSOUTPUTORDER".length() + 1));
            SkillsOutputOrder order = SkillsOutputOrder.values()[orderNum];
            if (this.compareVersionTo(new int[]{6, 1, 9}) < 0) {
                order = SkillsOutputOrder.NAME_ASC;
            }
            this.thePC.setSkillsOutputOrder(order);
        }
        catch (NumberFormatException nfe) {
            String message = "Illegal Skills Output Order line ignored: " + line;
            this.warnings.add(message);
        }
    }

    private void parseSkillFilterLine(String line) {
        try {
            int value = Integer.parseInt(line.substring("SKILLFILTER".length() + 1));
            this.thePC.setSkillFilter(SkillFilter.getByValue(value));
        }
        catch (NumberFormatException nfe) {
            String message = "Illegal Skill Filter line ignored: " + line;
            this.warnings.add(message);
        }
    }

    private void parseSkinColorLine(String line) {
        this.thePC.setSkinColor(EntityEncoder.decode(line.substring("SKINCOLOR".length() + 1)));
    }

    private void parseSpeechPatternLine(String line) {
        this.thePC.setSpeechTendency(EntityEncoder.decode(line.substring("SPEECHPATTERN".length() + 1)));
    }

    private void parseSpellBookLines(String line) {
        PCGTokenizer tokens;
        try {
            tokens = new PCGTokenizer(line);
        }
        catch (PCGParseException pcgpex) {
            String message = "Illegal Spell book ignored: " + line + Constants.LINE_SEPARATOR + "Error: " + pcgpex.getMessage();
            this.warnings.add(message);
            return;
        }
        SpellBook aSpellBook = null;
        for (PCGElement element : tokens.getElements()) {
            String tag = element.getName();
            if ("SPELLBOOK".equals(tag)) {
                String bookName = EntityEncoder.decode(element.getText());
                aSpellBook = new SpellBook(bookName, 2);
                continue;
            }
            if ("TYPE".equals(tag)) {
                try {
                    aSpellBook.setType(Integer.parseInt(element.getText()));
                }
                catch (NumberFormatException nfe) {
                    String message = "Spell book " + aSpellBook.getName() + " had an illegal type: " + element.getText() + " in line " + line;
                    this.warnings.add(message);
                }
                continue;
            }
            if (!"AUTOADDKNOWN".equals(tag) || !"Y".equals(element.getText())) continue;
            this.thePC.setSpellBookNameToAutoAddKnown(aSpellBook.getName());
        }
        if (aSpellBook == null) {
            this.warnings.add("Internal Error: Did not build Spell Book from SPELLBOOK line");
        } else {
            this.thePC.addSpellBook(aSpellBook);
        }
    }

    private void parseSpellLine(String line) {
        PCGTokenizer tokens;
        try {
            tokens = new PCGTokenizer(line);
        }
        catch (PCGParseException pcgpex) {
            String message = "Illegal Spell line ignored: " + line + Constants.LINE_SEPARATOR + "Error: " + pcgpex.getMessage();
            this.warnings.add(message);
            return;
        }
        Spell aSpell = null;
        PCClass aPCClass = null;
        PObject source = null;
        String spellBook = null;
        int times = 1;
        int spellLevel = 0;
        int numPages = 0;
        ArrayList<Ability> metaFeats = new ArrayList<Ability>();
        int ppCost = -1;
        for (PCGElement element : tokens.getElements()) {
            String message;
            String tag = element.getName();
            if ("SPELLNAME".equals(tag)) {
                String spellName = EntityEncoder.decode(element.getText());
                spellName = SpellMigration.getNewSpellKey(spellName, this.pcgenVersion, SettingsHandler.getGame().getName());
                aSpell = Globals.getSpellMap().get(spellName);
                if (aSpell != null) continue;
                message = "Could not find spell named: " + spellName;
                this.warnings.add(message);
                return;
            }
            if ("TIMES".equals(tag)) {
                try {
                    times = Integer.parseInt(element.getText());
                }
                catch (NumberFormatException nfe) {}
                continue;
            }
            if ("CLASS".equals(tag)) {
                String classKey = EntityEncoder.decode(element.getText());
                aPCClass = this.thePC.getClassKeyed(classKey);
                if (aPCClass != null) continue;
                message = "Invalid class specification: " + classKey;
                this.warnings.add(message);
                return;
            }
            if ("BOOK".equals(tag)) {
                spellBook = EntityEncoder.decode(element.getText());
                continue;
            }
            if ("SPELLLEVEL".equals(tag)) {
                try {
                    spellLevel = Integer.parseInt(element.getText());
                }
                catch (NumberFormatException nfe) {}
                continue;
            }
            if ("SPELLPPCOST".equals(tag)) {
                try {
                    ppCost = Integer.parseInt(element.getText());
                }
                catch (NumberFormatException nfe) {}
                continue;
            }
            if ("SPELLNUMPAGES".equals(tag)) {
                try {
                    numPages = Integer.parseInt(element.getText());
                }
                catch (NumberFormatException nfe) {}
                continue;
            }
            if ("SOURCE".equals(tag)) {
                String typeName = "";
                String objectKey = "";
                for (PCGElement child : element.getChildren()) {
                    String childTag = child.getName();
                    if ("TYPE".equals(childTag)) {
                        typeName = child.getText().toUpperCase();
                        continue;
                    }
                    if (!"NAME".equals(childTag)) continue;
                    objectKey = child.getText();
                }
                if ("DOMAIN".equals(typeName)) {
                    Domain domain = Globals.getContext().getReferenceContext().silentlyGetConstructedCDOMObject(DOMAIN_CLASS, objectKey);
                    ClassSource cs = this.thePC.getDomainSource(domain);
                    if (cs == null) {
                        String message2 = "Could not find domain: " + objectKey;
                        this.warnings.add(message2);
                        return;
                    }
                    source = domain;
                    continue;
                }
                ClassSpellList csl = Globals.getContext().getReferenceContext().silentlyGetConstructedCDOMObject(ClassSpellList.class, objectKey);
                if (aPCClass != null && objectKey.equals(aPCClass.getKeyName()) || aPCClass != null && this.thePC.getSpellLists(aPCClass).contains(csl)) {
                    source = aPCClass;
                    continue;
                }
                source = this.thePC.getClassKeyed(objectKey);
                continue;
            }
            if (!"FEATLIST".equals(tag)) continue;
            for (PCGElement child : element.getChildren()) {
                String featKey = EntityEncoder.decode(child.getText());
                Ability anAbility = Globals.getContext().getReferenceContext().silentlyGetConstructedCDOMObject(Ability.class, AbilityCategory.FEAT, featKey);
                if (anAbility == null) continue;
                metaFeats.add(anAbility);
            }
        }
        if (aPCClass == null || spellBook == null) {
            String message = "Illegal Spell line ignored: " + line;
            this.warnings.add(message);
            return;
        }
        if (source == null) {
            source = aPCClass;
        }
        this.thePC.addSpellBook(spellBook);
        SpellBook book = this.thePC.getSpellBookByName(spellBook);
        this.thePC.calculateKnownSpellsForClassLevel(aPCClass);
        Integer[] spellLevels = SpellLevel.levelForKey(aSpell, this.thePC.getSpellLists(source), this.thePC);
        boolean found = false;
        for (int sindex = 0; sindex < spellLevels.length; ++sindex) {
            int level = spellLevels[sindex];
            int metmagicLevels = this.totalAddedLevelsFromMetamagic(metaFeats);
            if (spellLevel > 0 && spellLevel != level + metmagicLevels) continue;
            if (level < 0) {
                Collection mods = source.getListMods(Spell.SPELLS);
                if (mods == null) continue;
                for (CDOMReference ref : mods) {
                    Collection refSpells = ref.getContainedObjects();
                    Collection<AssociatedPrereqObject> assocs = source.getListAssociations(Spell.SPELLS, ref);
                    block15: for (Spell sp : refSpells) {
                        if (!aSpell.getKeyName().equals(sp.getKeyName())) continue;
                        for (AssociatedPrereqObject apo : assocs) {
                            String sb = apo.getAssociation(AssociationKey.SPELLBOOK);
                            if (!spellBook.equals(sb)) continue;
                            found = true;
                            continue block15;
                        }
                    }
                }
                continue;
            }
            found = true;
            if (spellBook.equals(Globals.getDefaultSpellBook()) && this.thePC.getSpellSupport(aPCClass).isAutoKnownSpell(aSpell, level, false, this.thePC) && this.thePC.getAutoSpells()) continue;
            CharacterSpell aCharacterSpell = this.thePC.getCharacterSpellForSpell(aPCClass, aSpell, source);
            if (aCharacterSpell == null) {
                aCharacterSpell = new CharacterSpell(source, aSpell);
                aCharacterSpell.addInfo(level, times, spellBook);
                this.thePC.addCharacterSpell(aPCClass, aCharacterSpell);
            }
            SpellInfo aSpellInfo = null;
            if (!(!source.getKeyName().equals(aPCClass.getKeyName()) && spellBook.equals(Globals.getDefaultSpellBook()) || (aSpellInfo = aCharacterSpell.getSpellInfoFor(spellBook, spellLevel)) != null && metaFeats.isEmpty())) {
                aSpellInfo = aCharacterSpell.addInfo(spellLevel, times, spellBook);
            }
            if (aSpellInfo == null) continue;
            if (!metaFeats.isEmpty()) {
                aSpellInfo.addFeatsToList(metaFeats);
            }
            aSpellInfo.setActualPPCost(ppCost);
            aSpellInfo.setNumPages(numPages);
            book.setNumPagesUsed(book.getNumPagesUsed() + numPages);
            book.setNumSpells(book.getNumSpells() + 1);
        }
        if (!found) {
            String message = "Could not find spell " + aSpell.getDisplayName() + " in " + PCGVer2Parser.shortClassName(source) + " " + source.getDisplayName();
            this.warnings.add(message);
        }
    }

    private int totalAddedLevelsFromMetamagic(List<Ability> metaFeats) {
        int addedLevels = 0;
        for (Ability ability : metaFeats) {
            Integer featAddSpellLevel = ability.get(IntegerKey.ADD_SPELL_LEVEL);
            if (featAddSpellLevel == null) continue;
            addedLevels += featAddSpellLevel.intValue();
        }
        return addedLevels;
    }

    private void parseSpellListLines(String line) {
        String subLine = line.substring("SPELLLIST".length() + 1);
        StringTokenizer stok = new StringTokenizer(subLine, "|", false);
        String classKey = stok.nextToken();
        PCClass aClass = this.thePC.getClassKeyed(classKey);
        AbstractReferenceContext refContext = Globals.getContext().getReferenceContext();
        while (aClass != null && stok.hasMoreTokens()) {
            ClassSpellList csl;
            String tok = stok.nextToken();
            if (tok.startsWith("CLASS.")) {
                csl = refContext.silentlyGetConstructedCDOMObject(ClassSpellList.class, tok.substring(6));
                this.thePC.addClassSpellList(csl, aClass);
                continue;
            }
            if (tok.startsWith("DOMAIN.")) {
                DomainSpellList dsl = refContext.silentlyGetConstructedCDOMObject(DomainSpellList.class, tok.substring(7));
                this.thePC.addClassSpellList(dsl, aClass);
                continue;
            }
            csl = refContext.silentlyGetConstructedCDOMObject(ClassSpellList.class, tok);
            if (csl == null) {
                DomainSpellList dsl = refContext.silentlyGetConstructedCDOMObject(DomainSpellList.class, tok);
                if (dsl == null) continue;
                this.thePC.addClassSpellList(dsl, aClass);
                continue;
            }
            this.thePC.addClassSpellList(csl, aClass);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void parseStatLine(String line) throws PCGParseException {
        PCGTokenizer tokens;
        try {
            tokens = new PCGTokenizer(line);
        }
        catch (PCGParseException pcgpex) {
            throw new PCGParseException("parseStatLine", line, pcgpex.getMessage());
        }
        Iterator it = tokens.getElements().iterator();
        if (!it.hasNext()) {
            String message = "Invalid attribute specification. Cannot load character.";
            throw new PCGParseException("parseStatLine", line, "Invalid attribute specification. Cannot load character.");
        }
        PCGElement element = (PCGElement)it.next();
        String statName = element.getText();
        PCStat stat = Globals.getContext().getReferenceContext().silentlyGetConstructedCDOMObject(PCStat.class, statName);
        if (stat != null && this.seenStats.add(statName.toUpperCase()) && it.hasNext()) {
            element = (PCGElement)it.next();
            try {
                this.thePC.setStat(stat, Integer.parseInt(element.getText()));
                return;
            }
            catch (NumberFormatException nfe) {
                throw new PCGParseException("parseStatLine", line, nfe.getMessage());
            }
        }
        String message = "Invalid attribute specification. Cannot load character.";
        throw new PCGParseException("parseStatLine", line, "Invalid attribute specification. Cannot load character.");
    }

    private void parseTabNameLine(String line) {
        this.thePC.setTabName(EntityEncoder.decode(line.substring("TABNAME".length() + 1)));
    }

    private void parseTemplateLine(String line) throws PCGParseException {
        if (line.charAt("TEMPLATESAPPLIED".length() + 1) == '[') {
            PCGTokenizer tokens;
            try {
                tokens = new PCGTokenizer(line);
            }
            catch (PCGParseException pcgpex) {
                String message = "Illegal Template line ignored: " + line + Constants.LINE_SEPARATOR + "Error: " + pcgpex.getMessage();
                this.warnings.add(message);
                return;
            }
            PCTemplate aPCTemplate = null;
            Iterator it = tokens.getElements().iterator();
            if (it.hasNext()) {
                String childTag;
                PCGElement element = (PCGElement)it.next();
                String assoc = null;
                for (PCGElement child : element.getChildren()) {
                    childTag = child.getName();
                    if ("NAME".equals(childTag)) {
                        aPCTemplate = Globals.getContext().getReferenceContext().silentlyGetConstructedCDOMObject(PCTemplate.class, EntityEncoder.decode(child.getText()));
                        if (aPCTemplate != null) continue;
                        break;
                    }
                    if (!"APPLIEDTO".equals(childTag)) continue;
                    assoc = child.getText();
                }
                for (PCGElement child : element.getChildren()) {
                    childTag = child.getName();
                    if ("NAME".equals(childTag)) {
                        if (aPCTemplate == null) break;
                        this.addKeyedTemplate(aPCTemplate, assoc);
                        continue;
                    }
                    if ("CHOSENFEAT".equals(childTag)) {
                        String mapKey = null;
                        String mapValue = null;
                        for (PCGElement subChild : child.getChildren()) {
                            String subChildTag = subChild.getName();
                            if ("KEY".equals(subChildTag)) {
                                mapKey = subChild.getText();
                                continue;
                            }
                            if (!"VALUE".equals(subChildTag)) continue;
                            mapValue = subChild.getText();
                        }
                        if (mapKey == null || mapValue == null) continue;
                        String feat = EntityEncoder.decode(mapValue);
                        PCTemplate subt = Compatibility.getTemplateFor(aPCTemplate, EntityEncoder.decode(mapKey), feat);
                        if (subt == null) continue;
                        CNAbilitySelection as = CNAbilitySelection.getAbilitySelectionFromPersistentFormat(feat);
                        this.thePC.addTemplateFeat(subt, as);
                        continue;
                    }
                    if ("CHOSENTEMPLATE".equals(childTag)) {
                        for (PCGElement subChild : child.getChildren()) {
                            String subChildTag = subChild.getName();
                            if (!"NAME".equals(subChildTag)) continue;
                            String ownedTemplateKey = EntityEncoder.decode(subChild.getText());
                            PCTemplate ownedTemplate = Globals.getContext().getReferenceContext().silentlyGetConstructedCDOMObject(PCTemplate.class, ownedTemplateKey);
                            if (ownedTemplate == null) continue;
                            this.thePC.setTemplatesAdded(aPCTemplate, ownedTemplate);
                        }
                        continue;
                    }
                    if ("ADD".equals(childTag) || "APPLIEDTO".equals(childTag)) continue;
                    String msg = LanguageBundle.getFormattedString("Warnings.PCGenParser.UnknownTemplateInfo", childTag + ":" + child.getText());
                    this.warnings.add(msg);
                }
            }
            for (PCGElement e : new PCGTokenizer(line).getElements()) {
                String tag = e.getName();
                if (!tag.equals("ADD")) continue;
                this.parseAddTokenInfo(e, aPCTemplate);
            }
        } else {
            String key = EntityEncoder.decode(line.substring("TEMPLATESAPPLIED".length() + 1));
            PCTemplate aPCTemplate = Globals.getContext().getReferenceContext().silentlyGetConstructedCDOMObject(PCTemplate.class, key);
            this.addKeyedTemplate(aPCTemplate, null);
        }
    }

    private void parseUseTempModsLine(String line) {
        this.thePC.setUseTempMods(line.endsWith("Y"));
    }

    private void parseVFeatLine(String line) {
        PCGTokenizer tokens;
        try {
            tokens = new PCGTokenizer(line);
        }
        catch (PCGParseException pcgpex) {
            String message = "Illegal VFeat line ignored: " + line + Constants.LINE_SEPARATOR + "Error: " + pcgpex.getMessage();
            this.warnings.add(message);
            return;
        }
        Ability anAbility = null;
        Iterator<PCGElement> it = tokens.getElements().iterator();
        if (it.hasNext()) {
            PCGElement element = (PCGElement)it.next();
            String abilityKey = EntityEncoder.decode(element.getText());
            anAbility = Globals.getContext().getReferenceContext().silentlyGetConstructedCDOMObject(Ability.class, AbilityCategory.FEAT, abilityKey);
            if (anAbility == null) {
                String message = "Could not add vfeat: " + abilityKey;
                this.warnings.add(message);
                return;
            }
            CNAbility cna = CNAbilityFactory.getCNAbility(AbilityCategory.FEAT, Nature.VIRTUAL, anAbility);
            this.parseFeatsHandleAppliedToAndSaveTags(it, cna);
            this.thePC.setDirty(true);
        }
    }

    protected void parseVersionLine(String line) throws PCGParseException {
        int[] version = new int[]{0, 0, 0};
        if (!line.startsWith("VERSION:")) {
            throw new PCGParseException("parseVersionLine", line, "Not a Version Line.");
        }
        String[] tokens = line.substring("VERSION".length() + 1).split(" |\\.|\\-", 4);
        for (int idx = 0; idx < 3 && idx < tokens.length; ++idx) {
            try {
                version[idx] = Integer.parseInt(tokens[idx]);
                continue;
            }
            catch (NumberFormatException e) {
                if (idx == 2 && tokens[idx].startsWith("RC")) {
                    this.pcgenVersionSuffix = tokens[2];
                    continue;
                }
                throw new PCGParseException("parseVersionLine", line, "Invalid PCGen version.");
            }
        }
        if (tokens.length == 4) {
            this.pcgenVersionSuffix = tokens[3];
        }
        this.pcgenVersion = version;
    }

    private void parseWeaponProficienciesLine(String line) {
        List<PersistentTransitionChoice<?>> adds;
        PCGTokenizer tokens;
        try {
            tokens = new PCGTokenizer(line);
        }
        catch (PCGParseException pcgpex) {
            String message = "Illegal Weapon proficiencies line ignored: " + line + Constants.LINE_SEPARATOR + "Error: " + pcgpex.getMessage();
            this.warnings.add(message);
            return;
        }
        CDOMObject source = null;
        boolean hadSource = false;
        for (PCGElement element : tokens.getElements()) {
            String message;
            if (!"SOURCE".equals(element.getName())) continue;
            hadSource = true;
            String type = "";
            String key = "";
            for (PCGElement child : element.getChildren()) {
                String tag = child.getName();
                if ("TYPE".equals(tag)) {
                    type = child.getText().toUpperCase();
                    continue;
                }
                if (!"NAME".equals(tag)) continue;
                key = child.getText();
            }
            if ("".equals(type) || "".equals(key)) {
                message = "Illegal Weapon proficiencies line ignored: " + line;
                this.warnings.add(message);
                return;
            }
            if ("RACE".equals(type)) {
                source = this.thePC.getRace();
            } else if (TAG_PCTEMPLATE.equals(type)) {
                PCTemplate template = Globals.getContext().getReferenceContext().silentlyGetConstructedCDOMObject(PCTemplate.class, key);
                if (this.thePC.hasTemplate(template)) {
                    source = template;
                } else {
                    this.warnings.add("PC does not have Template: " + key);
                }
            } else if ("PCCLASS".equals(type)) {
                source = this.thePC.getClassKeyed(key);
            }
            if (source != null) break;
            message = "Invalid source specification: " + line;
            this.warnings.add(message);
            break;
        }
        PCGElement element = (PCGElement)tokens.getElements().get(0);
        boolean processed = false;
        if (source != null && (adds = source.getListFor(ListKey.ADD)) != null) {
            for (PersistentTransitionChoice<?> ptc : adds) {
                if (!ptc.getChoiceClass().equals(WeaponProf.class)) continue;
                for (PCGElement child : element.getChildren()) {
                    WeaponProf wp = this.getWeaponProf(child.getText());
                    Set<WeaponProf> c = Collections.singleton(wp);
                    ptc.act(c, source, this.thePC);
                }
                processed = true;
                break;
            }
        }
        if (hadSource && !processed) {
            String message = "Unable to apply WeaponProfs: " + line;
            this.warnings.add(message);
        }
    }

    private void parseWeightLine(String line) {
        try {
            this.thePC.setWeight(Integer.parseInt(line.substring("WEIGHT".length() + 1)));
        }
        catch (NumberFormatException nfe) {
            String message = "Illegal Weight line ignored: " + line;
            this.warnings.add(message);
        }
    }

    private static String shortClassName(Object o) {
        Class<?> objClass = o.getClass();
        String pckName = objClass.getPackage().getName();
        return objClass.getName().substring(pckName.length() + 1);
    }

    private WeaponProf getWeaponProf(String aString) {
        WeaponProf wp = Globals.getContext().getReferenceContext().silentlyGetConstructedCDOMObject(WeaponProf.class, EntityEncoder.decode(aString));
        if (wp == null) {
            String message = "Unable to find Weapon Proficiency in Rules Data:" + aString;
            if (Logging.isDebugMode()) {
                Logging.debugPrint(message);
            }
        }
        return wp;
    }

    private void parseCalcEquipSet(String line) {
        PCGTokenizer tokens;
        try {
            tokens = new PCGTokenizer(line);
        }
        catch (PCGParseException pcgpex) {
            String message = "Illegal Calc EquipSet line ignored: " + line + Constants.LINE_SEPARATOR + "Error: " + pcgpex.getMessage();
            this.warnings.add(message);
            return;
        }
        String calcEQId = EntityEncoder.decode(((PCGElement)tokens.getElements().get(0)).getText());
        if (calcEQId != null) {
            this.thePC.setCalcEquipSetId(calcEQId);
        }
    }

    private void parseCharacterBioLine(String line) {
        this.thePC.setBio(EntityEncoder.decode(line.substring("CHARACTERBIO".length() + 1)));
    }

    private void parseEquipmentLine(String line) {
        PCGTokenizer tokens;
        try {
            tokens = new PCGTokenizer(line);
        }
        catch (PCGParseException pcgpex) {
            String message = "Illegal Equipment line ignored: " + line + Constants.LINE_SEPARATOR + "Error: " + pcgpex.getMessage();
            this.warnings.add(message);
            return;
        }
        PCGElement element2 = (PCGElement)tokens.getElements().get(0);
        String itemKey = EntityEncoder.decode(element2.getText());
        itemKey = EquipmentMigration.getNewEquipmentKey(itemKey, this.pcgenVersion, SettingsHandler.getGame().getName());
        Equipment aEquip = this.thePC.getEquipmentNamed(itemKey);
        if (aEquip == null) {
            aEquip = Globals.getContext().getReferenceContext().silentlyGetConstructedCDOMObject(Equipment.class, itemKey);
            if (aEquip != null) {
                aEquip = aEquip.isType("Custom") ? null : aEquip.clone();
            }
            if (line.indexOf("CUSTOMIZATION") >= 0) {
                for (PCGElement element2 : tokens.getElements()) {
                    if (!"CUSTOMIZATION".equals(element2.getName())) continue;
                    String baseItemKey = "";
                    String customProperties = "";
                    for (PCGElement child : element2.getChildren()) {
                        String childTag = child.getName();
                        if ("BASEITEM".equals(childTag)) {
                            baseItemKey = EntityEncoder.decode(child.getText());
                            baseItemKey = EquipmentMigration.getNewEquipmentKey(baseItemKey, this.pcgenVersion, SettingsHandler.getGame().getName());
                            continue;
                        }
                        if (!"DATA".equals(childTag)) continue;
                        customProperties = EntityEncoder.decode(child.getText());
                    }
                    if (aEquip != null && baseItemKey.equals(aEquip.getBaseItemName())) {
                        EquipmentHead head = aEquip.getEquipmentHeadReference(1);
                        if (head != null) {
                            head.removeListFor(ListKey.EQMOD);
                            head.removeListFor(ListKey.EQMOD_INFO);
                        }
                        aEquip.setBase();
                        aEquip.load(customProperties, "$", "=", this.thePC);
                        aEquip.setToCustomSize(this.thePC);
                        break;
                    }
                    Equipment aEquip2 = Globals.getContext().getReferenceContext().silentlyGetConstructedCDOMObject(Equipment.class, baseItemKey);
                    if (aEquip2 == null) break;
                    if (aEquip2.isType("Custom")) {
                        aEquip2 = null;
                        break;
                    }
                    aEquip = aEquip2.clone();
                    EquipmentHead head = aEquip.getEquipmentHeadReference(1);
                    if (head != null) {
                        head.removeListFor(ListKey.EQMOD);
                        head.removeListFor(ListKey.EQMOD_INFO);
                    }
                    aEquip.setBase();
                    aEquip.load(customProperties, "$", "=", this.thePC);
                    aEquip.setToCustomSize(this.thePC);
                    aEquip.remove(StringKey.OUTPUT_NAME);
                    if (!aEquip.isType("Custom")) {
                        aEquip.addType(Type.CUSTOM);
                    }
                    Globals.getContext().getReferenceContext().importObject(aEquip.clone());
                    break;
                }
            }
            if (aEquip == null) {
                String msg = LanguageBundle.getFormattedString("Warnings.PCGenParser.EquipmentNotFound", itemKey);
                this.warnings.add(msg);
                return;
            }
            this.thePC.addEquipment(aEquip);
        }
        for (PCGElement element2 : tokens.getElements()) {
            String tag = element2.getName();
            if ("QUANTITY".equals(tag)) {
                float oldQty = aEquip.getQty().floatValue();
                aEquip.setQty(element2.getText());
                this.thePC.updateEquipmentQty(aEquip, oldQty, aEquip.getQty().floatValue());
                continue;
            }
            if ("OUTPUTORDER".equals(tag)) {
                int index = 0;
                try {
                    index = Integer.parseInt(element2.getText());
                }
                catch (NumberFormatException nfe) {
                    // empty catch block
                }
                aEquip.setOutputIndex(index);
                if (!aEquip.isAutomatic()) continue;
                this.thePC.cacheOutputIndex(aEquip);
                continue;
            }
            if ("COST".equals(tag) || "WT".equals(tag) || !"NOTE".equals(tag)) continue;
            aEquip.setNote(element2.getText());
        }
    }

    private void parseEquipmentSetLine(String line) {
        PCGTokenizer tokens;
        try {
            tokens = new PCGTokenizer(line);
        }
        catch (PCGParseException pcgpex) {
            String message = "Illegal EquipSet line ignored: " + line + Constants.LINE_SEPARATOR + "Error: " + pcgpex.getMessage();
            this.warnings.add(message);
            return;
        }
        String setName = null;
        String setID = null;
        String itemKey = null;
        String setNote = null;
        Float itemQuantity = null;
        boolean useTempMods = false;
        for (PCGElement element : tokens.getElements()) {
            String tag = element.getName();
            if ("EQUIPSET".equals(tag)) {
                setName = EntityEncoder.decode(element.getText());
                continue;
            }
            if ("ID".equals(tag)) {
                setID = element.getText();
                continue;
            }
            if ("VALUE".equals(tag)) {
                itemKey = EntityEncoder.decode(element.getText());
                continue;
            }
            if ("QUANTITY".equals(tag)) {
                try {
                    itemQuantity = new Float(element.getText());
                }
                catch (NumberFormatException nfe) {
                    itemQuantity = new Float(0.0f);
                }
                continue;
            }
            if ("NOTE".equals(tag)) {
                setNote = EntityEncoder.decode(element.getText());
                continue;
            }
            if (!"USETEMPMODS".equals(tag)) continue;
            useTempMods = element.getText().endsWith("Y");
        }
        if (setName == null || "".equals(setName) || setID == null || "".equals(setID)) {
            String message = "Illegal EquipSet line ignored: " + line;
            this.warnings.add(message);
            return;
        }
        EquipSet aEquipSet = new EquipSet(setID, setName);
        if (setNote != null) {
            aEquipSet.setNote(setNote);
        }
        if (itemKey != null) {
            aEquipSet.setValue(itemKey);
            Equipment eqI = this.thePC.getEquipmentNamed(itemKey);
            if (eqI == null) {
                eqI = Globals.getContext().getReferenceContext().silentlyGetConstructedCDOMObject(Equipment.class, itemKey);
            }
            if (eqI == null) {
                String message = "Could not find equipment: " + itemKey;
                this.warnings.add(message);
                return;
            }
            Equipment aEquip = eqI.clone();
            if (itemQuantity != null) {
                aEquipSet.setQty(itemQuantity);
                aEquip.setQty(itemQuantity);
                aEquip.setNumberCarried(itemQuantity);
            }
            if (new StringTokenizer(setID, ".").countTokens() > 3) {
                EquipSet aEquipSet2 = this.thePC.getEquipSetByIdPath(aEquipSet.getParentIdPath());
                Equipment aEquip2 = null;
                if (aEquipSet2 != null) {
                    aEquip2 = aEquipSet2.getItem();
                }
                if (aEquip2 != null) {
                    aEquip2.insertChild(this.thePC, aEquip);
                    aEquip.setParent(aEquip2);
                }
            }
            aEquipSet.setItem(aEquip);
        }
        aEquipSet.setUseTempMods(useTempMods);
        this.thePC.addEquipSet(aEquipSet);
    }

    private void parseMoneyLine(String line) {
        this.thePC.setGold(line.substring("MONEY".length() + 1));
    }

    private void parseTempBonusLine(String line) {
        PCGTokenizer tokens;
        try {
            tokens = new PCGTokenizer(line);
        }
        catch (PCGParseException pcgpex) {
            String message = "Illegal TempBonus line ignored: " + line + Constants.LINE_SEPARATOR + "Error: " + pcgpex.getMessage();
            this.warnings.add(message);
            return;
        }
        String cTag = null;
        String tName = null;
        boolean active = true;
        for (PCGElement element : tokens.getElements()) {
            String tag = element.getName();
            if ("TEMPBONUS".equals(tag)) {
                cTag = EntityEncoder.decode(element.getText());
                continue;
            }
            if ("TBTARGET".equals(tag)) {
                tName = EntityEncoder.decode(element.getText());
                continue;
            }
            if (!"TBACTIVE".equals(tag)) continue;
            active = element.getText().endsWith("Y");
        }
        if (cTag == null || tName == null) {
            this.warnings.add("Illegal TempBonus line ignored: " + line);
            return;
        }
        StringTokenizer aTok = new StringTokenizer(cTag, "=", false);
        if (aTok.countTokens() < 2) {
            return;
        }
        String cType = aTok.nextToken();
        String cKey = aTok.nextToken();
        Equipment aEq = null;
        if (!tName.equals("PC")) {
            Equipment eq = this.thePC.getEquipmentNamed(tName);
            if (eq == null) {
                return;
            }
            aEq = eq.clone();
            aEq.resetTempBonusList();
        }
        for (PCGElement element : tokens.getElements()) {
            BonusManager.TempBonusInfo tempBonusInfo;
            String bonus;
            String tag = element.getName();
            if (!"TBBONUS".equals(tag) || (bonus = EntityEncoder.decode(element.getText())) == null || bonus.length() <= 0) continue;
            BonusObj newB = null;
            PObject creator = null;
            LoadContext context = Globals.getContext();
            if (cType.equals("FEAT")) {
                for (AbilityCategory aCat : SettingsHandler.getGame().getAllAbilityCategories()) {
                    Ability a = Globals.getContext().getReferenceContext().silentlyGetConstructedCDOMObject(Ability.class, aCat, cKey);
                    if (a == null) continue;
                    newB = Bonus.newBonus(context, bonus);
                    creator = a;
                    break;
                }
            } else if (cType.equals("EQUIPMENT")) {
                Equipment aEquip = this.thePC.getEquipmentNamed(cKey);
                if (aEquip == null) {
                    aEquip = context.getReferenceContext().silentlyGetConstructedCDOMObject(Equipment.class, cKey);
                }
                if (aEquip != null) {
                    newB = Bonus.newBonus(context, bonus);
                    creator = aEquip;
                }
            } else if (cType.equals("CLASS")) {
                PCClass aClass = this.thePC.getClassKeyed(cKey);
                if (aClass == null) continue;
                int idx = bonus.indexOf(124);
                newB = Bonus.newBonus(context, bonus.substring(idx + 1));
                creator = aClass;
            } else if (cType.equals("TEMPLATE")) {
                PCTemplate aTemplate = context.getReferenceContext().silentlyGetConstructedCDOMObject(PCTemplate.class, cKey);
                if (aTemplate != null) {
                    newB = Bonus.newBonus(context, bonus);
                    creator = aTemplate;
                }
            } else if (cType.equals("SKILL")) {
                Skill aSkill = context.getReferenceContext().silentlyGetConstructedCDOMObject(Skill.class, cKey);
                if (aSkill != null) {
                    newB = Bonus.newBonus(context, bonus);
                    creator = aSkill;
                }
            } else if (cType.equals("SPELL")) {
                Spell aSpell = Globals.getSpellKeyed(cKey);
                if (aSpell != null) {
                    newB = Bonus.newBonus(context, bonus);
                    creator = aSpell;
                }
            } else if (cType.equals("NAME")) {
                newB = Bonus.newBonus(context, bonus);
            }
            if (newB == null) {
                return;
            }
            if (tName.equals("PC")) {
                this.thePC.setApplied(newB, true);
                tempBonusInfo = this.thePC.addTempBonus(newB, creator, this.thePC);
            } else {
                this.thePC.setApplied(newB, true);
                aEq.addTempBonus(newB);
                tempBonusInfo = this.thePC.addTempBonus(newB, creator, aEq);
            }
            if (active) continue;
            String bonusName = BonusDisplay.getBonusDisplayName(tempBonusInfo);
            this.thePC.setTempBonusFilter(bonusName);
        }
        if (aEq != null) {
            aEq.setAppliedName(cKey);
            this.thePC.addTempBonusItemList(aEq);
        }
    }

    private static String sourceElementToString(PCGElement source) {
        String type = "";
        String name = "";
        String level = "";
        String defined = "";
        for (PCGElement child : source.getChildren()) {
            String tag = child.getName();
            if ("TYPE".equals(tag)) {
                type = child.getText();
                continue;
            }
            if ("NAME".equals(tag)) {
                name = child.getText();
                continue;
            }
            if ("LEVEL".equals(tag)) {
                level = child.getText();
                continue;
            }
            if (!"DEFINED".equals(tag)) continue;
            defined = child.getText().toUpperCase();
        }
        StringBuilder buffer = new StringBuilder(1000);
        buffer.append(type);
        buffer.append("Y".equals(defined) ? (char)'=' : '|');
        buffer.append(name);
        if (!"".equals(level)) {
            buffer.append('|');
            buffer.append(level);
        }
        return buffer.toString();
    }

    protected int[] getPcgenVersion() {
        return this.pcgenVersion;
    }

    protected int compareVersionTo(int[] inVer) {
        return CoreUtility.compareVersions(this.pcgenVersion, inVer);
    }

    protected String getPcgenVersionSuffix() {
        return this.pcgenVersionSuffix;
    }

    private void parseLevelAbilityInfo(PCGElement element, CDOMObject pObj) {
        this.parseLevelAbilityInfo(element, pObj, -9);
    }

    private void parseLevelAbilityInfo(PCGElement element, CDOMObject pObj, int level) {
        Iterator<PCGElement> it2 = element.getChildren().iterator();
        if (it2.hasNext()) {
            String dString = EntityEncoder.decode(it2.next().getText());
            PersistentTransitionChoice<?> ptc = null;
            try {
                ptc = Compatibility.processOldAdd(Globals.getContext(), dString);
            }
            catch (PersistenceLayerException ple) {
                this.warnings.add(pObj.getDisplayName() + "(" + pObj.getClass().getName() + ")\nCould not process LevelAbility: " + dString + "\n" + ple.getLocalizedMessage());
                return;
            }
            if (ptc == null) {
                this.warnings.add(pObj.getDisplayName() + "(" + pObj.getClass().getName() + ")\nCould not process LevelAbility: " + dString);
                return;
            }
            CDOMObject target = pObj;
            if (pObj instanceof PCClass) {
                target = this.thePC.getActiveClassLevel((PCClass)pObj, level);
            }
            for (PersistentTransitionChoice<?> tptc : target.getSafeListFor(ListKey.ADD)) {
                if (!tptc.equals(ptc)) continue;
                while (it2.hasNext()) {
                    String choice = EntityEncoder.decode(it2.next().getText());
                    this.thePC.addAssoc(tptc, AssociationListKey.ADD, choice);
                }
            }
        }
    }

    @Override
    public double getBaseFeatPool() {
        return this.baseFeatPool;
    }

    @Override
    public boolean isCalcFeatPoolAfterLoad() {
        return this.calcFeatPoolAfterLoad;
    }

    private void resolveLanguages() {
        boolean acted;
        CNAbility langbonus = this.thePC.getBonusLanguageAbility();
        int currentBonusLang = this.thePC.getDetailedAssociationCount(langbonus);
        boolean foundLang = currentBonusLang > 0;
        HashSet<Language> foundLanguages = new HashSet<Language>();
        foundLanguages.addAll(this.thePC.getLanguageSet());
        this.cachedLanguages.removeAll(foundLanguages);
        HashMapToList langSources = new HashMapToList();
        IdentityHashMap<Object, Integer> actorLimit = new IdentityHashMap<Object, Integer>();
        IdentityHashMap<PersistentTransitionChoice, CDOMObject> ptcSources = new IdentityHashMap<PersistentTransitionChoice, CDOMObject>();
        List<? extends CDOMObject> abilities = this.thePC.getCDOMObjectList();
        for (CDOMObject cDOMObject : abilities) {
            List<PersistentTransitionChoice<?>> addList = cDOMObject.getListFor(ListKey.ADD);
            if (addList == null) continue;
            for (PersistentTransitionChoice<?> ptc : addList) {
                SelectableSet ss = ptc.getChoices();
                if (!ss.getName().equals("LANGUAGE") || !LANGUAGE_CLASS.equals(ss.getChoiceClass())) continue;
                Collection selected = ss.getSet(this.thePC);
                for (Language l : selected) {
                    if (!this.cachedLanguages.contains(l)) continue;
                    String source = SourceFormat.getFormattedString(cDOMObject, Globals.getSourceDisplay(), true);
                    int choiceCount = ptc.getCount().resolve(this.thePC, source).intValue();
                    if (choiceCount <= 0) continue;
                    langSources.addToListFor((Object)l, ptc);
                    ptcSources.put(ptc, cDOMObject);
                    actorLimit.put(ptc, choiceCount);
                }
            }
        }
        if (!foundLang) {
            Set<Language> bonusAllowed = this.thePC.getLanguageBonusSelectionList();
            int n = this.thePC.getBonusLanguageCount();
            int choiceCount = n - currentBonusLang;
            if (choiceCount > 0) {
                for (Language l : bonusAllowed) {
                    if (!this.cachedLanguages.contains(l)) continue;
                    langSources.addToListFor((Object)l, (Object)langbonus);
                    actorLimit.put(langbonus, choiceCount);
                }
            }
        }
        boolean bl = acted = !this.cachedLanguages.isEmpty();
        while (acted) {
            acted = false;
            for (Language l : langSources.getKeySet()) {
                List actors = langSources.getListFor((Object)l);
                if (actors == null || actors.size() != 1) continue;
                Object actor = actors.get(0);
                acted = true;
                this.processRemoval(langbonus, (HashMapToList<Language, Object>)langSources, actorLimit, ptcSources, l, actor);
            }
            if (acted || langSources.isEmpty() || actorLimit.isEmpty()) continue;
            Language language = (Language)langSources.getKeySet().iterator().next();
            Object source = langSources.getListFor((Object)language).get(0);
            this.processRemoval(langbonus, (HashMapToList<Language, Object>)langSources, actorLimit, ptcSources, language, source);
            acted = true;
        }
        for (Language l : this.cachedLanguages) {
            this.warnings.add("Unable to find source: Character no longer speaks language: " + l.getDisplayName());
        }
    }

    protected void processRemoval(CNAbility langbonus, HashMapToList<Language, Object> sources, Map<Object, Integer> actorLimit, Map<PersistentTransitionChoice, CDOMObject> ptcSources, Language l, Object actor) {
        Integer limit = actorLimit.get(actor);
        this.processActor(langbonus, ptcSources, l, actor);
        this.cachedLanguages.remove(l);
        sources.removeListFor((Object)l);
        if (limit == 1) {
            for (Language lang : sources.getKeySet()) {
                sources.removeFromListFor((Object)lang, actor);
            }
            actorLimit.remove(actor);
        } else {
            actorLimit.put(actor, limit - 1);
        }
    }

    protected void processActor(CNAbility langbonus, Map<PersistentTransitionChoice, CDOMObject> ptcSources, Language l, Object actor) {
        if (actor instanceof CNAbility) {
            this.thePC.addSavedAbility(new CNAbilitySelection(langbonus, l.getKeyName()), UserSelection.getInstance(), UserSelection.getInstance());
        } else if (actor instanceof PersistentTransitionChoice) {
            PersistentTransitionChoice ptc = (PersistentTransitionChoice)actor;
            ptc.restoreChoice(this.thePC, ptcSources.get(ptc), l);
        } else {
            this.warnings.add("Internal Error: Language actor of " + actor.getClass() + " is not understood");
        }
    }

    public ClassSource getDomainSource(String aSource) {
        ClassSource cs;
        StringTokenizer aTok = new StringTokenizer(aSource, "|", false);
        if (aTok.countTokens() < 2) {
            Logging.errorPrint("Invalid Domain Source:" + aSource);
            return null;
        }
        aTok.nextToken();
        String classString = aTok.nextToken();
        PCClass cl = this.thePC.getClassKeyed(classString);
        if (cl == null) {
            Logging.errorPrint("Invalid Class in Domain Source:" + aSource);
            return null;
        }
        if (aTok.hasMoreTokens()) {
            int level = Integer.parseInt(aTok.nextToken());
            cs = new ClassSource(cl, level);
        } else {
            cs = new ClassSource(cl);
        }
        return cs;
    }

    private void insertDefaultClassSpellLists() {
        for (PCClass pcc : this.thePC.getClassList()) {
            this.thePC.addDefaultSpellList(pcc);
        }
    }

    public PCAlignment getNoAlignment() {
        return Globals.getContext().getReferenceContext().silentlyGetConstructedCDOMObject(PCAlignment.class, "None");
    }

    private static final class PCGTokenizer {
        private final List<PCGElement> elements;
        private final String innerDelimiter;
        private final String nestedStartDelimiter;
        private final String nestedStopDelimiter;
        private final String outerDelimiter;
        private final char nestedStartDelimiterChar;
        private final char nestedStopDelimiterChar;

        private PCGTokenizer(String line) throws PCGParseException {
            this(line, ":|[]");
        }

        private PCGTokenizer(String line, String delimiters) throws PCGParseException {
            char[] dels = delimiters.toCharArray();
            this.innerDelimiter = String.valueOf(dels[0]);
            this.outerDelimiter = String.valueOf(dels[1]);
            this.nestedStartDelimiter = String.valueOf(dels[2]);
            this.nestedStopDelimiter = String.valueOf(dels[3]);
            this.nestedStartDelimiterChar = this.nestedStartDelimiter.charAt(0);
            this.nestedStopDelimiterChar = this.nestedStopDelimiter.charAt(0);
            this.elements = new ArrayList<PCGElement>(0);
            this.tokenizeLine(line);
        }

        private List<PCGElement> getElements() {
            return this.elements;
        }

        private void checkSyntax(String line) throws PCGParseException {
            char[] chars = line.toCharArray();
            int delimCount = 0;
            for (int i = 0; i < chars.length; ++i) {
                if (chars[i] == this.nestedStartDelimiterChar) {
                    ++delimCount;
                    continue;
                }
                if (chars[i] != this.nestedStopDelimiterChar) continue;
                --delimCount;
            }
            if (delimCount < 0) {
                String message = "Missing " + this.nestedStartDelimiter;
                throw new PCGParseException("PCGTokenizer::checkSyntax", line, message);
            }
            if (delimCount > 0) {
                String message = "Missing " + this.nestedStopDelimiter;
                throw new PCGParseException("PCGTokenizer::checkSyntax", line, message);
            }
        }

        private void tokenizeLine(String line) throws PCGParseException {
            this.checkSyntax(line);
            PCGElement root = new PCGElement("root");
            this.tokenizeLine(root, line);
            this.elements.addAll(root.getChildren());
        }

        /*
         * Enabled aggressive block sorting
         */
        private void tokenizeLine(PCGElement parent, String line) throws PCGParseException {
            PCGElement element;
            String message;
            String token;
            String dels = this.outerDelimiter + this.nestedStartDelimiter + this.nestedStopDelimiter;
            StringTokenizer tokens = new StringTokenizer(line, dels, true);
            int nestedDepth = 0;
            String tag = null;
            StringBuilder buffer = new StringBuilder(1000);
            while (tokens.hasMoreTokens()) {
                token = tokens.nextToken().trim();
                if (token.equals(this.outerDelimiter)) {
                    if (nestedDepth == 0) {
                        if (buffer.length() <= 0) continue;
                        token = buffer.toString();
                        int index = token.indexOf(this.innerDelimiter);
                        if (index < 0) {
                            message = "Malformed PCG element: " + token;
                            throw new PCGParseException("PCGTokenizer::tokenizeLine", line, message);
                        }
                        buffer.delete(0, buffer.length());
                        element = new PCGElement(token.substring(0, index));
                        element.addContent(token.substring(index + 1));
                        parent.addContent(element);
                        continue;
                    }
                    buffer.append(token);
                    continue;
                }
                if (token.equals(this.nestedStartDelimiter)) {
                    block11: {
                        if (nestedDepth == 0) {
                            token = buffer.toString();
                            int index = token.indexOf(this.innerDelimiter);
                            if (index >= 0 && index == token.length() - 1) {
                                buffer.delete(0, buffer.length());
                                tag = token.substring(0, index);
                                break block11;
                            } else {
                                message = "Malformed PCG element: " + token;
                                throw new PCGParseException("PCGTokenizer::tokenizeLine", line, message);
                            }
                        }
                        buffer.append(token);
                    }
                    ++nestedDepth;
                    continue;
                }
                if (token.equals(this.nestedStopDelimiter)) {
                    if (--nestedDepth == 0) {
                        PCGElement element2 = new PCGElement(tag);
                        this.tokenizeLine(element2, buffer.toString());
                        parent.addContent(element2);
                        buffer.delete(0, buffer.length());
                        continue;
                    }
                    buffer.append(token);
                    continue;
                }
                buffer.append(token);
            }
            if (buffer.length() <= 0) return;
            token = buffer.toString();
            int index = token.indexOf(this.innerDelimiter);
            if (index >= 0) {
                buffer.delete(0, buffer.length());
                element = new PCGElement(token.substring(0, index));
                element.addContent(token.substring(index + 1));
                parent.addContent(element);
                return;
            }
            message = "Malformed PCG element: " + token;
            throw new PCGParseException("PCGTokenizer::tokenizeLine", line, message);
        }
    }

    private static final class PCGElement {
        private final String name;
        private List<PCGElement> children;
        private String text;

        private PCGElement(String aName) {
            this.name = aName;
        }

        public String toString() {
            StringBuilder buffer = new StringBuilder(1000);
            buffer.append('<').append(this.getName()).append('>').append("\n");
            buffer.append("<text>").append(this.getText()).append("</text>").append("\n");
            for (PCGElement child : this.getChildren()) {
                buffer.append(child.toString()).append("\n");
            }
            buffer.append("</").append(this.getName()).append('>');
            return buffer.toString();
        }

        public List<PCGElement> getChildren() {
            if (this.children == null) {
                this.children = new ArrayList<PCGElement>(0);
            }
            return this.children;
        }

        private String getName() {
            return this.name;
        }

        private String getText() {
            return this.text != null ? this.text : "";
        }

        private void addContent(PCGElement child) {
            if (this.children == null) {
                this.children = new ArrayList<PCGElement>(0);
            }
            this.children.add(child);
        }

        private void addContent(String argText) {
            this.text = argText;
        }
    }
}

