/*
 * Decompiled with CFR 0.152.
 */
package pcgen.io.migration;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import pcgen.core.system.MigrationRule;
import pcgen.io.migration.MigrationUtils;

public class AbilityMigration {
    private static Map<int[], List<MigrationRule>> abilityChangesForVer = new HashMap<int[], List<MigrationRule>>();

    public static CategorisedKey getNewAbilityKey(String abilityCategory, String abilityKey, int[] pcgVer, String gameModeName) {
        List<MigrationRule> abilityChangeList = abilityChangesForVer.get(pcgVer);
        if (abilityChangeList == null) {
            abilityChangeList = MigrationUtils.getChangeList(pcgVer, gameModeName, MigrationRule.ObjectType.ABILITY);
            abilityChangesForVer.put(pcgVer, abilityChangeList);
        }
        for (MigrationRule rule : abilityChangeList) {
            if (!rule.getOldKey().equalsIgnoreCase(abilityKey) || !rule.getOldCategory().equalsIgnoreCase(abilityCategory)) continue;
            return new CategorisedKey(rule.getNewCategory() == null ? abilityCategory : rule.getNewCategory(), rule.getNewKey());
        }
        return new CategorisedKey(abilityCategory, abilityKey);
    }

    public static class CategorisedKey {
        private final String category;
        private final String key;

        private CategorisedKey(String category, String key) {
            this.category = category;
            this.key = key;
        }

        public String getCategory() {
            return this.category;
        }

        public String getKey() {
            return this.key;
        }
    }
}

