/*
 * Decompiled with CFR 0.152.
 */
package pcgen.persistence;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Observable;
import java.util.Observer;
import java.util.Set;
import java.util.TreeSet;
import java.util.logging.Handler;
import java.util.logging.LogRecord;
import pcgen.base.util.HashMapToList;
import pcgen.cdom.base.Constants;
import pcgen.cdom.content.ContentDefinition;
import pcgen.cdom.content.fact.FactDefinition;
import pcgen.cdom.content.factset.FactSetDefinition;
import pcgen.cdom.enumeration.IntegerKey;
import pcgen.cdom.enumeration.ListKey;
import pcgen.cdom.enumeration.MapKey;
import pcgen.cdom.enumeration.ObjectKey;
import pcgen.cdom.enumeration.SourceFormat;
import pcgen.cdom.enumeration.StringKey;
import pcgen.cdom.enumeration.Type;
import pcgen.core.Ability;
import pcgen.core.AbilityCategory;
import pcgen.core.ArmorProf;
import pcgen.core.Campaign;
import pcgen.core.CustomData;
import pcgen.core.DataSet;
import pcgen.core.Deity;
import pcgen.core.Description;
import pcgen.core.Domain;
import pcgen.core.Equipment;
import pcgen.core.EquipmentList;
import pcgen.core.EquipmentModifier;
import pcgen.core.GameMode;
import pcgen.core.Globals;
import pcgen.core.Language;
import pcgen.core.PCAlignment;
import pcgen.core.PCCheck;
import pcgen.core.PCStat;
import pcgen.core.PCTemplate;
import pcgen.core.Race;
import pcgen.core.SettingsHandler;
import pcgen.core.ShieldProf;
import pcgen.core.Skill;
import pcgen.core.SystemCollections;
import pcgen.core.WeaponProf;
import pcgen.core.analysis.EqModAttachment;
import pcgen.core.prereq.PrereqHandler;
import pcgen.core.prereq.Prerequisite;
import pcgen.facade.core.CampaignFacade;
import pcgen.facade.core.DataSetFacade;
import pcgen.facade.core.SourceSelectionFacade;
import pcgen.facade.core.UIDelegate;
import pcgen.facade.util.DefaultListFacade;
import pcgen.io.PCGFile;
import pcgen.persistence.PersistenceLayerException;
import pcgen.persistence.PersistenceManager;
import pcgen.persistence.lst.AbilityCategoryLoader;
import pcgen.persistence.lst.AbilityLoader;
import pcgen.persistence.lst.BioSetLoader;
import pcgen.persistence.lst.CampaignLoader;
import pcgen.persistence.lst.CampaignSourceEntry;
import pcgen.persistence.lst.CompanionModLoader;
import pcgen.persistence.lst.FeatLoader;
import pcgen.persistence.lst.GenericLoader;
import pcgen.persistence.lst.KitLoader;
import pcgen.persistence.lst.LstFileLoader;
import pcgen.persistence.lst.PCClassLoader;
import pcgen.persistence.lst.SpellLoader;
import pcgen.rules.context.AbstractReferenceContext;
import pcgen.rules.context.LoadContext;
import pcgen.rules.context.LoadValidator;
import pcgen.rules.context.ReferenceContextUtilities;
import pcgen.rules.persistence.CDOMControlLoader;
import pcgen.system.ConfigurationSettings;
import pcgen.system.LanguageBundle;
import pcgen.system.PCGenSettings;
import pcgen.system.PCGenTask;
import pcgen.util.Logging;

public class SourceFileLoader
extends PCGenTask
implements Observer {
    private final HashMapToList<ListKey<?>, CampaignSourceEntry> fileLists = new HashMapToList();
    private PCClassLoader classLoader = new PCClassLoader();
    private GenericLoader<Language> languageLoader = new GenericLoader<Language>(Language.class);
    private AbilityCategoryLoader abilityCategoryLoader = new AbilityCategoryLoader();
    private CompanionModLoader companionModLoader = new CompanionModLoader();
    private KitLoader kitLoader = new KitLoader();
    private SpellLoader spellLoader = new SpellLoader();
    private BioSetLoader bioLoader = new BioSetLoader();
    private AbilityLoader abilityLoader = new AbilityLoader();
    private FeatLoader featLoader = new FeatLoader();
    private GenericLoader<PCTemplate> templateLoader = new GenericLoader<PCTemplate>(PCTemplate.class);
    private GenericLoader<Equipment> equipmentLoader = new GenericLoader<Equipment>(Equipment.class);
    private GenericLoader<EquipmentModifier> eqModLoader = new GenericLoader<EquipmentModifier>(EquipmentModifier.class);
    private GenericLoader<Race> raceLoader = new GenericLoader<Race>(Race.class);
    private GenericLoader<Skill> skillLoader = new GenericLoader<Skill>(Skill.class);
    private GenericLoader<WeaponProf> wProfLoader = new GenericLoader<WeaponProf>(WeaponProf.class);
    private GenericLoader<ArmorProf> aProfLoader = new GenericLoader<ArmorProf>(ArmorProf.class);
    private GenericLoader<ShieldProf> sProfLoader = new GenericLoader<ShieldProf>(ShieldProf.class);
    private GenericLoader<Deity> deityLoader = new GenericLoader<Deity>(Deity.class);
    private GenericLoader<Domain> domainLoader = new GenericLoader<Domain>(Domain.class);
    private GenericLoader<PCCheck> savesLoader = new GenericLoader<PCCheck>(PCCheck.class);
    private GenericLoader<PCAlignment> alignmentLoader = new GenericLoader<PCAlignment>(PCAlignment.class);
    private GenericLoader<PCStat> statLoader = new GenericLoader<PCStat>(PCStat.class);
    private CDOMControlLoader dataControlLoader = new CDOMControlLoader();
    private final List<CampaignSourceEntry> licenseFiles = new ArrayList<CampaignSourceEntry>();
    private final Set<String> sourcesSet = new TreeSet<String>();
    private List<Campaign> loadedCampaigns = new ArrayList<Campaign>();
    private StringBuilder sec15 = new StringBuilder(500);
    private StringBuilder licensesToDisplayString = new StringBuilder(500);
    private StringBuilder matureCampaigns = new StringBuilder(100);
    private final CampaignSourceEntry globalCampaign;
    private boolean showD20 = false;
    private boolean showLicensed = true;
    private boolean showMature = false;
    private boolean showOGL = false;
    private List<Campaign> selectedCampaigns;
    private GameMode selectedGame;
    private DataSet dataset = null;
    private int progress = 0;
    private final UIDelegate uiDelegate;

    public SourceFileLoader(SourceSelectionFacade selection, UIDelegate delegate) {
        for (ListKey lk : CampaignLoader.OBJECT_FILE_LISTKEY) {
            this.fileLists.initializeListFor((Object)lk);
        }
        this.uiDelegate = delegate;
        this.selectedCampaigns = new ArrayList<Campaign>();
        for (CampaignFacade campaign : selection.getCampaigns()) {
            Campaign camp = Globals.getCampaignKeyed(campaign.getName());
            this.selectedCampaigns.add(camp);
        }
        this.selectedGame = SystemCollections.getGameModeNamed(selection.getGameMode().getReference().getName());
        this.globalCampaign = new CampaignSourceEntry(new Campaign(), URI.create("file:/System%20Configuration%20Document"));
        this.abilityCategoryLoader.addObserver(this);
        this.bioLoader.addObserver(this);
        this.companionModLoader.addObserver(this);
        this.deityLoader.addObserver(this);
        this.domainLoader.addObserver(this);
        this.equipmentLoader.addObserver(this);
        this.eqModLoader.addObserver(this);
        this.abilityLoader.addObserver(this);
        this.featLoader.addObserver(this);
        this.kitLoader.addObserver(this);
        this.languageLoader.addObserver(this);
        this.classLoader.addObserver(this);
        this.raceLoader.addObserver(this);
        this.skillLoader.addObserver(this);
        this.spellLoader.addObserver(this);
        this.templateLoader.addObserver(this);
        this.wProfLoader.addObserver(this);
        this.aProfLoader.addObserver(this);
        this.sProfLoader.addObserver(this);
        this.savesLoader.addObserver(this);
        this.alignmentLoader.addObserver(this);
        this.statLoader.addObserver(this);
        this.dataControlLoader.addObserver(this);
    }

    @Override
    public void execute() {
        Globals.emptyLists();
        SettingsHandler.setGame(this.selectedGame.getName());
        Globals.initPreferences();
        Globals.emptyLists();
        LoadHandler handler = new LoadHandler();
        Logging.registerHandler(handler);
        try {
            this.loadCampaigns();
        }
        catch (PersistenceLayerException e) {
            Logging.errorPrint("Failed to load sources", e);
            this.uiDelegate.showErrorMessage("PCGen", "Failed to load sources, see log for details.");
        }
        Logging.removeHandler(handler);
    }

    public String getOGL() {
        return this.sec15.toString();
    }

    public String getLicenses() {
        return this.licensesToDisplayString.toString();
    }

    public List<String> getOtherLicenses() {
        ArrayList<String> licenses = new ArrayList<String>();
        for (CampaignSourceEntry licenseFile : this.licenseFiles) {
            try {
                StringBuilder dataBuffer = LstFileLoader.readFromURI(licenseFile.getURI());
                licenses.add(dataBuffer.toString());
            }
            catch (PersistenceLayerException e) {
                Logging.errorPrint("Could not read license at " + licenseFile, e);
            }
        }
        return licenses;
    }

    public String getMatureInfo() {
        return this.matureCampaigns.toString();
    }

    public DataSetFacade getDataSetFacade() {
        return this.dataset;
    }

    private int countTotalFilesToLoad() {
        int count = 0;
        for (ListKey lk : this.fileLists.getKeySet()) {
            count += this.fileLists.sizeOfListFor((Object)lk);
        }
        return count;
    }

    private void addCustomFilesToStartOfList() {
        File templateFile;
        File spellFile;
        File skillFile;
        File raceFile;
        File languageFile;
        File featFile;
        File abilityFile;
        File domainFile;
        File deityFile;
        File classFile;
        CampaignSourceEntry tempSource = null;
        Campaign customCampaign = new Campaign();
        customCampaign.setName("Custom");
        customCampaign.addToListFor(ListKey.DESCRIPTION, new Description("Custom data"));
        File bioSetFile = new File(CustomData.customBioSetFilePath(true));
        if (bioSetFile.exists()) {
            tempSource = new CampaignSourceEntry(customCampaign, bioSetFile.toURI());
            this.fileLists.removeFromListFor(ListKey.FILE_BIO_SET, (Object)tempSource);
            this.fileLists.addToListFor(ListKey.FILE_BIO_SET, 0, (Object)tempSource);
        }
        if ((classFile = new File(CustomData.customClassFilePath(true))).exists()) {
            tempSource = new CampaignSourceEntry(customCampaign, classFile.toURI());
            this.fileLists.removeFromListFor(ListKey.FILE_CLASS, (Object)tempSource);
            this.fileLists.addToListFor(ListKey.FILE_CLASS, 0, (Object)tempSource);
        }
        if ((deityFile = new File(CustomData.customDeityFilePath(true))).exists()) {
            tempSource = new CampaignSourceEntry(customCampaign, deityFile.toURI());
            this.fileLists.removeFromListFor(ListKey.FILE_DEITY, (Object)tempSource);
            this.fileLists.addToListFor(ListKey.FILE_DEITY, 0, (Object)tempSource);
        }
        if ((domainFile = new File(CustomData.customDomainFilePath(true))).exists()) {
            tempSource = new CampaignSourceEntry(customCampaign, domainFile.toURI());
            this.fileLists.removeFromListFor(ListKey.FILE_DOMAIN, (Object)tempSource);
            this.fileLists.addToListFor(ListKey.FILE_DOMAIN, 0, (Object)tempSource);
        }
        if ((abilityFile = new File(CustomData.customAbilityFilePath(true))).exists()) {
            tempSource = new CampaignSourceEntry(customCampaign, abilityFile.toURI());
            this.fileLists.removeFromListFor(ListKey.FILE_ABILITY, (Object)tempSource);
            this.fileLists.addToListFor(ListKey.FILE_ABILITY, 0, (Object)tempSource);
        }
        if ((featFile = new File(CustomData.customFeatFilePath(true))).exists()) {
            tempSource = new CampaignSourceEntry(customCampaign, featFile.toURI());
            this.fileLists.removeFromListFor(ListKey.FILE_FEAT, (Object)tempSource);
            this.fileLists.addToListFor(ListKey.FILE_FEAT, 0, (Object)tempSource);
        }
        if ((languageFile = new File(CustomData.customLanguageFilePath(true))).exists()) {
            tempSource = new CampaignSourceEntry(customCampaign, languageFile.toURI());
            this.fileLists.removeFromListFor(ListKey.FILE_LANGUAGE, (Object)tempSource);
            this.fileLists.addToListFor(ListKey.FILE_LANGUAGE, 0, (Object)tempSource);
        }
        if ((raceFile = new File(CustomData.customRaceFilePath(true))).exists()) {
            tempSource = new CampaignSourceEntry(customCampaign, raceFile.toURI());
            this.fileLists.removeFromListFor(ListKey.FILE_RACE, (Object)tempSource);
            this.fileLists.addToListFor(ListKey.FILE_RACE, 0, (Object)tempSource);
        }
        if ((skillFile = new File(CustomData.customSkillFilePath(true))).exists()) {
            tempSource = new CampaignSourceEntry(customCampaign, skillFile.toURI());
            this.fileLists.removeFromListFor(ListKey.FILE_SKILL, (Object)tempSource);
            this.fileLists.addToListFor(ListKey.FILE_SKILL, 0, (Object)tempSource);
        }
        if ((spellFile = new File(CustomData.customSpellFilePath(true))).exists()) {
            tempSource = new CampaignSourceEntry(customCampaign, spellFile.toURI());
            this.fileLists.removeFromListFor(ListKey.FILE_SPELL, (Object)tempSource);
            this.fileLists.addToListFor(ListKey.FILE_SPELL, 0, (Object)tempSource);
        }
        if ((templateFile = new File(CustomData.customTemplateFilePath(true))).exists()) {
            tempSource = new CampaignSourceEntry(customCampaign, templateFile.toURI());
            this.fileLists.removeFromListFor(ListKey.FILE_TEMPLATE, (Object)tempSource);
            this.fileLists.addToListFor(ListKey.FILE_TEMPLATE, 0, (Object)tempSource);
        }
    }

    private void addDefaultEquipmentMods(LoadContext context) throws PersistenceLayerException {
        URI uri = URI.create("file:/" + this.eqModLoader.getClass().getName() + ".java");
        context.setSourceURI(uri);
        CampaignSourceEntry source = new CampaignSourceEntry(new Campaign(), uri);
        String aLine = "Add Type\tKEY:ADDTYPE\tTYPE:ALL\tCOST:0\tNAMEOPT:NONAME\tSOURCELONG:PCGen Internal\tCHOOSE:EQBUILDER.EQTYPE|COUNT=ALL|TITLE=desired TYPE(s)";
        this.eqModLoader.parseLine(context, null, aLine, source);
        aLine = "PCGENi_WEAPON\tTYPE:Weapon\tVISIBLE:NO\tCHOOSE:NOCHOICE\tNAMEOPT:NONAME";
        this.eqModLoader.parseLine(context, null, aLine, source);
        aLine = "PCGENi_ARMOR\tTYPE:Armor\tVISIBLE:NO\tCHOOSE:NOCHOICE\tNAMEOPT:NONAME";
        this.eqModLoader.parseLine(context, null, aLine, source);
    }

    private void loadCampaigns() throws PersistenceLayerException {
        Globals.emptyLists();
        PersistenceManager pManager = PersistenceManager.getInstance();
        ArrayList<URI> uris = new ArrayList<URI>();
        for (CampaignFacade campaignFacade : this.selectedCampaigns) {
            uris.add(((Campaign)campaignFacade).getSourceURI());
        }
        pManager.setChosenCampaignSourcefiles(uris);
        this.sourcesSet.clear();
        this.licenseFiles.clear();
        if (this.selectedCampaigns.size() == 0) {
            throw new PersistenceLayerException("You must select at least one campaign to load.");
        }
        try {
            LoadContext context = Globals.getContext();
            this.loadCampaigns(this.selectedGame, this.selectedCampaigns, context);
            this.loadCustomItems(context);
            this.finishLoad(this.selectedCampaigns, context);
            this.verifyWeaponsMeleeOrRanged(context);
            if (PCGenSettings.OPTIONS_CONTEXT.initBoolean("autoCreateMagicMwEquip", false)) {
                EquipmentList.autoGenerateEquipment();
            }
            for (Campaign campaign : this.selectedCampaigns) {
                this.sourcesSet.add(SourceFormat.getFormattedString(campaign, SourceFormat.MEDIUM, true));
            }
            context.setLoaded(this.selectedCampaigns);
            context.loadCampaignFacets();
            this.dataset = new DataSet(context, this.selectedGame, new DefaultListFacade<CampaignFacade>(this.selectedCampaigns));
        }
        catch (Throwable thr) {
            Logging.errorPrint("Exception loading files.", thr);
            this.uiDelegate.showErrorMessage("PCGen", "Failed to load campaigns, see log for details.");
        }
    }

    private void loadCampaigns(GameMode gamemode, List<Campaign> aSelectedCampaignsList, LoadContext context) throws PersistenceLayerException {
        Logging.log(Logging.INFO, "Loading game " + gamemode + " and sources " + aSelectedCampaignsList + ".");
        File gameModeDir = new File(ConfigurationSettings.getSystemsDir(), "gameModes");
        File specificGameModeDir = new File(gameModeDir, gamemode.getFolderName());
        this.sortCampaignsByRank(aSelectedCampaignsList);
        Collection<Campaign> loaded = this.readPccFiles(aSelectedCampaignsList);
        this.addCustomFilesToStartOfList();
        this.setMaximum(this.countTotalFilesToLoad());
        List dataDefFileList = this.fileLists.getListFor(ListKey.FILE_DATACTRL);
        SourceFileLoader.addDefaultDataControlIfNeeded(dataDefFileList);
        this.dataControlLoader.loadLstFiles(context, dataDefFileList);
        SourceFileLoader.processFactDefinitions(context);
        this.abilityCategoryLoader.loadLstFiles(context, this.fileLists.getListFor(ListKey.FILE_ABILITY_CATEGORY));
        for (Campaign c : loaded) {
            c.applyTo(context.getReferenceContext());
        }
        this.statLoader.loadLstFiles(context, this.fileLists.getListFor(ListKey.FILE_STAT));
        this.savesLoader.loadLstFiles(context, this.fileLists.getListFor(ListKey.FILE_SAVE));
        this.alignmentLoader.loadLstFiles(context, this.fileLists.getListFor(ListKey.FILE_ALIGNMENT));
        this.wProfLoader.loadLstFiles(context, this.fileLists.getListFor(ListKey.FILE_WEAPON_PROF));
        WeaponProf wp = context.getReferenceContext().silentlyGetConstructedCDOMObject(WeaponProf.class, "Unarmed Strike");
        if (wp == null) {
            wp = new WeaponProf();
            wp.setName(LanguageBundle.getString("Equipment.UnarmedStrike"));
            wp.put(StringKey.KEY_NAME, "Unarmed Strike");
            wp.addToListFor(ListKey.TYPE, Type.SIMPLE);
            context.getReferenceContext().importObject(wp);
        }
        this.aProfLoader.loadLstFiles(context, this.fileLists.getListFor(ListKey.FILE_ARMOR_PROF));
        this.sProfLoader.loadLstFiles(context, this.fileLists.getListFor(ListKey.FILE_SHIELD_PROF));
        this.skillLoader.loadLstFiles(context, this.fileLists.getListFor(ListKey.FILE_SKILL));
        this.languageLoader.loadLstFiles(context, this.fileLists.getListFor(ListKey.FILE_LANGUAGE));
        this.featLoader.loadLstFiles(context, this.fileLists.getListFor(ListKey.FILE_FEAT));
        this.abilityLoader.loadLstFiles(context, this.fileLists.getListFor(ListKey.FILE_ABILITY));
        this.raceLoader.loadLstFiles(context, this.fileLists.getListFor(ListKey.FILE_RACE));
        this.domainLoader.loadLstFiles(context, this.fileLists.getListFor(ListKey.FILE_DOMAIN));
        this.spellLoader.loadLstFiles(context, this.fileLists.getListFor(ListKey.FILE_SPELL));
        this.deityLoader.loadLstFiles(context, this.fileLists.getListFor(ListKey.FILE_DEITY));
        this.classLoader.loadLstFiles(context, this.fileLists.getListFor(ListKey.FILE_CLASS));
        this.templateLoader.loadLstFiles(context, this.fileLists.getListFor(ListKey.FILE_TEMPLATE));
        this.eqModLoader.loadLstFiles(context, this.fileLists.getListFor(ListKey.FILE_EQUIP_MOD));
        this.equipmentLoader.loadLstFiles(context, this.fileLists.getListFor(ListKey.FILE_EQUIP));
        this.companionModLoader.loadLstFiles(context, this.fileLists.getListFor(ListKey.FILE_COMPANION_MOD));
        this.kitLoader.loadLstFiles(context, this.fileLists.getListFor(ListKey.FILE_KIT));
        this.bioLoader.setGameMode(gamemode.getName());
        this.bioLoader.loadLstFiles(context, this.fileLists.getListFor(ListKey.FILE_BIO_SET));
        this.checkRequiredDeities(specificGameModeDir, context);
        this.addDefaultEquipmentMods(context);
        this.classLoader.loadSubLines(context);
        System.gc();
    }

    public static void addDefaultDataControlIfNeeded(List<CampaignSourceEntry> dataDefFileList) {
        if (dataDefFileList.isEmpty()) {
            File gameModeDir = new File(ConfigurationSettings.getSystemsDir(), "gameModes");
            File defaultGameModeDir = new File(gameModeDir, "default");
            File df = new File(defaultGameModeDir, "compatibilityDataControl.lst");
            Campaign c = new Campaign();
            c.setName("Default Data Control File");
            CampaignSourceEntry cse = new CampaignSourceEntry(c, df.toURI());
            dataDefFileList.add(cse);
        }
    }

    public static void processFactDefinitions(LoadContext context) {
        Collection<ContentDefinition> defs = context.getReferenceContext().getConstructedCDOMObjects(FactDefinition.class);
        for (ContentDefinition fd : defs) {
            fd.activate(context);
        }
        defs = context.getReferenceContext().getConstructedCDOMObjects(FactSetDefinition.class);
        for (ContentDefinition fd : defs) {
            fd.activate(context);
        }
    }

    private void finishLoad(List<Campaign> aSelectedCampaignsList, LoadContext context) {
        SourceFileLoader.createLangBonusObject(context);
        AbstractReferenceContext refContext = context.getReferenceContext();
        refContext.buildDeferredObjects();
        refContext.buildDerivedObjects();
        this.referenceAllCategories(context);
        context.resolveDeferredTokens();
        LoadValidator validator = new LoadValidator(aSelectedCampaignsList);
        refContext.validate(validator);
        refContext.resolveReferences(validator);
        context.resolvePostValidationTokens();
        context.resolvePostDeferredTokens();
        ReferenceContextUtilities.validateAssociations(refContext, validator);
        for (Equipment eq : refContext.getConstructedCDOMObjects(Equipment.class)) {
            eq.setToCustomSize(null);
            EqModAttachment.finishEquipment(eq);
        }
    }

    private void referenceAllCategories(LoadContext context) {
        GameMode gamemode = SettingsHandler.getGame();
        for (AbilityCategory cat : gamemode.getAllAbilityCategories()) {
            context.getReferenceContext().getManufacturer(Ability.class, cat);
        }
    }

    public static void createLangBonusObject(LoadContext context) {
        Ability a = context.getReferenceContext().constructCDOMObject(Ability.class, "*LANGBONUS");
        context.getReferenceContext().reassociateCategory(AbilityCategory.LANGBONUS, a);
        a.put(ObjectKey.INTERNAL, true);
        context.unconditionallyProcess(a, "CHOOSE", "LANG|!PC,LANGBONUS");
        context.unconditionallyProcess(a, "VISIBLE", "NO");
        context.unconditionallyProcess(a, "AUTO", "LANG|%LIST");
        context.unconditionallyProcess(a, "MULT", "YES");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadCustomItems(LoadContext context) {
        if (!PCGenSettings.OPTIONS_CONTEXT.getBoolean("saveCustomInLst")) {
            return;
        }
        BufferedReader br = CustomData.getCustomEquipmentReader();
        EquipmentList.setAutoGeneration(true);
        try {
            String aLine;
            while (br != null && (aLine = br.readLine()) != null) {
                int idx;
                if (!aLine.startsWith("BASEITEM:") || (idx = aLine.indexOf(9, 9)) < 10) continue;
                String baseItemKey = aLine.substring(9, idx);
                aLine = aLine.substring(idx + 1);
                Equipment aEq = context.getReferenceContext().silentlyGetConstructedCDOMObject(Equipment.class, baseItemKey);
                if (aEq == null) continue;
                aEq = aEq.clone();
                aEq.setBase();
                aEq.load(aLine, "\t", ":", null);
                if (!aEq.isType("Custom")) {
                    aEq.addType(Type.CUSTOM);
                }
                context.getReferenceContext().importObject(aEq);
            }
            CustomData.setCustomItemsLoaded(true);
        }
        catch (IOException e) {
            this.logError("Error when loading custom items", e);
        }
        finally {
            EquipmentList.setAutoGeneration(false);
            try {
                if (br != null) {
                    br.close();
                }
            }
            catch (IOException ex) {
                this.logError("Error when closing infile after loading custom items", ex);
            }
        }
    }

    private void checkRequiredDeities(File dir, LoadContext context) throws PersistenceLayerException {
        context.setSourceURI(new File(dir, "miscinfo.lst").toURI());
        List<String> gDeities = Globals.getGlobalDeityList();
        if (gDeities != null && gDeities.size() != 0) {
            for (String aLine : gDeities) {
                this.deityLoader.parseLine(context, null, aLine, this.globalCampaign);
            }
        }
    }

    private void verifyWeaponsMeleeOrRanged(LoadContext context) throws PersistenceLayerException {
        for (Equipment aEq : context.getReferenceContext().getConstructedCDOMObjects(Equipment.class)) {
            if (!aEq.isWeapon() || aEq.isMelee() || aEq.isRanged()) continue;
            throw new PersistenceLayerException("Weapon: " + aEq.getName() + " is neither Melee nor Ranged." + Constants.LINE_SEPARATOR + "PCGen" + " cannot calculate \"to hit\" unless one of these is selected." + Constants.LINE_SEPARATOR + "Source: " + aEq.getSourceURI());
        }
    }

    private void sortCampaignsByRank(List<Campaign> aSelectedCampaignsList) {
        Collections.sort(aSelectedCampaignsList, new Comparator<Campaign>(){

            @Override
            public int compare(Campaign c1, Campaign c2) {
                return c1.getSafe(IntegerKey.CAMPAIGN_RANK) - c2.getSafe(IntegerKey.CAMPAIGN_RANK);
            }
        });
    }

    private void logError(String message, Throwable e) {
        Logging.errorPrint(message, e);
    }

    private Collection<Campaign> readPccFiles(List<Campaign> aSelectedCampaignsList) {
        HashSet<Campaign> loadedSet = new HashSet<Campaign>();
        for (Campaign campaign : aSelectedCampaignsList) {
            if (Logging.isDebugMode()) {
                Logging.debugPrint("Loading campaign " + campaign);
            }
            this.loadedCampaigns.add(campaign);
            List<String> copyright = campaign.getListFor(ListKey.SECTION_15);
            if (copyright != null) {
                this.sec15.append("<br><b>Source Material:</b>");
                this.sec15.append(SourceFormat.getFormattedString(campaign, SourceFormat.LONG, true));
                this.sec15.append("<br>");
                this.sec15.append("<b>Section 15 Entry in Source Material:</b><br>");
                for (String license : copyright) {
                    this.sec15.append(license).append("<br>");
                }
            }
            this.showOGL |= campaign.getSafe(ObjectKey.IS_OGL).booleanValue();
            this.showD20 |= campaign.getSafe(ObjectKey.IS_D20).booleanValue();
            this.showLicensed |= campaign.getSafe(ObjectKey.IS_LICENSED).booleanValue();
            if (campaign.getSafe(ObjectKey.IS_LICENSED).booleanValue()) {
                List<CampaignSourceEntry> licenseURIs;
                List<String> licenseList = campaign.getSafeListFor(ListKey.LICENSE);
                if (licenseList != null && licenseList.size() > 0) {
                    this.licensesToDisplayString.append(licenseList);
                }
                if ((licenseURIs = campaign.getSafeListFor(ListKey.LICENSE_FILE)) != null) {
                    this.licenseFiles.addAll(licenseURIs);
                }
            }
            this.showMature |= campaign.getSafe(ObjectKey.IS_MATURE).booleanValue();
            if (campaign.getSafe(ObjectKey.IS_MATURE).booleanValue()) {
                this.matureCampaigns.append(SourceFormat.LONG.getField(campaign) + " (" + campaign.getSafe(StringKey.PUB_NAME_LONG) + ")<br>");
            }
            this.addQualifiedSources(campaign, ListKey.FILE_LST_EXCLUDE);
            for (ListKey lk : CampaignLoader.OBJECT_FILE_LISTKEY) {
                this.addQualifiedSources(campaign, lk);
            }
            loadedSet.add(campaign);
            if (PCGenSettings.OPTIONS_CONTEXT.initBoolean("optionAllowedInSources", true)) {
                SourceFileLoader.setCampaignOptions(campaign);
            }
            for (CampaignSourceEntry fName : campaign.getSafeListFor(ListKey.FILE_PCC)) {
                URI uri = fName.getURI();
                if (PCGFile.isPCGenCampaignFile(uri)) {
                    loadedSet.add(Globals.getCampaignByURI(uri, false));
                    continue;
                }
                Logging.errorPrint("The referenced source " + uri + " is not valid.");
            }
        }
        this.stripLstExcludes();
        return loadedSet;
    }

    private void addQualifiedSources(Campaign c, ListKey<CampaignSourceEntry> lk) {
        for (CampaignSourceEntry cse : c.getSafeListFor(lk)) {
            List<Prerequisite> prerequisites = cse.getPrerequisites();
            if (!prerequisites.isEmpty() && !PrereqHandler.passesAll(prerequisites, null, cse)) continue;
            this.fileLists.addToListFor(lk, (Object)cse);
        }
    }

    private static void setCampaignOptions(Campaign aCamp) {
        Set<String> keys = aCamp.getKeysFor(MapKey.PROPERTY);
        if (keys != null) {
            for (String key : keys) {
                String value = aCamp.get(MapKey.PROPERTY, key);
                if (key.contains(".")) {
                    PCGenSettings.getInstance().setProperty(key, value);
                } else {
                    PCGenSettings.OPTIONS_CONTEXT.setProperty(key, value);
                }
                SettingsHandler.setPCGenOption(key, value);
            }
            for (GameMode game : SystemCollections.getUnmodifiableGameModeList()) {
                game.applyPreferences();
            }
        }
    }

    private void stripLstExcludes() {
        for (ListKey lk : this.fileLists.getKeySet()) {
            if (ListKey.FILE_LST_EXCLUDE.equals(lk)) continue;
            this.stripLstExcludes(lk);
        }
    }

    private void stripLstExcludes(ListKey<?> lk) {
        List excludes = this.fileLists.getListFor(ListKey.FILE_LST_EXCLUDE);
        if (excludes != null) {
            for (CampaignSourceEntry exc : excludes) {
                URI uri = exc.getURI();
                for (CampaignSourceEntry cse : this.fileLists.getListFor(lk)) {
                    if (!cse.getURI().equals(uri)) continue;
                    this.fileLists.removeFromListFor(lk, (Object)cse);
                }
            }
        }
    }

    public boolean hasD20Campaign() {
        return this.showD20;
    }

    public boolean hasMatureCampaign() {
        return this.showMature;
    }

    public boolean hasOGLCampaign() {
        return this.showOGL;
    }

    public boolean hasLicensedCampaign() {
        return this.showLicensed;
    }

    @Override
    public void update(Observable o, Object arg) {
        if (arg instanceof URI) {
            ++this.progress;
            URI uri = (URI)arg;
            if ("file".equalsIgnoreCase(uri.getScheme())) {
                this.setProgress(new File(uri).getName(), this.progress);
            } else {
                this.setProgress(String.valueOf(uri), this.progress);
            }
        } else if (arg instanceof Exception) {
            this.sendErrorMessage((Exception)arg);
        }
    }

    private class LoadHandler
    extends Handler {
        public LoadHandler() {
            this.setLevel(Logging.LST_WARNING);
        }

        @Override
        public void close() throws SecurityException {
        }

        @Override
        public void flush() {
        }

        @Override
        public void publish(LogRecord arg0) {
            SourceFileLoader.this.sendErrorMessage(arg0);
        }
    }
}

