/*
 * Decompiled with CFR 0.152.
 */
package pcgen.persistence.lst;

import java.net.URI;
import pcgen.cdom.base.Loadable;
import pcgen.core.PointBuyCost;
import pcgen.core.PointBuyMethod;
import pcgen.persistence.lst.SimpleLoader;
import pcgen.rules.context.LoadContext;
import pcgen.util.Logging;

public class PointBuyLoader
extends SimpleLoader<Loadable> {
    public PointBuyLoader() {
        super(Loadable.class);
    }

    @Override
    protected Loadable getLoadable(LoadContext context, String token, URI sourceURI) {
        Class loadClass;
        int colonLoc = token.indexOf(58);
        if (colonLoc == -1) {
            Logging.errorPrint("Invalid Token - does not contain a colon: '" + token + "' in " + sourceURI);
            return null;
        }
        if (colonLoc == 0) {
            Logging.errorPrint("Invalid Token - starts with a colon: '" + token + "' in " + sourceURI);
            return null;
        }
        if (colonLoc == token.length() - 1) {
            Logging.errorPrint("Invalid Token - ends with a colon (no value): '" + token + "' in " + sourceURI);
            return null;
        }
        String key = token.substring(0, colonLoc);
        if ("METHOD".equals(key)) {
            loadClass = PointBuyMethod.class;
        } else if ("STAT".equals(key)) {
            loadClass = PointBuyCost.class;
        } else {
            Logging.errorPrint("Invalid Token '" + key + "' as the first key in " + sourceURI);
            return null;
        }
        String name = token.substring(colonLoc + 1);
        if (name == null || name.isEmpty()) {
            Logging.errorPrint("Invalid Token '" + key + "' had no value in " + sourceURI);
            return null;
        }
        PointBuyMethod loadable = context.getReferenceContext().constructCDOMObject(loadClass, name.intern());
        loadable.setSourceURI(sourceURI);
        return loadable;
    }
}

