/*
 * Decompiled with CFR 0.152.
 */
package pcgen.rules.context;

import java.util.ArrayList;
import java.util.List;
import pcgen.base.util.DoubleKeyMapToList;
import pcgen.base.util.HashMapToList;
import pcgen.cdom.base.Categorized;
import pcgen.cdom.base.Category;
import pcgen.cdom.base.Loadable;
import pcgen.cdom.enumeration.ListKey;
import pcgen.cdom.reference.CDOMSingleRef;
import pcgen.cdom.reference.CDOMTransparentCategorizedSingleRef;
import pcgen.cdom.reference.Qualifier;
import pcgen.cdom.reference.UnconstructedValidator;
import pcgen.core.Campaign;

public class LoadValidator
implements UnconstructedValidator {
    private static final Class<Categorized> CATEGORIZED_CLASS = Categorized.class;
    private final List<Campaign> campaignList;
    private HashMapToList<Class<?>, String> simpleMap;
    private DoubleKeyMapToList<Class<?>, String, String> categoryMap;

    public LoadValidator(List<Campaign> campaigns) {
        this.campaignList = new ArrayList<Campaign>(campaigns);
    }

    @Override
    public <T> boolean allow(Class<T> cl, String s) {
        List list;
        if (this.simpleMap == null) {
            this.buildSimpleMap();
        }
        if ((list = this.simpleMap.getListFor(cl)) != null) {
            for (String key : list) {
                if (!key.equalsIgnoreCase(s)) continue;
                return true;
            }
        }
        return false;
    }

    private void buildSimpleMap() {
        this.simpleMap = new HashMapToList();
        for (Campaign c : this.campaignList) {
            for (Qualifier q : c.getSafeListFor(ListKey.FORWARDREF)) {
                Class<? extends Loadable> qcl = q.getQualifiedClass();
                if (CATEGORIZED_CLASS.isAssignableFrom(qcl)) continue;
                this.simpleMap.addToListFor(qcl, (Object)q.getQualifiedReference().getLSTformat(false));
            }
        }
    }

    private void buildCategoryMap() {
        this.categoryMap = new DoubleKeyMapToList();
        for (Campaign c : this.campaignList) {
            for (Qualifier q : c.getSafeListFor(ListKey.FORWARDREF)) {
                Class<? extends Loadable> qcl = q.getQualifiedClass();
                if (!CATEGORIZED_CLASS.isAssignableFrom(qcl)) continue;
                CDOMSingleRef<? extends Loadable> ref = q.getQualifiedReference();
                String cat = ((CDOMTransparentCategorizedSingleRef)ref).getLSTCategory();
                this.categoryMap.addToListFor(qcl, (Object)cat, (Object)ref.getLSTformat(false));
            }
        }
    }

    @Override
    public <T extends Categorized<T>> boolean allow(Class<T> cl, Category<T> cat, String s) {
        List list;
        if (this.categoryMap == null) {
            this.buildCategoryMap();
        }
        if ((list = this.categoryMap.getListFor(cl, (Object)cat.getKeyName())) != null) {
            for (String key : list) {
                if (!key.equalsIgnoreCase(s)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean allowDuplicates(Class<?> cl) {
        for (Campaign c : this.campaignList) {
            if (!c.containsInList(ListKey.DUPES_ALLOWED, cl)) continue;
            return true;
        }
        return false;
    }
}

