/*
 * Decompiled with CFR 0.152.
 */
package pcgen.util;

import java.math.BigDecimal;
import pcgen.util.Logging;

public class BigDecimalHelper {
    public static BigDecimal formatBigDecimal(BigDecimal n, int dp) {
        return n.setScale(dp, 4);
    }

    public static BigDecimal trimBigDecimal(BigDecimal n) {
        if (n.unscaledValue().intValue() == 0) {
            return BigDecimal.ZERO;
        }
        if (n.scale() <= 0) {
            return n;
        }
        BigDecimal stripped = n.stripTrailingZeros();
        if (stripped.scale() < 0) {
            stripped = n.setScale(0);
        }
        return stripped;
    }

    public static String trimZeros(String numberToTrim) {
        BigDecimal aBigD = BigDecimal.ZERO;
        try {
            aBigD = new BigDecimal(numberToTrim);
        }
        catch (NumberFormatException exc) {
            Logging.errorPrint("Cannot trim zeroes from " + numberToTrim + " as is not a number. Using 0 instead.");
        }
        return BigDecimalHelper.trimBigDecimal(aBigD).toString();
    }

    public static String trimZeros(BigDecimal n) {
        return BigDecimalHelper.trimBigDecimal(n).toString();
    }
}

