/*
 * Decompiled with CFR 0.152.
 */
package plugin.initiative.gui;

import java.util.Enumeration;
import javax.swing.JTable;
import javax.swing.table.DefaultTableColumnModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;

public class AutoSizingColumnModel
extends DefaultTableColumnModel {
    private static final int COLUMN_WIDTH_PADDING = 10;
    JTable m_table = null;

    public void setColumnPreferredWidth(TableColumn aColumn) {
        if (this.m_table != null) {
            TableCellRenderer renderer = null;
            int rowCount = this.m_table.getRowCount();
            int headerWidth = 0;
            int contentsWidth = 0;
            renderer = aColumn.getHeaderRenderer() != null ? aColumn.getHeaderRenderer() : this.m_table.getTableHeader().getDefaultRenderer();
            if (renderer != null) {
                headerWidth = renderer.getTableCellRendererComponent((JTable)this.m_table, (Object)aColumn.getHeaderValue(), (boolean)false, (boolean)false, (int)0, (int)0).getPreferredSize().width;
            }
            if ((renderer = this.m_table.getDefaultRenderer(this.m_table.getModel().getColumnClass(this.getColumnCount()))) != null && this.getColumnCount() > 0) {
                for (int row = 0; row < rowCount; ++row) {
                    contentsWidth = Math.max(contentsWidth, renderer.getTableCellRendererComponent((JTable)this.m_table, (Object)this.m_table.getModel().getValueAt((int)row, (int)this.getColumnCount()), (boolean)false, (boolean)false, (int)row, (int)0).getPreferredSize().width);
                }
            }
            aColumn.setPreferredWidth(Math.max(headerWidth, contentsWidth) + this.getColumnMargin() + 10);
        } else {
            aColumn.setPreferredWidth(150);
        }
    }

    public int getTotalPreferredWidth() {
        int returnValue = 0;
        Enumeration<TableColumn> columns = this.getColumns();
        while (columns.hasMoreElements()) {
            returnValue += columns.nextElement().getPreferredWidth();
        }
        return returnValue;
    }

    @Override
    public void addColumn(TableColumn aColumn) {
        this.setColumnPreferredWidth(aColumn);
        super.addColumn(aColumn);
    }

    public void referenceTable(JTable table) {
        this.m_table = table;
    }
}

