/*
 * Decompiled with CFR 0.152.
 */
package plugin.lsttokens;

import java.util.ArrayList;
import java.util.Collection;
import java.util.StringTokenizer;
import pcgen.cdom.base.CDOMObject;
import pcgen.cdom.base.Ungranted;
import pcgen.cdom.enumeration.ListKey;
import pcgen.core.SpecialAbility;
import pcgen.core.prereq.Prerequisite;
import pcgen.rules.context.Changes;
import pcgen.rules.context.LoadContext;
import pcgen.rules.persistence.token.AbstractTokenWithSeparator;
import pcgen.rules.persistence.token.CDOMPrimaryToken;
import pcgen.rules.persistence.token.ParseResult;

public class SabLst
extends AbstractTokenWithSeparator<CDOMObject>
implements CDOMPrimaryToken<CDOMObject> {
    @Override
    public String getTokenName() {
        return "SAB";
    }

    @Override
    protected char separator() {
        return '|';
    }

    @Override
    protected ParseResult parseTokenWithSeparator(LoadContext context, CDOMObject obj, String aString) {
        if (obj instanceof Ungranted) {
            return new ParseResult.Fail("Cannot use " + this.getTokenName() + " on an Ungranted object type: " + obj.getClass().getSimpleName(), context);
        }
        StringTokenizer tok = new StringTokenizer(aString, "|");
        String firstToken = tok.nextToken();
        if (this.looksLikeAPrerequisite(firstToken)) {
            return new ParseResult.Fail("Cannot have only PRExxx subtoken in " + this.getTokenName(), context);
        }
        boolean foundClear = false;
        if (".CLEAR".equals(firstToken)) {
            context.getObjectContext().removeList(obj, ListKey.SAB);
            if (!tok.hasMoreTokens()) {
                return ParseResult.SUCCESS;
            }
            firstToken = tok.nextToken();
            foundClear = true;
        }
        if (this.looksLikeAPrerequisite(firstToken)) {
            return new ParseResult.Fail("Cannot use PREREQs when using .CLEAR in " + this.getTokenName(), context);
        }
        if (".CLEAR".equals(firstToken)) {
            return new ParseResult.Fail("SA tag confused by redundant '.CLEAR'" + aString, context);
        }
        SpecialAbility sa = new SpecialAbility(firstToken.intern());
        if (!tok.hasMoreTokens()) {
            sa.setName(firstToken.intern());
            context.getObjectContext().addToList(obj, ListKey.SAB, sa);
            return ParseResult.SUCCESS;
        }
        StringBuilder saName = new StringBuilder(aString.length());
        saName.append(firstToken);
        String token = tok.nextToken();
        while (true) {
            if (".CLEAR".equals(token)) {
                return new ParseResult.Fail("SA tag confused by '.CLEAR' as a middle token: " + aString, context);
            }
            if (this.looksLikeAPrerequisite(token)) break;
            saName.append("|").append(token);
            if (!tok.hasMoreTokens()) {
                sa.setName(saName.toString());
                context.getObjectContext().addToList(obj, ListKey.SAB, sa);
                return ParseResult.SUCCESS;
            }
            token = tok.nextToken();
        }
        sa.setName(saName.toString());
        if (foundClear) {
            return new ParseResult.Fail("Cannot use PREREQs when using .CLEAR and a Special Ability in " + this.getTokenName(), context);
        }
        while (true) {
            Prerequisite prereq;
            if ((prereq = this.getPrerequisite(token)) == null) {
                return new ParseResult.Fail("   (Did you put Abilities after the PRExxx tags in " + this.getTokenName() + ":?)", context);
            }
            sa.addPrerequisite(prereq);
            if (!tok.hasMoreTokens()) break;
            token = tok.nextToken();
        }
        context.getObjectContext().addToList(obj, ListKey.SAB, sa);
        return ParseResult.SUCCESS;
    }

    @Override
    public String[] unparse(LoadContext context, CDOMObject obj) {
        Changes<SpecialAbility> changes = context.getObjectContext().getListChanges(obj, ListKey.SAB);
        Collection<SpecialAbility> added = changes.getAdded();
        ArrayList<String> list = new ArrayList<String>();
        if (changes.includesGlobalClear()) {
            list.add(".CLEAR");
        } else if (added == null || added.isEmpty()) {
            return null;
        }
        if (added != null) {
            for (SpecialAbility ab : added) {
                StringBuilder sb = new StringBuilder();
                sb.append(ab.getLSTformat());
                if (ab.hasPrerequisites()) {
                    sb.append("|");
                    sb.append(this.getPrerequisiteString(context, ab.getPrerequisiteList()));
                }
                list.add(sb.toString());
            }
        }
        return list.toArray(new String[list.size()]);
    }

    @Override
    public Class<CDOMObject> getTokenClass() {
        return CDOMObject.class;
    }
}

