/*
 * Decompiled with CFR 0.152.
 */
package plugin.lsttokens;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.StringTokenizer;
import java.util.TreeSet;
import pcgen.base.lang.StringUtil;
import pcgen.base.util.TreeMapToList;
import pcgen.cdom.base.CDOMObject;
import pcgen.cdom.base.CDOMReference;
import pcgen.cdom.base.Categorized;
import pcgen.cdom.base.Category;
import pcgen.cdom.base.Loadable;
import pcgen.cdom.enumeration.ListKey;
import pcgen.cdom.reference.CDOMSingleRef;
import pcgen.cdom.reference.CategorizedCDOMReference;
import pcgen.cdom.reference.ReferenceManufacturer;
import pcgen.core.Ability;
import pcgen.core.PCClass;
import pcgen.core.PObject;
import pcgen.core.Race;
import pcgen.core.Skill;
import pcgen.rules.context.Changes;
import pcgen.rules.context.LoadContext;
import pcgen.rules.persistence.token.AbstractTokenWithSeparator;
import pcgen.rules.persistence.token.CDOMPrimaryToken;
import pcgen.rules.persistence.token.ComplexParseResult;
import pcgen.rules.persistence.token.ParseResult;
import pcgen.util.StringPClassUtil;

public class ServesAsToken
extends AbstractTokenWithSeparator<CDOMObject>
implements CDOMPrimaryToken<CDOMObject> {
    @Override
    public String getTokenName() {
        return "SERVESAS";
    }

    public List<Class<? extends PObject>> getLegalTypes() {
        return Arrays.asList(PCClass.class, Ability.class, Skill.class, Race.class);
    }

    @Override
    protected ParseResult parseNonEmptyToken(LoadContext context, CDOMObject obj, String value) {
        if (!this.getLegalTypes().contains(obj.getClass())) {
            ComplexParseResult cpr = new ComplexParseResult();
            cpr.addErrorMessage("Cannot use SERVESAS on a " + obj.getClass());
            cpr.addErrorMessage("   bad use found in " + obj.getClass().getSimpleName() + " " + obj.getKeyName());
            return cpr;
        }
        return super.parseNonEmptyToken(context, obj, value);
    }

    @Override
    protected char separator() {
        return '|';
    }

    @Override
    protected ParseResult parseTokenWithSeparator(LoadContext context, CDOMObject obj, String value) {
        StringTokenizer st = new StringTokenizer(value, "|");
        String firstToken = st.nextToken();
        ReferenceManufacturer<? extends Loadable> rm = context.getManufacturer(firstToken);
        if (rm == null) {
            return new ParseResult.Fail(this.getTokenName() + " unable to generate manufacturer for type: " + value, context);
        }
        if (!st.hasMoreTokens()) {
            return new ParseResult.Fail(this.getTokenName() + " must include at least one target object", context);
        }
        if (!rm.getReferenceClass().equals(obj.getClass())) {
            return new ParseResult.Fail(this.getTokenName() + " expecting a POBJECT Type valid for " + obj.getClass().getSimpleName() + ", found: " + firstToken, context);
        }
        String servekey = StringPClassUtil.getStringFor(obj.getClass());
        ListKey<CDOMReference> listkey = ListKey.getKeyFor(CDOMReference.class, "SERVES_AS_" + servekey);
        while (st.hasMoreTokens()) {
            CDOMSingleRef ref = rm.getReference(st.nextToken());
            context.getObjectContext().addToList(obj, listkey, ref);
        }
        return ParseResult.SUCCESS;
    }

    @Override
    public String[] unparse(LoadContext context, CDOMObject obj) {
        String key = StringPClassUtil.getStringFor(obj.getClass());
        ListKey<CDOMReference> listkey = ListKey.getKeyFor(CDOMReference.class, "SERVES_AS_" + key);
        Changes<CDOMReference> changes = context.getObjectContext().getListChanges(obj, listkey);
        Collection<CDOMReference> removedItems = changes.getRemoved();
        if (removedItems != null && !removedItems.isEmpty() || changes.includesGlobalClear()) {
            context.addWriteMessage(this.getTokenName() + " does not support .CLEAR");
            return null;
        }
        if (!changes.hasAddedItems()) {
            return null;
        }
        TreeMapToList map = new TreeMapToList();
        for (CDOMReference ref : changes.getAdded()) {
            String mapKey = key;
            if (Categorized.class.isAssignableFrom(obj.getClass())) {
                Category cat = ((CategorizedCDOMReference)((Object)ref)).getCDOMCategory();
                mapKey = mapKey + '=' + cat.toString();
            }
            map.addToListFor((Object)mapKey, (Object)ref.getLSTformat(false));
        }
        ArrayList<String> returnList = new ArrayList<String>();
        for (String mapKey : map.getKeySet()) {
            TreeSet set = new TreeSet(map.getListFor((Object)mapKey));
            returnList.add(mapKey + '|' + StringUtil.joinToStringBuilder(set, (String)"|"));
        }
        return returnList.toArray(new String[returnList.size()]);
    }

    @Override
    public Class<CDOMObject> getTokenClass() {
        return CDOMObject.class;
    }
}

