/*
 * Decompiled with CFR 0.152.
 */
package plugin.lsttokens.campaign;

import java.util.Collection;
import java.util.TreeSet;
import pcgen.cdom.enumeration.ListKey;
import pcgen.core.Campaign;
import pcgen.persistence.lst.CampaignSourceEntry;
import pcgen.rules.context.Changes;
import pcgen.rules.context.LoadContext;
import pcgen.rules.persistence.token.AbstractTokenWithSeparator;
import pcgen.rules.persistence.token.CDOMPrimaryToken;
import pcgen.rules.persistence.token.ParseResult;

public class BiosetToken
extends AbstractTokenWithSeparator<Campaign>
implements CDOMPrimaryToken<Campaign> {
    @Override
    public String getTokenName() {
        return "BIOSET";
    }

    @Override
    protected char separator() {
        return '|';
    }

    @Override
    protected ParseResult parseTokenWithSeparator(LoadContext context, Campaign campaign, String value) {
        CampaignSourceEntry cse = context.getCampaignSourceEntry(campaign, value);
        if (cse == null) {
            return ParseResult.INTERNAL_ERROR;
        }
        if (!cse.getIncludeItems().isEmpty()) {
            return new ParseResult.Fail(this.getTokenName() + " does not allow INCLUDE: " + value, context);
        }
        if (!cse.getExcludeItems().isEmpty()) {
            return new ParseResult.Fail(this.getTokenName() + " does not allow EXCLUDE: " + value, context);
        }
        context.getObjectContext().addToList(campaign, ListKey.FILE_BIO_SET, cse);
        return ParseResult.SUCCESS;
    }

    @Override
    public String[] unparse(LoadContext context, Campaign campaign) {
        Changes<CampaignSourceEntry> cseChanges = context.getObjectContext().getListChanges(campaign, ListKey.FILE_BIO_SET);
        Collection<CampaignSourceEntry> added = cseChanges.getAdded();
        if (added == null) {
            return null;
        }
        TreeSet<String> set = new TreeSet<String>();
        for (CampaignSourceEntry cse : added) {
            set.add(cse.getLSTformat());
        }
        return set.toArray(new String[set.size()]);
    }

    @Override
    public Class<Campaign> getTokenClass() {
        return Campaign.class;
    }
}

