/*
 * Decompiled with CFR 0.152.
 */
package plugin.lsttokens.load;

import pcgen.core.system.LoadInfo;
import pcgen.rules.context.LoadContext;
import pcgen.rules.persistence.token.AbstractNonEmptyToken;
import pcgen.rules.persistence.token.CDOMPrimaryToken;
import pcgen.rules.persistence.token.DeferredToken;
import pcgen.rules.persistence.token.ParseResult;
import pcgen.util.Logging;

public class EncumbranceToken
extends AbstractNonEmptyToken<LoadInfo>
implements CDOMPrimaryToken<LoadInfo>,
DeferredToken<LoadInfo> {
    @Override
    public String getTokenName() {
        return "ENCUMBRANCE";
    }

    @Override
    protected ParseResult parseNonEmptyToken(LoadContext context, LoadInfo info, String value) {
        Integer checkPenalty;
        String moveFormula;
        double mult;
        String[] tokens = value.split("\\|");
        int tokenCount = tokens.length;
        if (tokenCount != 2 && tokenCount != 4) {
            return new ParseResult.Fail("Expected " + this.getTokenName() + " to have 2 or 4 arguments, found: " + value, context);
        }
        String multString = tokens[1];
        int divLoc = multString.indexOf(47);
        if (divLoc == -1) {
            try {
                mult = Double.parseDouble(multString);
            }
            catch (NumberFormatException e) {
                return new ParseResult.Fail("Expected " + this.getTokenName() + " multiple to be a decimal (or a fraction), found: " + multString, context);
            }
        } else {
            if (divLoc != multString.lastIndexOf(47)) {
                return new ParseResult.Fail("Expected " + this.getTokenName() + " multiple to be a decimal or a fraction, found: " + multString, context);
            }
            mult = Double.parseDouble(multString.substring(0, divLoc)) / Double.parseDouble(multString.substring(divLoc + 1));
        }
        if (tokenCount == 4) {
            moveFormula = tokens[2];
            try {
                checkPenalty = Integer.valueOf(tokens[3]);
            }
            catch (NumberFormatException e) {
                return new ParseResult.Fail("Expected " + this.getTokenName() + " penalty to be an integer, found: " + tokens[3], context);
            }
        } else {
            moveFormula = "";
            checkPenalty = 0;
        }
        info.addLoadMultiplier(tokens[0].toUpperCase(), new Float(mult), moveFormula, checkPenalty);
        return ParseResult.SUCCESS;
    }

    @Override
    public String[] unparse(LoadContext context, LoadInfo info) {
        return null;
    }

    @Override
    public Class<LoadInfo> getTokenClass() {
        return LoadInfo.class;
    }

    @Override
    public Class<LoadInfo> getDeferredTokenClass() {
        return LoadInfo.class;
    }

    @Override
    public boolean process(LoadContext context, LoadInfo info) {
        if (info.getLoadMultiplierCount() == 0) {
            Logging.errorPrint("Warning: load.lst for game mode " + info.getDisplayName() + " does not contain load category definitions. " + "No weight categories will be available. " + "Please refer to the documentation for the Load List file. See: " + info.getSourceURI());
            return false;
        }
        if (info.getLoadMultiplier("LIGHT") == null || info.getLoadMultiplier("MEDIUM") == null || info.getLoadMultiplier("HEAVY") == null) {
            Logging.errorPrint("Warning: load.lst for game mode " + info.getDisplayName() + " does not contain load category definitions " + "for 'Light', 'Medium' and 'Heavy'. " + "Please refer to the documentation for the Load List file. See: " + info.getSourceURI());
            return false;
        }
        return true;
    }
}

