/*
 * Decompiled with CFR 0.152.
 */
package plugin.lsttokens.pcclass;

import java.util.Collection;
import java.util.StringTokenizer;
import java.util.TreeSet;
import pcgen.base.lang.StringUtil;
import pcgen.cdom.enumeration.ListKey;
import pcgen.core.PCClass;
import pcgen.core.SpellProhibitor;
import pcgen.rules.context.Changes;
import pcgen.rules.context.LoadContext;
import pcgen.rules.persistence.token.AbstractTokenWithSeparator;
import pcgen.rules.persistence.token.CDOMPrimaryToken;
import pcgen.rules.persistence.token.ParseResult;
import pcgen.util.enumeration.ProhibitedSpellType;

public class ProhibitedToken
extends AbstractTokenWithSeparator<PCClass>
implements CDOMPrimaryToken<PCClass> {
    @Override
    public String getTokenName() {
        return "PROHIBITED";
    }

    @Override
    protected char separator() {
        return ',';
    }

    @Override
    protected ParseResult parseTokenWithSeparator(LoadContext context, PCClass pcc, String value) {
        StringTokenizer elements = new StringTokenizer(value, ",");
        while (elements.hasMoreTokens()) {
            String aValue = elements.nextToken();
            if (aValue.equalsIgnoreCase("None")) continue;
            SpellProhibitor prohibSchool = new SpellProhibitor();
            prohibSchool.setType(ProhibitedSpellType.SCHOOL);
            prohibSchool.addValue(aValue);
            context.getObjectContext().addToList(pcc, ListKey.PROHIBITED_SPELLS, prohibSchool);
            SpellProhibitor prohibSubSchool = new SpellProhibitor();
            prohibSubSchool.setType(ProhibitedSpellType.SUBSCHOOL);
            prohibSubSchool.addValue(aValue);
            context.getObjectContext().addToList(pcc, ListKey.PROHIBITED_SPELLS, prohibSubSchool);
        }
        return ParseResult.SUCCESS;
    }

    @Override
    public String[] unparse(LoadContext context, PCClass pcc) {
        Changes<SpellProhibitor> changes = context.getObjectContext().getListChanges(pcc, ListKey.PROHIBITED_SPELLS);
        Collection<SpellProhibitor> added = changes.getAdded();
        if (added == null || added.isEmpty()) {
            return null;
        }
        TreeSet<String> set = new TreeSet<String>();
        for (SpellProhibitor sp : added) {
            set.addAll(sp.getValueList());
        }
        return new String[]{StringUtil.join(set, (String)",")};
    }

    @Override
    public Class<PCClass> getTokenClass() {
        return PCClass.class;
    }
}

