/*
 * Decompiled with CFR 0.152.
 */
package plugin.lsttokens.tempbonus;

import java.util.Collection;
import java.util.TreeSet;
import java.util.regex.Pattern;
import pcgen.cdom.base.CDOMObject;
import pcgen.cdom.enumeration.ListKey;
import pcgen.core.bonus.Bonus;
import pcgen.core.bonus.BonusObj;
import pcgen.rules.context.Changes;
import pcgen.rules.context.LoadContext;
import pcgen.rules.persistence.token.AbstractTokenWithSeparator;
import pcgen.rules.persistence.token.CDOMSecondaryToken;
import pcgen.rules.persistence.token.ParseResult;

public class AnyPCToken
extends AbstractTokenWithSeparator<CDOMObject>
implements CDOMSecondaryToken<CDOMObject> {
    @Override
    public String getTokenName() {
        return "ANYPC";
    }

    @Override
    public ParseResult parseTokenWithSeparator(LoadContext context, CDOMObject obj, String value) {
        String v = value.replaceAll(Pattern.quote("<this>"), obj.getKeyName());
        BonusObj bon = Bonus.newBonus(context, v);
        if (bon == null) {
            return new ParseResult.Fail(this.getFullTokenName() + " was given invalid type: " + value, context);
        }
        bon.setTokenSource(this.getFullTokenName());
        context.getObjectContext().addToList(obj, ListKey.BONUS_ANYPC, bon);
        return ParseResult.SUCCESS;
    }

    @Override
    public String[] unparse(LoadContext context, CDOMObject obj) {
        Changes<BonusObj> changes = context.getObjectContext().getListChanges(obj, ListKey.BONUS_ANYPC);
        Collection<BonusObj> added = changes.getAdded();
        if (added == null || added.isEmpty()) {
            return null;
        }
        TreeSet<String> bonusSet = new TreeSet<String>();
        for (BonusObj bonus : added) {
            bonusSet.add(bonus.getLSTformat());
        }
        return bonusSet.toArray(new String[bonusSet.size()]);
    }

    @Override
    public Class<CDOMObject> getTokenClass() {
        return CDOMObject.class;
    }

    @Override
    public String getParentToken() {
        return "TEMPBONUS";
    }

    private String getFullTokenName() {
        return "TEMPBONUS:ANYPC";
    }

    @Override
    protected char separator() {
        return '|';
    }
}

