/*
 * Decompiled with CFR 0.152.
 */
package coursier.cache.internal;

import coursier.cache.ArtifactError;
import coursier.cache.ArtifactError$NotFound$;
import coursier.cache.CacheDefaults$;
import coursier.cache.CacheLocks$;
import coursier.cache.CacheLogger;
import coursier.cache.CacheLogger$;
import coursier.cache.CachePolicy;
import coursier.cache.CacheUrl$;
import coursier.cache.ConnectionBuilder$;
import coursier.cache.internal.Downloader;
import coursier.cache.internal.Downloader$UnknownProtocol$;
import coursier.cache.internal.Retry;
import coursier.core.Authentication;
import coursier.credentials.DirectCredentials;
import coursier.util.Artifact;
import coursier.util.Sync;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URLConnection;
import java.nio.file.AccessDeniedException;
import java.time.Clock;
import java.util.concurrent.ExecutorService;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLSocketFactory;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.Some;
import scala.Tuple2;
import scala.collection.immutable.$colon$colon;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.FiniteDuration;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.Nothing$;
import scala.util.Either;
import scala.util.Left;
import scala.util.Properties$;
import scala.util.Right;
import scala.util.control.NonFatal$;

public final class Downloader$
implements Serializable {
    public static final Downloader$ MODULE$ = new Downloader$();
    private static boolean throwExceptions;
    private static final Seq<String> coursier$cache$internal$Downloader$$checksumHeader;
    private static volatile boolean bitmap$0;

    static {
        coursier$cache$internal$Downloader$$checksumHeader = new $colon$colon<Nothing$>((Nothing$)((Object)"MD5"), (List<Nothing$>)new $colon$colon<Nothing$>((Nothing$)((Object)"SHA1"), (List<Nothing$>)new $colon$colon<Nothing$>((Nothing$)((Object)"SHA256"), Nil$.MODULE$)));
    }

    private boolean throwExceptions$lzycompute() {
        Downloader$ downloader$ = this;
        synchronized (downloader$) {
            if (!bitmap$0) {
                throwExceptions = Boolean.getBoolean("coursier.cache.throw-exceptions");
                bitmap$0 = true;
            }
        }
        return throwExceptions;
    }

    public boolean throwExceptions() {
        if (!bitmap$0) {
            return this.throwExceptions$lzycompute();
        }
        return throwExceptions;
    }

    public Seq<String> coursier$cache$internal$Downloader$$checksumHeader() {
        return coursier$cache$internal$Downloader$$checksumHeader;
    }

    public void coursier$cache$internal$Downloader$$readFullyTo(InputStream in, OutputStream out, CacheLogger logger, String url, long alreadyDownloaded, int bufferSize) {
        byte[] b = (byte[])Array$.MODULE$.fill(bufferSize, () -> 0, ClassTag$.MODULE$.Byte());
        this.helper$1(alreadyDownloaded, in, b, out, logger, url);
    }

    public <T> Either<ArtifactError, T> coursier$cache$internal$Downloader$$downloading(String url, File file, Retry retry, Function0<Either<ArtifactError, T>> f, Function0<Option<Either<ArtifactError, T>>> ifLocked) {
        return (Either)retry.retryOpt((Function0<Option> & Serializable)() -> {
            Some some;
            try {
                Option res0 = CacheLocks$.MODULE$.withUrlLock(url, (Function0<Either> & Serializable)() -> {
                    Either either;
                    try {
                        either = (Either)f.apply();
                    }
                    catch (Throwable throwable) {
                        FileNotFoundException fileNotFoundException;
                        Throwable throwable2 = throwable;
                        if (throwable2 instanceof FileNotFoundException && (fileNotFoundException = (FileNotFoundException)throwable2).getMessage() != null) {
                            either = new Left(new ArtifactError.NotFound(fileNotFoundException.getMessage(), ArtifactError$NotFound$.MODULE$.$lessinit$greater$default$2()));
                        }
                        throw throwable;
                    }
                    return either;
                });
                some = res0.orElse(ifLocked);
            }
            catch (Throwable throwable) {
                Throwable throwable2;
                Option<Tuple2<MalformedURLException, String>> option;
                Option<Throwable> option2;
                Throwable throwable3 = throwable;
                if (throwable3 != null && !(option2 = NonFatal$.MODULE$.unapply(throwable3)).isEmpty()) {
                    Throwable e = option2.get();
                    if (MODULE$.throwExceptions()) {
                        ArtifactError.DownloadError ex = new ArtifactError.DownloadError(new StringBuilder(26).append("Caught ").append(e.getClass().getName()).append(Option$.MODULE$.apply(e.getMessage()).fold((Function0<String> & Serializable)() -> "", (Function1<String, String> & Serializable)x$25 -> new StringBuilder(3).append(" (").append((String)x$25).append(")").toString())).append(" while downloading ").append(url).toString(), new Some<Throwable>(e));
                        throw ex;
                    }
                }
                if (throwable3 != null && !(option = Downloader$UnknownProtocol$.MODULE$.unapply(throwable3)).isEmpty()) {
                    MalformedURLException e = option.get()._1();
                    String msg0 = option.get()._2();
                    String docUrl = "https://get-coursier.io/docs/extra.html#extra-protocols";
                    String msg = new $colon$colon<Nothing$>((Nothing$)((Object)new StringBuilder(30).append("Caught ").append(e.getClass().getName()).append(" (").append(msg0).append(") while downloading ").append(url).append(".").toString()), (List<Nothing$>)new $colon$colon<Nothing$>((Nothing$)((Object)new StringBuilder(47).append("Visit ").append(docUrl).append(" to learn how to handle custom protocols.").toString()), Nil$.MODULE$)).mkString(" ");
                    ArtifactError.DownloadError ex = new ArtifactError.DownloadError(msg, new Some<Throwable>(e));
                    some = new Some(new Left(ex));
                }
                if (throwable3 != null && NonFatal$.MODULE$.apply(throwable2 = throwable3)) {
                    ArtifactError.DownloadError ex = new ArtifactError.DownloadError(new StringBuilder(26).append("Caught ").append(throwable2.getClass().getName()).append(Option$.MODULE$.apply(throwable2.getMessage()).fold((Function0<String> & Serializable)() -> "", (Function1<String, String> & Serializable)x$26 -> new StringBuilder(3).append(" (").append((String)x$26).append(")").toString())).append(" while downloading ").append(url).toString(), new Some<Throwable>(throwable2));
                    some = new Some(new Left(ex));
                }
                throw throwable;
            }
            return some;
        }, (PartialFunction<Throwable, BoxedUnit>)((Object)new Serializable(){
            private static final long serialVersionUID = 0L;

            public final <A1 extends Throwable, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1 = x1;
                if (A1 instanceof AccessDeniedException && Properties$.MODULE$.isWin()) {
                    return (B1)BoxedUnit.UNIT;
                }
                if (A1 instanceof SSLException) {
                    return (B1)BoxedUnit.UNIT;
                }
                return function1.apply(x1);
            }

            public final boolean isDefinedAt(Throwable x1) {
                Throwable throwable = x1;
                if (throwable instanceof AccessDeniedException && Properties$.MODULE$.isWin()) {
                    return true;
                }
                return throwable instanceof SSLException;
            }
        }));
    }

    public Either<ArtifactError, Option<Object>> coursier$cache$internal$Downloader$$contentLength(String url, Option<Authentication> authentication, boolean followHttpToHttpsRedirections, boolean followHttpsToHttpRedirections, Seq<DirectCredentials> credentials, Option<SSLSocketFactory> sslSocketFactoryOpt, Option<HostnameVerifier> hostnameVerifierOpt, CacheLogger logger, Option<Object> maxRedirectionsOpt) {
        Left<ArtifactError, Option<Object>> left;
        block9: {
            URLConnection conn;
            block8: {
                conn = null;
                try {
                    URLConnection uRLConnection = conn = ConnectionBuilder$.MODULE$.apply(url).withAuthentication(authentication).withFollowHttpToHttpsRedirections(followHttpToHttpsRedirections).withFollowHttpsToHttpRedirections(followHttpsToHttpRedirections).withAutoCredentials(credentials).withSslSocketFactoryOpt(sslSocketFactoryOpt).withHostnameVerifierOpt(hostnameVerifierOpt).withMethod("HEAD").withMaxRedirectionsOpt(maxRedirectionsOpt).connection();
                    if (uRLConnection instanceof HttpURLConnection) {
                        HttpURLConnection httpURLConnection = (HttpURLConnection)uRLConnection;
                        logger.gettingLength(url);
                        boolean success = false;
                        try {
                            Option<Object> len = new Some<Long>(BoxesRunTime.boxToLong(httpURLConnection.getContentLengthLong())).filter(x$27 -> x$27 >= 0L);
                            success = true;
                            logger.gettingLengthResult(url, len);
                            left = new Right(len);
                            break block8;
                        }
                        finally {
                            if (!success) {
                                logger.gettingLengthResult(url, None$.MODULE$);
                            }
                        }
                    }
                    left = new Left(new ArtifactError.DownloadError(new StringBuilder(42).append("Cannot do HEAD request with connection ").append(uRLConnection).append(" (").append(url).append(")").toString(), None$.MODULE$));
                }
                catch (Throwable throwable) {
                    if (conn != null) {
                        CacheUrl$.MODULE$.closeConn(conn);
                    }
                    throw throwable;
                }
            }
            if (conn == null) break block9;
            CacheUrl$.MODULE$.closeConn(conn);
        }
        return left;
    }

    public <F> Downloader<F> apply(Artifact artifact, CachePolicy cachePolicy, File location, Seq<String> actualChecksums, F allCredentials, Sync<F> S) {
        return new Downloader<F>(artifact, cachePolicy, location, actualChecksums, allCredentials, CacheLogger$.MODULE$.nop(), CacheDefaults$.MODULE$.pool(), CacheDefaults$.MODULE$.ttl(), false, true, false, CacheDefaults$.MODULE$.maxRedirections(), CacheDefaults$.MODULE$.retryCount(), None$.MODULE$, None$.MODULE$, CacheDefaults$.MODULE$.bufferSize(), Nil$.MODULE$, Clock.systemDefaultZone(), CacheDefaults$.MODULE$.retryCount(), CacheDefaults$.MODULE$.retryBackoffInitialDelay(), CacheDefaults$.MODULE$.retryBackoffMultiplier(), S);
    }

    public <F> Downloader<F> apply(Artifact artifact, CachePolicy cachePolicy, File location, Seq<String> actualChecksums, F allCredentials, CacheLogger logger, ExecutorService pool, Option<Duration> ttl, boolean localArtifactsShouldBeCached, boolean followHttpToHttpsRedirections, boolean followHttpsToHttpRedirections, Option<Object> maxRedirections, int sslRetry, Option<SSLSocketFactory> sslSocketFactoryOpt, Option<HostnameVerifier> hostnameVerifierOpt, int bufferSize, Sync<F> S) {
        return new Downloader<F>(artifact, cachePolicy, location, actualChecksums, allCredentials, logger, pool, ttl, localArtifactsShouldBeCached, followHttpToHttpsRedirections, followHttpsToHttpRedirections, maxRedirections, sslRetry, sslSocketFactoryOpt, hostnameVerifierOpt, bufferSize, Nil$.MODULE$, Clock.systemDefaultZone(), CacheDefaults$.MODULE$.retryCount(), CacheDefaults$.MODULE$.retryBackoffInitialDelay(), CacheDefaults$.MODULE$.retryBackoffMultiplier(), S);
    }

    public <F> Downloader<F> apply(Artifact artifact, CachePolicy cachePolicy, File location, Seq<String> actualChecksums, F allCredentials, CacheLogger logger, ExecutorService pool, Option<Duration> ttl, boolean localArtifactsShouldBeCached, boolean followHttpToHttpsRedirections, boolean followHttpsToHttpRedirections, Option<Object> maxRedirections, int sslRetry, Option<SSLSocketFactory> sslSocketFactoryOpt, Option<HostnameVerifier> hostnameVerifierOpt, int bufferSize, Seq<ClassLoader> classLoaders, Sync<F> S) {
        return new Downloader<F>(artifact, cachePolicy, location, actualChecksums, allCredentials, logger, pool, ttl, localArtifactsShouldBeCached, followHttpToHttpsRedirections, followHttpsToHttpRedirections, maxRedirections, sslRetry, sslSocketFactoryOpt, hostnameVerifierOpt, bufferSize, classLoaders, Clock.systemDefaultZone(), CacheDefaults$.MODULE$.retryCount(), CacheDefaults$.MODULE$.retryBackoffInitialDelay(), CacheDefaults$.MODULE$.retryBackoffMultiplier(), S);
    }

    public <F> Downloader<F> apply(Artifact artifact, CachePolicy cachePolicy, File location, Seq<String> actualChecksums, F allCredentials, CacheLogger logger, ExecutorService pool, Option<Duration> ttl, boolean localArtifactsShouldBeCached, boolean followHttpToHttpsRedirections, boolean followHttpsToHttpRedirections, Option<Object> maxRedirections, int sslRetry, Option<SSLSocketFactory> sslSocketFactoryOpt, Option<HostnameVerifier> hostnameVerifierOpt, int bufferSize, Seq<ClassLoader> classLoaders, Clock clock, Sync<F> S) {
        return new Downloader<F>(artifact, cachePolicy, location, actualChecksums, allCredentials, logger, pool, ttl, localArtifactsShouldBeCached, followHttpToHttpsRedirections, followHttpsToHttpRedirections, maxRedirections, sslRetry, sslSocketFactoryOpt, hostnameVerifierOpt, bufferSize, classLoaders, clock, CacheDefaults$.MODULE$.retryCount(), CacheDefaults$.MODULE$.retryBackoffInitialDelay(), CacheDefaults$.MODULE$.retryBackoffMultiplier(), S);
    }

    public <F> Downloader<F> apply(Artifact artifact, CachePolicy cachePolicy, File location, Seq<String> actualChecksums, F allCredentials, CacheLogger logger, ExecutorService pool, Option<Duration> ttl, boolean localArtifactsShouldBeCached, boolean followHttpToHttpsRedirections, boolean followHttpsToHttpRedirections, Option<Object> maxRedirections, int sslRetry, Option<SSLSocketFactory> sslSocketFactoryOpt, Option<HostnameVerifier> hostnameVerifierOpt, int bufferSize, Seq<ClassLoader> classLoaders, Clock clock, int retryCount, Sync<F> S) {
        return new Downloader<F>(artifact, cachePolicy, location, actualChecksums, allCredentials, logger, pool, ttl, localArtifactsShouldBeCached, followHttpToHttpsRedirections, followHttpsToHttpRedirections, maxRedirections, sslRetry, sslSocketFactoryOpt, hostnameVerifierOpt, bufferSize, classLoaders, clock, retryCount, CacheDefaults$.MODULE$.retryBackoffInitialDelay(), CacheDefaults$.MODULE$.retryBackoffMultiplier(), S);
    }

    public <F> Downloader<F> apply(Artifact artifact, CachePolicy cachePolicy, File location, Seq<String> actualChecksums, F allCredentials, CacheLogger logger, ExecutorService pool, Option<Duration> ttl, boolean localArtifactsShouldBeCached, boolean followHttpToHttpsRedirections, boolean followHttpsToHttpRedirections, Option<Object> maxRedirections, int sslRetry, Option<SSLSocketFactory> sslSocketFactoryOpt, Option<HostnameVerifier> hostnameVerifierOpt, int bufferSize, Seq<ClassLoader> classLoaders, Clock clock, int retryCount, FiniteDuration retryBackoffInitialDelay2, Sync<F> S) {
        return new Downloader<F>(artifact, cachePolicy, location, actualChecksums, allCredentials, logger, pool, ttl, localArtifactsShouldBeCached, followHttpToHttpsRedirections, followHttpsToHttpRedirections, maxRedirections, sslRetry, sslSocketFactoryOpt, hostnameVerifierOpt, bufferSize, classLoaders, clock, retryCount, retryBackoffInitialDelay2, CacheDefaults$.MODULE$.retryBackoffMultiplier(), S);
    }

    public <F> Downloader<F> apply(Artifact artifact, CachePolicy cachePolicy, File location, Seq<String> actualChecksums, F allCredentials, CacheLogger logger, ExecutorService pool, Option<Duration> ttl, boolean localArtifactsShouldBeCached, boolean followHttpToHttpsRedirections, boolean followHttpsToHttpRedirections, Option<Object> maxRedirections, int sslRetry, Option<SSLSocketFactory> sslSocketFactoryOpt, Option<HostnameVerifier> hostnameVerifierOpt, int bufferSize, Seq<ClassLoader> classLoaders, Clock clock, int retryCount, FiniteDuration retryBackoffInitialDelay2, double retryBackoffMultiplier, Sync<F> S) {
        return new Downloader<F>(artifact, cachePolicy, location, actualChecksums, allCredentials, logger, pool, ttl, localArtifactsShouldBeCached, followHttpToHttpsRedirections, followHttpsToHttpRedirections, maxRedirections, sslRetry, sslSocketFactoryOpt, hostnameVerifierOpt, bufferSize, classLoaders, clock, retryCount, retryBackoffInitialDelay2, retryBackoffMultiplier, S);
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(Downloader$.class);
    }

    private final void helper$1(long count, InputStream in$1, byte[] b$1, OutputStream out$1, CacheLogger logger$2, String url$9) {
        int read2;
        while ((read2 = in$1.read(b$1)) >= 0) {
            out$1.write(b$1, 0, read2);
            out$1.flush();
            logger$2.downloadProgress(url$9, count + (long)read2);
            count += (long)read2;
        }
    }

    private Downloader$() {
    }
}

