/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.execution.history.impl;

import com.google.common.collect.ImmutableMultimap;
import java.util.Map;
import org.gradle.internal.fingerprint.FileCollectionFingerprint;
import org.gradle.internal.fingerprint.FileSystemLocationFingerprint;
import org.gradle.internal.fingerprint.FingerprintingStrategy;
import org.gradle.internal.hash.HashCode;

public class SerializableFileCollectionFingerprint
implements FileCollectionFingerprint {
    private final Map<String, FileSystemLocationFingerprint> fingerprints;
    private final ImmutableMultimap<String, HashCode> rootHashes;
    private final HashCode strategyConfigurationHash;

    public SerializableFileCollectionFingerprint(Map<String, FileSystemLocationFingerprint> fingerprints, ImmutableMultimap<String, HashCode> rootHashes, HashCode strategyConfigurationHash) {
        this.fingerprints = fingerprints;
        this.rootHashes = rootHashes;
        this.strategyConfigurationHash = strategyConfigurationHash;
    }

    public Map<String, FileSystemLocationFingerprint> getFingerprints() {
        return this.fingerprints;
    }

    public ImmutableMultimap<String, HashCode> getRootHashes() {
        return this.rootHashes;
    }

    public boolean wasCreatedWithStrategy(FingerprintingStrategy strategy) {
        return strategy.getConfigurationHash().equals((Object)this.strategyConfigurationHash);
    }

    public HashCode getStrategyConfigurationHash() {
        return this.strategyConfigurationHash;
    }
}

