/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.properties.annotations;

import com.google.common.collect.ImmutableSet;
import java.util.Optional;
import java.util.stream.Collectors;
import org.gradle.api.Action;
import org.gradle.api.NonNullApi;
import org.gradle.api.problems.DocLink;
import org.gradle.api.problems.Severity;
import org.gradle.internal.deprecation.Documentation;
import org.gradle.internal.reflect.problems.ValidationProblemId;
import org.gradle.internal.reflect.validation.TypeAwareProblemBuilder;
import org.gradle.internal.reflect.validation.TypeValidationContext;

@NonNullApi
public class NestedValidationUtil {
    private static final ImmutableSet<Class<?>> SUPPORTED_KEY_TYPES = ImmutableSet.of(Enum.class, Integer.class, String.class);

    public static void validateBeanType(TypeValidationContext validationContext, String propertyName, Class<?> beanType) {
        NestedValidationUtil.getUnsupportedReason(beanType).ifPresent(reason -> validationContext.visitPropertyProblem((Action<? super TypeAwareProblemBuilder>)((Action)problem -> problem.forProperty(propertyName).label("with nested type '" + beanType.getName() + "' is not supported", new Object[0]).documentedAt((DocLink)Documentation.userManual((String)"validation_problems", (String)"unsupported_nested_type")).noLocation().type(ValidationProblemId.NESTED_TYPE_UNSUPPORTED.name()).group("type_validation").severity(Severity.WARNING).details(reason).solution("Use a different input annotation if type is not a bean").solution("Use a different package that doesn't conflict with standard Java or Kotlin types for custom types"))));
    }

    private static Optional<String> getUnsupportedReason(Class<?> type) {
        if (type.getName().startsWith("java.") || type.getName().startsWith("javax.")) {
            return Optional.of("Type is in 'java.*' or 'javax.*' package that are reserved for standard Java API types");
        }
        if (type.getName().startsWith("kotlin.")) {
            return Optional.of("Type is in 'kotlin.*' package that is reserved for Kotlin stdlib types");
        }
        if (type.getName().startsWith("groovy.lang.GString")) {
            return Optional.of("Groovy's GString type is not supported as a nested type");
        }
        return Optional.empty();
    }

    public static void validateKeyType(TypeValidationContext validationContext, String propertyName, Class<?> keyType) {
        if (!SUPPORTED_KEY_TYPES.contains(keyType)) {
            validationContext.visitPropertyProblem((Action<? super TypeAwareProblemBuilder>)((Action)problem -> problem.forProperty(propertyName).label("where key of nested map is of type '" + keyType.getName() + "'", new Object[0]).documentedAt((DocLink)Documentation.userManual((String)"validation_problems", (String)"unsupported_key_type_of_nested_map")).noLocation().type(ValidationProblemId.NESTED_MAP_UNSUPPORTED_KEY_TYPE.name()).group("type_validation").severity(Severity.WARNING).details("Key of nested map must be one of the following types: " + NestedValidationUtil.getSupportedKeyTypes()).solution("Change type of key to one of the following types: " + NestedValidationUtil.getSupportedKeyTypes())));
        }
    }

    private static String getSupportedKeyTypes() {
        return SUPPORTED_KEY_TYPES.stream().map(cls -> "'" + cls.getSimpleName() + "'").collect(Collectors.joining(", "));
    }
}

