/*
 * Decompiled with CFR 0.152.
 */
package org.dita.dost.writer;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.Map;
import org.dita.dost.exception.DITAOTException;
import org.dita.dost.util.Constants;
import org.dita.dost.util.Job;
import org.dita.dost.util.StringUtils;
import org.dita.dost.util.URLUtils;
import org.dita.dost.util.XMLUtils;
import org.dita.dost.writer.AbstractXMLFilter;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.XMLFilterImpl;

public final class DitaLinksWriter
extends AbstractXMLFilter {
    private String curMatchTopic;
    private boolean firstTopic;
    private Map<String, Element> indexEntries;
    private Deque<String> topicIdStack;
    private final ArrayList<String> topicSpecList = new ArrayList();
    private static final Attributes relatedLinksAtts = new XMLUtils.AttributesBuilder().add("class", Constants.TOPIC_RELATED_LINKS.toString()).build();
    private URI baseURI;

    @Override
    public void setJob(Job job) {
        super.setJob(job);
        Job.FileInfo in = job.getFileInfo(fi -> fi.isInput).iterator().next();
        this.baseURI = job.tempDir.toURI().resolve(in.uri);
    }

    public void setLinks(Map<String, Element> indexEntries) {
        this.indexEntries = indexEntries;
    }

    @Override
    public void write(File filename) throws DITAOTException {
        if (filename == null || !this.job.getStore().exists(filename.toURI())) {
            return;
        }
        this.curMatchTopic = this.indexEntries.containsKey("#") ? "#" : null;
        this.topicIdStack = new ArrayDeque<String>();
        super.write(filename);
    }

    @Override
    public void startDocument() throws SAXException {
        this.topicIdStack.clear();
        this.firstTopic = true;
        this.getContentHandler().startDocument();
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
        if (Constants.TOPIC_TOPIC.matches(atts)) {
            String t;
            if (!this.topicSpecList.contains(localName)) {
                this.topicSpecList.add(localName);
            }
            this.topicIdStack.addFirst(atts.getValue("id"));
            if (this.curMatchTopic != null && !this.firstTopic) {
                try {
                    this.getContentHandler().startElement("", Constants.TOPIC_RELATED_LINKS.localName, Constants.TOPIC_RELATED_LINKS.localName, relatedLinksAtts);
                    this.domToSax(this.indexEntries.get(this.curMatchTopic));
                    this.getContentHandler().endElement("", Constants.TOPIC_RELATED_LINKS.localName, Constants.TOPIC_RELATED_LINKS.localName);
                    this.curMatchTopic = null;
                }
                catch (RuntimeException e) {
                    throw e;
                }
                catch (Exception e) {
                    this.logger.error(e.getMessage(), e);
                }
            }
            if (this.indexEntries.containsKey(t = StringUtils.join(this.topicIdStack, "/"))) {
                this.curMatchTopic = t;
            } else if (this.indexEntries.containsKey(this.topicIdStack.peekFirst())) {
                this.curMatchTopic = this.topicIdStack.peekFirst();
            }
            if (this.firstTopic) {
                this.firstTopic = false;
            }
        }
        this.getContentHandler().startElement(uri, localName, qName, atts);
        if (Constants.TOPIC_RELATED_LINKS.matches(atts) && this.curMatchTopic != null) {
            this.domToSax(this.indexEntries.get(this.curMatchTopic));
            this.curMatchTopic = null;
        }
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        if (this.topicSpecList.contains(localName)) {
            if (!this.topicIdStack.isEmpty()) {
                this.topicIdStack.removeFirst();
            }
            if (this.firstTopic) {
                this.firstTopic = false;
            }
        }
        if (this.curMatchTopic != null && this.topicSpecList.contains(localName)) {
            this.getContentHandler().startElement("", Constants.TOPIC_RELATED_LINKS.localName, Constants.TOPIC_RELATED_LINKS.localName, relatedLinksAtts);
            this.domToSax(this.indexEntries.get(this.curMatchTopic));
            this.getContentHandler().endElement("", Constants.TOPIC_RELATED_LINKS.localName, Constants.TOPIC_RELATED_LINKS.localName);
            this.curMatchTopic = null;
        }
        this.getContentHandler().endElement(uri, localName, qName);
    }

    private void domToSax(Node root) throws SAXException {
        try {
            FilterHandler handler = new FilterHandler(this.getContentHandler());
            NodeList children = root.getChildNodes();
            for (int i = 0; i < children.getLength(); ++i) {
                Element links = this.rewriteLinks((Element)children.item(i));
                this.job.getStore().writeDocument(links, (ContentHandler)handler);
            }
        }
        catch (IOException e) {
            throw new SAXException("Failed to serialize DOM node to SAX: " + e.getMessage(), e);
        }
    }

    private Element rewriteLinks(Element src) {
        Element dst = (Element)src.cloneNode(true);
        for (Element desc : XMLUtils.getChildElements(dst, Constants.TOPIC_DESC, true)) {
            for (Element elem : XMLUtils.getChildElements(desc, true)) {
                Attr href = elem.getAttributeNode("href");
                String scope = XMLUtils.getCascadeValue(elem, "scope");
                if (href == null || scope.equals("external")) continue;
                URI abs = this.baseURI.resolve(href.getValue());
                URI rel = URLUtils.getRelativePath(this.currentFile, abs);
                href.setValue(rel.toString());
            }
        }
        return dst;
    }

    private static class FilterHandler
    extends XMLFilterImpl {
        public FilterHandler(ContentHandler handler) {
            this.setContentHandler(handler);
        }

        @Override
        public void startDocument() throws SAXException {
        }

        @Override
        public void endDocument() throws SAXException {
        }
    }
}

