/*
 * Decompiled with CFR 0.152.
 */
package com.elovirta.dita.markdown;

import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.dita.dost.util.Constants;
import org.dita.dost.util.DitaClass;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;
import org.xml.sax.helpers.XMLFilterImpl;

public class SpecializeFilter
extends XMLFilterImpl {
    private static final int DEPTH_IN_BODY = 3;
    private final Type forceType;
    private final Deque<Type> typeStack = new ArrayDeque<Type>(List.of(Type.TOPIC));
    private int paragraphCountInStep = 0;
    private int depth = 0;
    private TaskState taskState = null;
    private ReferenceState referenceState = null;
    private final Deque<String> elementStack = new ArrayDeque<String>();

    public SpecializeFilter() {
        this((Type)null);
    }

    public SpecializeFilter(Type forceType) {
        this.forceType = forceType;
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
        ++this.depth;
        if (localName.equals(Constants.TOPIC_TOPIC.localName)) {
            this.depth = 1;
            if (this.forceType != null) {
                this.typeStack.push(this.forceType);
            } else {
                Collection<String> outputclasses = this.getOutputclass(atts);
                if (outputclasses.contains(Constants.CONCEPT_CONCEPT.localName)) {
                    this.typeStack.push(Type.CONCEPT);
                } else if (outputclasses.contains(Constants.TASK_TASK.localName)) {
                    this.typeStack.push(Type.TASK);
                } else if (outputclasses.contains(Constants.REFERENCE_REFERENCE.localName)) {
                    this.typeStack.push(Type.REFERENCE);
                } else {
                    this.typeStack.push(this.typeStack.peek());
                }
            }
        }
        switch (this.typeStack.peek()) {
            case CONCEPT: {
                this.startElementConcept(uri, localName, qName, atts);
                break;
            }
            case TASK: {
                this.startElementTask(uri, localName, qName, atts);
                break;
            }
            case REFERENCE: {
                this.startElementReference(uri, localName, qName, atts);
                break;
            }
            default: {
                this.doStartElement(uri, localName, qName, atts);
            }
        }
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        switch (this.typeStack.peek()) {
            case TASK: {
                this.endElementTask(uri, localName, qName);
                break;
            }
            case REFERENCE: {
                this.endElementReference(uri, localName, qName);
                break;
            }
            case CONCEPT: {
                this.endElementConcept(uri, localName, qName);
                break;
            }
            default: {
                this.doEndElement(uri, localName, qName);
            }
        }
        if (localName.equals(Constants.TOPIC_TOPIC.localName)) {
            this.typeStack.pop();
        }
        --this.depth;
    }

    private void startElementConcept(String uri, String localName, String qName, Attributes atts) throws SAXException {
        switch (localName) {
            case "topic": {
                this.renameStartElement(Constants.CONCEPT_CONCEPT, atts);
                break;
            }
            case "body": {
                this.renameStartElement(Constants.CONCEPT_CONBODY, atts);
                break;
            }
            default: {
                this.doStartElement(uri, localName, qName, atts);
            }
        }
    }

    private void endElementConcept(String uri, String localName, String qName) throws SAXException {
        this.doEndElement(uri, localName, qName);
    }

    private void startElementTask(String uri, String localName, String qName, Attributes atts) throws SAXException {
        block7 : switch (localName) {
            case "topic": {
                this.renameStartElement(Constants.TASK_TASK, atts);
                this.taskState = null;
                break;
            }
            case "body": {
                this.taskState = TaskState.BODY;
                this.renameStartElement(Constants.TASK_TASKBODY, atts);
                break;
            }
            case "ol": {
                if (this.depth == 3) {
                    if (this.taskState == TaskState.CONTEXT) {
                        this.doEndElement(uri, Constants.TASK_CONTEXT.localName, Constants.TASK_CONTEXT.localName);
                    }
                    this.taskState = TaskState.STEPS;
                    this.renameStartElement(Constants.TASK_STEPS, atts);
                    break;
                }
                this.doStartElement(uri, localName, qName, atts);
                break;
            }
            case "ul": {
                if (this.depth == 3) {
                    if (this.taskState == TaskState.CONTEXT) {
                        this.doEndElement(uri, Constants.TASK_CONTEXT.localName, Constants.TASK_CONTEXT.localName);
                    }
                    this.taskState = TaskState.STEPS;
                    this.renameStartElement(Constants.TASK_STEPS_UNORDERED, atts);
                    break;
                }
                this.doStartElement(uri, localName, qName, atts);
                break;
            }
            case "li": {
                if (this.taskState == TaskState.STEPS && this.depth == 4) {
                    this.renameStartElement(Constants.TASK_STEP, atts);
                    this.taskState = TaskState.STEP;
                    break;
                }
                this.doStartElement(uri, localName, qName, atts);
                break;
            }
            default: {
                if (this.depth == 3) {
                    if (this.taskState == TaskState.BODY) {
                        AttributesImpl sectionAtts = new AttributesImpl();
                        sectionAtts.addAttribute("", "class", "class", "CDATA", Constants.TASK_CONTEXT.toString());
                        this.doStartElement(uri, Constants.TASK_CONTEXT.localName, Constants.TASK_CONTEXT.localName, sectionAtts);
                        this.taskState = TaskState.CONTEXT;
                    }
                    this.doStartElement(uri, localName, qName, atts);
                    break;
                }
                if ((this.taskState == TaskState.STEP || this.taskState == TaskState.INFO) && this.depth == 5) {
                    switch (localName) {
                        case "p": 
                        case "tight-list-p": {
                            ++this.paragraphCountInStep;
                            if (this.paragraphCountInStep == 1) {
                                this.renameStartElement(Constants.TASK_CMD, atts);
                                break block7;
                            }
                            if (this.paragraphCountInStep == 2 && this.taskState != TaskState.INFO) {
                                AttributesImpl res = new AttributesImpl(atts);
                                res.addAttribute("", "class", "class", "CDATA", Constants.TASK_INFO.toString());
                                this.doStartElement("", Constants.TASK_INFO.localName, Constants.TASK_INFO.localName, res);
                                this.taskState = TaskState.INFO;
                                this.doStartElement(uri, localName, qName, atts);
                                break block7;
                            }
                            this.doStartElement(uri, localName, qName, atts);
                            break block7;
                        }
                    }
                    if (this.taskState != TaskState.INFO) {
                        AttributesImpl res = new AttributesImpl(atts);
                        res.addAttribute("", "class", "class", "CDATA", Constants.TASK_INFO.toString());
                        this.doStartElement("", Constants.TASK_INFO.localName, Constants.TASK_INFO.localName, res);
                        this.taskState = TaskState.INFO;
                    }
                    this.doStartElement(uri, localName, qName, atts);
                    break;
                }
                this.doStartElement(uri, localName, qName, atts);
            }
        }
    }

    private void endElementTask(String uri, String localName, String qName) throws SAXException {
        switch (localName) {
            case "body": {
                if (this.taskState == TaskState.CONTEXT) {
                    this.taskState = null;
                    this.doEndElement(uri, Constants.TASK_CONTEXT.localName, Constants.TASK_CONTEXT.localName);
                }
                this.doEndElement(uri, localName, qName);
                break;
            }
            case "li": {
                if (this.taskState == TaskState.INFO && this.depth == 4) {
                    this.doEndElement("", Constants.TASK_INFO.localName, Constants.TASK_INFO.localName);
                    this.taskState = TaskState.STEP;
                }
                if (this.taskState == TaskState.STEP && this.depth == 4) {
                    this.paragraphCountInStep = 0;
                    this.taskState = TaskState.STEPS;
                }
                this.doEndElement(uri, localName, qName);
                break;
            }
            default: {
                this.doEndElement(uri, localName, qName);
            }
        }
    }

    private void startElementReference(String uri, String localName, String qName, Attributes atts) throws SAXException {
        switch (localName) {
            case "topic": {
                this.referenceState = null;
                this.renameStartElement(Constants.REFERENCE_REFERENCE, atts);
                break;
            }
            case "body": {
                this.renameStartElement(Constants.REFERENCE_REFBODY, atts);
                this.referenceState = ReferenceState.BODY;
                break;
            }
            default: {
                if (this.depth == 3) {
                    switch (localName) {
                        case "table": 
                        case "section": {
                            if (this.referenceState != ReferenceState.SECTION) break;
                            this.referenceState = ReferenceState.BODY;
                            this.doEndElement(uri, "section", "section");
                            break;
                        }
                        default: {
                            if (this.referenceState != ReferenceState.BODY) break;
                            AttributesImpl sectionAtts = new AttributesImpl();
                            sectionAtts.addAttribute("", "class", "class", "CDATA", "- topic/section ");
                            this.doStartElement(uri, Constants.TOPIC_SECTION.localName, Constants.TOPIC_SECTION.localName, sectionAtts);
                            this.referenceState = ReferenceState.SECTION;
                        }
                    }
                    this.doStartElement(uri, localName, qName, atts);
                    break;
                }
                this.doStartElement(uri, localName, qName, atts);
            }
        }
    }

    private void endElementReference(String uri, String localName, String qName) throws SAXException {
        switch (localName) {
            case "body": {
                if (this.referenceState == ReferenceState.SECTION) {
                    this.referenceState = null;
                    this.doEndElement(uri, Constants.TOPIC_SECTION.localName, Constants.TOPIC_SECTION.localName);
                }
                this.doEndElement(uri, localName, qName);
                break;
            }
            default: {
                this.doEndElement(uri, localName, qName);
            }
        }
    }

    public void doStartElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
        super.startElement(uri, localName, qName, atts);
        this.elementStack.push(localName);
    }

    public void doEndElement(String uri, String localName, String qName) throws SAXException {
        String l = this.elementStack.pop();
        super.endElement(uri, l, l);
    }

    void renameStartElement(DitaClass cls, Attributes atts) throws SAXException {
        AttributesImpl res = new AttributesImpl(atts);
        int classIndex = res.getIndex("class");
        if (classIndex != -1) {
            res.setValue(classIndex, cls.toString());
        } else {
            res.addAttribute("", "class", "class", "CDATA", cls.toString());
        }
        int outputClassIndex = res.getIndex("", "outputclass");
        if (outputClassIndex != -1) {
            String outputClassValue = res.getValue(outputClassIndex).trim();
            if (outputClassValue.isEmpty()) {
                res.removeAttribute(outputClassIndex);
            } else {
                List outputClass = Stream.of(outputClassValue.split("\\s+")).filter(token -> !token.equals(cls.localName)).collect(Collectors.toList());
                if (outputClass.isEmpty()) {
                    res.removeAttribute(outputClassIndex);
                } else {
                    res.setValue(outputClassIndex, String.join((CharSequence)" ", outputClass));
                }
            }
        }
        this.doStartElement("", cls.localName, cls.localName, res);
    }

    private Collection<String> getOutputclass(Attributes atts) {
        String outputclass = atts.getValue("outputclass");
        if (outputclass == null) {
            return Collections.emptyList();
        }
        return Arrays.asList(outputclass.trim().split("\\s+"));
    }

    private static enum TaskState {
        BODY,
        CONTEXT,
        STEPS,
        STEP,
        INFO,
        RESULT;

    }

    private static enum ReferenceState {
        BODY,
        SECTION;

    }

    public static enum Type {
        TOPIC,
        CONCEPT,
        TASK,
        REFERENCE;

    }
}

