/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.resolve.caching;

import java.io.IOException;
import org.gradle.api.Named;
import org.gradle.api.attributes.Attribute;
import org.gradle.api.attributes.AttributeContainer;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.result.AttributeContainerSerializer;
import org.gradle.api.internal.attributes.ImmutableAttributes;
import org.gradle.api.internal.attributes.ImmutableAttributesFactory;
import org.gradle.api.internal.model.NamedObjectInstantiator;
import org.gradle.internal.isolation.Isolatable;
import org.gradle.internal.serialize.Decoder;
import org.gradle.internal.serialize.Encoder;
import org.gradle.internal.snapshot.impl.CoercingStringValueSnapshot;

public class DesugaringAttributeContainerSerializer
implements AttributeContainerSerializer {
    private final ImmutableAttributesFactory attributesFactory;
    private final NamedObjectInstantiator namedObjectInstantiator;
    private static final byte STRING_ATTRIBUTE = 1;
    private static final byte BOOLEAN_ATTRIBUTE = 2;
    private static final byte DESUGARED_ATTRIBUTE = 3;
    private static final byte INTEGER_ATTRIBUTE = 4;

    public DesugaringAttributeContainerSerializer(ImmutableAttributesFactory attributesFactory, NamedObjectInstantiator namedObjectInstantiator) {
        this.attributesFactory = attributesFactory;
        this.namedObjectInstantiator = namedObjectInstantiator;
    }

    @Override
    public ImmutableAttributes read(Decoder decoder) throws IOException {
        ImmutableAttributes attributes = ImmutableAttributes.EMPTY;
        int count = decoder.readSmallInt();
        for (int i = 0; i < count; ++i) {
            String value;
            String name = decoder.readString();
            byte type = decoder.readByte();
            if (type == 2) {
                attributes = this.attributesFactory.concat(attributes, Attribute.of((String)name, Boolean.class), (Object)decoder.readBoolean());
                continue;
            }
            if (type == 1) {
                value = decoder.readString();
                attributes = this.attributesFactory.concat(attributes, Attribute.of((String)name, String.class), (Object)value);
                continue;
            }
            if (type == 4) {
                int value2 = decoder.readInt();
                attributes = this.attributesFactory.concat(attributes, Attribute.of((String)name, Integer.class), (Object)value2);
                continue;
            }
            if (type != 3) continue;
            value = decoder.readString();
            attributes = this.attributesFactory.concat(attributes, Attribute.of((String)name, String.class), (Isolatable)new CoercingStringValueSnapshot(value, this.namedObjectInstantiator));
        }
        return attributes;
    }

    @Override
    public void write(Encoder encoder, AttributeContainer container) throws IOException {
        encoder.writeSmallInt(container.keySet().size());
        for (Attribute attribute : container.keySet()) {
            encoder.writeString((CharSequence)attribute.getName());
            if (attribute.getType().equals(Boolean.class)) {
                encoder.writeByte((byte)2);
                encoder.writeBoolean(((Boolean)container.getAttribute(attribute)).booleanValue());
                continue;
            }
            if (attribute.getType().equals(String.class)) {
                encoder.writeByte((byte)1);
                encoder.writeString((CharSequence)((String)container.getAttribute(attribute)));
                continue;
            }
            if (attribute.getType().equals(Integer.class)) {
                encoder.writeByte((byte)4);
                encoder.writeInt(((Integer)container.getAttribute(attribute)).intValue());
                continue;
            }
            assert (Named.class.isAssignableFrom(attribute.getType()));
            Named attributeValue = (Named)container.getAttribute(attribute);
            encoder.writeByte((byte)3);
            encoder.writeString((CharSequence)attributeValue.getName());
        }
    }
}

