IF( NOT INCLUDED_MACROS )

    MACRO( MY_SWIG_ADD_MODULE NAME LANGUAGE )
        IF( ${CMAKE_VERSION} VERSION_LESS "3.9.0" )
            SWIG_ADD_MODULE( ${NAME} ${LANGUAGE} ${ARGN} )
        ELSE()
            SWIG_ADD_LIBRARY( ${NAME} LANGUAGE ${LANGUAGE} TYPE MODULE SOURCES ${ARGN} )
        ENDIF()
    ENDMACRO()

    MACRO( INSTALL_TCL_PACKAGE TARGET INDEXFILE DIR PATTERN )
        # Prepare the Tcl package index file for Release and Debug mode in the build directory.
        # Replaces the following keywords:
        # @TCL3D_VERSION@
        # @TCL_DEBUG_POSTFIX@
        SET( TCL_DEBUG_POSTFIX ${CMAKE_RELEASE_POSTFIX} )
        CONFIGURE_FILE( ${INDEXFILE} pkgIndex.Release.tcl @ONLY )
        SET( TCL_DEBUG_POSTFIX ${CMAKE_DEBUG_POSTFIX} )
        CONFIGURE_FILE( ${INDEXFILE} pkgIndex.Debug.tcl @ONLY )

        # Install all Tcl-only package files.
        # This statement must be executed before copying the pkgIndex.tcl
        # files, as we still have the original pkgIndex.tcl files.
        INSTALL(
            DIRECTORY   ${DIR}
            DESTINATION ${TCL3D_INST_DIR}/${TARGET}
            FILES_MATCHING PATTERN ${PATTERN}
        )

        # Install the configuration specific Tcl package index file.
        INSTALL(
            FILES ${CMAKE_CURRENT_BINARY_DIR}/pkgIndex.Debug.tcl
            DESTINATION ${TCL3D_INST_DIR}/${TARGET}
            RENAME pkgIndex.tcl
            CONFIGURATIONS Debug
        )
        INSTALL(
            FILES ${CMAKE_CURRENT_BINARY_DIR}/pkgIndex.Release.tcl
            DESTINATION ${TCL3D_INST_DIR}/${TARGET}
            RENAME pkgIndex.tcl
            CONFIGURATIONS Release
        )
    ENDMACRO()

    MACRO( FIND_SOURCES var )
        SET( ALL_SOURCES "" )
        SET(ARGUMENTS ${ARGN})
        IF(${ARGC} GREATER 1)
            STRING(TOUPPER ${ARGV1} LIB_TYPE)
            IF(${LIB_TYPE} STREQUAL "STATIC" OR ${LIB_TYPE} STREQUAL "SHARED")
                LIST(REMOVE_AT ARGUMENTS 0)
            ENDIF()
        ENDIF()
        SET(ARG_COUNT 0)
        LIST(LENGTH ARGUMENTS ARG_COUNT)
        IF( ${ARG_COUNT} EQUAL 0 )
            FILE( GLOB MY_SOURCES ./*.c ./*.cpp ./*.h )
            SET( ALL_SOURCES ${ALL_SOURCES} ${MY_SOURCES} )
        ELSE()
            FOREACH( ELEMENT ${ARGUMENTS} )
                SET( MY_PATH ${CMAKE_CURRENT_SOURCE_DIR}/${ELEMENT} )
                IF( IS_DIRECTORY ${MY_PATH} )
                    FILE( GLOB MY_SOURCES ${MY_PATH}/*.c ${MY_PATH}/*.cpp ${MY_PATH}/*.h )
                    SET( ALL_SOURCES ${ALL_SOURCES} ${MY_SOURCES} )
                ELSE()
                    SET( ALL_SOURCES ${ALL_SOURCES} ${ELEMENT} )
                ENDIF()
            ENDFOREACH()
        ENDIF()
        SET( ${ARGV0} ${ALL_SOURCES} )
    ENDMACRO()

    # Run gcc compiler with "-dumpversion" and parse major/minor version with a regex.
    FUNCTION(GET_GCC_VERSION COMPILER_VERSION)
        EXEC_PROGRAM(${CMAKE_CXX_COMPILER}
            ARGS ${CMAKE_CXX_COMPILER_ARG1} -dumpversion
            OUTPUT_VARIABLE _COMPILER_VERSION
        )
        STRING(REGEX REPLACE "([0-9])\\.([0-9])(\\.[0-9])?" "\\1.\\2"
            _COMPILER_VERSION ${_COMPILER_VERSION})

        SET(${COMPILER_VERSION} ${_COMPILER_VERSION} PARENT_SCOPE)
    ENDFUNCTION()

    SET( INCLUDED_MACROS TRUE )
ENDIF()
