/*
 * Decompiled with CFR 0.152.
 */
package com.impossibl.postgres.system.procs;

import com.impossibl.postgres.system.Context;
import com.impossibl.postgres.system.procs.BinaryDecoder;
import com.impossibl.postgres.system.procs.BinaryEncoder;
import com.impossibl.postgres.system.procs.SimpleProcProvider;
import com.impossibl.postgres.system.procs.TextDecoder;
import com.impossibl.postgres.system.procs.TextEncoder;
import com.impossibl.postgres.types.PrimitiveType;
import com.impossibl.postgres.types.Type;
import io.netty.buffer.ByteBuf;
import java.io.IOException;

public class Bools
extends SimpleProcProvider {
    public Bools() {
        super((Type.Codec.Encoder)new TxtEncoder(), (Type.Codec.Decoder)new TxtDecoder(), (Type.Codec.Encoder)new BinEncoder(), (Type.Codec.Decoder)new BinDecoder(), "bool");
    }

    static class TxtEncoder
    extends TextEncoder {
        TxtEncoder() {
        }

        @Override
        public Class<?> getInputType() {
            return Boolean.class;
        }

        @Override
        public PrimitiveType getOutputPrimitiveType() {
            return PrimitiveType.Bool;
        }

        @Override
        public void encode(Type type, StringBuilder buffer, Object val, Context context) throws IOException {
            buffer.append((Boolean)val);
        }
    }

    static class TxtDecoder
    extends TextDecoder {
        TxtDecoder() {
        }

        @Override
        public PrimitiveType getInputPrimitiveType() {
            return PrimitiveType.Bool;
        }

        @Override
        public Class<?> getOutputType() {
            return Boolean.class;
        }

        @Override
        public Boolean decode(Type type, Short typeLength, Integer typeModifier, CharSequence buffer, Context context) throws IOException {
            switch (buffer.toString()) {
                case "TRUE": 
                case "t": 
                case "true": 
                case "y": 
                case "yes": 
                case "on": 
                case "1": {
                    return true;
                }
                case "FALSE": 
                case "f": 
                case "false": 
                case "n": 
                case "no": 
                case "off": 
                case "0": {
                    return false;
                }
            }
            return Boolean.FALSE;
        }
    }

    static class BinEncoder
    extends BinaryEncoder {
        BinEncoder() {
        }

        @Override
        public Class<?> getInputType() {
            return Boolean.class;
        }

        @Override
        public PrimitiveType getOutputPrimitiveType() {
            return PrimitiveType.Bool;
        }

        @Override
        public void encode(Type type, ByteBuf buffer, Object val, Context context) throws IOException {
            if (val == null) {
                buffer.writeInt(-1);
            } else {
                buffer.writeInt(1);
                buffer.writeByte((Boolean)val != false ? 1 : 0);
            }
        }
    }

    static class BinDecoder
    extends BinaryDecoder {
        BinDecoder() {
        }

        @Override
        public PrimitiveType getInputPrimitiveType() {
            return PrimitiveType.Bool;
        }

        @Override
        public Class<?> getOutputType() {
            return Boolean.class;
        }

        @Override
        public Boolean decode(Type type, Short typeLength, Integer typeModifier, ByteBuf buffer, Context context) throws IOException {
            int length = buffer.readInt();
            if (length == -1) {
                return null;
            }
            if (length != 1) {
                throw new IOException("invalid length");
            }
            return buffer.readByte() != 0;
        }
    }
}

