/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.applicationinsights.internal.heartbeat;

import com.microsoft.applicationinsights.TelemetryClient;
import com.microsoft.applicationinsights.TelemetryConfiguration;
import com.microsoft.applicationinsights.core.dependencies.apachecommons.lang3.StringUtils;
import com.microsoft.applicationinsights.internal.heartbeat.HeartBeatPropertyPayload;
import com.microsoft.applicationinsights.internal.heartbeat.HeartBeatProviderInterface;
import com.microsoft.applicationinsights.internal.heartbeat.HeartbeatDefaultPayload;
import com.microsoft.applicationinsights.internal.logger.InternalLogger;
import com.microsoft.applicationinsights.internal.shutdown.SDKShutdownActivity;
import com.microsoft.applicationinsights.internal.shutdown.Stoppable;
import com.microsoft.applicationinsights.internal.util.ThreadPoolUtils;
import com.microsoft.applicationinsights.telemetry.MetricTelemetry;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;

public class HeartBeatProvider
implements HeartBeatProviderInterface,
Stoppable {
    private final String HEARTBEAT_SYNTHETIC_METRIC_NAME = "HeartbeatState";
    private List<String> disableDefaultProperties = new ArrayList<String>();
    private List<String> disabledHeartBeatPropertiesProviders = new ArrayList<String>();
    private long heartbeatsSent = 0L;
    private ConcurrentMap<String, HeartBeatPropertyPayload> heartbeatProperties;
    private long interval = HeartBeatProviderInterface.DEFAULT_HEARTBEAT_INTERVAL;
    private TelemetryClient telemetryClient;
    private ExecutorService propertyUpdateService;
    private ScheduledExecutorService heartBeatSenderService;
    private volatile boolean isEnabled = true;

    public HeartBeatProvider() {
        this.heartbeatProperties = new ConcurrentHashMap<String, HeartBeatPropertyPayload>();
        this.propertyUpdateService = Executors.newCachedThreadPool(ThreadPoolUtils.createDaemonThreadFactory(HeartBeatProvider.class, "propertyUpdateService"));
        this.heartBeatSenderService = Executors.newSingleThreadScheduledExecutor(ThreadPoolUtils.createDaemonThreadFactory(HeartBeatProvider.class, "heartBeatSenderService"));
        SDKShutdownActivity.INSTANCE.register(this);
    }

    @Override
    public String getInstrumentationKey() {
        return this.telemetryClient.getContext().getInstrumentationKey();
    }

    @Override
    public void setInstrumentationKey(String key) {
        if (this.telemetryClient != null && key != null) {
            this.telemetryClient.getContext().setInstrumentationKey(key);
        }
    }

    @Override
    public void initialize(TelemetryConfiguration configuration) {
        if (this.isEnabled) {
            if (this.telemetryClient == null) {
                this.telemetryClient = new TelemetryClient(configuration);
            }
            this.propertyUpdateService.submit(HeartbeatDefaultPayload.populateDefaultPayload(this.getExcludedHeartBeatProperties(), this.getExcludedHeartBeatPropertyProviders(), this));
            this.heartBeatSenderService.scheduleAtFixedRate(this.heartBeatPulse(), this.interval, this.interval, TimeUnit.SECONDS);
        }
    }

    @Override
    public boolean addHeartBeatProperty(String propertyName, String propertyValue, boolean isHealthy) {
        boolean isAdded = false;
        if (!StringUtils.isEmpty(propertyName)) {
            if (!this.heartbeatProperties.containsKey(propertyName)) {
                HeartBeatPropertyPayload payload = new HeartBeatPropertyPayload();
                payload.setHealthy(isHealthy);
                payload.setPayloadValue(propertyValue);
                this.heartbeatProperties.put(propertyName, payload);
                isAdded = true;
                InternalLogger.INSTANCE.trace("added heartbeat property %s - %s", propertyName, propertyValue);
            } else {
                InternalLogger.INSTANCE.trace("heartbeat property %s cannot be added twice. Please use setHeartBeatProperty instead to modify the value", propertyName);
            }
        } else {
            InternalLogger.INSTANCE.warn("cannot add property without property name", new Object[0]);
        }
        return isAdded;
    }

    @Override
    public boolean setHeartBeatProperty(String propertyName, String propertyValue, boolean isHealthy) {
        boolean setResult = false;
        if (!StringUtils.isEmpty(propertyName)) {
            if (!this.heartbeatProperties.containsKey(propertyName)) {
                InternalLogger.INSTANCE.trace("The property %s is not already present. It will be added", propertyName);
            }
            if (HeartbeatDefaultPayload.isDefaultKeyword(propertyName)) {
                InternalLogger.INSTANCE.warn("heartbeat beat property specified %s is a reserved property", propertyName);
                return false;
            }
            HeartBeatPropertyPayload payload = new HeartBeatPropertyPayload();
            payload.setHealthy(isHealthy);
            payload.setPayloadValue(propertyValue);
            this.heartbeatProperties.put(propertyName, payload);
            setResult = true;
        } else {
            InternalLogger.INSTANCE.warn("cannot set property without property name", new Object[0]);
        }
        return setResult;
    }

    @Override
    public boolean isHeartBeatEnabled() {
        return this.isEnabled;
    }

    @Override
    public void setHeartBeatEnabled(boolean isEnabled) {
        this.isEnabled = isEnabled;
    }

    @Override
    public List<String> getExcludedHeartBeatPropertyProviders() {
        return this.disabledHeartBeatPropertiesProviders;
    }

    @Override
    public void setExcludedHeartBeatPropertyProviders(List<String> excludedHeartBeatPropertyProviders) {
        this.disabledHeartBeatPropertiesProviders = excludedHeartBeatPropertyProviders;
    }

    @Override
    public long getHeartBeatInterval() {
        return this.interval;
    }

    @Override
    public void setHeartBeatInterval(long timeUnit) {
        this.interval = timeUnit <= HeartBeatProviderInterface.MINIMUM_HEARTBEAT_INTERVAL ? HeartBeatProviderInterface.MINIMUM_HEARTBEAT_INTERVAL : timeUnit;
    }

    @Override
    public List<String> getExcludedHeartBeatProperties() {
        return this.disableDefaultProperties;
    }

    @Override
    public void setExcludedHeartBeatProperties(List<String> excludedHeartBeatProperties) {
        this.disableDefaultProperties = excludedHeartBeatProperties;
    }

    @Override
    public boolean containsHeartBeatProperty(String key) {
        return this.heartbeatProperties.containsKey(key);
    }

    @Override
    public void stop(long timeout, TimeUnit timeUnit) {
        ThreadPoolUtils.stop(this.propertyUpdateService, timeout, timeUnit);
        ThreadPoolUtils.stop(this.heartBeatSenderService, timeout, timeUnit);
    }

    private void send() {
        MetricTelemetry telemetry = this.gatherData();
        telemetry.getContext().getOperation().setSyntheticSource("HeartbeatState");
        this.telemetryClient.trackMetric(telemetry);
        InternalLogger.INSTANCE.trace("No of heartbeats sent, %s", ++this.heartbeatsSent);
    }

    private MetricTelemetry gatherData() {
        MetricTelemetry heartbeat = new MetricTelemetry("HeartbeatState", 0.0);
        Map<String, String> property = heartbeat.getProperties();
        for (Map.Entry entry : this.heartbeatProperties.entrySet()) {
            property.put((String)entry.getKey(), ((HeartBeatPropertyPayload)entry.getValue()).getPayloadValue());
            double currentValue = heartbeat.getValue();
            heartbeat.setValue(currentValue += ((HeartBeatPropertyPayload)entry.getValue()).isHealthy() ? 0.0 : 1.0);
        }
        return heartbeat;
    }

    private Runnable heartBeatPulse() {
        return new Runnable(){

            @Override
            public void run() {
                try {
                    HeartBeatProvider.this.send();
                }
                catch (Exception e) {
                    InternalLogger.INSTANCE.warn("Error occured while sending heartbeat", new Object[0]);
                }
            }
        };
    }
}

