/*
 * Decompiled with CFR 0.152.
 */
package difflib;

import difflib.ChangeDelta;
import difflib.Chunk;
import difflib.DeleteDelta;
import difflib.Delta;
import difflib.DiffAlgorithm;
import difflib.DiffRow;
import difflib.DiffUtils;
import difflib.InsertDelta;
import difflib.Patch;
import difflib.Utils;
import difflib.myers.Equalizer;
import difflib.myers.MyersDiff;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class DiffRowGenerator {
    private static final String NEW_LINE = "\n";
    private static final Pattern WS_PATTERN = Pattern.compile("\\s+");
    private static final String DEFAULT_TAG_DELETE = "del";
    private static final String DEFAULT_TAG_INSERT = "ins";
    private static final String DEFAULT_TAG_CHANGE = "span";
    private static final String DEFAULT_CSSCLASS_DELETE = null;
    private static final String DEFAULT_CSSCLASS_INSERT = null;
    private static final String DEFAULT_CSSCLASS_CHANGE = "change";
    private static final DiffAlgorithm<String> DEFAULT_DIFFALGORITHM = new MyersDiff<String>(new Equalizer<String>(){

        @Override
        public boolean equals(String original, String revised) {
            return Objects.equals(original, revised);
        }

        @Override
        public boolean skip(String original) {
            return false;
        }
    });
    private final boolean showInlineDiffs;
    private final boolean ignoreWhiteSpaces;
    private final String inlineOriginDeleteTag;
    private final String inlineRevisedInsertTag;
    private final String inlineOriginChangeTag;
    private final String inlineRevisedChangeTag;
    private final String inlineOriginDeleteCssClass;
    private final String inlineRevisedInsertCssClass;
    private final String inlineOriginChangeCssClass;
    private final String inlineRevisedChangeCssClass;
    private final int columnWidth;
    @Nullable
    private final String defaultString;
    private final DiffAlgorithm<String> diffAlgorithm;
    private static final Pattern PATTERN_CRLF = Pattern.compile("([\\n\\r]+)");

    private DiffRowGenerator(Builder builder) {
        this.showInlineDiffs = builder.showInlineDiffs;
        this.ignoreWhiteSpaces = builder.ignoreWhiteSpaces;
        this.inlineOriginDeleteTag = builder.inlineOriginDeleteTag;
        this.inlineOriginDeleteCssClass = builder.inlineOriginDeleteCssClass;
        this.inlineOriginChangeTag = builder.inlineOriginChangeTag;
        this.inlineOriginChangeCssClass = builder.inlineOriginChangeCssClass;
        this.inlineRevisedInsertTag = builder.inlineRevisedInsertTag;
        this.inlineRevisedInsertCssClass = builder.inlineRevisedInsertCssClass;
        this.inlineRevisedChangeTag = builder.inlineRevisedChangeTag;
        this.inlineRevisedChangeCssClass = builder.inlineRevisedChangeCssClass;
        this.columnWidth = builder.columnWidth;
        this.defaultString = builder.defaultString;
        this.diffAlgorithm = builder.diffAlgorithm;
    }

    public List<DiffRow> generateDiffRows(List<String> original, List<String> revised) {
        if (this.ignoreWhiteSpaces) {
            this.replAllWs(original);
            this.replAllWs(revised);
        }
        return this.generateDiffRows(original, revised, DiffUtils.diff(original, revised, this.diffAlgorithm));
    }

    private void replAllWs(List<String> strList) {
        ListIterator<String> i = strList.listIterator();
        while (i.hasNext()) {
            String s2 = i.next();
            if (s2 == null) continue;
            i.set(WS_PATTERN.matcher(s2.trim()).replaceAll(" "));
        }
    }

    public List<DiffRow> generateDiffRows(List<String> original, List<String> revised, Patch<String> patch) {
        original = Utils.normalize(original);
        revised = Utils.normalize(revised);
        if (this.columnWidth > 0) {
            original = Utils.wrapText(original, this.columnWidth);
            revised = Utils.wrapText(revised, this.columnWidth);
        }
        ArrayList<DiffRow> diffRows = new ArrayList<DiffRow>();
        int orgEndPos = 0;
        int revEndPos = 0;
        List<Delta<String>> deltaList = patch.getDeltas();
        Equalizer<String> equalizer = this.diffAlgorithm.getEqualizer();
        for (int i = 0; i < deltaList.size(); ++i) {
            String revLine;
            String orgLine;
            int j;
            Delta<String> delta = deltaList.get(i);
            Chunk<String> orig = delta.getOriginal();
            Chunk<String> rev = delta.getRevised();
            orig.setLines(Utils.normalize(orig.getLines()));
            rev.setLines(Utils.normalize(rev.getLines()));
            if (this.columnWidth > 0) {
                orig.setLines(Utils.wrapText(orig.getLines(), this.columnWidth));
                rev.setLines(Utils.wrapText(rev.getLines(), this.columnWidth));
            }
            this.copyEqualsLines(equalizer, diffRows, original, orgEndPos, orig.getPosition(), revised, revEndPos, rev.getPosition());
            if (delta.getClass() == InsertDelta.class) {
                orgEndPos = orig.last() + 1;
                revEndPos = rev.last() + 1;
                for (String line : rev.getLines()) {
                    if (equalizer.skip(line)) {
                        diffRows.add(new DiffRow(DiffRow.Tag.SKIP, this.defaultString, line));
                        continue;
                    }
                    diffRows.add(new DiffRow(DiffRow.Tag.INSERT, this.defaultString, line));
                }
                continue;
            }
            if (delta.getClass() == DeleteDelta.class) {
                orgEndPos = orig.last() + 1;
                revEndPos = rev.last() + 1;
                for (String line : orig.getLines()) {
                    if (equalizer.skip(line)) {
                        diffRows.add(new DiffRow(DiffRow.Tag.SKIP, line, this.defaultString));
                        continue;
                    }
                    diffRows.add(new DiffRow(DiffRow.Tag.DELETE, line, this.defaultString));
                }
                continue;
            }
            if (this.showInlineDiffs) {
                this.addInlineDiffs(delta);
            }
            if (orig.size() == rev.size()) {
                for (j = 0; j < orig.size(); ++j) {
                    DiffRowGenerator.addChangeDiffRow(equalizer, diffRows, orig.getLines().get(j), rev.getLines().get(j), this.defaultString);
                }
            } else if (orig.size() > rev.size()) {
                for (j = 0; j < orig.size(); ++j) {
                    orgLine = orig.getLines().get(j);
                    revLine = rev.getLines().size() > j ? rev.getLines().get(j) : this.defaultString;
                    DiffRowGenerator.addChangeDiffRow(equalizer, diffRows, orgLine, revLine, this.defaultString);
                }
            } else {
                for (j = 0; j < rev.size(); ++j) {
                    orgLine = orig.getLines().size() > j ? orig.getLines().get(j) : this.defaultString;
                    revLine = rev.getLines().get(j);
                    DiffRowGenerator.addChangeDiffRow(equalizer, diffRows, orgLine, revLine, this.defaultString);
                }
            }
            orgEndPos = orig.last() + 1;
            revEndPos = rev.last() + 1;
        }
        this.copyEqualsLines(equalizer, diffRows, original, orgEndPos, original.size(), revised, revEndPos, revised.size());
        return diffRows;
    }

    private static final void addChangeDiffRow(Equalizer<String> equalizer, List<DiffRow> diffRows, String orgLine, String revLine, String defaultString) {
        boolean skipOrg = equalizer.skip(orgLine);
        boolean skipRev = equalizer.skip(revLine);
        if (skipOrg && skipRev) {
            diffRows.add(new DiffRow(DiffRow.Tag.SKIP, orgLine, revLine));
        } else if (skipOrg) {
            diffRows.add(new DiffRow(DiffRow.Tag.SKIP, orgLine, defaultString));
            diffRows.add(new DiffRow(DiffRow.Tag.CHANGE, defaultString, revLine));
        } else if (skipRev) {
            diffRows.add(new DiffRow(DiffRow.Tag.CHANGE, orgLine, defaultString));
            diffRows.add(new DiffRow(DiffRow.Tag.SKIP, defaultString, revLine));
        } else {
            diffRows.add(new DiffRow(DiffRow.Tag.CHANGE, orgLine, revLine));
        }
    }

    protected void copyEqualsLines(Equalizer<String> equalizer, List<DiffRow> diffRows, List<String> original, int originalStartPos, int originalEndPos, List<String> revised, int revisedStartPos, int revisedEndPos) {
        String[][] lines = new String[originalEndPos - originalStartPos][2];
        int idx = 0;
        for (String line : original.subList(originalStartPos, originalEndPos)) {
            lines[idx++][0] = line;
        }
        idx = 0;
        for (String line : revised.subList(revisedStartPos, revisedEndPos)) {
            lines[idx++][1] = line;
        }
        for (String[] line : lines) {
            String orgLine = line[0];
            String revLine = line[1];
            if (equalizer.skip(orgLine) && equalizer.skip(revLine)) {
                diffRows.add(new DiffRow(DiffRow.Tag.SKIP, orgLine, revLine));
                continue;
            }
            diffRows.add(new DiffRow(DiffRow.Tag.EQUAL, orgLine, revLine));
        }
    }

    private void addInlineDiffs(Delta<String> delta) {
        List<String> orig = delta.getOriginal().getLines();
        List<String> rev = delta.getRevised().getLines();
        LinkedList<String> origList = DiffRowGenerator.charArrayToStringList(Utils.join(orig, NEW_LINE).toCharArray());
        LinkedList<String> revList = DiffRowGenerator.charArrayToStringList(Utils.join(rev, NEW_LINE).toCharArray());
        List<Delta<String>> inlineDeltas = DiffUtils.diff(origList, revList).getDeltas();
        Collections.reverse(inlineDeltas);
        for (Delta<String> inlineDelta : inlineDeltas) {
            Chunk<String> inlineOrig = inlineDelta.getOriginal();
            Chunk<String> inlineRev = inlineDelta.getRevised();
            if (inlineDelta.getClass().equals(DeleteDelta.class)) {
                origList = DiffRowGenerator.wrapInTag(origList, inlineOrig.getPosition(), inlineOrig.getPosition() + inlineOrig.size() + 1, this.inlineOriginDeleteTag, this.inlineOriginDeleteCssClass);
                continue;
            }
            if (inlineDelta.getClass().equals(InsertDelta.class)) {
                revList = DiffRowGenerator.wrapInTag(revList, inlineRev.getPosition(), inlineRev.getPosition() + inlineRev.size() + 1, this.inlineRevisedInsertTag, this.inlineRevisedInsertCssClass);
                continue;
            }
            if (!inlineDelta.getClass().equals(ChangeDelta.class)) continue;
            origList = DiffRowGenerator.wrapInTag(origList, inlineOrig.getPosition(), inlineOrig.getPosition() + inlineOrig.size() + 1, this.inlineOriginChangeTag, this.inlineOriginChangeCssClass);
            revList = DiffRowGenerator.wrapInTag(revList, inlineRev.getPosition(), inlineRev.getPosition() + inlineRev.size() + 1, this.inlineRevisedChangeTag, this.inlineRevisedChangeCssClass);
        }
        delta.getOriginal().setLines(this.addMissingLines(origList, orig.size()));
        delta.getRevised().setLines(this.addMissingLines(revList, rev.size()));
    }

    private List<String> addMissingLines(List<String> lines, int targetSize) {
        List<String> tempList = Arrays.asList(Utils.join(lines, "").split(NEW_LINE));
        if (tempList.size() < targetSize) {
            tempList = new ArrayList<String>(tempList);
            while (tempList.size() < targetSize) {
                tempList.add("");
            }
        }
        return tempList;
    }

    private static final LinkedList<String> charArrayToStringList(char[] cs) {
        LinkedList<String> result = new LinkedList<String>();
        char[] cArray = cs;
        int n = cArray.length;
        for (int i = 0; i < n; ++i) {
            Character character = Character.valueOf(cArray[i]);
            result.add(character.toString());
        }
        return result;
    }

    public static LinkedList<String> wrapInTag(LinkedList<String> sequence, int startPosition, int endPosition, String tag, String cssClass) {
        LinkedList result = (LinkedList)sequence.clone();
        StringBuilder tagBuilder = new StringBuilder();
        tagBuilder.append("<");
        tagBuilder.append(tag);
        if (cssClass != null) {
            tagBuilder.append(" class=\"");
            tagBuilder.append(cssClass);
            tagBuilder.append("\"");
        }
        tagBuilder.append(">");
        String startTag = tagBuilder.toString();
        tagBuilder.delete(0, tagBuilder.length());
        tagBuilder.append("</");
        tagBuilder.append(tag);
        tagBuilder.append(">");
        String endTag = tagBuilder.toString();
        result.add(startPosition, startTag);
        result.add(endPosition, endTag);
        String joinTag = Matcher.quoteReplacement(endTag) + "$1" + Matcher.quoteReplacement(startTag);
        for (int i = startPosition + 1; i < endPosition; ++i) {
            String val = (String)result.get(i);
            if (!val.contains(NEW_LINE) && !val.contains("\r")) continue;
            result.set(i, PATTERN_CRLF.matcher(val).replaceAll(joinTag));
        }
        return result;
    }

    public static String wrapInTag(String line, String tag, String cssClass) {
        StringBuilder tagBuilder = new StringBuilder();
        tagBuilder.append("<");
        tagBuilder.append(tag);
        if (cssClass != null) {
            tagBuilder.append(" class=\"");
            tagBuilder.append(cssClass);
            tagBuilder.append("\"");
        }
        tagBuilder.append(">");
        String startTag = tagBuilder.toString();
        tagBuilder.delete(0, tagBuilder.length());
        tagBuilder.append("</");
        tagBuilder.append(tag);
        tagBuilder.append(">");
        String endTag = tagBuilder.toString();
        String joinTag = Matcher.quoteReplacement(endTag) + "$1" + Matcher.quoteReplacement(startTag);
        return startTag + PATTERN_CRLF.matcher(line).replaceAll(joinTag) + endTag;
    }

    static /* synthetic */ String access$000() {
        return DEFAULT_CSSCLASS_DELETE;
    }

    static /* synthetic */ String access$100() {
        return DEFAULT_CSSCLASS_INSERT;
    }

    static /* synthetic */ DiffAlgorithm access$200() {
        return DEFAULT_DIFFALGORITHM;
    }

    public static class Builder {
        private boolean showInlineDiffs = false;
        private boolean ignoreWhiteSpaces = false;
        private String inlineOriginDeleteTag = "del";
        private String inlineOriginChangeTag = "span";
        private String inlineRevisedInsertTag = "ins";
        private String inlineRevisedChangeTag = "span";
        private String inlineOriginDeleteCssClass = DiffRowGenerator.access$000();
        private String inlineRevisedInsertCssClass = DiffRowGenerator.access$100();
        private String inlineOriginChangeCssClass = "change";
        private String inlineRevisedChangeCssClass = "change";
        private int columnWidth = -1;
        @Nullable
        private String defaultString = "";
        private DiffAlgorithm<String> diffAlgorithm = DiffRowGenerator.access$200();

        public Builder showInlineDiffs(boolean val) {
            this.showInlineDiffs = val;
            return this;
        }

        public Builder ignoreWhiteSpaces(boolean val) {
            this.ignoreWhiteSpaces = val;
            return this;
        }

        @Deprecated
        public Builder InlineOldTag(String tag) {
            this.inlineOriginDeleteTag = tag;
            return this;
        }

        public Builder inlineOriginDeleteTag(String tag) {
            this.inlineOriginDeleteTag = tag;
            return this;
        }

        public Builder InlineNewTag(String tag) {
            this.inlineRevisedInsertTag = tag;
            return this;
        }

        public Builder inlineRevisedInsertTag(String tag) {
            this.inlineRevisedInsertTag = tag;
            return this;
        }

        public Builder InlineOldCssClass(String cssClass) {
            this.inlineOriginDeleteCssClass = cssClass;
            return this;
        }

        public Builder inlineOriginDeleteCssClass(String cssClass) {
            this.inlineOriginDeleteCssClass = cssClass;
            return this;
        }

        public Builder InlineNewCssClass(String cssClass) {
            this.inlineRevisedInsertCssClass = cssClass;
            return this;
        }

        public Builder inlineRevisedInsertCssClass(String cssClass) {
            this.inlineRevisedInsertCssClass = cssClass;
            return this;
        }

        public Builder columnWidth(int width) {
            this.columnWidth = width;
            return this;
        }

        @Nonnull
        public Builder defaultString(@Nullable String defaultString) {
            this.defaultString = defaultString;
            return this;
        }

        public Builder stringEqualizer(Equalizer<String> stringEqualizer) {
            this.diffAlgorithm = new MyersDiff<String>(stringEqualizer);
            return this;
        }

        public Builder diffAlgorithm(DiffAlgorithm<String> diffAlgorithm) {
            this.diffAlgorithm = diffAlgorithm;
            return this;
        }

        public DiffRowGenerator build() {
            return new DiffRowGenerator(this);
        }
    }
}

