/*
 * Decompiled with CFR 0.152.
 */
package impl.org.controlsfx.skin;

import javafx.animation.Animation;
import javafx.animation.Interpolator;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.Timeline;
import javafx.beans.InvalidationListener;
import javafx.beans.Observable;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.value.ObservableValue;
import javafx.beans.value.WritableValue;
import javafx.collections.ObservableList;
import javafx.event.ActionEvent;
import javafx.event.Event;
import javafx.event.EventHandler;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.geometry.VPos;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonBar;
import javafx.scene.control.Label;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.Priority;
import javafx.scene.layout.Region;
import javafx.scene.layout.StackPane;
import javafx.util.Duration;
import org.controlsfx.control.NotificationPane;
import org.controlsfx.control.action.Action;
import org.controlsfx.control.action.ActionUtils;

public abstract class NotificationBar
extends Region {
    private static final double MIN_HEIGHT = 40.0;
    final Label label;
    Label title;
    ButtonBar actionsBar;
    Button closeBtn;
    private final GridPane pane;
    public DoubleProperty transition = new SimpleDoubleProperty(){

        protected void invalidated() {
            NotificationBar.this.requestContainerLayout();
        }
    };
    private final Duration TRANSITION_DURATION = new Duration(350.0);
    private Timeline timeline;
    private double transitionStartValue;

    public void requestContainerLayout() {
        this.layoutChildren();
    }

    public String getTitle() {
        return "";
    }

    public boolean isCloseButtonVisible() {
        return true;
    }

    public abstract String getText();

    public abstract Node getGraphic();

    public abstract ObservableList<Action> getActions();

    public abstract void hide();

    public abstract boolean isShowing();

    public abstract boolean isShowFromTop();

    public abstract double getContainerHeight();

    public abstract void relocateInParent(double var1, double var3);

    public NotificationBar() {
        this.getStyleClass().add((Object)"notification-bar");
        this.setVisible(this.isShowing());
        this.pane = new GridPane();
        this.pane.getStyleClass().add((Object)"pane");
        this.pane.setAlignment(Pos.BASELINE_LEFT);
        this.getChildren().setAll((Object[])new Node[]{this.pane});
        String titleStr = this.getTitle();
        if (titleStr != null && !titleStr.isEmpty()) {
            this.title = new Label();
            this.title.getStyleClass().add((Object)"title");
            this.title.setMaxSize(Double.MAX_VALUE, Double.MAX_VALUE);
            GridPane.setHgrow((Node)this.title, (Priority)Priority.ALWAYS);
            this.title.setText(titleStr);
            this.title.opacityProperty().bind((ObservableValue)this.transition);
        }
        this.label = new Label();
        this.label.setMaxSize(Double.MAX_VALUE, Double.MAX_VALUE);
        GridPane.setVgrow((Node)this.label, (Priority)Priority.ALWAYS);
        GridPane.setHgrow((Node)this.label, (Priority)Priority.ALWAYS);
        this.label.setText(this.getText());
        this.label.setGraphic(this.getGraphic());
        this.label.opacityProperty().bind((ObservableValue)this.transition);
        this.getActions().addListener(new InvalidationListener(){

            public void invalidated(Observable arg0) {
                NotificationBar.this.updatePane();
            }
        });
        this.closeBtn = new Button();
        this.closeBtn.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent arg0) {
                NotificationBar.this.hide();
            }
        });
        this.closeBtn.getStyleClass().setAll((Object[])new String[]{"close-button"});
        StackPane graphic = new StackPane();
        graphic.getStyleClass().setAll((Object[])new String[]{"graphic"});
        this.closeBtn.setGraphic((Node)graphic);
        this.closeBtn.setMinSize(17.0, 17.0);
        this.closeBtn.setPrefSize(17.0, 17.0);
        this.closeBtn.setFocusTraversable(false);
        this.closeBtn.opacityProperty().bind((ObservableValue)this.transition);
        GridPane.setMargin((Node)this.closeBtn, (Insets)new Insets(0.0, 0.0, 0.0, 8.0));
        double minHeight = this.minHeight(-1.0);
        GridPane.setValignment((Node)this.closeBtn, (VPos)(minHeight == 40.0 ? VPos.CENTER : VPos.TOP));
        this.updatePane();
    }

    void updatePane() {
        this.actionsBar = ActionUtils.createButtonBar(this.getActions());
        this.actionsBar.opacityProperty().bind((ObservableValue)this.transition);
        GridPane.setHgrow((Node)this.actionsBar, (Priority)Priority.SOMETIMES);
        this.pane.getChildren().clear();
        int row = 0;
        if (this.title != null) {
            this.pane.add((Node)this.title, 0, row++);
        }
        this.pane.add((Node)this.label, 0, row);
        this.pane.add((Node)this.actionsBar, 1, row);
        if (this.isCloseButtonVisible()) {
            this.pane.add((Node)this.closeBtn, 2, 0, 1, row + 1);
        }
    }

    protected void layoutChildren() {
        double w = this.getWidth();
        double h2 = this.computePrefHeight(-1.0);
        double notificationBarHeight = this.prefHeight(w);
        double notificationMinHeight = this.minHeight(w);
        if (this.isShowFromTop()) {
            this.pane.resize(w, h2);
            this.relocateInParent(0.0, (this.transition.get() - 1.0) * notificationMinHeight);
        } else {
            this.pane.resize(w, notificationBarHeight);
            this.relocateInParent(0.0, this.getContainerHeight() - notificationBarHeight);
        }
    }

    protected double computeMinHeight(double width) {
        return Math.max(super.computePrefHeight(width), 40.0);
    }

    protected double computePrefHeight(double width) {
        return Math.max(this.pane.prefHeight(width), this.minHeight(width)) * this.transition.get();
    }

    public void doShow() {
        this.transitionStartValue = 0.0;
        this.doAnimationTransition();
    }

    public void doHide() {
        this.transitionStartValue = 1.0;
        this.doAnimationTransition();
    }

    private void doAnimationTransition() {
        KeyFrame k2;
        KeyFrame k1;
        Duration duration;
        if (this.timeline != null && this.timeline.getStatus() != Animation.Status.STOPPED) {
            duration = this.timeline.getCurrentTime();
            duration = duration == Duration.ZERO ? this.TRANSITION_DURATION : duration;
            this.transitionStartValue = this.transition.get();
            this.timeline.stop();
        } else {
            duration = this.TRANSITION_DURATION;
        }
        this.timeline = new Timeline();
        this.timeline.setCycleCount(1);
        if (this.isShowing()) {
            k1 = new KeyFrame(Duration.ZERO, (EventHandler)new EventHandler<ActionEvent>(){

                public void handle(ActionEvent event) {
                    NotificationBar.this.setCache(true);
                    NotificationBar.this.setVisible(true);
                    NotificationBar.this.pane.fireEvent(new Event(NotificationPane.ON_SHOWING));
                }
            }, new KeyValue[]{new KeyValue((WritableValue)this.transition, (Object)this.transitionStartValue)});
            k2 = new KeyFrame(duration, (EventHandler)new EventHandler<ActionEvent>(){

                public void handle(ActionEvent event) {
                    NotificationBar.this.pane.setCache(false);
                    NotificationBar.this.pane.fireEvent(new Event(NotificationPane.ON_SHOWN));
                }
            }, new KeyValue[]{new KeyValue((WritableValue)this.transition, (Object)1, Interpolator.EASE_OUT)});
        } else {
            k1 = new KeyFrame(Duration.ZERO, (EventHandler)new EventHandler<ActionEvent>(){

                public void handle(ActionEvent event) {
                    NotificationBar.this.pane.setCache(true);
                    NotificationBar.this.pane.fireEvent(new Event(NotificationPane.ON_HIDING));
                }
            }, new KeyValue[]{new KeyValue((WritableValue)this.transition, (Object)this.transitionStartValue)});
            k2 = new KeyFrame(duration, (EventHandler)new EventHandler<ActionEvent>(){

                public void handle(ActionEvent event) {
                    NotificationBar.this.setCache(false);
                    NotificationBar.this.setVisible(false);
                    NotificationBar.this.pane.fireEvent(new Event(NotificationPane.ON_HIDDEN));
                }
            }, new KeyValue[]{new KeyValue((WritableValue)this.transition, (Object)0, Interpolator.EASE_IN)});
        }
        this.timeline.getKeyFrames().setAll((Object[])new KeyFrame[]{k1, k2});
        this.timeline.play();
    }
}

