/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.dom.svg;

import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import org.apache.batik.dom.svg.SVGOMException;
import org.apache.batik.dom.svg.SVGOMMatrix;
import org.w3c.dom.DOMException;
import org.w3c.dom.svg.SVGException;
import org.w3c.dom.svg.SVGMatrix;

public abstract class AbstractSVGMatrix
implements SVGMatrix {
    protected static final AffineTransform FLIP_X_TRANSFORM = new AffineTransform(-1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f);
    protected static final AffineTransform FLIP_Y_TRANSFORM = new AffineTransform(1.0f, 0.0f, 0.0f, -1.0f, 0.0f, 0.0f);

    protected abstract AffineTransform getAffineTransform();

    @Override
    public float getA() {
        return (float)this.getAffineTransform().getScaleX();
    }

    @Override
    public void setA(float f) throws DOMException {
        AffineTransform affineTransform = this.getAffineTransform();
        affineTransform.setTransform(f, affineTransform.getShearY(), affineTransform.getShearX(), affineTransform.getScaleY(), affineTransform.getTranslateX(), affineTransform.getTranslateY());
    }

    @Override
    public float getB() {
        return (float)this.getAffineTransform().getShearY();
    }

    @Override
    public void setB(float f) throws DOMException {
        AffineTransform affineTransform = this.getAffineTransform();
        affineTransform.setTransform(affineTransform.getScaleX(), f, affineTransform.getShearX(), affineTransform.getScaleY(), affineTransform.getTranslateX(), affineTransform.getTranslateY());
    }

    @Override
    public float getC() {
        return (float)this.getAffineTransform().getShearX();
    }

    @Override
    public void setC(float f) throws DOMException {
        AffineTransform affineTransform = this.getAffineTransform();
        affineTransform.setTransform(affineTransform.getScaleX(), affineTransform.getShearY(), f, affineTransform.getScaleY(), affineTransform.getTranslateX(), affineTransform.getTranslateY());
    }

    @Override
    public float getD() {
        return (float)this.getAffineTransform().getScaleY();
    }

    @Override
    public void setD(float f) throws DOMException {
        AffineTransform affineTransform = this.getAffineTransform();
        affineTransform.setTransform(affineTransform.getScaleX(), affineTransform.getShearY(), affineTransform.getShearX(), f, affineTransform.getTranslateX(), affineTransform.getTranslateY());
    }

    @Override
    public float getE() {
        return (float)this.getAffineTransform().getTranslateX();
    }

    @Override
    public void setE(float f) throws DOMException {
        AffineTransform affineTransform = this.getAffineTransform();
        affineTransform.setTransform(affineTransform.getScaleX(), affineTransform.getShearY(), affineTransform.getShearX(), affineTransform.getScaleY(), f, affineTransform.getTranslateY());
    }

    @Override
    public float getF() {
        return (float)this.getAffineTransform().getTranslateY();
    }

    @Override
    public void setF(float f) throws DOMException {
        AffineTransform affineTransform = this.getAffineTransform();
        affineTransform.setTransform(affineTransform.getScaleX(), affineTransform.getShearY(), affineTransform.getShearX(), affineTransform.getScaleY(), affineTransform.getTranslateX(), f);
    }

    @Override
    public SVGMatrix multiply(SVGMatrix sVGMatrix) {
        AffineTransform affineTransform = new AffineTransform(sVGMatrix.getA(), sVGMatrix.getB(), sVGMatrix.getC(), sVGMatrix.getD(), sVGMatrix.getE(), sVGMatrix.getF());
        AffineTransform affineTransform2 = (AffineTransform)this.getAffineTransform().clone();
        affineTransform2.concatenate(affineTransform);
        return new SVGOMMatrix(affineTransform2);
    }

    @Override
    public SVGMatrix inverse() throws SVGException {
        try {
            return new SVGOMMatrix(this.getAffineTransform().createInverse());
        }
        catch (NoninvertibleTransformException noninvertibleTransformException) {
            throw new SVGOMException(2, noninvertibleTransformException.getMessage());
        }
    }

    @Override
    public SVGMatrix translate(float f, float f2) {
        AffineTransform affineTransform = (AffineTransform)this.getAffineTransform().clone();
        affineTransform.translate(f, f2);
        return new SVGOMMatrix(affineTransform);
    }

    @Override
    public SVGMatrix scale(float f) {
        AffineTransform affineTransform = (AffineTransform)this.getAffineTransform().clone();
        affineTransform.scale(f, f);
        return new SVGOMMatrix(affineTransform);
    }

    @Override
    public SVGMatrix scaleNonUniform(float f, float f2) {
        AffineTransform affineTransform = (AffineTransform)this.getAffineTransform().clone();
        affineTransform.scale(f, f2);
        return new SVGOMMatrix(affineTransform);
    }

    @Override
    public SVGMatrix rotate(float f) {
        AffineTransform affineTransform = (AffineTransform)this.getAffineTransform().clone();
        affineTransform.rotate(Math.toRadians(f));
        return new SVGOMMatrix(affineTransform);
    }

    @Override
    public SVGMatrix rotateFromVector(float f, float f2) throws SVGException {
        if (f == 0.0f || f2 == 0.0f) {
            throw new SVGOMException(1, "");
        }
        AffineTransform affineTransform = (AffineTransform)this.getAffineTransform().clone();
        affineTransform.rotate(Math.atan2(f2, f));
        return new SVGOMMatrix(affineTransform);
    }

    @Override
    public SVGMatrix flipX() {
        AffineTransform affineTransform = (AffineTransform)this.getAffineTransform().clone();
        affineTransform.concatenate(FLIP_X_TRANSFORM);
        return new SVGOMMatrix(affineTransform);
    }

    @Override
    public SVGMatrix flipY() {
        AffineTransform affineTransform = (AffineTransform)this.getAffineTransform().clone();
        affineTransform.concatenate(FLIP_Y_TRANSFORM);
        return new SVGOMMatrix(affineTransform);
    }

    @Override
    public SVGMatrix skewX(float f) {
        AffineTransform affineTransform = (AffineTransform)this.getAffineTransform().clone();
        affineTransform.concatenate(AffineTransform.getShearInstance(Math.tan(Math.toRadians(f)), 0.0));
        return new SVGOMMatrix(affineTransform);
    }

    @Override
    public SVGMatrix skewY(float f) {
        AffineTransform affineTransform = (AffineTransform)this.getAffineTransform().clone();
        affineTransform.concatenate(AffineTransform.getShearInstance(0.0, Math.tan(Math.toRadians(f))));
        return new SVGOMMatrix(affineTransform);
    }
}

