/*
 * Decompiled with CFR 0.152.
 */
package org.fxmisc.easybind.monadic;

import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import javafx.beans.InvalidationListener;
import javafx.beans.Observable;
import javafx.beans.property.Property;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableObjectValue;
import javafx.beans.value.ObservableValue;
import org.fxmisc.easybind.PreboundBinding;
import org.fxmisc.easybind.Subscription;
import org.fxmisc.easybind.monadic.FirstNonNullBinding;
import org.fxmisc.easybind.monadic.FlatMapBinding;
import org.fxmisc.easybind.monadic.FlatMapProperty;
import org.fxmisc.easybind.monadic.MonadicBinding;
import org.fxmisc.easybind.monadic.PropertyBinding;
import org.fxmisc.easybind.select.SelectBuilder;

public interface MonadicObservableValue<T>
extends ObservableObjectValue<T> {
    default public boolean isPresent() {
        return this.getValue() != null;
    }

    default public boolean isEmpty() {
        return this.getValue() == null;
    }

    default public void ifPresent(Consumer<? super T> f) {
        Object val = this.getValue();
        if (val != null) {
            f.accept(val);
        }
    }

    default public T getOrThrow() {
        Object res = this.getValue();
        if (res != null) {
            return (T)res;
        }
        throw new NoSuchElementException();
    }

    default public T getOrElse(T other) {
        Object res = this.getValue();
        if (res != null) {
            return (T)res;
        }
        return other;
    }

    default public Optional<T> getOpt() {
        return Optional.ofNullable(this.getValue());
    }

    default public MonadicBinding<T> orElse(final T other) {
        return new PreboundBinding<T>(new Observable[]{this}){

            protected T computeValue() {
                Object val = MonadicObservableValue.this.getValue();
                return val != null ? val : other;
            }
        };
    }

    default public MonadicBinding<T> orElse(ObservableValue<T> other) {
        return new FirstNonNullBinding(new ObservableValue[]{this, other});
    }

    default public MonadicBinding<T> filter(final Predicate<? super T> p) {
        return new PreboundBinding<T>(new Observable[]{this}){

            protected T computeValue() {
                Object val = MonadicObservableValue.this.getValue();
                return val != null && p.test(val) ? val : null;
            }
        };
    }

    default public <U> MonadicBinding<U> map(final Function<? super T, ? extends U> f) {
        return new PreboundBinding<U>(new Observable[]{this}){

            protected U computeValue() {
                Object baseVal = MonadicObservableValue.this.getValue();
                return baseVal != null ? (Object)f.apply(baseVal) : null;
            }
        };
    }

    default public <U> MonadicBinding<U> flatMap(Function<? super T, ObservableValue<U>> f) {
        return new FlatMapBinding<T, U>(this, f);
    }

    default public <U> PropertyBinding<U> selectProperty(Function<? super T, Property<U>> f) {
        return new FlatMapProperty<T, U>(this, f);
    }

    default public <U> SelectBuilder<U> select(Function<? super T, ObservableValue<U>> selector) {
        return SelectBuilder.startAt(this).select(selector);
    }

    default public Subscription subscribe(InvalidationListener listener) {
        this.addListener(listener);
        return () -> this.removeListener(listener);
    }

    default public Subscription subscribe(ChangeListener<? super T> listener) {
        this.addListener(listener);
        return () -> this.removeListener(listener);
    }
}

