/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.gui;

import com.airhacks.afterburner.views.FXMLView;
import java.util.Optional;
import java.util.function.Function;
import javafx.scene.Parent;
import javafx.stage.Stage;
import org.jabref.gui.AbstractController;
import org.jabref.gui.AbstractDialogView;
import org.jabref.logic.l10n.Localization;

public class AbstractView
extends FXMLView {
    public AbstractView() {
        this(f -> null);
    }

    public AbstractView(Function<String, Object> injectionContext) {
        super(injectionContext);
        this.bundle = Localization.getMessages();
    }

    @Override
    public Parent getView() {
        Parent view = super.getView();
        view.getStylesheets().add(0, (Object)AbstractDialogView.class.getResource("Main.css").toExternalForm());
        view.sceneProperty().addListener((observable, oldValue, newValue) -> {
            Stage stage;
            if (newValue != null && newValue.getWindow() instanceof Stage && (stage = (Stage)newValue.getWindow()) != null) {
                this.getController().ifPresent(controller -> controller.setStage(stage));
            }
        });
        return view;
    }

    private Optional<AbstractController> getController() {
        return Optional.ofNullable(this.presenterProperty.get()).map(presenter -> (AbstractController)presenter);
    }
}

