/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.gui;

import java.nio.file.Path;
import java.util.List;
import java.util.Optional;
import javafx.concurrent.Task;
import javafx.print.PrinterJob;
import javafx.scene.control.Alert;
import javafx.scene.control.ButtonType;
import javafx.scene.control.DialogPane;
import org.jabref.gui.Dialog;
import org.jabref.gui.util.DirectoryDialogConfiguration;
import org.jabref.gui.util.FileDialogConfiguration;
import org.jabref.logic.l10n.Localization;

public interface DialogService {
    public Optional<String> showInputDialogAndWait(String var1, String var2);

    public void showInformationDialogAndWait(String var1, String var2);

    public void showWarningDialogAndWait(String var1, String var2);

    public void showErrorDialogAndWait(String var1, String var2);

    public void showErrorDialogAndWait(String var1, Throwable var2);

    default public void showErrorDialogAndWait(Exception exception) {
        this.showErrorDialogAndWait(Localization.lang("Unhandled exception occurred.", new String[0]), exception);
    }

    public void showErrorDialogAndWait(String var1);

    public boolean showConfirmationDialogAndWait(String var1, String var2);

    public boolean showConfirmationDialogAndWait(String var1, String var2, String var3);

    public boolean showConfirmationDialogAndWait(String var1, String var2, String var3, String var4);

    public Optional<ButtonType> showCustomButtonDialogAndWait(Alert.AlertType var1, String var2, String var3, ButtonType ... var4);

    public Optional<ButtonType> showCustomDialogAndWait(String var1, DialogPane var2, ButtonType ... var3);

    public <R> Optional<R> showCustomDialogAndWait(Dialog<R> var1);

    public <V> void showCanceableProgressDialogAndWait(Task<V> var1);

    public void notify(String var1);

    public Optional<Path> showFileSaveDialog(FileDialogConfiguration var1);

    public Optional<Path> showFileOpenDialog(FileDialogConfiguration var1);

    public List<Path> showFileOpenDialogAndGetMultipleFiles(FileDialogConfiguration var1);

    public Optional<Path> showDirectorySelectionDialog(DirectoryDialogConfiguration var1);

    public boolean showPrintDialog(PrinterJob var1);
}

