/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.gui;

import com.jgoodies.forms.builder.ButtonBarBuilder;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JRootPane;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.filechooser.FileSystemView;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.jabref.Globals;
import org.jabref.JabRefExecutorService;
import org.jabref.JabRefGUI;
import org.jabref.gui.BasePanel;
import org.jabref.gui.FXDialogService;
import org.jabref.gui.JabRefDialog;
import org.jabref.gui.JabRefFrame;
import org.jabref.gui.desktop.JabRefDesktop;
import org.jabref.gui.externalfiletype.ExternalFileTypes;
import org.jabref.gui.importer.EntryFromFileCreator;
import org.jabref.gui.importer.EntryFromFileCreatorManager;
import org.jabref.gui.importer.UnlinkedFilesCrawler;
import org.jabref.gui.importer.UnlinkedPDFFileFilter;
import org.jabref.gui.util.DefaultTaskExecutor;
import org.jabref.gui.util.DirectoryDialogConfiguration;
import org.jabref.gui.util.FileDialogConfiguration;
import org.jabref.logic.l10n.Localization;
import org.jabref.model.EntryTypes;
import org.jabref.model.database.BibDatabaseContext;
import org.jabref.model.entry.EntryType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FindUnlinkedFilesDialog
extends JabRefDialog {
    public static final String ACTION_COMMAND = "findUnlinkedFiles";
    public static final String ACTION_MENU_TITLE = Localization.menuTitle("Find unlinked files...", new String[0]);
    public static final String ACTION_SHORT_DESCRIPTION = Localization.lang("Searches for unlinked PDF files on the file system", new String[0]);
    private static final Logger LOGGER = LoggerFactory.getLogger(FindUnlinkedFilesDialog.class);
    private static final String GLOBAL_PREFS_WORKING_DIRECTORY_KEY = "findUnlinkedFilesWD";
    private static final String GLOBAL_PREFS_DIALOG_SIZE_KEY = "findUnlinkedFilesDialogSize";
    private final JabRefFrame frame;
    private final BibDatabaseContext databaseContext;
    private final EntryFromFileCreatorManager creatorManager;
    private final UnlinkedFilesCrawler crawler;
    private Path lastSelectedDirectory;
    private TreeModel treeModel;
    private JPanel panelDirectory;
    private JPanel panelSearchArea;
    private JPanel panelFiles;
    private JPanel panelOptions;
    private JPanel panelButtons;
    private JPanel panelEntryTypesSelection;
    private JPanel panelImportArea;
    private JButton buttonBrowse;
    private JButton buttonScan;
    private JButton buttonExport;
    private JButton buttonApply;
    private JButton buttonClose;
    private JButton buttonOptionSelectAll;
    private JButton buttonOptionDeselectAll;
    private JButton buttonOptionExpandAll;
    private JButton buttonOptionCollapseAll;
    private JCheckBox checkboxCreateKeywords;
    private JTextField textfieldDirectoryPath;
    private JLabel labelDirectoryDescription;
    private JLabel labelFileTypesDescription;
    private JLabel labelFilesDescription;
    private JLabel labelEntryTypeDescription;
    private JLabel labelSearchingDirectoryInfo;
    private JLabel labelImportingInfo;
    private JLabel labelExportingInfo;
    private JTree tree;
    private JScrollPane scrollpaneTree;
    private JComboBox<FileFilter> comboBoxFileTypeSelection;
    private JComboBox<BibtexEntryTypeWrapper> comboBoxEntryTypeSelection;
    private JProgressBar progressBarSearching;
    private JProgressBar progressBarImporting;
    private MouseListener treeMouseListener;
    private Action actionSelectAll;
    private Action actionUnselectAll;
    private Action actionExpandTree;
    private Action actionCollapseTree;
    private ComponentListener dialogPositionListener;
    private final AtomicBoolean threadState = new AtomicBoolean();
    private boolean checkBoxWhyIsThereNoGetSelectedStupidSwing;

    public FindUnlinkedFilesDialog(Frame owner, JabRefFrame frame, BasePanel panel) {
        super(owner, Localization.lang("Find unlinked files", new String[0]), true, FindUnlinkedFilesDialog.class);
        this.frame = frame;
        this.restoreSizeOfDialog();
        this.databaseContext = panel.getBibDatabaseContext();
        this.creatorManager = new EntryFromFileCreatorManager(ExternalFileTypes.getInstance());
        this.crawler = new UnlinkedFilesCrawler(this.databaseContext);
        this.lastSelectedDirectory = this.loadLastSelectedDirectory();
        this.initialize();
        this.buttonApply.setEnabled(false);
        this.buttonExport.setEnabled(false);
    }

    @Override
    protected JRootPane createRootPane() {
        ActionListener actionListener = actionEvent -> this.setVisible(false);
        JRootPane rPane = new JRootPane();
        KeyStroke stroke = KeyStroke.getKeyStroke(27, 0);
        rPane.registerKeyboardAction(actionListener, stroke, 2);
        return rPane;
    }

    private void storeSizeOfDialog() {
        Dimension dim = this.getSize();
        String store = dim.width + ";" + dim.height;
        Globals.prefs.put(GLOBAL_PREFS_DIALOG_SIZE_KEY, store);
    }

    private void restoreSizeOfDialog() {
        String store = Globals.prefs.get(GLOBAL_PREFS_DIALOG_SIZE_KEY);
        Dimension dimension = null;
        if (store != null) {
            try {
                String[] dim = store.split(";");
                dimension = new Dimension(Integer.valueOf(dim[0]), Integer.valueOf(dim[1]));
            }
            catch (NumberFormatException ignoredEx) {
                LOGGER.debug("RestoreSizeDialog Exception ", ignoredEx);
            }
        }
        if (dimension != null) {
            this.setPreferredSize(dimension);
        }
    }

    private void initialize() {
        this.initializeActions();
        this.initComponents();
        this.createTree();
        this.createFileTypesCombobox();
        this.createEntryTypesCombobox();
        this.initLayout();
        this.setupActions();
        this.pack();
    }

    private void initializeActions() {
        this.actionSelectAll = new AbstractAction(Localization.lang("Select all", new String[0])){

            @Override
            public void actionPerformed(ActionEvent e) {
                CheckableTreeNode rootNode = (CheckableTreeNode)FindUnlinkedFilesDialog.this.tree.getModel().getRoot();
                rootNode.setSelected(true);
                FindUnlinkedFilesDialog.this.tree.invalidate();
                FindUnlinkedFilesDialog.this.tree.repaint();
            }
        };
        this.actionUnselectAll = new AbstractAction(Localization.lang("Unselect all", new String[0])){

            @Override
            public void actionPerformed(ActionEvent e) {
                CheckableTreeNode rootNode = (CheckableTreeNode)FindUnlinkedFilesDialog.this.tree.getModel().getRoot();
                rootNode.setSelected(false);
                FindUnlinkedFilesDialog.this.tree.invalidate();
                FindUnlinkedFilesDialog.this.tree.repaint();
            }
        };
        this.actionExpandTree = new AbstractAction(Localization.lang("Expand all", new String[0])){

            @Override
            public void actionPerformed(ActionEvent e) {
                CheckableTreeNode rootNode = (CheckableTreeNode)FindUnlinkedFilesDialog.this.tree.getModel().getRoot();
                FindUnlinkedFilesDialog.this.expandTree(FindUnlinkedFilesDialog.this.tree, new TreePath(rootNode), true);
            }
        };
        this.actionCollapseTree = new AbstractAction(Localization.lang("Collapse all", new String[0])){

            @Override
            public void actionPerformed(ActionEvent e) {
                CheckableTreeNode rootNode = (CheckableTreeNode)FindUnlinkedFilesDialog.this.tree.getModel().getRoot();
                FindUnlinkedFilesDialog.this.expandTree(FindUnlinkedFilesDialog.this.tree, new TreePath(rootNode), false);
            }
        };
        this.dialogPositionListener = new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                FindUnlinkedFilesDialog.this.storeSizeOfDialog();
            }

            @Override
            public void componentMoved(ComponentEvent e) {
                FindUnlinkedFilesDialog.this.storeSizeOfDialog();
            }
        };
    }

    private void storeLastSelectedDirectory(Path lastSelectedDir) {
        this.lastSelectedDirectory = lastSelectedDir;
        if (this.lastSelectedDirectory != null) {
            Globals.prefs.put(GLOBAL_PREFS_WORKING_DIRECTORY_KEY, this.lastSelectedDirectory.toAbsolutePath().toString());
        }
    }

    private Path loadLastSelectedDirectory() {
        String workingDirectory = Globals.prefs.get(GLOBAL_PREFS_WORKING_DIRECTORY_KEY);
        if (workingDirectory == null) {
            workingDirectory = Globals.prefs.get("workingDirectory");
        }
        this.lastSelectedDirectory = Paths.get(workingDirectory, new String[0]);
        return this.lastSelectedDirectory;
    }

    private void disOrEnableDialog(boolean enable) {
        if (enable) {
            this.tree.addMouseListener(this.treeMouseListener);
        } else {
            this.tree.removeMouseListener(this.treeMouseListener);
        }
        this.disOrEnableAllElements(this, enable);
    }

    private void disOrEnableAllElements(Container startContainer, boolean enable) {
        Component[] children;
        for (Component child : children = startContainer.getComponents()) {
            if (child instanceof Container) {
                this.disOrEnableAllElements((Container)child, enable);
            }
            child.setEnabled(enable);
        }
    }

    private void expandTree(JTree currentTree, TreePath parent, boolean expand) {
        TreeNode node = (TreeNode)parent.getLastPathComponent();
        if (node.getChildCount() >= 0) {
            Enumeration<? extends TreeNode> e = node.children();
            while (e.hasMoreElements()) {
                TreePath path = parent.pathByAddingChild(e.nextElement());
                this.expandTree(currentTree, path, expand);
            }
        }
        if (expand) {
            currentTree.expandPath(parent);
        } else {
            currentTree.collapsePath(parent);
        }
    }

    private void startSearch() {
        Path directory = Paths.get(this.textfieldDirectoryPath.getText(), new String[0]);
        if (Files.notExists(directory, new LinkOption[0])) {
            directory = Paths.get(System.getProperty("user.dir"), new String[0]);
        }
        if (!Files.isDirectory(directory, new LinkOption[0])) {
            directory = directory.getParent();
        }
        Path dir = directory;
        this.storeLastSelectedDirectory(directory);
        this.progressBarSearching.setMinimumSize(new Dimension(this.buttonScan.getSize().width, this.progressBarSearching.getMinimumSize().height));
        this.progressBarSearching.setVisible(true);
        this.progressBarSearching.setString("");
        this.labelSearchingDirectoryInfo.setVisible(true);
        this.buttonScan.setVisible(false);
        this.disOrEnableDialog(false);
        this.labelSearchingDirectoryInfo.setEnabled(true);
        FileFilter selectedFileFilter = (FileFilter)this.comboBoxFileTypeSelection.getSelectedItem();
        this.threadState.set(true);
        JabRefExecutorService.INSTANCE.execute(() -> {
            UnlinkedPDFFileFilter unlinkedPDFFileFilter = new UnlinkedPDFFileFilter(selectedFileFilter, this.databaseContext);
            CheckableTreeNode rootNode = this.crawler.searchDirectory(dir.toFile(), unlinkedPDFFileFilter, this.threadState, new ChangeListener(){
                int counter;

                @Override
                public void stateChanged(ChangeEvent e) {
                    ++this.counter;
                    String message = this.counter == 1 ? Localization.lang("One file found", new String[0]) : Localization.lang("%0 files found", Integer.toString(this.counter));
                    FindUnlinkedFilesDialog.this.progressBarSearching.setString(message);
                }
            });
            this.searchFinishedHandler(rootNode);
        });
    }

    private void startImport() {
        if (this.treeModel == null) {
            return;
        }
        this.setDefaultCloseOperation(0);
        CheckableTreeNode root = (CheckableTreeNode)this.treeModel.getRoot();
        List<File> fileList = this.getFileListFromNode(root);
        if (fileList == null || fileList.isEmpty()) {
            return;
        }
        this.progressBarImporting.setVisible(true);
        this.labelImportingInfo.setVisible(true);
        this.buttonExport.setVisible(false);
        this.buttonApply.setVisible(false);
        this.buttonClose.setVisible(false);
        this.disOrEnableDialog(false);
        this.labelImportingInfo.setEnabled(true);
        this.progressBarImporting.setMinimum(0);
        this.progressBarImporting.setMaximum(fileList.size());
        this.progressBarImporting.setValue(0);
        this.progressBarImporting.setString("");
        EntryType entryType = ((BibtexEntryTypeWrapper)this.comboBoxEntryTypeSelection.getSelectedItem()).getEntryType();
        this.threadState.set(true);
        JabRefExecutorService.INSTANCE.execute(() -> {
            LinkedList<String> errors = new LinkedList<String>();
            this.creatorManager.addEntriesFromFiles(fileList, this.databaseContext.getDatabase(), this.frame.getCurrentBasePanel(), entryType, this.checkBoxWhyIsThereNoGetSelectedStupidSwing, new ChangeListener(){
                int counter;

                @Override
                public void stateChanged(ChangeEvent e) {
                    ++this.counter;
                    FindUnlinkedFilesDialog.this.progressBarImporting.setValue(this.counter);
                    FindUnlinkedFilesDialog.this.progressBarImporting.setString(Localization.lang("%0 of %1", Integer.toString(this.counter), Integer.toString(FindUnlinkedFilesDialog.this.progressBarImporting.getMaximum())));
                }
            }, errors);
            this.importFinishedHandler(errors);
        });
    }

    private void startExport() {
        if (this.treeModel == null) {
            return;
        }
        this.setDefaultCloseOperation(0);
        CheckableTreeNode root = (CheckableTreeNode)this.treeModel.getRoot();
        List<File> fileList = this.getFileListFromNode(root);
        if (fileList == null || fileList.isEmpty()) {
            return;
        }
        this.buttonExport.setVisible(false);
        this.buttonApply.setVisible(false);
        this.buttonClose.setVisible(false);
        this.disOrEnableDialog(false);
        FileDialogConfiguration fileDialogConfiguration = new FileDialogConfiguration.Builder().withInitialDirectory(Globals.prefs.get("workingDirectory")).build();
        FXDialogService ds = new FXDialogService();
        Optional exportPath = DefaultTaskExecutor.runInJavaFXThread(() -> ds.showFileSaveDialog(fileDialogConfiguration));
        if (!exportPath.isPresent()) {
            this.exportFinishedHandler();
            return;
        }
        this.threadState.set(true);
        JabRefExecutorService.INSTANCE.execute(() -> {
            try (BufferedWriter writer = Files.newBufferedWriter((Path)exportPath.get(), StandardCharsets.UTF_8, StandardOpenOption.CREATE);){
                for (File file : fileList) {
                    writer.write(file.toString() + "\n");
                }
            }
            catch (IOException e) {
                LOGGER.warn("IO Error.", e);
            }
        });
        this.exportFinishedHandler();
    }

    private void exportFinishedHandler() {
        this.buttonExport.setVisible(true);
        this.buttonApply.setVisible(true);
        this.buttonClose.setVisible(true);
        this.disOrEnableDialog(true);
        this.setDefaultCloseOperation(2);
        this.frame.getCurrentBasePanel().markBaseChanged();
    }

    private void importFinishedHandler(List<String> errors) {
        if (errors != null && !errors.isEmpty()) {
            String message = errors.size() == 1 ? Localization.lang("There was one file that could not be imported.", new String[0]) : Localization.lang("There were %0 files which could not be imported.", Integer.toString(errors.size()));
            JOptionPane.showMessageDialog(this, Localization.lang("The import finished with warnings:", new String[0]) + "\n" + message, Localization.lang("Warning", new String[0]), 2);
        }
        this.progressBarImporting.setVisible(false);
        this.labelImportingInfo.setVisible(false);
        this.buttonExport.setVisible(true);
        this.buttonApply.setVisible(true);
        this.buttonClose.setVisible(true);
        this.disOrEnableDialog(true);
        this.setDefaultCloseOperation(2);
        this.frame.getCurrentBasePanel().markBaseChanged();
    }

    private void searchFinishedHandler(CheckableTreeNode rootNode) {
        this.treeModel = new DefaultTreeModel(rootNode);
        this.tree.setModel(this.treeModel);
        this.tree.setRootVisible(rootNode.getChildCount() > 0);
        this.tree.invalidate();
        this.tree.repaint();
        this.progressBarSearching.setVisible(false);
        this.labelSearchingDirectoryInfo.setVisible(false);
        this.buttonScan.setVisible(true);
        this.actionSelectAll.actionPerformed(null);
        this.disOrEnableDialog(true);
        this.buttonApply.setEnabled(true);
        this.buttonExport.setEnabled(true);
    }

    private void setupActions() {
        DirectoryDialogConfiguration directoryDialogConfiguration = new DirectoryDialogConfiguration.Builder().withInitialDirectory(Globals.prefs.get("workingDirectory")).build();
        FXDialogService ds = new FXDialogService();
        this.buttonBrowse.addActionListener(e -> {
            Optional selectedDirectory = DefaultTaskExecutor.runInJavaFXThread(() -> ds.showDirectorySelectionDialog(directoryDialogConfiguration));
            selectedDirectory.ifPresent(d -> {
                this.textfieldDirectoryPath.setText(d.toAbsolutePath().toString());
                this.storeLastSelectedDirectory((Path)d);
            });
        });
        this.buttonScan.addActionListener(e -> this.startSearch());
        this.buttonExport.addActionListener(e -> this.startExport());
        this.buttonApply.addActionListener(e -> this.startImport());
        this.buttonClose.addActionListener(e -> this.dispose());
    }

    private List<File> getFileListFromNode(CheckableTreeNode node) {
        ArrayList<File> filesList = new ArrayList<File>();
        Enumeration<TreeNode> children = node.depthFirstEnumeration();
        ArrayList<CheckableTreeNode> nodesToRemove = new ArrayList<CheckableTreeNode>();
        for (CheckableTreeNode checkableTreeNode : Collections.list(children)) {
            File nodeFile;
            if (!checkableTreeNode.isLeaf() || !checkableTreeNode.isSelected() || (nodeFile = ((FileNodeWrapper)checkableTreeNode.getUserObject()).file) == null || !nodeFile.isFile()) continue;
            filesList.add(nodeFile);
            nodesToRemove.add(checkableTreeNode);
        }
        DefaultTreeModel model = (DefaultTreeModel)this.tree.getModel();
        for (CheckableTreeNode nodeToRemove : nodesToRemove) {
            DefaultMutableTreeNode parent = (DefaultMutableTreeNode)nodeToRemove.getParent();
            model.removeNodeFromParent(nodeToRemove);
            while (parent != null && parent.isLeaf()) {
                DefaultMutableTreeNode pp = (DefaultMutableTreeNode)parent.getParent();
                if (pp != null) {
                    model.removeNodeFromParent(parent);
                }
                parent = pp;
            }
        }
        this.tree.invalidate();
        this.tree.repaint();
        return filesList;
    }

    private void initComponents() {
        this.addComponentListener(this.dialogPositionListener);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                FindUnlinkedFilesDialog.this.threadState.set(false);
            }
        });
        this.panelDirectory = new JPanel();
        this.panelSearchArea = new JPanel();
        this.panelFiles = new JPanel();
        this.panelOptions = new JPanel();
        this.panelEntryTypesSelection = new JPanel();
        this.panelButtons = new JPanel();
        this.panelImportArea = new JPanel();
        this.buttonBrowse = new JButton(Localization.lang("Browse", new String[0]));
        this.buttonBrowse.setMnemonic('B');
        this.buttonBrowse.setToolTipText(Localization.lang("Opens the file browser.", new String[0]));
        this.buttonScan = new JButton(Localization.lang("Scan directory", new String[0]));
        this.buttonScan.setMnemonic('S');
        this.buttonScan.setToolTipText(Localization.lang("Searches the selected directory for unlinked files.", new String[0]));
        this.buttonExport = new JButton(Localization.lang("Export", new String[0]));
        this.buttonExport.setMnemonic('E');
        this.buttonExport.setToolTipText(Localization.lang("Export to text file.", new String[0]));
        this.buttonApply = new JButton(Localization.lang("Apply", new String[0]));
        this.buttonApply.setMnemonic('I');
        this.buttonApply.setToolTipText(Localization.lang("Starts the import of BibTeX entries.", new String[0]));
        this.buttonClose = new JButton(Localization.lang("Close", new String[0]));
        this.buttonClose.setToolTipText(Localization.lang("Leave this dialog.", new String[0]));
        this.buttonClose.setMnemonic('C');
        this.buttonOptionSelectAll = new JButton();
        this.buttonOptionSelectAll.setMnemonic('A');
        this.buttonOptionSelectAll.setAction(this.actionSelectAll);
        this.buttonOptionDeselectAll = new JButton();
        this.buttonOptionDeselectAll.setMnemonic('U');
        this.buttonOptionDeselectAll.setAction(this.actionUnselectAll);
        this.buttonOptionExpandAll = new JButton();
        this.buttonOptionExpandAll.setMnemonic('E');
        this.buttonOptionExpandAll.setAction(this.actionExpandTree);
        this.buttonOptionCollapseAll = new JButton();
        this.buttonOptionCollapseAll.setMnemonic('L');
        this.buttonOptionCollapseAll.setAction(this.actionCollapseTree);
        this.checkboxCreateKeywords = new JCheckBox(Localization.lang("Create directory based keywords", new String[0]));
        this.checkboxCreateKeywords.setToolTipText(Localization.lang("Creates keywords in created entrys with directory pathnames", new String[0]));
        this.checkboxCreateKeywords.setSelected(this.checkBoxWhyIsThereNoGetSelectedStupidSwing);
        this.checkboxCreateKeywords.addItemListener(e -> {
            this.checkBoxWhyIsThereNoGetSelectedStupidSwing = !this.checkBoxWhyIsThereNoGetSelectedStupidSwing;
        });
        this.textfieldDirectoryPath = new JTextField();
        this.textfieldDirectoryPath.setText(this.lastSelectedDirectory == null ? "" : this.lastSelectedDirectory.toAbsolutePath().toString());
        this.labelDirectoryDescription = new JLabel(Localization.lang("Select a directory where the search shall start.", new String[0]));
        this.labelFileTypesDescription = new JLabel(Localization.lang("Select file type:", new String[0]));
        this.labelFilesDescription = new JLabel(Localization.lang("These files are not linked in the active library.", new String[0]));
        this.labelEntryTypeDescription = new JLabel(Localization.lang("Entry type to be created:", new String[0]));
        this.labelSearchingDirectoryInfo = new JLabel(Localization.lang("Searching file system...", new String[0]));
        this.labelSearchingDirectoryInfo.setHorizontalAlignment(0);
        this.labelSearchingDirectoryInfo.setVisible(false);
        this.labelImportingInfo = new JLabel(Localization.lang("Importing into Library...", new String[0]));
        this.labelImportingInfo.setHorizontalAlignment(0);
        this.labelImportingInfo.setVisible(false);
        this.labelExportingInfo = new JLabel(Localization.lang("Exporting into file...", new String[0]));
        this.labelExportingInfo.setHorizontalAlignment(0);
        this.labelExportingInfo.setVisible(false);
        this.tree = new JTree();
        this.scrollpaneTree = new JScrollPane(this.tree);
        this.scrollpaneTree.setWheelScrollingEnabled(true);
        this.progressBarSearching = new JProgressBar();
        this.progressBarSearching.setIndeterminate(true);
        this.progressBarSearching.setVisible(false);
        this.progressBarSearching.setStringPainted(true);
        this.progressBarImporting = new JProgressBar();
        this.progressBarImporting.setIndeterminate(false);
        this.progressBarImporting.setVisible(false);
        this.progressBarImporting.setStringPainted(true);
    }

    private void initLayout() {
        GridBagLayout gbl = new GridBagLayout();
        this.panelDirectory.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), Localization.lang("Select directory", new String[0])));
        this.panelFiles.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), Localization.lang("Select files", new String[0])));
        this.panelEntryTypesSelection.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), Localization.lang("BibTeX entry creation", new String[0])));
        Insets basicInsets = new Insets(6, 6, 6, 6);
        Insets smallInsets = new Insets(3, 2, 3, 1);
        Insets noInsets = new Insets(0, 0, 0, 0);
        FindUnlinkedFilesDialog.addComponent(gbl, this.panelSearchArea, this.buttonScan, 2, 13, noInsets, 0, 1, 1, 1, 1.0, 1.0, 40, 10);
        FindUnlinkedFilesDialog.addComponent(gbl, this.panelSearchArea, this.labelSearchingDirectoryInfo, 2, 13, noInsets, 0, 2, 1, 1, 0.0, 0.0, 0, 0);
        FindUnlinkedFilesDialog.addComponent(gbl, this.panelSearchArea, this.progressBarSearching, 2, 13, noInsets, 0, 3, 1, 1, 0.0, 0.0, 0, 0);
        FindUnlinkedFilesDialog.addComponent(gbl, this.panelDirectory, this.labelDirectoryDescription, null, 17, new Insets(6, 6, 0, 6), 0, 0, 3, 1, 0.0, 0.0, 0, 0);
        FindUnlinkedFilesDialog.addComponent(gbl, this.panelDirectory, this.textfieldDirectoryPath, 2, null, basicInsets, 0, 1, 2, 1, 1.0, 1.0, 0, 0);
        FindUnlinkedFilesDialog.addComponent(gbl, this.panelDirectory, this.buttonBrowse, 2, 13, basicInsets, 2, 1, 1, 1, 0.0, 0.0, 0, 0);
        FindUnlinkedFilesDialog.addComponent(gbl, this.panelDirectory, this.labelFileTypesDescription, 0, 17, new Insets(18, 6, 18, 3), 0, 3, 1, 1, 0.0, 0.0, 0, 0);
        FindUnlinkedFilesDialog.addComponent(gbl, this.panelDirectory, this.comboBoxFileTypeSelection, 2, 17, new Insets(18, 3, 18, 6), 1, 3, 1, 1, 1.0, 0.0, 0, 0);
        FindUnlinkedFilesDialog.addComponent(gbl, this.panelDirectory, this.panelSearchArea, 2, 13, new Insets(18, 6, 18, 6), 2, 3, 1, 1, 0.0, 0.0, 0, 0);
        FindUnlinkedFilesDialog.addComponent(gbl, this.panelFiles, this.labelFilesDescription, 2, 17, new Insets(6, 6, 0, 6), 0, 0, 1, 1, 0.0, 0.0, 0, 0);
        FindUnlinkedFilesDialog.addComponent(gbl, this.panelFiles, this.scrollpaneTree, 1, 10, basicInsets, 0, 1, 1, 1, 1.0, 1.0, 0, 0);
        FindUnlinkedFilesDialog.addComponent(gbl, this.panelFiles, this.panelOptions, 0, 12, basicInsets, 1, 1, 1, 1, 0.0, 0.0, 0, 0);
        FindUnlinkedFilesDialog.addComponent(gbl, this.panelOptions, this.buttonOptionSelectAll, 2, 11, noInsets, 0, 0, 1, 1, 1.0, 0.0, 0, 0);
        FindUnlinkedFilesDialog.addComponent(gbl, this.panelOptions, this.buttonOptionDeselectAll, 2, 11, noInsets, 0, 1, 1, 1, 0.0, 0.0, 0, 0);
        FindUnlinkedFilesDialog.addComponent(gbl, this.panelOptions, this.buttonOptionExpandAll, 2, 11, new Insets(6, 0, 0, 0), 0, 2, 1, 1, 0.0, 0.0, 0, 0);
        FindUnlinkedFilesDialog.addComponent(gbl, this.panelOptions, this.buttonOptionCollapseAll, 2, 11, noInsets, 0, 3, 1, 1, 0.0, 0.0, 0, 0);
        FindUnlinkedFilesDialog.addComponent(gbl, this.panelEntryTypesSelection, this.labelEntryTypeDescription, 0, 17, basicInsets, 0, 0, 1, 1, 0.0, 0.0, 0, 0);
        FindUnlinkedFilesDialog.addComponent(gbl, this.panelEntryTypesSelection, this.comboBoxEntryTypeSelection, 0, 17, basicInsets, 1, 0, 1, 1, 1.0, 0.0, 0, 0);
        FindUnlinkedFilesDialog.addComponent(gbl, this.panelEntryTypesSelection, this.checkboxCreateKeywords, 2, 17, basicInsets, 0, 1, 2, 1, 0.0, 0.0, 0, 0);
        FindUnlinkedFilesDialog.addComponent(gbl, this.panelImportArea, this.labelImportingInfo, 2, 10, new Insets(6, 6, 0, 6), 0, 1, 1, 1, 1.0, 0.0, 0, 0);
        FindUnlinkedFilesDialog.addComponent(gbl, this.panelImportArea, this.labelExportingInfo, 2, 10, new Insets(6, 6, 0, 6), 0, 1, 1, 1, 1.0, 0.0, 0, 0);
        FindUnlinkedFilesDialog.addComponent(gbl, this.panelImportArea, this.progressBarImporting, 2, 10, new Insets(0, 6, 6, 6), 0, 2, 1, 1, 1.0, 0.0, 0, 0);
        FindUnlinkedFilesDialog.addComponent(gbl, this.panelButtons, this.panelImportArea, 0, 13, smallInsets, 1, 0, 1, 1, 0.0, 0.0, 0, 0);
        FindUnlinkedFilesDialog.addComponent(gbl, this.getContentPane(), this.panelDirectory, 2, 10, basicInsets, 0, 0, 1, 1, 0.0, 0.0, 0, 0);
        FindUnlinkedFilesDialog.addComponent(gbl, this.getContentPane(), this.panelFiles, 1, 18, new Insets(12, 6, 2, 2), 0, 1, 1, 1, 1.0, 1.0, 0, 0);
        FindUnlinkedFilesDialog.addComponent(gbl, this.getContentPane(), this.panelEntryTypesSelection, 2, 16, new Insets(12, 6, 2, 2), 0, 2, 1, 1, 0.0, 0.0, 0, 0);
        FindUnlinkedFilesDialog.addComponent(gbl, this.getContentPane(), this.panelButtons, 2, 10, new Insets(10, 6, 10, 6), 0, 3, 1, 1, 0.0, 0.0, 0, 0);
        ButtonBarBuilder bb = new ButtonBarBuilder();
        bb.addGlue();
        bb.addButton((JComponent)this.buttonExport);
        bb.addButton((JComponent)this.buttonApply);
        bb.addButton((JComponent)this.buttonClose);
        bb.addGlue();
        bb.getPanel().setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.panelImportArea.add((Component)bb.getPanel(), 0);
        this.pack();
    }

    private static void addComponent(GridBagLayout layout, Container container, Component component, Integer fill, Integer anchor, Insets insets, int gridX, int gridY, int width, int height, double weightX, double weightY, int ipadX, int ipadY) {
        container.setLayout(layout);
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.gridx = gridX;
        constraints.gridy = gridY;
        constraints.gridwidth = width;
        constraints.gridheight = height;
        constraints.weightx = weightX;
        constraints.weighty = weightY;
        constraints.ipadx = ipadX;
        constraints.ipady = ipadY;
        if (fill != null) {
            constraints.fill = fill;
        }
        if (insets != null) {
            constraints.insets = insets;
        }
        if (anchor != null) {
            constraints.anchor = anchor;
        }
        layout.setConstraints(component, constraints);
        container.add(component);
    }

    private void createTree() {
        this.treeMouseListener = new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                int x = e.getX();
                int y = e.getY();
                int row = FindUnlinkedFilesDialog.this.tree.getRowForLocation(x, y);
                TreePath path = FindUnlinkedFilesDialog.this.tree.getPathForRow(row);
                if (path != null) {
                    CheckableTreeNode node = (CheckableTreeNode)path.getLastPathComponent();
                    if (e.getClickCount() == 2) {
                        Object userObject = node.getUserObject();
                        if (userObject instanceof FileNodeWrapper && node.isLeaf()) {
                            FileNodeWrapper fnw = (FileNodeWrapper)userObject;
                            try {
                                JabRefDesktop.openExternalViewer(JabRefGUI.getMainFrame().getCurrentBasePanel().getBibDatabaseContext(), fnw.file.getAbsolutePath(), "pdf");
                            }
                            catch (IOException e1) {
                                LOGGER.info("Error opening file", e1);
                            }
                        }
                    } else {
                        node.check();
                        FindUnlinkedFilesDialog.this.tree.invalidate();
                        FindUnlinkedFilesDialog.this.tree.repaint();
                    }
                }
            }
        };
        CheckableTreeNode startNode = new CheckableTreeNode("ROOT");
        DefaultTreeModel model = new DefaultTreeModel(startNode);
        this.tree.setModel(model);
        this.tree.setRootVisible(false);
        CheckboxTreeCellRenderer renderer = new CheckboxTreeCellRenderer();
        this.tree.setCellRenderer(renderer);
        this.tree.addMouseListener(this.treeMouseListener);
    }

    private void createFileTypesCombobox() {
        List<FileFilter> fileFilterList = this.creatorManager.getFileFilterList();
        this.comboBoxFileTypeSelection = new JComboBox<FileFilter>(fileFilterList.toArray(new FileFilter[fileFilterList.size()]));
        this.comboBoxFileTypeSelection.setRenderer(new DefaultListCellRenderer(){

            @Override
            public Component getListCellRendererComponent(JList<?> list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                EntryFromFileCreator creator;
                JLabel label = (JLabel)super.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
                if (value instanceof EntryFromFileCreator && (creator = (EntryFromFileCreator)value).getExternalFileType() != null) {
                    label.setIcon(creator.getExternalFileType().getIcon());
                }
                return label;
            }
        });
    }

    private void createEntryTypesCombobox() {
        Iterator<EntryType> iterator = EntryTypes.getAllValues(this.frame.getCurrentBasePanel().getBibDatabaseContext().getMode()).iterator();
        ArrayList<BibtexEntryTypeWrapper> list = new ArrayList<BibtexEntryTypeWrapper>();
        list.add(new BibtexEntryTypeWrapper(null));
        while (iterator.hasNext()) {
            list.add(new BibtexEntryTypeWrapper(iterator.next()));
        }
        this.comboBoxEntryTypeSelection = new JComboBox<BibtexEntryTypeWrapper>(list.toArray(new BibtexEntryTypeWrapper[list.size()]));
    }

    public static class FileNodeWrapper {
        public final File file;
        public final int fileCount;

        public FileNodeWrapper(File aFile) {
            this(aFile, 0);
        }

        public FileNodeWrapper(File aDirectory, int fileCount) {
            this.file = aDirectory;
            this.fileCount = fileCount;
        }

        public String toString() {
            return this.file.getName();
        }
    }

    private static class CheckboxTreeCellRenderer
    extends DefaultTreeCellRenderer {
        private final FileSystemView fsv = FileSystemView.getFileSystemView();

        private CheckboxTreeCellRenderer() {
        }

        @Override
        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            Component nodeComponent = super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
            CheckableTreeNode node = (CheckableTreeNode)value;
            FileNodeWrapper userObject = (FileNodeWrapper)node.getUserObject();
            JPanel newPanel = new JPanel();
            JCheckBox checkbox = node.getCheckbox();
            checkbox.setSelected(node.isSelected());
            try {
                this.setIcon(this.fsv.getSystemIcon(userObject.file));
            }
            catch (Exception exception) {
                // empty catch block
            }
            newPanel.setBackground(nodeComponent.getBackground());
            checkbox.setBackground(nodeComponent.getBackground());
            GridBagLayout gbl = new GridBagLayout();
            FindUnlinkedFilesDialog.addComponent(gbl, newPanel, checkbox, null, null, null, 0, 0, 1, 1, 0.0, 0.0, 0, 0);
            FindUnlinkedFilesDialog.addComponent(gbl, newPanel, nodeComponent, 2, null, new Insets(1, 2, 0, 0), 1, 0, 1, 1, 1.0, 0.0, 0, 0);
            if (userObject.fileCount > 0) {
                JLabel label = new JLabel("(" + userObject.fileCount + " file" + (userObject.fileCount > 1 ? "s" : "") + ")");
                FindUnlinkedFilesDialog.addComponent(gbl, newPanel, label, null, null, new Insets(1, 2, 0, 0), 2, 0, 1, 1, 0.0, 0.0, 0, 0);
            }
            return newPanel;
        }
    }

    public static class CheckableTreeNode
    extends DefaultMutableTreeNode {
        private boolean isSelected;
        private final JCheckBox checkbox = new JCheckBox();

        public CheckableTreeNode(Object userObject) {
            super(userObject);
        }

        public JCheckBox getCheckbox() {
            return this.checkbox;
        }

        public void check() {
            this.setSelected(!this.isSelected);
        }

        public void setSelected(boolean bSelected) {
            this.isSelected = bSelected;
            Enumeration<TreeNode> tmpChildren = this.children();
            for (CheckableTreeNode checkableTreeNode : Collections.list(tmpChildren)) {
                checkableTreeNode.setSelected(bSelected);
            }
        }

        public boolean isSelected() {
            return this.isSelected;
        }
    }

    private static class BibtexEntryTypeWrapper {
        private final EntryType entryType;

        BibtexEntryTypeWrapper(EntryType bibtexType) {
            this.entryType = bibtexType;
        }

        public String toString() {
            if (this.entryType == null) {
                return Localization.lang("<No selection>", new String[0]);
            }
            return this.entryType.getName();
        }

        public EntryType getEntryType() {
            return this.entryType;
        }
    }
}

