/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.gui.auximport;

import com.jgoodies.forms.builder.ButtonBarBuilder;
import com.jgoodies.forms.builder.DefaultFormBuilder;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.nio.file.Paths;
import java.util.Optional;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import org.jabref.Globals;
import org.jabref.gui.BasePanel;
import org.jabref.gui.FXDialogService;
import org.jabref.gui.JabRefDialog;
import org.jabref.gui.JabRefFrame;
import org.jabref.gui.auximport.AuxParserResultViewModel;
import org.jabref.gui.keyboard.KeyBinding;
import org.jabref.gui.util.DefaultTaskExecutor;
import org.jabref.gui.util.FileDialogConfiguration;
import org.jabref.logic.auxparser.DefaultAuxParser;
import org.jabref.logic.l10n.Localization;
import org.jabref.logic.util.StandardFileType;
import org.jabref.model.auxparser.AuxParserResult;
import org.jabref.model.database.BibDatabase;

public class FromAuxDialog
extends JabRefDialog {
    private final JPanel statusPanel = new JPanel();
    private final JPanel buttons = new JPanel();
    private final JButton generateButton = new JButton();
    private final JButton cancelButton = new JButton();
    private final JButton parseButton = new JButton();
    private final JComboBox<String> dbChooser = new JComboBox();
    private JTextField auxFileField;
    private JList<String> notFoundList;
    private JTextArea statusInfos;
    private final JTabbedPane parentTabbedPane;
    private boolean generatePressed;
    private AuxParserResult auxParserResult;
    private final JabRefFrame parentFrame;

    public FromAuxDialog(JabRefFrame frame, String title, boolean modal, JTabbedPane viewedDBs) {
        super((Frame)frame, title, modal, FromAuxDialog.class);
        this.parentTabbedPane = viewedDBs;
        this.parentFrame = frame;
        this.jbInit();
        this.pack();
        this.setSize(600, 500);
    }

    private void jbInit() {
        JPanel panel1 = new JPanel();
        panel1.setLayout(new BorderLayout());
        this.generateButton.setText(Localization.lang("Generate", new String[0]));
        this.generateButton.setEnabled(false);
        this.generateButton.addActionListener(e -> {
            this.generatePressed = true;
            this.dispose();
        });
        this.cancelButton.setText(Localization.lang("Cancel", new String[0]));
        this.cancelButton.addActionListener(e -> this.dispose());
        this.parseButton.setText(Localization.lang("Parse", new String[0]));
        this.parseButton.addActionListener(e -> this.parseActionPerformed());
        this.initPanels();
        ButtonBarBuilder bb = new ButtonBarBuilder();
        JPanel buttonPanel = bb.getPanel();
        buttonPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        bb.addGlue();
        bb.addButton((JComponent)this.parseButton);
        bb.addRelatedGap();
        bb.addButton((JComponent)this.generateButton);
        bb.addButton((JComponent)this.cancelButton);
        bb.addGlue();
        this.setModal(true);
        this.setResizable(true);
        this.setTitle(Localization.lang("AUX file import", new String[0]));
        JLabel desc = new JLabel("<html><h3>" + Localization.lang("AUX file import", new String[0]) + "</h3><p>" + Localization.lang("This feature generates a new library based on which entries are needed in an existing LaTeX document.", new String[0]) + "</p><p>" + Localization.lang("You need to select one of your open libraries from which to choose entries, as well as the AUX file produced by LaTeX when compiling your document.", new String[0]) + "</p></html>");
        desc.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        panel1.add((Component)desc, "North");
        JPanel centerPane = new JPanel(new BorderLayout());
        centerPane.add((Component)this.buttons, "North");
        centerPane.add((Component)this.statusPanel, "Center");
        this.getContentPane().add((Component)panel1, "North");
        this.getContentPane().add((Component)centerPane, "Center");
        this.getContentPane().add((Component)buttonPanel, "South");
        ActionMap am = this.statusPanel.getActionMap();
        InputMap im = this.statusPanel.getInputMap(2);
        im.put(Globals.getKeyPrefs().getKey(KeyBinding.CLOSE_DIALOG), "close");
        am.put("close", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FromAuxDialog.this.dispose();
            }
        });
    }

    private void initPanels() {
        int len = this.parentTabbedPane.getTabCount();
        int toSelect = -1;
        for (int i = 0; i < len; ++i) {
            this.dbChooser.addItem(this.parentTabbedPane.getTitleAt(i));
            if (this.parentFrame.getBasePanelAt(i) != this.parentFrame.getCurrentBasePanel()) continue;
            toSelect = i;
        }
        if (toSelect >= 0) {
            this.dbChooser.setSelectedIndex(toSelect);
        }
        this.auxFileField = new JTextField("", 25);
        JButton browseAuxFileButton = new JButton(Localization.lang("Browse", new String[0]));
        FileDialogConfiguration fileDialogConfiguration = new FileDialogConfiguration.Builder().addExtensionFilter(StandardFileType.AUX).withDefaultExtension(StandardFileType.AUX).withInitialDirectory(Globals.prefs.get("workingDirectory")).build();
        FXDialogService ds = new FXDialogService();
        browseAuxFileButton.addActionListener(e -> {
            Optional file = DefaultTaskExecutor.runInJavaFXThread(() -> ds.showFileOpenDialog(fileDialogConfiguration));
            file.ifPresent(f -> this.auxFileField.setText(f.toAbsolutePath().toString()));
        });
        this.notFoundList = new JList();
        JScrollPane listScrollPane = new JScrollPane(this.notFoundList);
        this.statusInfos = new JTextArea("", 5, 20);
        JScrollPane statusScrollPane = new JScrollPane(this.statusInfos);
        this.statusInfos.setEditable(false);
        DefaultFormBuilder b = new DefaultFormBuilder(new FormLayout("left:pref, 4dlu, fill:pref:grow, 4dlu, left:pref", ""), this.buttons);
        b.appendSeparator(Localization.lang("Options", new String[0]));
        b.append(Localization.lang("Reference library", new String[0]) + ":");
        b.append(this.dbChooser, 3);
        b.nextLine();
        b.append(Localization.lang("LaTeX AUX file", new String[0]) + ":");
        b.append(this.auxFileField);
        b.append(browseAuxFileButton);
        b.getPanel().setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        b = new DefaultFormBuilder(new FormLayout("fill:pref:grow, 4dlu, fill:pref:grow", "pref, pref, fill:pref:grow"), this.statusPanel);
        b.appendSeparator(Localization.lang("Result", new String[0]));
        b.append(Localization.lang("Unknown BibTeX entries", new String[0]) + ":");
        b.append(Localization.lang("Messages", new String[0]) + ":");
        b.nextLine();
        b.append(listScrollPane);
        b.append(statusScrollPane);
        b.getPanel().setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
    }

    private void parseActionPerformed() {
        this.parseButton.setEnabled(false);
        BasePanel bp = (BasePanel)this.parentTabbedPane.getComponentAt(this.dbChooser.getSelectedIndex());
        this.notFoundList.removeAll();
        this.statusInfos.setText(null);
        BibDatabase refBase = bp.getDatabase();
        String auxName = this.auxFileField.getText();
        if (auxName != null && refBase != null && !auxName.isEmpty()) {
            DefaultAuxParser auxParser = new DefaultAuxParser(refBase);
            this.auxParserResult = auxParser.parse(Paths.get(auxName, new String[0]));
            this.notFoundList.setListData((String[])this.auxParserResult.getUnresolvedKeys().toArray(new String[this.auxParserResult.getUnresolvedKeys().size()]));
            this.statusInfos.append(new AuxParserResultViewModel(this.auxParserResult).getInformation(false));
            this.generateButton.setEnabled(true);
            if (!this.auxParserResult.getGeneratedBibDatabase().hasEntries()) {
                this.statusInfos.append("\n" + Localization.lang("empty library", new String[0]));
                this.generateButton.setEnabled(false);
            }
        } else {
            this.generateButton.setEnabled(false);
        }
        this.parseButton.setEnabled(true);
    }

    public boolean generatePressed() {
        return this.generatePressed;
    }

    public BibDatabase getGenerateDB() {
        return this.auxParserResult.getGeneratedBibDatabase();
    }
}

