/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.gui.documentviewer;

import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Optional;
import javafx.animation.FadeTransition;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ChangeListener;
import javafx.collections.ObservableList;
import javafx.scene.Node;
import javafx.scene.control.ProgressIndicator;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.layout.StackPane;
import javafx.scene.shape.Rectangle;
import javafx.util.Duration;
import org.fxmisc.easybind.EasyBind;
import org.fxmisc.flowless.Cell;
import org.fxmisc.flowless.VirtualFlow;
import org.fxmisc.flowless.VirtualFlowHit;
import org.jabref.gui.documentviewer.DocumentPageViewModel;
import org.jabref.gui.documentviewer.DocumentViewModel;
import org.jabref.gui.documentviewer.PageDimension;
import org.jabref.gui.util.BackgroundTask;
import org.jabref.gui.util.TaskExecutor;

public class DocumentViewerControl
extends StackPane {
    private TaskExecutor taskExecutor;
    private ObjectProperty<Integer> currentPage = new SimpleObjectProperty((Object)1);
    private DoubleProperty scrollY = new SimpleDoubleProperty();
    private DoubleProperty scrollYMax = new SimpleDoubleProperty();
    private VirtualFlow<DocumentPageViewModel, DocumentViewerPage> flow;
    private PageDimension desiredPageDimension = PageDimension.ofFixedWidth(600);

    public DocumentViewerControl(TaskExecutor taskExecutor) {
        this.taskExecutor = Objects.requireNonNull(taskExecutor);
        this.getStyleClass().add((Object)"document-viewer");
        EasyBind.subscribe(this.currentPage, this::showPage);
    }

    public DoubleProperty scrollYMaxProperty() {
        return this.scrollYMax;
    }

    public DoubleProperty scrollYProperty() {
        return this.scrollY;
    }

    public int getCurrentPage() {
        return (Integer)this.currentPage.get();
    }

    public ObjectProperty<Integer> currentPageProperty() {
        return this.currentPage;
    }

    private void showPage(int pageNumber) {
        if (this.flow != null) {
            this.flow.show(pageNumber - 1);
        }
    }

    public void show(DocumentViewModel document) {
        this.flow = VirtualFlow.createVertical(document.getPages(), x$0 -> new DocumentViewerPage((DocumentPageViewModel)x$0));
        this.getChildren().setAll((Object[])new Node[]{this.flow});
        this.flow.visibleCells().addListener(c -> this.updateCurrentPage(this.flow.visibleCells()));
        this.flow.estimatedScrollYProperty().addListener((ChangeListener<Double>)((ChangeListener)(observable, oldValue, newValue) -> this.scrollY.setValue((Number)newValue)));
        this.scrollY.addListener((observable, oldValue, newValue) -> this.flow.estimatedScrollYProperty().setValue((double)((Double)newValue)));
        this.flow.totalLengthEstimateProperty().addListener((ChangeListener<Double>)((ChangeListener)(observable, oldValue, newValue) -> this.scrollYMax.setValue((Number)newValue)));
    }

    private void updateCurrentPage(ObservableList<DocumentViewerPage> visiblePages) {
        if (this.flow == null) {
            return;
        }
        Optional<Object> inMiddleOfViewport = Optional.empty();
        try {
            VirtualFlowHit<DocumentViewerPage> hit = this.flow.hit(0.0, this.flow.getHeight() / 2.0);
            if (hit.isCellHit()) {
                inMiddleOfViewport = Optional.of(hit.getCell());
            }
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
        if (inMiddleOfViewport.isPresent()) {
            this.currentPage.set((Object)((DocumentViewerPage)inMiddleOfViewport.get()).getPageNumber());
        } else {
            this.currentPage.set((Object)visiblePages.stream().findFirst().map(DocumentViewerPage::getPageNumber).orElse(1));
        }
    }

    public void setPageWidth(double width) {
        this.desiredPageDimension = PageDimension.ofFixedWidth(width);
        this.updateSizeOfDisplayedPages();
    }

    public void setPageHeight(double height) {
        this.desiredPageDimension = PageDimension.ofFixedHeight(height);
        this.updateSizeOfDisplayedPages();
    }

    private void updateSizeOfDisplayedPages() {
        if (this.flow != null) {
            for (DocumentViewerPage page : this.flow.visibleCells()) {
                page.updateSize();
            }
            this.flow.requestLayout();
        }
    }

    public void changePageWidth(int delta) {
        this.setPageWidth(this.desiredPageDimension.getWidth(Math.sqrt(2.0)) + delta);
    }

    private class DocumentViewerPage
    implements Cell<DocumentPageViewModel, StackPane> {
        private final ImageView imageView;
        private final StackPane imageHolder;
        private final Rectangle background;
        private DocumentPageViewModel page;

        public DocumentViewerPage(DocumentPageViewModel initialPage) {
            this.page = initialPage;
            this.imageView = new ImageView();
            this.imageHolder = new StackPane();
            this.imageHolder.getStyleClass().add((Object)"page");
            ProgressIndicator progress = new ProgressIndicator();
            progress.setMaxSize(50.0, 50.0);
            this.background = new Rectangle((double)this.getDesiredWidth(), (double)this.getDesiredHeight());
            this.background.setStyle("-fx-fill: WHITE");
            BackgroundTask<Image> generateImage = BackgroundTask.wrap(() -> this.renderPage(initialPage)).onSuccess(image -> {
                this.imageView.setImage(image);
                progress.setVisible(false);
                this.background.setVisible(false);
            });
            DocumentViewerControl.this.taskExecutor.execute(generateImage);
            this.imageHolder.getChildren().setAll((Object[])new Node[]{this.background, progress, this.imageView});
        }

        private int getDesiredHeight() {
            return DocumentViewerControl.this.desiredPageDimension.getHeight(this.page.getAspectRatio());
        }

        private int getDesiredWidth() {
            return DocumentViewerControl.this.desiredPageDimension.getWidth(this.page.getAspectRatio());
        }

        @Override
        public StackPane getNode() {
            return this.imageHolder;
        }

        @Override
        public boolean isReusable() {
            return true;
        }

        @Override
        public void updateItem(DocumentPageViewModel page) {
            this.page = page;
            this.background.setWidth((double)this.getDesiredWidth());
            this.background.setHeight((double)this.getDesiredHeight());
            this.background.setVisible(true);
            this.imageView.setOpacity(0.0);
            BackgroundTask<Image> generateImage = BackgroundTask.wrap(() -> this.renderPage(page)).onSuccess(image -> {
                this.imageView.setImage(image);
                FadeTransition fadeIn = new FadeTransition(Duration.millis((double)100.0), (Node)this.imageView);
                fadeIn.setFromValue(0.0);
                fadeIn.setToValue(1.0);
                fadeIn.play();
            });
            DocumentViewerControl.this.taskExecutor.execute(generateImage);
        }

        private Image renderPage(DocumentPageViewModel page) {
            return page.render(this.getDesiredWidth(), this.getDesiredHeight());
        }

        public int getPageNumber() {
            return this.page.getPageNumber();
        }

        public void updateSize() {
            this.background.setWidth((double)this.getDesiredWidth());
            this.background.setHeight((double)this.getDesiredWidth());
            this.updateItem(this.page);
            this.imageHolder.requestLayout();
        }
    }
}

